package com.tydic.picker.enums;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.picker.utils.DynamicUtil;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @ClassName ConstantEnum
 * @Description 通用枚举类
 * @Author liugs
 * @Date 2022/8/17 17:26
 */
public class ConstantEnum {

    /**
     * 同步记录状态枚举值
     */
    public enum PickerRecordStatusEnum {
        /**
         * 初始状态
         */
        INIT(0, "初始状态"),
        /**
         * 成功
         */
        SUCCESS(1, "成功"),
        /**
         * 失败
         */
        FAIL(2, "失败");
        private Integer state;

        private String desc;

        PickerRecordStatusEnum(Integer state, String desc) {
            this.state = state;
            this.desc = desc;
        }

        public Integer getState() {
            return state;
        }

        public String getDesc() {
            return desc;
        }
    }

    /**
     * 事件同步方式
     */
    public enum SyncTypeEnum {
        /**
         * 同步
         */
        SYNC("1"),
        /**
         * 异步
         */
        ASYNC("2");

        private String syncType;

        SyncTypeEnum(String syncType) {
            this.syncType = syncType;
        }

        public String getSyncType() {
            return syncType;
        }
    }

    /**
     * 记录表动态SQL
     */
    public enum DynamicSqlEnum {
        /**
         * 检查记录表是否存在
         */
        CHECK("SHOW TABLES LIKE 'picker_record';"),
        /**
         * 创建表格
         */
        CREATE("CREATE TABLE `picker_record` (\n" +
                "  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '主键',\n" +
                "  `busi_code` varchar(32) COLLATE utf8mb4_bin NOT NULL COMMENT '业务中心编码',\n" +
                "  `service_code` varchar(128) COLLATE utf8mb4_bin NOT NULL COMMENT '服务编码',\n" +
                "  `method_code` varchar(128) COLLATE utf8mb4_bin NOT NULL COMMENT '方法编码',\n" +
                "  `index_name` varchar(128) COLLATE utf8mb4_bin NOT NULL COMMENT '索引名称',\n" +
                "  `doc_id_field` varchar(32) COLLATE utf8mb4_bin NOT NULL COMMENT '文档ID取值字段',\n" +
                "  `dynamic_sql` text COLLATE utf8mb4_bin NOT NULL COMMENT '动态语句',\n" +
                "  `condition_param` text COLLATE utf8mb4_bin NOT NULL COMMENT '条件参数',\n" +
                "  `mapping_info` text COLLATE utf8mb4_bin NOT NULL COMMENT '映射关系',\n" +
                "  `sync_type` int NOT NULL COMMENT '同步类型 0：同步，1：异步',\n" +
                "  `event_type` int NOT NULL COMMENT '事件类型 1：新增，2：更新，3：删除',\n" +
                "  `status` int NOT NULL DEFAULT '0' COMMENT '状态 0：初始状态，1：成功， 2：失败',\n" +
                "  `status_desc` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '状态描述',\n" +
                "  `start_time` datetime NOT NULL COMMENT '开始时间',\n" +
                "  `finish_time` datetime DEFAULT NULL COMMENT '完成时间',\n" +
                "  PRIMARY KEY (`id`)\n" +
                ") ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin;"),
        /**
         * 新增
         */
        INSERT("INSERT INTO `picker_record` (" +
                "`id`,`busi_code`,`service_code`,`method_code`,`index_name`,`doc_id_field`,`dynamic_sql`,`condition_param`,`mapping_info`,`sync_type`,`event_type`,`status_desc`,`start_time`) " +
                "VALUES(${id},'${busiCode}','${serviceCode}','${methodCode}','${indexName}','${docIdField}','${dynamicSql}', '${conditionParam}','${mappingInfo}',${syncType},${eventType},'${statusDesc}','${startTime}');"),
        /**
         * 更新
         */
        UPDATE("UPDATE `picker_record` SET `status` = ${status}, `status_desc` = '${statusDesc}', `finish_time` = '${finishTime}' WHERE `id` = ${id}");

        /** 动态SQL */
        private String dynamicSql;

        DynamicSqlEnum(String dynamicSql) {
            this.dynamicSql = dynamicSql;
        }

        public String getDynamicSql(Map<String, Object> paramMap) {
            if (ObjectUtil.isNotEmpty(paramMap)) {
                return doReplace(DynamicUtil.PLACE_PATTERN, dynamicSql, paramMap);
            }
            return dynamicSql;
        }

        /**
         * 描述 替换
         * @param pattern
         * @param template
         * @param paramMap
         * @return java.lang.String
         * @author liugs
         * @date 2022/8/19 14:48
         */
        private static String doReplace(Pattern pattern, String template, Map<String, Object> paramMap) {
            StringBuffer stringBuffer = new StringBuffer();
            Matcher matcher = pattern.matcher(template);
            while (matcher.find()) {
                String group = matcher.group(2);
                if (paramMap.get(group) == null) {
                    matcher.appendReplacement(stringBuffer, "null");
                    continue;
                }
                matcher.appendReplacement(stringBuffer, paramMap.get(group).toString());
            }
            matcher.appendTail(stringBuffer);

            return stringBuffer.toString().trim();
        }
    }

    /**
     * 子查询字段数据类型
     */
    public enum DataType {
        /** 对象 */
        SINGLE("SINGLE"),
        /** 字段 */
        FIELD("FIELD"),
        /** 列表 */
        MULTIPLE("MULTIPLE");

        private String type;

        DataType(String type) {
            this.type = type;
        }

        public Boolean equal(String that) {
            return this.type.equals(that);
        }
    }
}
