/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.picker.utils;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.picker.dto.DataPickDTO;
import com.tydic.picker.dto.DataSyncConfigSubQueryDTO;
import com.tydic.picker.enums.ConstantEnum;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
public class DynamicSqlUtil {
    private static final Logger log = LoggerFactory.getLogger(DynamicSqlUtil.class);
    private static final int MAXIMUM_DEPTH = 2;
    public static final Pattern PLACE_PATTERN = Pattern.compile("(\\$\\{)([\\w]+)(})");
    private JdbcTemplate jdbcTemplate;

    public DynamicSqlUtil(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public JSONObject getMappedData(DataPickDTO dto) {
        JSONObject mappingRelJson = JSON.parseObject((String)dto.getMappingInfo());
        JSONObject mappedDataJson = new JSONObject(true);
        Map<String, Object> conditionParam = dto.getConditionParam();
        if (StringUtils.isEmpty((CharSequence)dto.getDynamicSql())) {
            for (Map.Entry<String, Object> entry : conditionParam.entrySet()) {
                mappedDataJson.put(entry.getValue().toString(), conditionParam.get(entry.getKey()));
            }
            mappedDataJson.put("DOCUMENT_ID", conditionParam.get(dto.getDocIdField()));
            return mappedDataJson;
        }
        String dynamicSql = DynamicSqlUtil.buildDynamicSql(dto.getDynamicSql(), conditionParam);
        log.info("\u9876\u5c42\u6570\u636e\u6267\u884c\u7684\u53d6\u503c\u52a8\u6001\u8bed\u53e5\u4e3a\uff1a{}", (Object)dynamicSql);
        Map<String, Object> dynamicSqlResult = this.buildSingleData(mappedDataJson, mappingRelJson, dynamicSql, conditionParam);
        this.buildSubField(mappedDataJson, dynamicSqlResult, conditionParam, dto.getSubQuery(), 0);
        mappedDataJson.put("DOCUMENT_ID", mappedDataJson.get((Object)dto.getDocIdField()));
        return mappedDataJson;
    }

    private void buildSubField(JSONObject parentData, Map<String, Object> parentQryResult, Map<String, Object> conditionParam, List<DataSyncConfigSubQueryDTO> subQuery, int depth) {
        if (2 < depth || CollectionUtils.isEmpty(subQuery)) {
            return;
        }
        HashMap<String, Object> dynamicConditionMap = new HashMap<String, Object>(16);
        dynamicConditionMap.putAll(conditionParam);
        dynamicConditionMap.putAll(parentQryResult);
        for (DataSyncConfigSubQueryDTO subQueryItem : subQuery) {
            JSONObject fieldMapping = JSON.parseObject((String)subQueryItem.getMappingInfo());
            String dynamicSql = DynamicSqlUtil.buildDynamicSql(subQueryItem.getDataFilter(), dynamicConditionMap);
            log.info("[{}]\u7ea7\u5b50\u67e5\u8be2\u53d6\u503c\u52a8\u6001\u8bed\u53e5\u4e3a\uff1a{}", (Object)depth, (Object)dynamicSql);
            ConstantEnum.DataType typeEnum = ConstantEnum.DataType.getType(subQueryItem.getDataType());
            switch (typeEnum) {
                case MULTIPLE: {
                    parentData.put(subQueryItem.getParentField(), (Object)this.buildMultipleData(fieldMapping, dynamicSql, conditionParam));
                    break;
                }
                case FIELD: {
                    this.buildFieldData(parentData, fieldMapping, conditionParam, dynamicSql);
                    break;
                }
                case EXTEND_FIELD: {
                    this.buildExtFieldData(parentData, fieldMapping, dynamicSql);
                    break;
                }
                case SINGLE: {
                    Map<String, Object> dynamicSqlResult;
                    JSONObject subData = new JSONObject();
                    try {
                        dynamicSqlResult = this.buildSingleData(subData, fieldMapping, dynamicSql, conditionParam);
                    }
                    catch (DataAccessException e) {
                        log.error("[{}]\u7ea7\u5b50\u6267\u884c\u5355\u4e00\u5bf9\u8c61\u578b\u53d6\u503c\u52a8\u6001\u8bed\u53e5\u5f02\u5e38\uff1a{}", (Object)depth, (Object)e.getMessage());
                        parentData.put(subQueryItem.getParentField(), (Object)subData);
                        break;
                    }
                    if (CollectionUtils.isNotEmpty(subQueryItem.getSubQuery())) {
                        this.buildSubField(subData, dynamicSqlResult, conditionParam, subQueryItem.getSubQuery(), ++depth);
                        --depth;
                    }
                    parentData.put(subQueryItem.getParentField(), (Object)subData);
                    break;
                }
            }
        }
    }

    private void buildExtFieldData(JSONObject parentData, JSONObject fieldMapping, String dynamicSql) {
        List queryForList;
        try {
            queryForList = this.jdbcTemplate.queryForList(dynamicSql);
        }
        catch (DataAccessException e) {
            log.error("\u6267\u884c\u52a8\u6001\u5b50\u67e5\u8be2\u8bed\u53e5\u83b7\u53d6\u6269\u5c55\u5b57\u6bb5\u7c7b\u578b\u6570\u636e\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            return;
        }
        log.debug("\u6267\u884c\u52a8\u6001\u5b50\u67e5\u8be2\u8bed\u53e5\u83b7\u53d6\u5230\u7684\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)queryForList));
        queryForList.forEach(item -> {
            for (Map.Entry entry : fieldMapping.entrySet()) {
                Object esKey = item.get(entry.getKey());
                if (!ObjectUtil.isNotEmpty(esKey)) continue;
                parentData.put(StrUtil.toCamelCase((CharSequence)esKey.toString()), item.get(entry.getValue()));
            }
        });
    }

    private void buildFieldData(JSONObject parentData, JSONObject fieldMapping, Map<String, Object> conditionParam, String dynamicSql) {
        Map resultDataMap;
        try {
            resultDataMap = this.jdbcTemplate.queryForMap(dynamicSql);
        }
        catch (DataAccessException e) {
            log.error("\u6267\u884c\u52a8\u6001\u5b50\u67e5\u8be2\u8bed\u53e5\u83b7\u53d6\u5b57\u6bb5\u7c7b\u578b\u6570\u636e\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            return;
        }
        log.debug("\u6267\u884c\u52a8\u6001\u5b50\u67e5\u8be2\u8bed\u53e5\u83b7\u53d6\u5230\u7684\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)resultDataMap));
        resultDataMap.putAll(conditionParam);
        for (Map.Entry entry : fieldMapping.entrySet()) {
            parentData.put(entry.getValue().toString(), resultDataMap.get(entry.getKey()));
        }
    }

    private JSONArray buildMultipleData(JSONObject fieldMapping, String dynamicSql, Map<String, Object> conditionParam) {
        List queryForList;
        JSONArray subArrayData = new JSONArray();
        try {
            queryForList = this.jdbcTemplate.queryForList(dynamicSql);
        }
        catch (DataAccessException e) {
            log.error("\u6267\u884c\u52a8\u6001\u5b50\u67e5\u8be2\u8bed\u53e5\u83b7\u53d6\u5217\u8868\u7c7b\u578b\u6570\u636e\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            return subArrayData;
        }
        if (CollectionUtils.isEmpty((Collection)queryForList)) {
            log.error("\u6267\u884c\u52a8\u6001\u5b50\u67e5\u8be2\u8bed\u53e5[{}]\u672a\u83b7\u53d6\u5230\u6570\u636e\u5217\u8868", (Object)dynamicSql);
            return subArrayData;
        }
        queryForList.forEach(item -> {
            item.putAll(conditionParam);
            JSONObject subDateItem = new JSONObject();
            for (Map.Entry entry : fieldMapping.entrySet()) {
                subDateItem.put(entry.getValue().toString(), item.get(entry.getKey()));
            }
            subArrayData.add((Object)subDateItem);
        });
        return subArrayData;
    }

    private Map<String, Object> buildSingleData(JSONObject targetData, JSONObject fieldMapping, String dynamicSql, Map<String, Object> conditionParam) {
        Map resultDataMap = this.jdbcTemplate.queryForMap(dynamicSql);
        log.debug("\u6267\u884c\u52a8\u6001\u8bed\u53e5\u83b7\u53d6\u5230\u7684\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)resultDataMap));
        HashMap<String, Object> tempDataMap = new HashMap<String, Object>(16);
        tempDataMap.putAll(conditionParam);
        tempDataMap.putAll(resultDataMap);
        for (Map.Entry entry : fieldMapping.entrySet()) {
            targetData.put(entry.getValue().toString(), tempDataMap.get(entry.getKey()));
        }
        return resultDataMap;
    }

    private static String buildDynamicSql(String dynamicSql, Map<String, Object> paramMap) {
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = PLACE_PATTERN.matcher(dynamicSql);
        while (matcher.find()) {
            String group = matcher.group(2);
            if (paramMap.get(group) == null) {
                matcher.appendReplacement(stringBuffer, "null");
                continue;
            }
            matcher.appendReplacement(stringBuffer, "'" + paramMap.get(group).toString() + "'");
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString().trim();
    }
}

