package com.tydic.picker.config;

import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ToStringSerializer;

import java.math.BigInteger;

/**
 * @ClassName FastJsonConfig
 * @Description
 * @Author liugs
 * @Date 2023/6/21 15:03
 */
public class FastJsonConfig {

    private static final com.alibaba.fastjson.support.config.FastJsonConfig FAST_JSON_CONFIG;

    static {
        // 初始化一个转换器配置
        com.alibaba.fastjson.support.config.FastJsonConfig fastJsonConfig = new com.alibaba.fastjson.support.config.FastJsonConfig();
//        JSON.DEFFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
        fastJsonConfig.setSerializerFeatures(SerializerFeature.BrowserCompatible,
                SerializerFeature.WriteNullListAsEmpty,
                SerializerFeature.PrettyFormat,
                SerializerFeature.WriteDateUseDateFormat,
                SerializerFeature.WriteNullStringAsEmpty,
                SerializerFeature.WriteMapNullValue,
                SerializerFeature.DisableCircularReferenceDetect);
        //解决Long转json精度丢失的问题
        SerializeConfig serializeConfig = SerializeConfig.globalInstance;
        serializeConfig.put(BigInteger.class, ToStringSerializer.instance);
        serializeConfig.put(Long.class, ToStringSerializer.instance);
        serializeConfig.put(Long.TYPE, ToStringSerializer.instance);
        fastJsonConfig.setSerializeConfig(serializeConfig);

        fastJsonConfig.getFeatures();

        FAST_JSON_CONFIG = fastJsonConfig;
    }

    public static SerializerFeature[] getSerializerFeature() {
        return FAST_JSON_CONFIG.getSerializerFeatures();
    }

}
