package com.tydic.picker.result;

import com.tydic.picker.enums.ResultCodeEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * @ClassName PickerResult
 * @Description 数据同步 返回对象
 * @Author liugs
 * @Date 2022/8/15 17:01
 */
@Data
public class PickerResult implements Serializable {

    private static final long serialVersionUID = 5142011572949076973L;

    public PickerResult(ResultCodeEnum codeEnum) {
        this.code = codeEnum.getCode();
        this.message = codeEnum.getMessage();
    }

    private String code;

    private String message;

    /**
     * 失败返回对象构建
     * @param message
     */
    public void buildFail(String message) {
        this.code = ResultCodeEnum.FAIL.getCode();
        this.message = message;
    }
}
