/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.picker.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.picker.enums.DataEventTypeEnum;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.core.GetSourceRequest;
import org.elasticsearch.client.core.GetSourceResponse;
import org.elasticsearch.common.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public class ElasticsearchUtil {
    private static final Logger log = LoggerFactory.getLogger(ElasticsearchUtil.class);
    private RestHighLevelClient restHighLevelClient;

    public ElasticsearchUtil(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public void doSyncByEventType(DataEventTypeEnum eventTypeEnum, String indexName, JSONObject esData) {
        switch (eventTypeEnum) {
            case CREATE: {
                this.addDocument(indexName, esData.remove((Object)"DOCUMENT_ID").toString(), esData);
                break;
            }
            case UPDATE: {
                this.updateDoc(indexName, esData.remove((Object)"DOCUMENT_ID").toString(), esData);
                break;
            }
            case BATCH_UPDATE: {
                this.updateBatch(indexName, esData.remove((Object)"DOCUMENT_ID"), esData);
                break;
            }
            case DELETE: {
                this.deleteDocById(indexName, esData.getString("DOCUMENT_ID"));
                break;
            }
            case BATCH_DELETE: {
                this.deleteBatch(indexName, esData.get((Object)"DOCUMENT_ID"));
                break;
            }
        }
    }

    public boolean deleteIndex(String index) {
        if (StringUtils.isBlank((CharSequence)index)) {
            log.info("\u5220\u9664\u7d22\u5f15\u5185\u5bb9\u4e3a\u7a7a");
            return false;
        }
        DeleteIndexRequest request = new DeleteIndexRequest(index);
        try {
            AcknowledgedResponse indexResponse = this.restHighLevelClient.indices().delete(request, RequestOptions.DEFAULT);
            if (indexResponse.isAcknowledged()) {
                log.info("\u5220\u9664\u7d22\u5f15\u6210\u529f");
            } else {
                log.info("\u5220\u9664\u7d22\u5f15\u5931\u8d25");
            }
            return indexResponse.isAcknowledged();
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u7d22\u5f15\u5931\u8d25", (Throwable)e);
            String exceptionStr = JSON.toJSONString((Object)e.getMessage());
            return exceptionStr.contains("index_not_found_exception");
        }
    }

    public boolean createIndex(String index) {
        CreateIndexRequest request = new CreateIndexRequest(index);
        try {
            CreateIndexResponse indexResponse = this.restHighLevelClient.indices().create(request, RequestOptions.DEFAULT);
            if (indexResponse.isAcknowledged()) {
                log.info("\u521b\u5efa\u7d22\u5f15\u6210\u529f");
            } else {
                log.info("\u521b\u5efa\u7d22\u5f15\u5931\u8d25");
            }
            return indexResponse.isAcknowledged();
        }
        catch (IOException e) {
            log.error("\u521b\u5efa\u7d22\u5f15\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    public String addData(String index, String type, String id, JSONObject object) {
        IndexRequest indexRequest = new IndexRequest(index);
        indexRequest.id(id);
        try {
            indexRequest.source(JSON.toJSONString((Object)object), XContentType.JSON);
            IndexResponse indexResponse = this.restHighLevelClient.index(indexRequest, RequestOptions.DEFAULT);
            return indexResponse.getId();
        }
        catch (Exception e) {
            log.info("\u63d2\u5165\u6570\u636e\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public String addJsonData(String index, String id, String jsonStr) {
        IndexRequest indexRequest = new IndexRequest(index);
        indexRequest.id(id);
        try {
            indexRequest.source(jsonStr, XContentType.JSON);
            log.info("addJsonData\u4fdd\u5b58\u6570\u636e\uff1a" + jsonStr);
            IndexResponse indexResponse = this.restHighLevelClient.index(indexRequest, RequestOptions.DEFAULT);
            return indexResponse.getId();
        }
        catch (Exception e) {
            log.error("\u63d2\u5165\u6570\u636e\u5931\u8d25", (Throwable)e);
            throw new BaseBusinessException("8888", "\u63d2\u5165\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    public boolean checkIndexExist(String index) {
        String ok = "OK";
        boolean checkResult = false;
        try {
            Request request = new Request("HEAD", index);
            Response response = this.restHighLevelClient.getLowLevelClient().performRequest(request);
            if (ok.equals(response.getStatusLine().getReasonPhrase())) {
                checkResult = true;
            }
        }
        catch (IOException e) {
            log.error("\u68c0\u67e5\u7d22\u5f15\u5931\u8d25", (Throwable)e);
        }
        return checkResult;
    }

    public Boolean deleteDataByCondition(String endPoint, String qryJsonStr) {
        boolean deleteResult = false;
        NStringEntity entity = new NStringEntity(qryJsonStr, ContentType.APPLICATION_JSON);
        try {
            JSONObject deleteResultJson;
            int deleteCount;
            Request request = new Request("POST", endPoint);
            request.setEntity((HttpEntity)entity);
            Response response = this.restHighLevelClient.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (StringUtils.isNotBlank((CharSequence)result) && (deleteCount = (deleteResultJson = JSONObject.parseObject((String)result)).getInteger("deleted").intValue()) > 0) {
                deleteResult = true;
            }
        }
        catch (IOException e) {
            log.error("\u6839\u636e\u6761\u4ef6\u5220\u9664ES\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
        return deleteResult;
    }

    public String addDocument(String indexName, String docId, JSONObject source) {
        log.debug("\u65b0\u589e\u6587\u7ae0\u5165\u53c2\uff1aindexName='{}'\uff0cid='{}'\uff0csource='{}'", new Object[]{indexName, docId, source});
        if (StringUtils.isEmpty((CharSequence)indexName) || source.isEmpty()) {
            log.info("\u65b0\u589e\u6587\u7ae0\uff0c[indexName]\uff0c[source]\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BaseBusinessException("8888", "\u65b0\u589e\u6587\u7ae0\uff0c[indexName]\uff0c[source]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        IndexRequest request = new IndexRequest(indexName);
        if (!StringUtils.isEmpty((CharSequence)docId)) {
            request.id(docId);
        }
        request.source(JSON.toJSONString((Object)source), XContentType.JSON);
        try {
            IndexResponse response = this.restHighLevelClient.index(request, RequestOptions.DEFAULT);
            if (DocWriteResponse.Result.CREATED.equals((Object)response.getResult()) || StringUtils.isNotEmpty((CharSequence)response.getId())) {
                log.info("\u65b0\u589e\u6587\u7ae0\u6210\u529f");
                return response.getId();
            }
            String failReason = null;
            if (response.getShardInfo().getFailed() > 0) {
                ReplicationResponse.ShardInfo.Failure[] failures = response.getShardInfo().getFailures();
                failReason = failures[0].reason();
            }
            log.info("\u65b0\u589e\u6587\u7ae0\u5931\u8d25\uff1a{}", failReason);
            throw new BaseBusinessException("8888", "\u65b0\u589e\u6587\u7ae0\u5931\u8d25\uff1a" + failReason);
        }
        catch (IOException e) {
            log.error("\u65b0\u589e\u6587\u7ae0\u5f02\u5e38\uff1a" + e);
            throw new BaseBusinessException("8888", "\u65b0\u589e\u6587\u7ae0\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public void updateDoc(String indexName, String docId, JSONObject source) {
        if (log.isDebugEnabled()) {
            log.debug("\u6839\u636e\u6587\u7ae0ID\u66f4\u65b0\u6587\u7ae0\uff0c\u5165\u53c2\uff1aindexName = '{}', docId = '{}'", (Object)indexName, (Object)docId);
        }
        UpdateRequest request = new UpdateRequest(indexName, "_doc", docId);
        request.retryOnConflict(1);
        request.doc(JSON.toJSONString((Object)source), XContentType.JSON);
        try {
            UpdateResponse response = this.restHighLevelClient.update(request, RequestOptions.DEFAULT);
            if (DocWriteResponse.Result.UPDATED.equals((Object)response.getResult()) || DocWriteResponse.Result.NOOP.equals((Object)response.getResult())) {
                log.info("\u6587\u7ae0\u66f4\u65b0\u6210\u529f");
                return;
            }
            throw new BaseBusinessException("8888", "\u6839\u636e\u6587\u7ae0ID\u66f4\u65b0\u6587\u7ae0\u5931\u8d25\uff1a" + response.getResult());
        }
        catch (Exception e) {
            log.info("\u53d1\u751f\u5f02\u5e38\uff0c \u5c1d\u8bd5\u4f7f\u7528ES6\u66f4\u65b0\u6587\u7ae0");
            this.updateForEs6(indexName, source, docId);
            return;
        }
    }

    public void deleteDocById(String indexName, String docId) {
        log.debug("\u6839\u636e\u6587\u7ae0ID\u5220\u9664\u6587\u7ae0\uff0c\u5165\u53c2\uff1aindexName={}\uff0cdocId={}", (Object)indexName, (Object)docId);
        if (StringUtils.isEmpty((CharSequence)indexName) || StringUtils.isEmpty((CharSequence)docId)) {
            log.info("\u6839\u636e\u6587\u7ae0ID\u5220\u9664\u6587\u7ae0\uff0c\u5165\u53c2[indexName]\u548c[docId]\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BaseBusinessException("8888", "\u6839\u636e\u6587\u7ae0ID\u5220\u9664\u6587\u7ae0\uff0c\u5165\u53c2[indexName]\u548c[docId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DeleteRequest request = new DeleteRequest(indexName, docId);
        try {
            DeleteResponse response = this.restHighLevelClient.delete(request, RequestOptions.DEFAULT);
            if (response.getShardInfo().getFailed() <= 0) {
                log.info("\u5220\u9664\u7d22\u5f15[{}]\u6587\u7ae0[{}]\u6210\u529f", (Object)indexName, (Object)docId);
                return;
            }
            ReplicationResponse.ShardInfo.Failure[] failures = response.getShardInfo().getFailures();
            log.info("\u5220\u9664\u6587\u7ae0\u5931\u8d25\uff1a{}", (Object)failures[0].reason());
            throw new BaseBusinessException("8888", "\u6839\u636e\u6587\u7ae0ID\u5220\u9664\u6587\u7ae0\u5931\u8d25\uff1a" + failures[0].reason());
        }
        catch (IOException e) {
            log.error("\u6839\u636e\u6587\u7ae0ID\u5220\u9664\u6587\u7ae0\u5f02\u5e38\uff1a" + e);
            throw new BaseBusinessException("8888", "\u6839\u636e\u6587\u7ae0ID\u5220\u9664\u6587\u7ae0\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public void deleteBatch(String indexName, Object docIds) {
        String endPoint = "/" + indexName + "/_delete_by_query";
        String esUpdateStr = this.toEsBatchDeleteStr(docIds);
        log.info("esDelete URL:{}", (Object)endPoint);
        log.info("esDeleteStrReq:{}", (Object)esUpdateStr);
        NStringEntity entity = new NStringEntity(esUpdateStr, ContentType.APPLICATION_JSON);
        try {
            JSONObject rspJsonObject;
            Integer deleted;
            Request request = new Request("POST", endPoint);
            request.setEntity((HttpEntity)entity);
            Response response = this.restHighLevelClient.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            log.info("esUpdateStrRsp:{}", (Object)result);
            if (StringUtils.isNotBlank((CharSequence)result) && (deleted = (Integer)(rspJsonObject = JSON.parseObject((String)result)).get((Object)"deleted")) > 0) {
                log.info("\u6279\u91cf\u5220\u9664\u6210\u529f");
            }
        }
        catch (IOException e) {
            log.error("\u6279\u91cf\u5220\u9664ES\u6570\u636e\u5931\u8d25:{},\u5220\u9664\u8bed\u53e5:{}", (Object)e, (Object)esUpdateStr);
            throw new BaseBusinessException("8888", "\u6279\u91cf\u5220\u9664ES\u6570\u636e\u5931\u8d25(ES6)\uff1a" + e.getMessage());
        }
    }

    public JSONObject getDocById(String indexName, String docId) {
        if (log.isDebugEnabled()) {
            log.debug("\u6839\u636e\u6587\u7ae0ID\u83b7\u53d6\u6587\u7ae0\uff1a\u5165\u53c2\uff1aindexName='{}'\uff0cdocId='{}'", (Object)indexName, (Object)docId);
        }
        GetSourceRequest request = new GetSourceRequest(indexName, docId);
        Map source = new HashMap(16);
        try {
            GetSourceResponse response = this.restHighLevelClient.getSource(request, RequestOptions.DEFAULT);
            source = response.getSource();
        }
        catch (IOException e) {
            log.error("\u6839\u636e\u6587\u7ae0ID\u83b7\u53d6\u6587\u7ae0\u5f02\u5e38\uff1a" + e);
        }
        if (source.isEmpty()) {
            log.info("\u6839\u636e\u5165\u53c2\uff1a\u5165\u53c2\uff1aindexName='{}'\uff0cdocId='{}'\uff0c\u672a\u67e5\u8be2\u5230\u6587\u7ae0", (Object)indexName, (Object)docId);
        }
        return new JSONObject(source);
    }

    public void updateForEs6(String indexName, JSONObject source, String docId) {
        int retry = 0;
        while (retry++ < 3) {
            if (retry > 0) {
                log.info("updateForEs6, \u53d1\u8d77\u7b2c(" + retry + ")\u6b21\u91cd\u8bd5");
            }
            String endPoint = "/" + indexName + "/_doc/" + docId + "/_update";
            String esUpdateStr = this.toEsUpdateStr(docId, source);
            log.info("========\u6267\u884cES\u66f4\u65b0\u8bed\u53e5======= :{}", (Object)endPoint);
            log.info("========ES\u8bf7\u6c42\u62a5\u6587==========:{}", (Object)esUpdateStr);
            NStringEntity entity = new NStringEntity(esUpdateStr, ContentType.APPLICATION_JSON);
            try {
                Request request = new Request("POST", endPoint);
                request.setEntity((HttpEntity)entity);
                Response response = this.restHighLevelClient.getLowLevelClient().performRequest(request);
                String result = EntityUtils.toString((HttpEntity)response.getEntity());
                log.info("=======ES\u54cd\u5e94\u62a5\u6587==========:{}", (Object)result);
                if (StringUtils.isNotBlank((CharSequence)result)) {
                    JSONObject rspJsonObject = JSON.parseObject((String)result);
                    JSONObject shardsJson = JSON.parseObject((String)JSON.toJSONString((Object)rspJsonObject.get((Object)"_shards")));
                    if (!ObjectUtils.isEmpty((Object)shardsJson) && (Integer)shardsJson.get((Object)"failed") == 0) {
                        log.info("\u66f4\u65b0\u6210\u529f\uff0crspJsonObject\uff1a{} ", (Object)rspJsonObject);
                        break;
                    }
                    if (1 != (Integer)rspJsonObject.get((Object)"updated") && retry >= 3) {
                        log.info("\u66f4\u65b0\u91cd\u8bd5\u5b8c\u6210, \u66f4\u65b0\u72b6\u6001\uff1a\u5931\u8d25");
                        break;
                    }
                    log.info("\u66f4\u65b0\u5931\u8d25\uff0c\u51c6\u5907\u53d1\u8d77\u91cd\u8bd5\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
                }
                log.info("\u66f4\u65b0\u5931\u8d25\uff0c\u51c6\u5907\u53d1\u8d77\u91cd\u8bd5\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
            }
            catch (Exception e) {
                log.error("\u6839\u636e\u6761\u4ef6\u66f4\u65b0ES\u6570\u636e\u5931\u8d25:{},\u66f4\u65b0\u8bed\u53e5:{}", (Object)e, (Object)esUpdateStr);
                log.info("\u66f4\u65b0\u5931\u8d25\uff0c\u51c6\u5907\u53d1\u8d77\u91cd\u8bd5\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
            }
        }
        if (retry <= 3) {
            log.info("\u672c\u6b21\u66f4\u65b0\u6210\u529f");
        }
    }

    public String toEsUpdateStr(String id, JSONObject updateParams) {
        JSONObject esJsonObj = new JSONObject();
        esJsonObj.put("doc", (Object)updateParams);
        return esJsonObj.toJSONString();
    }

    public JSONObject getDocByDocId(String indexName, String docId) {
        String endPoint = "/" + indexName + "/_doc/" + docId;
        try {
            Request request = new Request("GET", endPoint);
            Response response = this.restHighLevelClient.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            log.info("esGetStrRsp:{}", (Object)result);
            if (StringUtils.isNotBlank((CharSequence)result)) {
                JSONObject rspJsonObject = JSON.parseObject((String)result);
                if (!ObjectUtils.isEmpty((Object)"_seq_no") && !ObjectUtils.isEmpty((Object)"_primary_term")) {
                    return rspJsonObject;
                }
                throw new BaseBusinessException("8888", "\u67e5\u8be2ES\u6587\u6863\u4fe1\u606f(_seq_no, _primary_term)\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2ES\u6587\u6863\u5931\u8d25:{},\u67e5\u8be2\u8bed\u53e5:{}", (Object)e, (Object)endPoint);
            log.error("\u67e5\u8be2ES\u6587\u6863\u5f02\u5e38\uff1a" + e);
            throw new BaseBusinessException("8888", "\u67e5\u8be2ES\u6587\u6863\u7248\u672c\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return null;
    }

    private String getSource(JSONObject updateParams) {
        StringBuilder stringBuilder = new StringBuilder();
        updateParams.keySet().forEach(key -> stringBuilder.append("ctx._source.").append((String)key).append("=").append("params.").append((String)key).append(";"));
        return stringBuilder.toString();
    }

    public void updateBatch(String indexName, Object docIds, JSONObject source) {
        String endPoint = "/" + indexName + "/_update_by_query";
        String esUpdateStr = this.toEsBatchUpdateStr(docIds, source);
        log.info("esUpdate URL:{}", (Object)endPoint);
        log.info("esUpdateStrReq:{}", (Object)esUpdateStr);
        NStringEntity entity = new NStringEntity(esUpdateStr, ContentType.APPLICATION_JSON);
        try {
            JSONObject rspJsonObject;
            Integer updated;
            Request request = new Request("POST", endPoint);
            request.setEntity((HttpEntity)entity);
            Response response = this.restHighLevelClient.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            log.info("esUpdateStrRsp:{}", (Object)result);
            if (StringUtils.isNotBlank((CharSequence)result) && (updated = (Integer)(rspJsonObject = JSON.parseObject((String)result)).get((Object)"updated")) > 0) {
                log.info("\u6279\u91cf\u66f4\u65b0\u6210\u529f");
            }
        }
        catch (IOException e) {
            log.error("\u6279\u91cf\u66f4\u65b0ES\u6570\u636e\u5931\u8d25:{},\u66f4\u65b0\u8bed\u53e5:{}", (Object)e, (Object)esUpdateStr);
            throw new BaseBusinessException("8888", "\u6279\u91cf\u66f4\u65b0ES\u6570\u636e\u5931\u8d25(ES6)\uff1a" + e.getMessage());
        }
    }

    public String toEsBatchUpdateStr(Object docIds, JSONObject updateParams) {
        JSONArray docList = JSON.parseArray((String)JSON.toJSONString((Object)docIds));
        List idsList = docList.stream().map(Object::toString).collect(Collectors.toList());
        JSONObject ids = new JSONObject();
        ids.put("values", idsList);
        JSONObject query = new JSONObject();
        query.put("ids", (Object)ids);
        JSONObject script = new JSONObject();
        script.put("source", (Object)this.getSource(updateParams));
        script.put("lang", (Object)"painless");
        script.put("params", (Object)updateParams);
        JSONObject esJsonObj = new JSONObject();
        esJsonObj.put("query", (Object)query);
        esJsonObj.put("script", (Object)script);
        return esJsonObj.toJSONString();
    }

    public String toEsBatchDeleteStr(Object docIds) {
        JSONArray docList = JSON.parseArray((String)JSON.toJSONString((Object)docIds));
        List idsList = docList.stream().map(Object::toString).collect(Collectors.toList());
        JSONObject terms = new JSONObject();
        terms.put("_id", idsList);
        JSONObject query = new JSONObject();
        query.put("terms", (Object)terms);
        JSONObject esJsonObj = new JSONObject();
        esJsonObj.put("query", (Object)query);
        return esJsonObj.toJSONString();
    }
}

