package com.tydic.picker.utils;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Aspect
@Component
public class JdbcTemplateAspect {

    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Around("execution(* org.springframework.jdbc.core.JdbcTemplate.*(..))")
    public Object aroundJdbcTemplateMethods(ProceedingJoinPoint joinPoint) throws Throwable {
        Object result = joinPoint.proceed();
        if (result instanceof List) {
            List<?> list = (List<?>) result;
            if (!list.isEmpty() && list.get(0) instanceof Map) {
                return convertDateTimeValues(list);
            }
        }
        return result;
    }

    private List<Map<String, Object>> convertDateTimeValues(List<?> rawList) {
        List<Map<String, Object>> convertedList = new ArrayList<>();
        for (Object item : rawList) {
            @SuppressWarnings("unchecked")
            Map<String, Object> row = (Map<String, Object>) item;
            Map<String, Object> convertedRow = new HashMap<>();
            for (Map.Entry<String, Object> entry : row.entrySet()) {
                convertedRow.put(entry.getKey(), convertDateTimeValue(entry.getValue()));
            }
            convertedList.add(convertedRow);
        }
        return convertedList;
    }

    private Object convertDateTimeValue(Object value) {
        if (value instanceof Timestamp) {
            return value;
        } else if (value instanceof Map) {
            @SuppressWarnings("unchecked")
            Map<String, Object> dateMap = (Map<String, Object>) value;
            if ("datetime".equals(dateMap.get("type")) && dateMap.get("value") instanceof String) {
                try {
                    return Timestamp.valueOf((String) dateMap.get("value"));
                } catch (IllegalArgumentException e) {
                    // 处理解析错误
                    return value;
                }
            }
        } else if (value instanceof String) {
            try {
                return Timestamp.valueOf((String) value);
            } catch (IllegalArgumentException e) {
                // 处理解析错误
                return value;
            }
        } else if (value instanceof Long) {
            return new Timestamp((Long) value);
        }
        return value;
    }
}