/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.picker.utils;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class JdbcTemplateAspect {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Around(value="execution(* org.springframework.jdbc.core.JdbcTemplate.*(..))")
    public Object aroundJdbcTemplateMethods(ProceedingJoinPoint joinPoint) throws Throwable {
        List list;
        Object result = joinPoint.proceed();
        if (result instanceof List && !(list = (List)result).isEmpty() && list.get(0) instanceof Map) {
            return this.convertDateTimeValues(list);
        }
        return result;
    }

    private List<Map<String, Object>> convertDateTimeValues(List<?> rawList) {
        ArrayList<Map<String, Object>> convertedList = new ArrayList<Map<String, Object>>();
        for (Object item : rawList) {
            Map row = (Map)item;
            HashMap convertedRow = new HashMap();
            for (Map.Entry entry : row.entrySet()) {
                convertedRow.put(entry.getKey(), this.convertDateTimeValue(entry.getValue()));
            }
            convertedList.add(convertedRow);
        }
        return convertedList;
    }

    private Object convertDateTimeValue(Object value) {
        if (value instanceof Timestamp) {
            return value;
        }
        if (value instanceof Map) {
            Map dateMap = (Map)value;
            if ("datetime".equals(dateMap.get("type")) && dateMap.get("value") instanceof String) {
                try {
                    return Timestamp.valueOf((String)dateMap.get("value"));
                }
                catch (IllegalArgumentException e) {
                    return value;
                }
            }
        } else {
            if (value instanceof String) {
                try {
                    return Timestamp.valueOf((String)value);
                }
                catch (IllegalArgumentException e) {
                    return value;
                }
            }
            if (value instanceof Long) {
                return new Timestamp((Long)value);
            }
        }
        return value;
    }
}

