package com.tydic.picker.enums;

import com.ohaotian.plugin.base.exception.ZTBusinessException;

import java.util.Arrays;
import java.util.Objects;

/**
 * @ClassName DataEventTypeEnum
 * @Description 数据事件枚举
 * @Author liugs
 * @Date 2022/8/15 16:53
 */
public enum DataEventTypeEnum {

    /**
     * insert event.
     */
    CREATE(1),

    /**
     * update event.
     */
    UPDATE(2),

    /**
     * delete event.
     */
    DELETE(3),

    BATCH_UPDATE(4),

    BATCH_DELETE(5),

    DELETE_BY_QUERY(6)
    ;



    private Integer eventType;

    DataEventTypeEnum(Integer eventType) {
        this.eventType = eventType;
    }

    public Integer getEventType() {
        return eventType;
    }

    /**
     * Acquire by value data event type enum.
     *
     * @param value the value
     * @return the data event type enum
     */
    public static DataEventTypeEnum acquireByValue(final String value) {
        return Arrays.stream(DataEventTypeEnum.values())
                .filter(e -> Objects.equals(e.getEventType(), Integer.valueOf(value)))
                .findFirst()
                .orElseThrow(() -> new ZTBusinessException(String.format("this DataEventTypeEnum not be supported %s", value)));
    }
}
