/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.picker.provider;

import com.lmax.disruptor.EventTranslatorOneArg;
import com.lmax.disruptor.EventTranslatorTwoArg;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.dsl.Disruptor;
import com.tydic.picker.event.DataEvent;
import com.tydic.picker.event.OrderlyDataEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisruptorProvider<T> {
    private static final Logger log = LoggerFactory.getLogger(DisruptorProvider.class);
    private final RingBuffer<DataEvent<T>> ringBuffer;
    private final Disruptor<DataEvent<T>> disruptor;
    private final boolean isOrderly;
    private final EventTranslatorOneArg<DataEvent<T>, T> translatorOneArg = (event, sequence, t) -> event.setData(t);
    private final EventTranslatorTwoArg<DataEvent<T>, T, String> orderlyArg = (event, sequence, t, orderly) -> {
        if (event instanceof OrderlyDataEvent) {
            ((OrderlyDataEvent)event).setHash((String)orderly);
        }
        event.setData(t);
    };

    public DisruptorProvider(RingBuffer<DataEvent<T>> ringBuffer, Disruptor<DataEvent<T>> disruptor, boolean isOrderly) {
        this.ringBuffer = ringBuffer;
        this.disruptor = disruptor;
        this.isOrderly = isOrderly;
    }

    public void onData(T data) {
        if (this.isOrderly) {
            throw new IllegalArgumentException("The current provider is  of orderly type. Please use onOrderlyData() method.");
        }
        try {
            this.ringBuffer.publishEvent(this.translatorOneArg, data);
        }
        catch (Exception ex) {
            log.error("ex", (Throwable)ex);
        }
    }

    public void onOrderlyData(T data, String ... hashArray) {
        if (!this.isOrderly) {
            throw new IllegalArgumentException("The current provider is not of orderly type. Please use onData() method.");
        }
        try {
            String hash = String.join((CharSequence)":", hashArray);
            this.ringBuffer.publishEvent(this.orderlyArg, data, (Object)hash);
        }
        catch (Exception ex) {
            log.error("ex", (Throwable)ex);
        }
    }

    public void shutdown() {
        if (null != this.disruptor) {
            this.disruptor.shutdown();
        }
    }
}

