/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.prc.atom.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.prc.atom.ActivitiTaskAtomService;
import com.tydic.prc.atom.bo.ChangeGroupTaskAtomReqBO;
import com.tydic.prc.atom.bo.ChangeGroupTaskAtomRespBO;
import com.tydic.prc.atom.bo.ChangePersonalTaskAtomReqBO;
import com.tydic.prc.atom.bo.ChangePersonalTaskAtomRespBO;
import com.tydic.prc.atom.bo.CompleteTaskAtomReqBO;
import com.tydic.prc.atom.bo.CompleteTaskAtomRespBO;
import com.tydic.prc.atom.bo.DeleteTaskAtomReqBO;
import com.tydic.prc.atom.bo.DeleteTaskAtomRespBO;
import com.tydic.prc.atom.bo.DeleteVariablesAtomReqBO;
import com.tydic.prc.atom.bo.DeleteVariablesAtomRespBO;
import com.tydic.prc.atom.bo.GetVariablesAtomReqBO;
import com.tydic.prc.atom.bo.GetVariablesAtomRespBO;
import com.tydic.prc.atom.bo.QueryTaskAtomReqBO;
import com.tydic.prc.atom.bo.QueryTaskAtomRespBO;
import com.tydic.prc.atom.bo.QueryTaskBySqlAtomReqBO;
import com.tydic.prc.atom.bo.QueryTaskBySqlAtomRespBO;
import com.tydic.prc.atom.bo.ResolveDelegateTaskAtomReqBO;
import com.tydic.prc.atom.bo.ResolveDelegateTaskAtomRespBO;
import com.tydic.prc.atom.bo.SetVariablesAtomReqBO;
import com.tydic.prc.atom.bo.SetVariablesAtomRespBO;
import com.tydic.prc.atom.bo.TaskAtomBO;
import com.tydic.prc.atom.constant.AtomCommonsConstant;
import com.tydic.prc.dao.PrcReGroupComposeMapper;
import com.tydic.prc.dao.PrcTaskCandidateMapper;
import com.tydic.prc.po.PrcReGroupComposePO;
import com.tydic.prc.po.PrcTaskCandidatePO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.DelegationState;
import org.activiti.engine.task.NativeTaskQuery;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivitiTaskAtomServiceImpl
implements ActivitiTaskAtomService {
    @Autowired
    private TaskService taskService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private PrcReGroupComposeMapper prcReGroupComposeMapper;
    @Autowired
    private PrcTaskCandidateMapper prcTaskCandidateMapper;
    public static final String PERSONAL_TASK_CHANGE_DEAL_DELEGATE = "DELEGATE";
    public static final String PERSONAL_TASK_CHANGE_DEAL_OWNER = "OWNER";
    public static final String PERSONAL_TASK_CHANGE_DEAL_ASSIGNEE = "ASSIGNEE";
    public static final String PERSONAL_TASK_CHANGE_DEAL_UPDATE = "UPDATE";
    public static final String GROUP_TASK_CHANGE_DEAL_CLAIM = "CLAIM";
    public static final String GROUP_TASK_CHANGE_DEAL_UNCLAIM = "UNCLAIM";
    public static final String GROUP_TASK_CHANGE_DEAL_ADD = "ADD";
    public static final String GROUP_TASK_CHANGE_DEAL_DEL = "DEL";
    public static final String GET_VARIABLE_RANGE_GLOBAL = "GLOBAL";
    public static final String GET_VARIABLE_RANGE_SUB = "SUB";
    public static final String GET_VARIABLE_RANGE_LOCAL = "LOCAL";
    public static final String DELEGATION_STATE_PENDING = "PENDING";
    public static final String DELEGATION_STATE_RESOLVED = "RESOLVED";
    public static final String IS_YES = "YES";
    public static final String IS_NO = "NO";

    @Override
    public QueryTaskBySqlAtomRespBO queryTaskBySql(QueryTaskBySqlAtomReqBO reqBO) {
        QueryTaskBySqlAtomRespBO respBO = new QueryTaskBySqlAtomRespBO();
        Long totalCount = 0L;
        List taskList = null;
        NativeTaskQuery nativeTaskQuery = this.taskService.createNativeTaskQuery();
        if (null != reqBO.getCountOnly() && reqBO.getCountOnly().booleanValue()) {
            totalCount = ((NativeTaskQuery)nativeTaskQuery.sql(reqBO.getSql())).list().size();
            respBO.setRspCode("0000");
            respBO.setRspDesc("\u67e5\u8be2\u4efb\u52a1\u6761\u6570\u6210\u529f");
            respBO.setTotalCount(totalCount);
            return respBO;
        }
        totalCount = ((NativeTaskQuery)nativeTaskQuery.sql(reqBO.getSql())).list().size();
        taskList = null != reqBO.getPageNo() && null != reqBO.getPageSize() ? ((NativeTaskQuery)nativeTaskQuery.sql(reqBO.getSql())).listPage((reqBO.getPageNo() - 1) * reqBO.getPageSize(), reqBO.getPageSize().intValue()) : ((NativeTaskQuery)nativeTaskQuery.sql(reqBO.getSql())).listPage((AtomCommonsConstant.DEFAULT_PAGE_NO - 1) * AtomCommonsConstant.DEFAULT_PAGE_SIZE, AtomCommonsConstant.DEFAULT_PAGE_SIZE.intValue());
        if (null != taskList && taskList.size() > 0) {
            respBO.setRspCode("0000");
            respBO.setRspDesc("\u67e5\u8be2\u4efb\u52a1\u6210\u529f");
            respBO.setTotalCount(totalCount);
            if (null != reqBO && null != reqBO.getGetVariables() && reqBO.getGetVariables().booleanValue()) {
                respBO.setTaskList(this.setTaskInfoListData(taskList, true));
            } else {
                respBO.setTaskList(this.setTaskInfoListData(taskList, false));
            }
        } else {
            respBO.setRspCode("1011");
            respBO.setRspDesc("\u672a\u67e5\u8be2\u5230\u6570\u636e");
        }
        return respBO;
    }

    @Override
    public QueryTaskAtomRespBO queryTask(QueryTaskAtomReqBO reqBO) {
        QueryTaskAtomRespBO respBO = new QueryTaskAtomRespBO();
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Long totalCount = 0L;
        List taskList = null;
        if (null != reqBO) {
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getSysCode())) {
                taskQuery.taskTenantId(reqBO.getSysCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getExecutionId())) {
                taskQuery.executionId(reqBO.getExecutionId());
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getProcInstId())) {
                taskQuery.processInstanceId(reqBO.getProcInstId());
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getProcDefId())) {
                taskQuery.processDefinitionId(reqBO.getProcDefId());
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getProcDefKey())) {
                taskQuery.processDefinitionKey(reqBO.getProcDefKey());
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getProcDefName())) {
                taskQuery.processDefinitionNameLike("%" + reqBO.getProcDefName() + "%");
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getTaskAssignee())) {
                taskQuery.taskAssignee(reqBO.getTaskAssignee());
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getTaskCandidateUser())) {
                taskQuery.taskCandidateUser(reqBO.getTaskCandidateUser());
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getTaskId())) {
                taskQuery.taskId(reqBO.getTaskId());
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getTaskOwner())) {
                taskQuery.taskOwner(reqBO.getTaskOwner());
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getTaskDefKey())) {
                taskQuery.taskDefinitionKey(reqBO.getTaskDefKey());
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getTaskName())) {
                taskQuery.taskNameLike("%" + reqBO.getTaskName() + "%");
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getDelegationState()) && DELEGATION_STATE_PENDING.equals(reqBO.getDelegationState())) {
                taskQuery.taskDelegationState(DelegationState.PENDING);
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getDelegationState()) && DELEGATION_STATE_RESOLVED.equals(reqBO.getDelegationState())) {
                taskQuery.taskDelegationState(DelegationState.RESOLVED);
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getActiveType())) {
                if ("ACTIVE".equals(reqBO.getActiveType())) {
                    taskQuery.active();
                } else if ("SUSPEND".equals(reqBO.getActiveType())) {
                    taskQuery.suspended();
                } else {
                    respBO.setRspCode("1011");
                    respBO.setRspDesc("\u4f20\u5165\u7684\u4efb\u52a1\u72b6\u6001\u6807\u8bc6[active_type]\u65e0\u6cd5\u8bc6\u522b");
                    return respBO;
                }
            }
            if (null != reqBO.getCreateDateStart()) {
                taskQuery.taskCreatedAfter(reqBO.getCreateDateStart());
            }
            if (null != reqBO.getCreateDateEnd()) {
                taskQuery.taskCreatedBefore(reqBO.getCreateDateEnd());
            }
            if (null != reqBO.getDueDateStart()) {
                taskQuery.taskDueAfter(reqBO.getDueDateStart());
            }
            if (null != reqBO.getDueDateEnd()) {
                taskQuery.taskDueBefore(reqBO.getDueDateEnd());
            }
            if (null != reqBO.getProcVariables()) {
                Map<String, Object> procVariables = reqBO.getProcVariables();
                for (String procVariableName : procVariables.keySet()) {
                    if (null == procVariables.get(procVariableName)) continue;
                    taskQuery.processVariableValueEquals(procVariableName, procVariables.get(procVariableName));
                }
            }
            if (null != reqBO.getTaskVariables()) {
                Map<String, Object> taskVariables = reqBO.getTaskVariables();
                for (String taskVariableName : taskVariables.keySet()) {
                    if (null == taskVariables.get(taskVariableName)) continue;
                    taskQuery.processVariableValueEquals(taskVariableName, taskVariables.get(taskVariableName));
                }
            }
            if (null != reqBO.getCountOnly() && reqBO.getCountOnly().booleanValue()) {
                totalCount = taskQuery.count();
                respBO.setRspCode("0000");
                respBO.setRspDesc("\u67e5\u8be2\u4efb\u52a1\u6761\u6570\u6210\u529f");
                respBO.setTotalCount(totalCount);
                return respBO;
            }
            if (null != reqBO.getPageNo() && null != reqBO.getPageSize()) {
                totalCount = taskQuery.count();
                taskList = taskQuery.listPage((reqBO.getPageNo() - 1) * reqBO.getPageSize(), reqBO.getPageSize().intValue());
            } else {
                totalCount = taskQuery.count();
                taskList = taskQuery.listPage((AtomCommonsConstant.DEFAULT_PAGE_NO - 1) * AtomCommonsConstant.DEFAULT_PAGE_SIZE, AtomCommonsConstant.DEFAULT_PAGE_SIZE.intValue());
            }
        } else {
            totalCount = taskQuery.count();
            taskList = taskQuery.listPage((AtomCommonsConstant.DEFAULT_PAGE_NO - 1) * AtomCommonsConstant.DEFAULT_PAGE_SIZE, AtomCommonsConstant.DEFAULT_PAGE_SIZE.intValue());
        }
        if (null != taskList && taskList.size() > 0) {
            respBO.setRspCode("0000");
            respBO.setRspDesc("\u67e5\u8be2\u4efb\u52a1\u6210\u529f");
            respBO.setTotalCount(totalCount);
            if (null != reqBO && null != reqBO.getGetVariables() && reqBO.getGetVariables().booleanValue()) {
                respBO.setTaskList(this.setTaskInfoListData(taskList, true));
            } else {
                respBO.setTaskList(this.setTaskInfoListData(taskList, false));
            }
        } else {
            respBO.setRspCode("1011");
            respBO.setRspDesc("\u672a\u67e5\u8be2\u5230\u6570\u636e");
        }
        return respBO;
    }

    private List<TaskAtomBO> setTaskInfoListData(List<Task> list, Boolean needVariables) {
        if (null != list && list.size() > 0) {
            ArrayList<TaskAtomBO> resultList = new ArrayList<TaskAtomBO>();
            for (Task t : list) {
                TaskAtomBO taskBo = new TaskAtomBO();
                Map localVariables = this.taskService.getVariablesLocal(t.getId());
                Map variables = this.runtimeService.getVariables(t.getProcessInstanceId());
                String groupId = localVariables.get("groupId").toString();
                if (!groupId.equals(t.getAssignee())) {
                    taskBo.setTaskAssignee(t.getAssignee());
                } else {
                    PrcReGroupComposePO queryPrcReGroupComposePO = new PrcReGroupComposePO();
                    queryPrcReGroupComposePO.setSysCode(t.getTenantId());
                    queryPrcReGroupComposePO.setGroupId(groupId);
                    List<PrcReGroupComposePO> prcReGroupComposePOResult = this.prcReGroupComposeMapper.selectByCondition(queryPrcReGroupComposePO);
                    if (prcReGroupComposePOResult != null && prcReGroupComposePOResult.size() > 0) {
                        ArrayList<String> candidateIds = new ArrayList<String>();
                        for (PrcReGroupComposePO prgc : prcReGroupComposePOResult) {
                            candidateIds.add(prgc.getOperId());
                        }
                        taskBo.setCandidateIds(candidateIds);
                    } else {
                        PrcTaskCandidatePO prcTaskCandidatePO = new PrcTaskCandidatePO();
                        prcTaskCandidatePO.setGroupId(groupId);
                        prcTaskCandidatePO.setSysCode(t.getTenantId());
                        List<PrcTaskCandidatePO> prcTaskCandidatePOList = this.prcTaskCandidateMapper.selectByCondition(prcTaskCandidatePO);
                        if (prcTaskCandidatePOList != null && prcTaskCandidatePOList.size() > 0) {
                            ArrayList<String> candidateIds = new ArrayList<String>();
                            for (PrcTaskCandidatePO ptc : prcTaskCandidatePOList) {
                                candidateIds.add(ptc.getOperId());
                            }
                            taskBo.setCandidateIds(candidateIds);
                        }
                    }
                }
                taskBo.setDelegationState(String.valueOf(t.getDelegationState()));
                taskBo.setTaskId(t.getId());
                taskBo.setSysCode(t.getTenantId());
                taskBo.setTaskName(t.getName());
                taskBo.setTaskOwner(t.getOwner());
                taskBo.setExecutionId(t.getExecutionId());
                taskBo.setProcInstId(t.getProcessInstanceId());
                taskBo.setProcDefId(t.getProcessDefinitionId());
                taskBo.setParentTaskId(t.getParentTaskId());
                taskBo.setTaskDefKey(t.getTaskDefinitionKey());
                taskBo.setTaskDesc(t.getDescription());
                taskBo.setCreateTime(DateUtils.dateToStr((Date)t.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                taskBo.setDueDate(DateUtils.dateToStr((Date)t.getDueDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                taskBo.setGroupId(groupId);
                taskBo.setIsSendMqMsg(Boolean.valueOf(localVariables.get("isSendMqMsg").toString()));
                taskBo.setIsCallService(Boolean.valueOf(localVariables.get("isCallService").toString()));
                taskBo.setIsSendNotice(Boolean.valueOf(localVariables.get("isSendNotice").toString()));
                taskBo.setBusiSn(String.valueOf(variables.get("busiSn")));
                taskBo.setBusiCode(String.valueOf(variables.get("busiCode")));
                if (null != needVariables && needVariables.booleanValue()) {
                    taskBo.setTaskLocalVariables(localVariables);
                    if (t.getExecutionId().equals(t.getProcessInstanceId())) {
                        taskBo.setSuperProcVariables(this.runtimeService.getVariables(t.getExecutionId()));
                    } else {
                        taskBo.setSubProcVariables(this.runtimeService.getVariablesLocal(t.getExecutionId()));
                        taskBo.setSuperProcVariables(variables);
                    }
                }
                resultList.add(taskBo);
            }
            return resultList;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public ChangePersonalTaskAtomRespBO changePersonalTask(ChangePersonalTaskAtomReqBO reqBO) {
        ChangePersonalTaskAtomRespBO respBO = new ChangePersonalTaskAtomRespBO();
        if (null == reqBO || null == reqBO.getTaskId() || null == reqBO.getDealType()) {
            respBO.setRspCode("1012");
            respBO.setRspDesc("\u5fc5\u4f20\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return respBO;
        }
        if (PERSONAL_TASK_CHANGE_DEAL_DELEGATE.equals(reqBO.getDealType())) {
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getUserId())) {
                this.taskService.delegateTask(reqBO.getTaskId(), reqBO.getUserId());
                this.setTaskDueDateAndPriorty(reqBO.getTaskId(), reqBO.getDueDate(), reqBO.getPriorty());
                return respBO;
            }
            respBO.setRspCode("1012");
            respBO.setRspDesc("\u4e2a\u4eba\u4efb\u52a1\u59d4\u6d3e\u65f6\uff0c\u59d4\u6d3e\u4ebaid[userId]\u4e0d\u80fd\u4e3a\u7a7a");
            return respBO;
        }
        if (PERSONAL_TASK_CHANGE_DEAL_OWNER.equals(reqBO.getDealType())) {
            if (StringUtils.isNotBlank((CharSequence)reqBO.getUserId())) {
                this.taskService.setOwner(reqBO.getTaskId(), reqBO.getUserId());
                this.setTaskDueDateAndPriorty(reqBO.getTaskId(), reqBO.getDueDate(), reqBO.getPriorty());
                return respBO;
            }
            respBO.setRspCode("1012");
            respBO.setRspDesc("\u4e2a\u4eba\u4efb\u52a1\u8f6c\u8ba9\u65f6\uff0c\u8f6c\u8ba9\u4ebaid[userId]\u4e0d\u80fd\u4e3a\u7a7a");
            return respBO;
        }
        if (PERSONAL_TASK_CHANGE_DEAL_ASSIGNEE.equals(reqBO.getDealType())) {
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getUserId())) {
                this.taskService.setAssignee(reqBO.getTaskId(), reqBO.getUserId());
                this.setTaskDueDateAndPriorty(reqBO.getTaskId(), reqBO.getDueDate(), reqBO.getPriorty());
                return respBO;
            }
            respBO.setRspCode("1012");
            respBO.setRspDesc("\u4e2a\u4eba\u4efb\u52a1\u53d8\u66f4\u5904\u7406\u4eba\u65f6\uff0c\u5904\u7406\u4ebaid[userId]\u4e0d\u80fd\u4e3a\u7a7a");
            return respBO;
        }
        if (PERSONAL_TASK_CHANGE_DEAL_UPDATE.equals(reqBO.getDealType())) {
            this.setTaskDueDateAndPriorty(reqBO.getTaskId(), reqBO.getDueDate(), reqBO.getPriorty());
            return respBO;
        }
        respBO.setRspCode("1012");
        respBO.setRspDesc("\u65e0\u6cd5\u8bc6\u522b\u7684\u64cd\u4f5c\u7c7b\u578b[dealType]");
        return respBO;
    }

    private void setTaskDueDateAndPriorty(String taskId, Date dueDate, Integer priorty) {
        if (null != dueDate) {
            this.taskService.setDueDate(taskId, dueDate);
        }
        if (null != priorty) {
            this.taskService.setPriority(taskId, priorty.intValue());
        }
    }

    @Override
    public CompleteTaskAtomRespBO completeTask(CompleteTaskAtomReqBO reqBO) {
        CompleteTaskAtomRespBO respBO = new CompleteTaskAtomRespBO();
        if (null == reqBO || StringUtils.isEmpty((CharSequence)reqBO.getTaskId())) {
            respBO.setRspCode("1013");
            respBO.setRspDesc("\u4efb\u52a1id[taskId]\u4e0d\u80fd\u4e3a\u7a7a");
            return respBO;
        }
        Task task = (Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskId(reqBO.getTaskId())).taskTenantId(reqBO.getSysCode())).singleResult();
        if (task != null) {
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getCommentCode())) {
                this.taskService.setVariableLocal(reqBO.getTaskId(), "prcTaskCompleteCommentCode", (Object)reqBO.getCommentCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getCommentDesc())) {
                this.taskService.setVariableLocal(reqBO.getTaskId(), "prcTaskCompleteCommentDesc", (Object)reqBO.getCommentDesc());
            }
            if (null != reqBO.getVariables()) {
                this.taskService.complete(reqBO.getTaskId(), reqBO.getVariables());
            } else {
                this.taskService.complete(reqBO.getTaskId());
            }
            ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            if (processInstance != null) {
                respBO.setIsFinish(IS_NO);
            } else {
                respBO.setIsFinish(IS_YES);
            }
            respBO.setIsRecomplete(IS_NO);
            respBO.setRspCode("0000");
            respBO.setRspDesc("\u4efb\u52a1\u63d0\u4ea4\u6210\u529f");
            respBO.setProcInstId(task.getProcessInstanceId());
            return respBO;
        }
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(reqBO.getTaskId())).taskTenantId(reqBO.getSysCode())).finished().singleResult();
        if (historicTaskInstance != null) {
            ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(historicTaskInstance.getProcessInstanceId()).singleResult();
            if (processInstance != null) {
                respBO.setIsFinish(IS_NO);
            } else {
                respBO.setIsFinish(IS_YES);
            }
            respBO.setRspCode("0000");
            respBO.setIsRecomplete(IS_YES);
            respBO.setRspDesc("\u8be5\u4efb\u52a1\u5df2\u4f5c\u8fc7\u6210\u529f\u63d0\u4ea4");
            respBO.setProcInstId(historicTaskInstance.getProcessInstanceId());
            return respBO;
        }
        respBO.setRspCode("1013");
        respBO.setRspDesc("\u8be5\u7cfb\u7edf\u4e2d\u4efb\u52a1\u4e0d\u5b58\u5728");
        return respBO;
    }

    @Override
    public DeleteTaskAtomRespBO deleteTask(DeleteTaskAtomReqBO reqBO) {
        DeleteTaskAtomRespBO respBO = new DeleteTaskAtomRespBO();
        if (null == reqBO || StringUtils.isEmpty((CharSequence)reqBO.getTaskId())) {
            respBO.setRspCode("1014");
            respBO.setRspDesc("\u4efb\u52a1id[taskId]\u4e0d\u80fd\u4e3a\u7a7a");
            return respBO;
        }
        String delReason = "";
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getDelReasonCode())) {
            delReason = delReason + "\u5220\u9664\u539f\u56e0\u7f16\u7801\uff1a" + reqBO.getDelReasonCode();
            this.taskService.setVariableLocal(reqBO.getTaskId(), "prcTaskDelReasonCode", (Object)reqBO.getDelReasonCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getDelReasonDesc())) {
            delReason = delReason + "\u5220\u9664\u539f\u56e0\u63cf\u8ff0\uff1a" + reqBO.getDelReasonDesc();
            this.taskService.setVariableLocal(reqBO.getTaskId(), "prcTaskDelReasonDesc", (Object)reqBO.getDelReasonDesc());
        }
        this.taskService.deleteTask(reqBO.getTaskId(), delReason);
        respBO.setRspCode("0000");
        respBO.setRspDesc("\u4efb\u52a1\u5220\u9664\u6210\u529f");
        return respBO;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public ChangeGroupTaskAtomRespBO changeGroupTask(ChangeGroupTaskAtomReqBO reqBO) {
        ChangeGroupTaskAtomRespBO respBO = new ChangeGroupTaskAtomRespBO();
        if (null == reqBO || StringUtils.isEmpty((CharSequence)reqBO.getTaskId()) || StringUtils.isEmpty((CharSequence)reqBO.getDealType())) {
            respBO.setRspCode("1015");
            respBO.setRspDesc("\u5fc5\u4f20\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return respBO;
        }
        if (GROUP_TASK_CHANGE_DEAL_CLAIM.equals(reqBO.getDealType())) {
            if (!StringUtils.isNotEmpty((CharSequence)reqBO.getUserId())) {
                respBO.setRspCode("1015");
                respBO.setRspDesc("\u9886\u53d6\u4efb\u52a1\u65f6\uff0c\u9886\u53d6\u4eba[user_id]\u4e0d\u80fd\u4e3a\u7a7a");
                return respBO;
            }
            this.taskService.claim(reqBO.getTaskId(), reqBO.getUserId());
        } else if (GROUP_TASK_CHANGE_DEAL_UNCLAIM.equals(reqBO.getDealType())) {
            this.taskService.setAssignee(reqBO.getTaskId(), null);
        } else if (GROUP_TASK_CHANGE_DEAL_ADD.equals(reqBO.getDealType())) {
            if (!StringUtils.isNotEmpty((CharSequence)reqBO.getUserId())) {
                respBO.setRspCode("1015");
                respBO.setRspDesc("\u6dfb\u52a0\u7ec4\u4efb\u52a1\u5019\u9009\u4eba\u65f6\uff0c\u5019\u9009\u4eba[user_id]\u4e0d\u80fd\u4e3a\u7a7a");
                return respBO;
            }
            this.taskService.addCandidateUser(reqBO.getTaskId(), reqBO.getUserId());
        } else {
            if (!GROUP_TASK_CHANGE_DEAL_DEL.equals(reqBO.getDealType())) {
                respBO.setRspCode("1015");
                respBO.setRspDesc("\u65e0\u6cd5\u8bc6\u522b\u7684\u64cd\u4f5c\u7c7b\u578b[deal_type]");
                return respBO;
            }
            if (!StringUtils.isNotEmpty((CharSequence)reqBO.getUserId())) {
                respBO.setRspCode("1015");
                respBO.setRspDesc("\u5220\u9664\u7ec4\u4efb\u52a1\u5019\u9009\u4eba\u65f6\uff0c\u5019\u9009\u4eba[user_id]\u4e0d\u80fd\u4e3a\u7a7a");
                return respBO;
            }
            this.taskService.deleteCandidateUser(reqBO.getTaskId(), reqBO.getUserId());
        }
        respBO.setRspCode("0000");
        respBO.setRspDesc("\u53d8\u66f4\u7ec4\u4efb\u52a1\u4fe1\u606f\u6210\u529f");
        return respBO;
    }

    @Override
    public SetVariablesAtomRespBO setVariables(SetVariablesAtomReqBO reqBO) {
        SetVariablesAtomRespBO respBO = new SetVariablesAtomRespBO();
        if (StringUtils.isEmpty((CharSequence)reqBO.getTask_id()) && StringUtils.isEmpty((CharSequence)reqBO.getProc_inst_id())) {
            respBO.setRspCode("1016");
            respBO.setRspDesc("\u4efb\u52a1id[task_id]\u548c\u6d41\u7a0b\u5b9e\u4f8bid[proc_inst_id]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            return respBO;
        }
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getProc_inst_id()) && null != reqBO.getSuper_proc_variables()) {
            this.runtimeService.setVariables(reqBO.getProc_inst_id(), reqBO.getSuper_proc_variables());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getTask_id())) {
            if (null != reqBO.getTask_local_variables()) {
                this.taskService.setVariablesLocal(reqBO.getTask_id(), reqBO.getTask_local_variables());
            }
            if (null != reqBO.getSuper_proc_variables()) {
                String procInstId = ((Task)((TaskQuery)this.taskService.createTaskQuery().taskId(reqBO.getTask_id())).singleResult()).getProcessInstanceId();
                this.runtimeService.setVariables(procInstId, reqBO.getSuper_proc_variables());
            }
            if (null != reqBO.getSub_proc_variables()) {
                String executionId = ((Task)((TaskQuery)this.taskService.createTaskQuery().taskId(reqBO.getTask_id())).singleResult()).getExecutionId();
                this.runtimeService.setVariablesLocal(executionId, reqBO.getSub_proc_variables());
            }
        }
        respBO.setRspCode("0000");
        respBO.setRspDesc("\u8bbe\u7f6e\u6d41\u7a0b\u53c2\u6570\u5b8c\u6210");
        return respBO;
    }

    @Override
    public DeleteVariablesAtomRespBO deleteVariables(DeleteVariablesAtomReqBO reqBO) {
        DeleteVariablesAtomRespBO respBO = new DeleteVariablesAtomRespBO();
        if (StringUtils.isBlank((CharSequence)reqBO.getTaskId()) && StringUtils.isBlank((CharSequence)reqBO.getProcInstId())) {
            respBO.setRspCode("1017");
            respBO.setRspDesc("\u4efb\u52a1id[taskId]\u548c\u6d41\u7a0b\u5b9e\u4f8bid[procInstId]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            return respBO;
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getProcInstId()) && null != reqBO.getSpuerProcVariableNames()) {
            this.runtimeService.removeVariables(reqBO.getProcInstId(), reqBO.getSpuerProcVariableNames());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getTaskId())) {
            if (null != reqBO.getTaskLocalVariableNames()) {
                this.taskService.removeVariablesLocal(reqBO.getTaskId(), reqBO.getTaskLocalVariableNames());
            }
            if (null != reqBO.getSpuerProcVariableNames()) {
                this.taskService.removeVariables(reqBO.getTaskId(), reqBO.getSpuerProcVariableNames());
            }
            if (null != reqBO.getSubProcVariableNames()) {
                String executionId = ((Task)((TaskQuery)this.taskService.createTaskQuery().taskId(reqBO.getTaskId())).singleResult()).getExecutionId();
                this.runtimeService.removeVariablesLocal(executionId, reqBO.getSubProcVariableNames());
            }
        }
        respBO.setRspCode("0000");
        respBO.setRspDesc("\u5220\u9664\u6d41\u7a0b\u53c2\u6570\u5b8c\u6210");
        return respBO;
    }

    @Override
    public GetVariablesAtomRespBO getVariables(GetVariablesAtomReqBO reqBO) {
        GetVariablesAtomRespBO respBO = new GetVariablesAtomRespBO();
        if (StringUtils.isNotBlank((CharSequence)reqBO.getTaskId())) {
            Task task = (Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskId(reqBO.getTaskId())).taskTenantId(reqBO.getSysCode())).singleResult();
            if (null == task) {
                respBO.setRspCode("1018");
                respBO.setRspDesc("\u8be5\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u5bf9\u5e94\u4efb\u52a1\u6570\u636e");
                return respBO;
            }
            if (GET_VARIABLE_RANGE_GLOBAL.equals(reqBO.getRangeType())) {
                if (null != reqBO.getSuperProcVariableNames() && !reqBO.getSuperProcVariableNames().isEmpty()) {
                    respBO.setSuperProcVariables(this.runtimeService.getVariables(task.getProcessInstanceId(), reqBO.getSuperProcVariableNames()));
                } else {
                    respBO.setSuperProcVariables(this.runtimeService.getVariables(task.getProcessInstanceId()));
                }
            } else if (GET_VARIABLE_RANGE_SUB.equals(reqBO.getRangeType())) {
                if (null != reqBO.getSuperProcVariableNames() && !reqBO.getSuperProcVariableNames().isEmpty()) {
                    respBO.setSuperProcVariables(this.runtimeService.getVariables(task.getProcessInstanceId(), reqBO.getSuperProcVariableNames()));
                } else {
                    respBO.setSuperProcVariables(this.runtimeService.getVariables(task.getProcessInstanceId()));
                }
                if (!task.getProcessInstanceId().equals(task.getExecutionId())) {
                    if (null != reqBO.getSubProcVariableNames() && !reqBO.getSubProcVariableNames().isEmpty()) {
                        respBO.setSubProcVariables(this.runtimeService.getVariablesLocal(task.getExecutionId(), reqBO.getSubProcVariableNames()));
                    } else {
                        respBO.setSubProcVariables(this.runtimeService.getVariablesLocal(task.getExecutionId()));
                    }
                }
            } else if (StringUtils.isBlank((CharSequence)reqBO.getRangeType()) || GET_VARIABLE_RANGE_LOCAL.equals(reqBO.getRangeType())) {
                if (null != reqBO.getSuperProcVariableNames() && !reqBO.getSuperProcVariableNames().isEmpty()) {
                    respBO.setSuperProcVariables(this.runtimeService.getVariables(task.getProcessInstanceId(), reqBO.getSuperProcVariableNames()));
                } else {
                    respBO.setSuperProcVariables(this.runtimeService.getVariables(task.getProcessInstanceId()));
                }
                if (!task.getProcessInstanceId().equals(task.getExecutionId())) {
                    if (null != reqBO.getSubProcVariableNames() && !reqBO.getSubProcVariableNames().isEmpty()) {
                        respBO.setSubProcVariables(this.runtimeService.getVariablesLocal(task.getExecutionId(), reqBO.getSubProcVariableNames()));
                    } else {
                        respBO.setSubProcVariables(this.runtimeService.getVariablesLocal(task.getExecutionId()));
                    }
                }
                if (null != reqBO.getTaskLocalVariableNames() && !reqBO.getTaskLocalVariableNames().isEmpty()) {
                    respBO.setTaskLocalVariables(this.taskService.getVariablesLocal(task.getId(), reqBO.getTaskLocalVariableNames()));
                } else {
                    respBO.setTaskLocalVariables(this.taskService.getVariablesLocal(task.getId()));
                }
            } else {
                respBO.setRspCode("1018");
                respBO.setRspDesc("\u65e0\u6cd5\u8bc6\u522b\u7684\u53c2\u6570\u83b7\u53d6\u8303\u56f4");
                return respBO;
            }
            respBO.setRspCode("0000");
            respBO.setRspDesc("\u83b7\u53d6\u6d41\u7a0b\u53c2\u6570\u6210\u529f");
            return respBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getTaskId()) && StringUtils.isNotBlank((CharSequence)reqBO.getProcInstId())) {
            ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(reqBO.getProcInstId()).processInstanceTenantId(reqBO.getSysCode()).singleResult();
            if (null == processInstance) {
                respBO.setRspCode("1018");
                respBO.setRspDesc("\u8be5\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u5bf9\u5e94\u6d41\u7a0b\u5b9e\u4f8b\u6570\u636e");
                return respBO;
            }
            if (null != reqBO.getSuperProcVariableNames() && !reqBO.getSuperProcVariableNames().isEmpty()) {
                respBO.setSuperProcVariables(this.runtimeService.getVariables(processInstance.getProcessInstanceId(), reqBO.getSuperProcVariableNames()));
            } else {
                respBO.setSuperProcVariables(this.runtimeService.getVariables(processInstance.getProcessInstanceId()));
            }
            respBO.setRspCode("0000");
            respBO.setRspDesc("\u83b7\u53d6\u6d41\u7a0b\u53c2\u6570\u6210\u529f");
            return respBO;
        }
        respBO.setRspCode("1018");
        respBO.setRspDesc("\u4efb\u52a1id[taskId]\u548c\u6d41\u7a0b\u5b9e\u4f8bid[procInstId]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        return respBO;
    }

    @Override
    public ResolveDelegateTaskAtomRespBO resolveDelegateTask(ResolveDelegateTaskAtomReqBO reqBO) {
        ResolveDelegateTaskAtomRespBO respBO = new ResolveDelegateTaskAtomRespBO();
        if (null == reqBO || StringUtils.isEmpty((CharSequence)reqBO.getTaskId())) {
            respBO.setRspCode("1019");
            respBO.setRspDesc("\u5fc5\u4f20\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return respBO;
        }
        Task task = (Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskId(reqBO.getTaskId())).taskTenantId(reqBO.getSysCode())).singleResult();
        if (null == task) {
            respBO.setRspCode("1019");
            respBO.setRspDesc("\u8be5\u7cfb\u7edf\u4e0d\u5b58\u5728\u6b64\u4efb\u52a1\u6570\u636e");
            return respBO;
        }
        if (task.getDelegationState() != null && DELEGATION_STATE_PENDING.equals(task.getDelegationState().toString())) {
            if (null != reqBO.getVariables() && !reqBO.getVariables().isEmpty()) {
                this.taskService.resolveTask(reqBO.getTaskId(), reqBO.getVariables());
            } else {
                this.taskService.resolveTask(reqBO.getTaskId());
            }
            respBO.setRspCode("0000");
            respBO.setRspDesc("\u5904\u7406\u59d4\u6258\u4efb\u52a1\u6210\u529f");
            return respBO;
        }
        if (task.getDelegationState() != null && DELEGATION_STATE_RESOLVED.equals(task.getDelegationState().toString())) {
            respBO.setRspCode("1019");
            respBO.setRspDesc("\u8be5\u59d4\u6258\u4efb\u52a1\u5df2\u7ecf\u5904\u7406");
            return respBO;
        }
        respBO.setRspCode("1019");
        respBO.setRspDesc("\u8be5\u4efb\u52a1\u4e3a\u975e\u59d4\u6258\u4efb\u52a1");
        return respBO;
    }
}

