/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.prc.atom.impl;

import com.tydic.prc.atom.ActivitiRuntimeAtomService;
import com.tydic.prc.atom.bo.ChangeProcessInstanceAtomReqBO;
import com.tydic.prc.atom.bo.ChangeProcessInstanceAtomRespBO;
import com.tydic.prc.atom.bo.ProcessInstanceAtomBO;
import com.tydic.prc.atom.bo.QueryProcressInstanceInfoAtomReqBO;
import com.tydic.prc.atom.bo.QueryProcressInstanceInfoAtomRespBO;
import com.tydic.prc.atom.bo.StartProcessAtomReqBO;
import com.tydic.prc.atom.bo.StartProcessAtomRespBO;
import com.tydic.prc.atom.constant.AtomCommonsConstant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.runtime.ProcessInstanceQuery;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivitiRuntimeAtomServiceImpl
implements ActivitiRuntimeAtomService {
    @Autowired
    private RuntimeService runtimeService;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public StartProcessAtomRespBO startProcess(StartProcessAtomReqBO startProcessReqBO) {
        StartProcessAtomRespBO startProcessRespBO = new StartProcessAtomRespBO();
        if (startProcessReqBO == null) {
            startProcessRespBO.setRspCode("1008");
            startProcessRespBO.setRspDesc("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3anull");
            return startProcessRespBO;
        }
        ProcessInstance processInstance = null;
        if (StringUtils.isNotEmpty((CharSequence)startProcessReqBO.getProcDefId())) {
            processInstance = StringUtils.isNotEmpty((CharSequence)startProcessReqBO.getBusinessKey()) ? (null != startProcessReqBO.getProcVariables() ? this.runtimeService.startProcessInstanceById(startProcessReqBO.getProcDefId(), startProcessReqBO.getBusinessKey(), startProcessReqBO.getProcVariables()) : this.runtimeService.startProcessInstanceById(startProcessReqBO.getProcDefId(), startProcessReqBO.getBusinessKey())) : (null != startProcessReqBO.getProcVariables() ? this.runtimeService.startProcessInstanceById(startProcessReqBO.getProcDefId(), startProcessReqBO.getProcVariables()) : this.runtimeService.startProcessInstanceById(startProcessReqBO.getProcDefId()));
        } else if (StringUtils.isEmpty((CharSequence)startProcessReqBO.getProcDefId()) && StringUtils.isNotEmpty((CharSequence)startProcessReqBO.getProcDefKey())) {
            if (!StringUtils.isNotEmpty((CharSequence)startProcessReqBO.getTenantId())) {
                startProcessRespBO.setRspCode("1008");
                startProcessRespBO.setRspDesc("\u4f7f\u7528\u6d41\u7a0b\u5b9a\u4e49key\u542f\u52a8\u65f6\uff0c\u79df\u6237id[tenant_id]\u4e0d\u80fd\u4e3a\u7a7a");
                return startProcessRespBO;
            }
            processInstance = StringUtils.isNotEmpty((CharSequence)startProcessReqBO.getBusinessKey()) ? (null != startProcessReqBO.getProcVariables() ? this.runtimeService.startProcessInstanceByKeyAndTenantId(startProcessReqBO.getProcDefKey(), startProcessReqBO.getBusinessKey(), startProcessReqBO.getProcVariables(), startProcessReqBO.getTenantId()) : this.runtimeService.startProcessInstanceByKeyAndTenantId(startProcessReqBO.getProcDefKey(), startProcessReqBO.getBusinessKey(), startProcessReqBO.getTenantId())) : (null != startProcessReqBO.getProcVariables() ? this.runtimeService.startProcessInstanceByKeyAndTenantId(startProcessReqBO.getProcDefKey(), startProcessReqBO.getProcVariables(), startProcessReqBO.getTenantId()) : this.runtimeService.startProcessInstanceByKeyAndTenantId(startProcessReqBO.getProcDefKey(), startProcessReqBO.getTenantId()));
        } else {
            startProcessRespBO.setRspCode("1008");
            startProcessRespBO.setRspDesc("\u5165\u53c2\u6d41\u7a0b\u5b9a\u4e49id[proc_def_id]\u548c\u6d41\u7a0b\u5b9a\u4e49key[proc_def_key]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            return startProcessRespBO;
        }
        if (null == processInstance) {
            startProcessRespBO.setRspCode("1008");
            startProcessRespBO.setRspDesc("\u542f\u52a8\u6d41\u7a0b\u5b9e\u4f8b\u5931\u8d25");
            return startProcessRespBO;
        }
        if (StringUtils.isNotEmpty((CharSequence)startProcessReqBO.getProcInstName())) {
            this.runtimeService.setProcessInstanceName(processInstance.getProcessInstanceId(), startProcessReqBO.getProcInstName());
        }
        startProcessRespBO.setRspCode("0000");
        startProcessRespBO.setRspDesc("\u542f\u52a8\u6d41\u7a0b\u5b9e\u4f8b\u6210\u529f");
        startProcessRespBO.setExecutionId(processInstance.getId());
        startProcessRespBO.setProcDefId(processInstance.getProcessDefinitionId());
        startProcessRespBO.setProcInstId(processInstance.getProcessInstanceId());
        return startProcessRespBO;
    }

    @Override
    public QueryProcressInstanceInfoAtomRespBO queryProcressInstanceInfo(QueryProcressInstanceInfoAtomReqBO queryProcressInstanceInfoReqBO) {
        QueryProcressInstanceInfoAtomRespBO respBO = new QueryProcressInstanceInfoAtomRespBO();
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery();
        List processInstanceList = null;
        Long totalCount = 0L;
        if (null != queryProcressInstanceInfoReqBO) {
            if ("ACTIVE".equals(queryProcressInstanceInfoReqBO.getActiveType())) {
                processInstanceQuery.active();
            }
            if ("SUSPEND".equals(queryProcressInstanceInfoReqBO.getActiveType())) {
                processInstanceQuery.suspended();
            }
            if (StringUtils.isNotEmpty((CharSequence)queryProcressInstanceInfoReqBO.getProcInstId())) {
                processInstanceQuery.processInstanceId(queryProcressInstanceInfoReqBO.getProcInstId());
            }
            if (StringUtils.isNotEmpty((CharSequence)queryProcressInstanceInfoReqBO.getProcDefId())) {
                processInstanceQuery.processDefinitionId(queryProcressInstanceInfoReqBO.getProcDefId());
            }
            if (StringUtils.isNotEmpty((CharSequence)queryProcressInstanceInfoReqBO.getProcDefKey())) {
                processInstanceQuery.processDefinitionKey(queryProcressInstanceInfoReqBO.getProcDefKey());
            }
            if (StringUtils.isNotEmpty((CharSequence)queryProcressInstanceInfoReqBO.getProcDefName())) {
                processInstanceQuery.processDefinitionName(queryProcressInstanceInfoReqBO.getProcDefName());
            }
            if (StringUtils.isNotEmpty((CharSequence)queryProcressInstanceInfoReqBO.getBusinessKey())) {
                processInstanceQuery.processInstanceBusinessKey(queryProcressInstanceInfoReqBO.getBusinessKey());
            }
            if (StringUtils.isNotEmpty((CharSequence)queryProcressInstanceInfoReqBO.getProcInstName())) {
                processInstanceQuery.processInstanceNameLike("%" + queryProcressInstanceInfoReqBO.getProcInstName() + "%");
            }
            if (StringUtils.isNotEmpty((CharSequence)queryProcressInstanceInfoReqBO.getTenantId())) {
                processInstanceQuery.processInstanceTenantId(queryProcressInstanceInfoReqBO.getTenantId());
            }
            if (StringUtils.isNotEmpty((CharSequence)queryProcressInstanceInfoReqBO.getUserId())) {
                processInstanceQuery.involvedUser(queryProcressInstanceInfoReqBO.getUserId());
            }
            if (null != queryProcressInstanceInfoReqBO.getProcVariables()) {
                Map<String, Object> proc_variables = queryProcressInstanceInfoReqBO.getProcVariables();
                for (String variable_name : proc_variables.keySet()) {
                    processInstanceQuery.variableValueEquals(variable_name, proc_variables.get(variable_name));
                }
            }
            if (null != queryProcressInstanceInfoReqBO.getCountOnly() && queryProcressInstanceInfoReqBO.getCountOnly().booleanValue()) {
                totalCount = processInstanceQuery.count();
            } else if (null != queryProcressInstanceInfoReqBO.getPageNo() && null != queryProcressInstanceInfoReqBO.getPageSize()) {
                totalCount = processInstanceQuery.count();
                processInstanceList = processInstanceQuery.listPage((queryProcressInstanceInfoReqBO.getPageNo() - 1) * queryProcressInstanceInfoReqBO.getPageSize(), queryProcressInstanceInfoReqBO.getPageSize().intValue());
            } else {
                processInstanceList = processInstanceQuery.listPage((AtomCommonsConstant.DEFAULT_PAGE_NO - 1) * AtomCommonsConstant.DEFAULT_PAGE_SIZE, AtomCommonsConstant.DEFAULT_PAGE_SIZE.intValue());
                totalCount = processInstanceQuery.count();
            }
        } else {
            processInstanceList = processInstanceQuery.listPage((AtomCommonsConstant.DEFAULT_PAGE_NO - 1) * AtomCommonsConstant.DEFAULT_PAGE_SIZE, AtomCommonsConstant.DEFAULT_PAGE_SIZE.intValue());
            totalCount = processInstanceQuery.count();
        }
        if (null != processInstanceList && processInstanceList.size() > 0) {
            respBO.setRspCode("0000");
            respBO.setRspDesc("\u67e5\u8be2\u6d41\u7a0b\u5b9e\u4f8b\u6210\u529f");
            respBO.setTotalCount(totalCount);
            respBO.setProcInstList(this.setProcInfoListData(processInstanceList));
        } else {
            respBO.setRspCode("1009");
            respBO.setRspDesc("\u67e5\u8be2\u6d41\u7a0b\u5b9e\u4f8b\u5931\u8d25\uff0c\u672a\u83b7\u53d6\u5230\u6570\u636e");
        }
        return respBO;
    }

    private List<ProcessInstanceAtomBO> setProcInfoListData(List<ProcessInstance> list) {
        if (null != list && list.size() > 0) {
            ArrayList<ProcessInstanceAtomBO> resultList = new ArrayList<ProcessInstanceAtomBO>();
            for (ProcessInstance pi : list) {
                ProcessInstanceAtomBO processInstanceBO = new ProcessInstanceAtomBO();
                processInstanceBO.setActivityId(pi.getActivityId());
                processInstanceBO.setProcBusiKey(pi.getBusinessKey());
                processInstanceBO.setProcDefId(pi.getProcessDefinitionId());
                processInstanceBO.setProcDefKey(pi.getProcessDefinitionKey());
                processInstanceBO.setProcDefName(pi.getProcessDefinitionName());
                processInstanceBO.setProcDefVersion(pi.getProcessDefinitionVersion());
                processInstanceBO.setProcInstId(pi.getProcessInstanceId());
                processInstanceBO.setProcInstName(pi.getName());
                resultList.add(processInstanceBO);
            }
            return resultList;
        }
        return null;
    }

    @Override
    public ChangeProcessInstanceAtomRespBO changeProcessInstance(ChangeProcessInstanceAtomReqBO reqBO) {
        ChangeProcessInstanceAtomRespBO respBO = new ChangeProcessInstanceAtomRespBO();
        if (null == reqBO || StringUtils.isEmpty((CharSequence)reqBO.getDealType()) || StringUtils.isEmpty((CharSequence)reqBO.getProcInstId())) {
            respBO.setRspCode("1010");
            respBO.setRspDesc("\u5165\u53c2\u5bf9\u8c61\u4e2d\u5fc5\u4f20\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return respBO;
        }
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(reqBO.getProcInstId()).processInstanceTenantId(reqBO.getSysCode()).singleResult();
        if (null == processInstance) {
            respBO.setRspCode("1010");
            respBO.setRspDesc("\u8be5\u7cfb\u7edf\u4e2d\u6b64\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5b58\u5728");
        } else if ("ACTIVE".equals(reqBO.getDealType())) {
            ProcessInstance suspendprocessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(reqBO.getProcInstId()).suspended().singleResult();
            if (null == suspendprocessInstance) {
                respBO.setRspCode("0000");
                respBO.setRspDesc("\u6d41\u7a0b\u5b9e\u4f8b\u5df2\u662f\u6fc0\u6d3b\u72b6\u6001");
            } else {
                this.runtimeService.activateProcessInstanceById(reqBO.getProcInstId());
                respBO.setRspCode("0000");
                respBO.setRspDesc("\u6d41\u7a0b\u5b9e\u4f8b\u6fc0\u6d3b\u6210\u529f");
            }
        } else if ("SUSPEND".equals(reqBO.getDealType())) {
            ProcessInstance activeprocessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(reqBO.getProcInstId()).active().singleResult();
            if (null == activeprocessInstance) {
                respBO.setRspCode("0000");
                respBO.setRspDesc("\u6d41\u7a0b\u5b9e\u4f8b\u5df2\u662f\u6302\u8d77\u72b6\u6001");
            } else {
                this.runtimeService.suspendProcessInstanceById(reqBO.getProcInstId());
                respBO.setRspCode("0000");
                respBO.setRspDesc("\u6d41\u7a0b\u5b9e\u4f8b\u6302\u8d77\u6210\u529f");
            }
        } else if ("DELETE".equals(reqBO.getDealType())) {
            String delReason = "";
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getDelReasonCode())) {
                delReason = delReason + "\u5220\u9664\u539f\u56e0\u7f16\u7801\uff1a" + reqBO.getDelReasonCode();
                this.runtimeService.setVariableLocal(reqBO.getProcInstId(), "prcProcInstDelReasonCode", (Object)reqBO.getDelReasonCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getDelReasonDesc())) {
                delReason = delReason + ",\u5220\u9664\u539f\u56e0\u63cf\u8ff0\uff1a" + reqBO.getDelReasonDesc();
                this.runtimeService.setVariableLocal(reqBO.getProcInstId(), "prcProcInstDelReasonDesc", (Object)reqBO.getDelReasonDesc());
            }
            this.runtimeService.deleteProcessInstance(reqBO.getProcInstId(), delReason);
            respBO.setRspCode("0000");
            respBO.setRspDesc("\u6d41\u7a0b\u5b9e\u4f8b\u5220\u9664\u6210\u529f");
        } else {
            respBO.setRspCode("1010");
            respBO.setRspDesc("\u5165\u53c2\u5bf9\u8c61\u4e2d\uff0c\u5904\u7406\u7c7b\u578b[deal_type]\u65e0\u6cd5\u8bc6\u522b");
        }
        return respBO;
    }
}

