/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.prc.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.prc.atom.ActivitiTaskAtomService;
import com.tydic.prc.atom.TimeUtils;
import com.tydic.prc.atom.bo.QueryTaskAtomReqBO;
import com.tydic.prc.atom.bo.QueryTaskAtomRespBO;
import com.tydic.prc.atom.bo.TaskAtomBO;
import com.tydic.prc.busi.PrcGetDelegateTaskBusiService;
import com.tydic.prc.busi.bo.DelegationTaskBusiBO;
import com.tydic.prc.busi.bo.PrcGetDelegateTaskBusiReqBO;
import com.tydic.prc.busi.bo.PrcGetDelegateTaskBusiRespBO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PrcGetDelegateTaskBusiServiceImpl
implements PrcGetDelegateTaskBusiService {
    @Autowired
    private ActivitiTaskAtomService activitiTaskAtomService;
    public static final String DELEGATION_STATE_PENDING = "PENDING";
    public static final String DELEGATION_STATE_RESOLVED = "RESOLVED";
    public static final String DELEGATION_STATE_ALL = "ALL";

    public PrcGetDelegateTaskBusiRespBO getDelegateTask(PrcGetDelegateTaskBusiReqBO req) {
        QueryTaskAtomRespBO queryTaskAtomRespBO;
        PrcGetDelegateTaskBusiRespBO rsp = new PrcGetDelegateTaskBusiRespBO();
        QueryTaskAtomReqBO atomReq = new QueryTaskAtomReqBO();
        HashMap<String, Object> procVariables = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)req.getBusiCode())) {
            procVariables.put("busiCode", req.getBusiCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)req.getOtherParamJson())) {
            procVariables.putAll((Map)JSON.parseObject((String)req.getOtherParamJson(), (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]));
        }
        if (!procVariables.isEmpty()) {
            atomReq.setProcVariables(procVariables);
        }
        atomReq.setSysCode(req.getSysCode());
        atomReq.setTaskDefKey(req.getTacheCode());
        atomReq.setCreateDateStart(DateUtils.strToDate((String)req.getCreateTimeStart()));
        atomReq.setCreateDateEnd(TimeUtils.addEndDate(DateUtils.strToDate((String)req.getCreateTimeEnd()), 1));
        atomReq.setDueDateStart(DateUtils.strToDate((String)req.getDueTimeStart()));
        atomReq.setDueDateEnd(TimeUtils.addEndDate(DateUtils.strToDate((String)req.getDueTimeEnd()), 1));
        atomReq.setPageSize(req.getPageSize());
        atomReq.setPageNo(req.getPageNo());
        atomReq.setTaskOwner(req.getOperId());
        if (DELEGATION_STATE_PENDING.equals(req.getDelegationState())) {
            atomReq.setDelegationState(DELEGATION_STATE_PENDING);
        }
        if (DELEGATION_STATE_RESOLVED.equals(req.getDelegationState())) {
            atomReq.setDelegationState(DELEGATION_STATE_RESOLVED);
        }
        if ("0000".equals((queryTaskAtomRespBO = this.activitiTaskAtomService.queryTask(atomReq)).getRspCode())) {
            ArrayList<DelegationTaskBusiBO> taskList = new ArrayList<DelegationTaskBusiBO>();
            for (TaskAtomBO taskBO : queryTaskAtomRespBO.getTaskList()) {
                DelegationTaskBusiBO busiTaskBO = new DelegationTaskBusiBO();
                BeanUtils.copyProperties((Object)taskBO, (Object)busiTaskBO);
                busiTaskBO.setTacheCode(taskBO.getTaskDefKey());
                taskList.add(busiTaskBO);
            }
            rsp.setTaskList(taskList);
            rsp.setTotalCount(Integer.valueOf(queryTaskAtomRespBO.getTotalCount().intValue()));
            rsp.setRspCode("0000");
            rsp.setRspDesc("\u83b7\u53d6\u4e2a\u4eba\u59d4\u6258\u4efb\u52a1\u5217\u8868\u6210\u529f\uff01");
            return rsp;
        }
        rsp.setRspCode(queryTaskAtomRespBO.getRspCode());
        rsp.setRspDesc(queryTaskAtomRespBO.getRspDesc());
        return rsp;
    }
}

