/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.prc.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.tydic.prc.atom.PrcGetRouteExtraParamAtomService;
import com.tydic.prc.atom.bo.PrcGetRouteExtraParamAtomReqBO;
import com.tydic.prc.atom.bo.PrcGetRouteExtraParamAtomRespBO;
import com.tydic.prc.atom.constant.AtomCommonsConstant;
import com.tydic.prc.busi.PrcGetOutsideGroupsBusiService;
import com.tydic.prc.busi.bo.PrcGetOutsideGroupsBusiReqBO;
import com.tydic.prc.busi.bo.PrcGetOutsideGroupsBusiRespBO;
import com.tydic.prc.dao.PrcReAssignInstMapper;
import com.tydic.prc.dao.PrcReAssignRouteMapper;
import com.tydic.prc.po.PrcReAssignInstPO;
import com.tydic.prc.po.PrcReAssignRoutePO;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PrcGetOutsideGroupsBusiServiceImpl
implements PrcGetOutsideGroupsBusiService {
    @Autowired
    private PrcReAssignRouteMapper prcReAssignRouteMapper;
    @Autowired
    private PrcGetRouteExtraParamAtomService prcGetRouteExtraParamAtomService;
    @Autowired
    private PrcReAssignInstMapper prcReAssignInstMapper;

    /*
     * Enabled aggressive block sorting
     */
    public PrcGetOutsideGroupsBusiRespBO getOutsideGroups(PrcGetOutsideGroupsBusiReqBO reqBO) {
        PrcGetOutsideGroupsBusiRespBO respBO = new PrcGetOutsideGroupsBusiRespBO();
        PrcReAssignRoutePO paramPo = new PrcReAssignRoutePO();
        paramPo.setBusiCode(reqBO.getBusiCode());
        paramPo.setSysCode(reqBO.getSysCode());
        paramPo.setTacheCode(reqBO.getTacheCode());
        List<PrcReAssignRoutePO> routeList = this.prcReAssignRouteMapper.selectAssignRouteList(paramPo);
        if (routeList != null && routeList.size() == 1) {
            List<PrcReAssignInstPO> assignInstList;
            PrcReAssignInstPO instPO = new PrcReAssignInstPO();
            instPO.setBusiCode(routeList.get(0).getBusiCode());
            instPO.setSysCode(routeList.get(0).getSysCode());
            instPO.setTacheCode(routeList.get(0).getTacheCode());
            instPO.setRouteId(routeList.get(0).getRouteId());
            instPO.setRouteType(routeList.get(0).getRouteType());
            instPO.setGroupType(2);
            if (AtomCommonsConstant.PRC_NEED_EXT.equals(routeList.get(0).getIsNeedExt()) && StringUtils.isNotEmpty((CharSequence)reqBO.getExtParamJsonStr())) {
                PrcGetRouteExtraParamAtomReqBO routeExtraParamReqBO = new PrcGetRouteExtraParamAtomReqBO();
                routeExtraParamReqBO.setRouteId(routeList.get(0).getRouteId());
                routeExtraParamReqBO.setRouteType(routeList.get(0).getRouteType());
                routeExtraParamReqBO.setParamMap((Map)JSON.parseObject((String)reqBO.getExtParamJsonStr(), (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]));
                PrcGetRouteExtraParamAtomRespBO routeExtraParam = this.prcGetRouteExtraParamAtomService.getRouteExtraParam(routeExtraParamReqBO);
                if (!"0000".equals(routeExtraParam.getRspCode())) {
                    respBO.setRspCode(routeExtraParam.getRspCode());
                    respBO.setRspDesc(routeExtraParam.getRspDesc());
                    return respBO;
                }
                Map<String, Object> extParamMap = routeExtraParam.getExtParamMap();
                if (extParamMap == null) {
                    respBO.setRspCode("2028");
                    respBO.setRspDesc("\u672a\u914d\u7f6e\u8def\u7531\u62d3\u5c55\u53c2\u6570");
                    return respBO;
                }
                instPO.setExtFieldValue1(extParamMap.get("extFieldValue1") != null ? extParamMap.get("extFieldValue1").toString() : null);
                instPO.setExtFieldValue2(extParamMap.get("extFieldValue2") != null ? extParamMap.get("extFieldValue2").toString() : null);
                instPO.setExtFieldValue3(extParamMap.get("extFieldValue3") != null ? extParamMap.get("extFieldValue3").toString() : null);
                instPO.setExtFieldValue4(extParamMap.get("extFieldValue4") != null ? extParamMap.get("extFieldValue4").toString() : null);
                instPO.setExtFieldValue5(extParamMap.get("extFieldValue5") != null ? extParamMap.get("extFieldValue5").toString() : null);
            }
            if ((assignInstList = this.prcReAssignInstMapper.selectGroupIdByCondition(instPO)) != null && assignInstList.size() > 0) {
                ArrayList<String> groupIds = new ArrayList<String>();
                Iterator<PrcReAssignInstPO> iterator = assignInstList.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        respBO.setGroupIds(groupIds);
                        respBO.setTotalCount(Integer.valueOf(assignInstList.size()));
                        respBO.setRspCode("0000");
                        respBO.setRspDesc("\u83b7\u53d6\u5f85\u529e\u7ec4\u5217\u8868\u6210\u529f\uff01");
                        return respBO;
                    }
                    PrcReAssignInstPO prai = iterator.next();
                    groupIds.add(prai.getGroupId());
                }
            }
            respBO.setRspCode("2028");
            respBO.setRspDesc("\u672a\u67e5\u8be2\u5230\u6570\u636e");
            return respBO;
        }
        respBO.setRspCode("2028");
        respBO.setRspDesc("\u73af\u8282\u5f85\u529e\u4efb\u52a1\u5019\u9009\u4eba\u5206\u914d\u8def\u7531\u8868\u914d\u7f6e\u6709\u8bef");
        return respBO;
    }
}

