/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.prc.atom.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.prc.atom.ActivitiHistoryAtomService;
import com.tydic.prc.atom.bo.GetProcessHistoricActivityInfoAtomReqBO;
import com.tydic.prc.atom.bo.GetProcessHistoricActivityInfoAtomRespBO;
import com.tydic.prc.atom.bo.GetProcessHistoricTaskInfoAtomReqBO;
import com.tydic.prc.atom.bo.GetProcessHistoricTaskInfoAtomRespBO;
import com.tydic.prc.atom.bo.HistoricActivityInfoAtomBO;
import com.tydic.prc.atom.bo.HistoricProcessInstanceAtomBO;
import com.tydic.prc.atom.bo.HistoricTaskInfoAtomBO;
import com.tydic.prc.atom.bo.QueryHistoricProcressInstanceInfoAtomReqBO;
import com.tydic.prc.atom.bo.QueryHistoricProcressInstanceInfoAtomRespBO;
import com.tydic.prc.atom.constant.AtomCommonsConstant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.HistoryService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricActivityInstanceQuery;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricProcessInstanceQuery;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.history.HistoricVariableInstance;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivitiHistoryAtomServiceImpl
implements ActivitiHistoryAtomService {
    @Autowired
    private HistoryService historyService;
    private static final String STATE_FINISH = "FINISH";
    private static final String STATE_UNFINISH = "UNFINISH";
    private static final String STATE_DELETE = "DELETED";
    private static final String STATE_UNDELETED = "UNDELETED";

    @Override
    public GetProcessHistoricActivityInfoAtomRespBO getProcessHistoricActivityInfo(GetProcessHistoricActivityInfoAtomReqBO reqBO) {
        GetProcessHistoricActivityInfoAtomRespBO respBO = new GetProcessHistoricActivityInfoAtomRespBO();
        HistoricActivityInstanceQuery historicActivityInstanceQuery = this.historyService.createHistoricActivityInstanceQuery();
        Long totalCount = 0L;
        List historicActivityInstanceList = null;
        if (null != reqBO) {
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getProcInstId())) {
                historicActivityInstanceQuery.processInstanceId(reqBO.getProcInstId());
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getExecutionId())) {
                historicActivityInstanceQuery.executionId(reqBO.getExecutionId());
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getActivityId())) {
                historicActivityInstanceQuery.activityId(reqBO.getActivityId());
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getActivityName())) {
                historicActivityInstanceQuery.activityName(reqBO.getActivityName());
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getTenantId())) {
                historicActivityInstanceQuery.activityTenantId(reqBO.getTenantId());
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getFinishFlag()) && STATE_FINISH.equals(reqBO.getFinishFlag())) {
                historicActivityInstanceQuery.finished();
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getFinishFlag()) && STATE_UNFINISH.equals(reqBO.getFinishFlag())) {
                historicActivityInstanceQuery.unfinished();
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getProcDefId())) {
                historicActivityInstanceQuery.processDefinitionId(reqBO.getProcDefId());
            }
            if (null != reqBO.getCountOnly() && reqBO.getCountOnly().booleanValue()) {
                totalCount = historicActivityInstanceQuery.count();
            } else if (null != reqBO.getPageNo() && null != reqBO.getPageSize()) {
                totalCount = historicActivityInstanceQuery.count();
                historicActivityInstanceList = ((HistoricActivityInstanceQuery)historicActivityInstanceQuery.orderByHistoricActivityInstanceStartTime().desc()).listPage((reqBO.getPageNo() - 1) * reqBO.getPageSize(), reqBO.getPageSize().intValue());
            } else {
                totalCount = historicActivityInstanceQuery.count();
                historicActivityInstanceList = ((HistoricActivityInstanceQuery)historicActivityInstanceQuery.orderByHistoricActivityInstanceStartTime().desc()).listPage((AtomCommonsConstant.DEFAULT_PAGE_NO - 1) * AtomCommonsConstant.DEFAULT_PAGE_SIZE, AtomCommonsConstant.DEFAULT_PAGE_SIZE.intValue());
            }
        } else {
            totalCount = historicActivityInstanceQuery.count();
            historicActivityInstanceList = ((HistoricActivityInstanceQuery)historicActivityInstanceQuery.orderByHistoricActivityInstanceStartTime().desc()).listPage((AtomCommonsConstant.DEFAULT_PAGE_NO - 1) * AtomCommonsConstant.DEFAULT_PAGE_SIZE, AtomCommonsConstant.DEFAULT_PAGE_SIZE.intValue());
        }
        if (null != historicActivityInstanceList && historicActivityInstanceList.size() > 0) {
            respBO.setRspCode("0000");
            respBO.setRspDesc("\u67e5\u8be2\u5386\u53f2\u8282\u70b9\u4fe1\u606f\u6210\u529f");
            respBO.setTotalCount(totalCount);
            respBO.setActivityList(this.setHisActInfoDataList(historicActivityInstanceList));
        } else {
            respBO.setRspCode("1004");
            respBO.setRspDesc("\u672a\u67e5\u8be2\u5230\u5386\u53f2\u8282\u70b9\u4fe1\u606f");
        }
        return respBO;
    }

    private List<HistoricActivityInfoAtomBO> setHisActInfoDataList(List<HistoricActivityInstance> list) {
        if (list != null && list.size() > 0) {
            ArrayList<HistoricActivityInfoAtomBO> resultList = new ArrayList<HistoricActivityInfoAtomBO>();
            for (HistoricActivityInstance hai : list) {
                HistoricActivityInfoAtomBO historicActivityInfoBO = new HistoricActivityInfoAtomBO();
                historicActivityInfoBO.setActivityId(hai.getActivityId());
                historicActivityInfoBO.setActivityName(hai.getActivityName());
                historicActivityInfoBO.setActivityType(hai.getActivityType());
                historicActivityInfoBO.setCalledProcInstId(hai.getCalledProcessInstanceId());
                historicActivityInfoBO.setEndTime(hai.getEndTime());
                historicActivityInfoBO.setExecutionId(hai.getExecutionId());
                historicActivityInfoBO.setId(hai.getId());
                historicActivityInfoBO.setProcDefId(hai.getProcessDefinitionId());
                historicActivityInfoBO.setProcInstId(hai.getProcessInstanceId());
                historicActivityInfoBO.setStartTime(hai.getStartTime());
                historicActivityInfoBO.setTaskAssignee(hai.getAssignee());
                historicActivityInfoBO.setTaskId(hai.getTaskId());
                historicActivityInfoBO.setTenantId(hai.getTenantId());
                resultList.add(historicActivityInfoBO);
            }
            return resultList;
        }
        return null;
    }

    @Override
    public QueryHistoricProcressInstanceInfoAtomRespBO queryHistoricProcressInstanceInfo(QueryHistoricProcressInstanceInfoAtomReqBO reqBO) {
        QueryHistoricProcressInstanceInfoAtomRespBO respBO = new QueryHistoricProcressInstanceInfoAtomRespBO();
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        Long totalCount = 0L;
        List historicProcessInstanceList = null;
        if (null != reqBO) {
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getDeteleType()) && STATE_DELETE.equals(reqBO.getDeteleType())) {
                historicProcessInstanceQuery.deleted();
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getDeteleType()) && STATE_UNDELETED.equals(reqBO.getDeteleType())) {
                historicProcessInstanceQuery.notDeleted();
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getFinishType()) && STATE_FINISH.equals(reqBO.getFinishType())) {
                historicProcessInstanceQuery.finished();
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getFinishType()) && STATE_UNFINISH.equals(reqBO.getFinishType())) {
                historicProcessInstanceQuery.unfinished();
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getInvolveUser())) {
                historicProcessInstanceQuery.involvedUser(reqBO.getInvolveUser());
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getProcDefId())) {
                historicProcessInstanceQuery.processDefinitionId(reqBO.getProcDefId());
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getProcDefKey())) {
                historicProcessInstanceQuery.processDefinitionKey(reqBO.getProcDefKey());
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getProcInstId())) {
                historicProcessInstanceQuery.processInstanceId(reqBO.getProcInstId());
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getProcInstName())) {
                historicProcessInstanceQuery.processInstanceNameLike(reqBO.getProcInstName());
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getTenantId())) {
                historicProcessInstanceQuery.processInstanceTenantId(reqBO.getTenantId());
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getSuperProcInstId())) {
                historicProcessInstanceQuery.superProcessInstanceId(reqBO.getSuperProcInstId());
            }
            if (null != reqBO.getCreateTimeStart()) {
                historicProcessInstanceQuery.startedAfter(reqBO.getCreateTimeStart());
            }
            if (null != reqBO.getCreateTimeEnd()) {
                historicProcessInstanceQuery.startedBefore(reqBO.getCreateTimeEnd());
            }
            if (null != reqBO.getFinishTimeStart()) {
                historicProcessInstanceQuery.finishedAfter(reqBO.getFinishTimeStart());
            }
            if (null != reqBO.getFinishTimeEnd()) {
                historicProcessInstanceQuery.finishedBefore(reqBO.getFinishTimeEnd());
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getDelReasonCode())) {
                historicProcessInstanceQuery.variableValueEquals("prcProcInstDelReasonCode", (Object)reqBO.getDelReasonCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getDelReasonDesc())) {
                historicProcessInstanceQuery.variableValueLike("prcProcInstDelReasonDesc", reqBO.getDelReasonDesc());
            }
            if (null != reqBO.getCountOnly() && reqBO.getCountOnly().booleanValue()) {
                totalCount = historicProcessInstanceQuery.count();
            } else if (null != reqBO.getPageNo() && null != reqBO.getPageSize()) {
                totalCount = historicProcessInstanceQuery.count();
                historicProcessInstanceList = historicProcessInstanceQuery.listPage((reqBO.getPageNo() - 1) * reqBO.getPageSize(), reqBO.getPageSize().intValue());
            } else {
                totalCount = historicProcessInstanceQuery.count();
                historicProcessInstanceList = historicProcessInstanceQuery.listPage((AtomCommonsConstant.DEFAULT_PAGE_NO - 1) * AtomCommonsConstant.DEFAULT_PAGE_SIZE, AtomCommonsConstant.DEFAULT_PAGE_SIZE.intValue());
            }
        } else {
            totalCount = historicProcessInstanceQuery.count();
            historicProcessInstanceList = historicProcessInstanceQuery.listPage((AtomCommonsConstant.DEFAULT_PAGE_NO - 1) * AtomCommonsConstant.DEFAULT_PAGE_SIZE, AtomCommonsConstant.DEFAULT_PAGE_SIZE.intValue());
        }
        if (null != historicProcessInstanceList && historicProcessInstanceList.size() > 0) {
            respBO.setRspCode("0000");
            respBO.setRspCode("\u67e5\u8be2\u5386\u53f2\u6d41\u7a0b\u5b9e\u4f8b\u6210\u529f");
            respBO.setTotalCount(totalCount);
            respBO.setProcInstList(this.setHisProcInstDataList(historicProcessInstanceList));
        } else {
            respBO.setRspCode("1005");
            respBO.setRspCode("\u672a\u67e5\u8be2\u5230\u5386\u53f2\u6d41\u7a0b\u5b9e\u4f8b\u4fe1\u606f");
        }
        return respBO;
    }

    private List<HistoricProcessInstanceAtomBO> setHisProcInstDataList(List<HistoricProcessInstance> list) {
        if (null != list && list.size() > 0) {
            ArrayList<HistoricProcessInstanceAtomBO> resultList = new ArrayList<HistoricProcessInstanceAtomBO>();
            for (HistoricProcessInstance hpi : list) {
                HistoricProcessInstanceAtomBO historicProcessInstanceBO = new HistoricProcessInstanceAtomBO();
                historicProcessInstanceBO.setBusinessKey(hpi.getBusinessKey());
                historicProcessInstanceBO.setDeleteReason(hpi.getDeleteReason());
                historicProcessInstanceBO.setEndTime(hpi.getEndTime());
                historicProcessInstanceBO.setProcDefId(hpi.getProcessDefinitionId());
                historicProcessInstanceBO.setProcInstId(hpi.getId());
                historicProcessInstanceBO.setProcInstName(hpi.getName());
                historicProcessInstanceBO.setStartTime(hpi.getStartTime());
                historicProcessInstanceBO.setSuperProcInstId(hpi.getSuperProcessInstanceId());
                historicProcessInstanceBO.setTenantId(hpi.getTenantId());
                resultList.add(historicProcessInstanceBO);
            }
            return resultList;
        }
        return null;
    }

    @Override
    public GetProcessHistoricTaskInfoAtomRespBO getProcessHistoricTaskInfo(GetProcessHistoricTaskInfoAtomReqBO reqBO) {
        GetProcessHistoricTaskInfoAtomRespBO respBO = new GetProcessHistoricTaskInfoAtomRespBO();
        HistoricTaskInstanceQuery historicTaskInstanceQuery = this.historyService.createHistoricTaskInstanceQuery();
        historicTaskInstanceQuery.finished();
        Long totalCount = 0L;
        List historicTaskInstanceList = null;
        if (null != reqBO) {
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getProcInstId())) {
                historicTaskInstanceQuery.processInstanceId(reqBO.getProcInstId());
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getExecutionId())) {
                historicTaskInstanceQuery.executionId(reqBO.getExecutionId());
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getProcDefId())) {
                historicTaskInstanceQuery.processDefinitionId(reqBO.getProcDefId());
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getProcDefKey())) {
                historicTaskInstanceQuery.processDefinitionKey(reqBO.getProcDefKey());
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getProcDefName())) {
                historicTaskInstanceQuery.processDefinitionNameLike(reqBO.getProcDefName());
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getTaskAssignee())) {
                historicTaskInstanceQuery.taskAssignee(reqBO.getTaskAssignee());
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getTaskDefKey())) {
                historicTaskInstanceQuery.taskDefinitionKey(reqBO.getTaskDefKey());
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getDelReasonCode())) {
                historicTaskInstanceQuery.taskVariableValueEquals("prcTaskDelReasonCode", (Object)reqBO.getDelReasonCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getDelReasonDesc())) {
                historicTaskInstanceQuery.taskVariableValueLike("prcTaskDelReasonDesc", reqBO.getDelReasonDesc());
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getTaskDesc())) {
                historicTaskInstanceQuery.taskDescriptionLike(reqBO.getTaskDesc());
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getTaskId())) {
                historicTaskInstanceQuery.taskId(reqBO.getTaskId());
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getTaskName())) {
                historicTaskInstanceQuery.taskNameLike(reqBO.getTaskName());
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getTaskOwner())) {
                historicTaskInstanceQuery.taskOwner(reqBO.getTaskOwner());
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getParentTaskId())) {
                historicTaskInstanceQuery.taskParentTaskId(reqBO.getParentTaskId());
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getTenantId())) {
                historicTaskInstanceQuery.taskTenantId(reqBO.getTenantId());
            }
            if (null != reqBO.getCreateDateStart()) {
                historicTaskInstanceQuery.taskCreatedAfter(reqBO.getCreateDateStart());
            }
            if (null != reqBO.getCreateDateEnd()) {
                historicTaskInstanceQuery.taskCreatedBefore(reqBO.getCreateDateEnd());
            }
            if (null != reqBO.getCompleteDateStart()) {
                historicTaskInstanceQuery.taskCompletedAfter(reqBO.getCompleteDateStart());
            }
            if (null != reqBO.getCompleteDateEnd()) {
                historicTaskInstanceQuery.taskCompletedBefore(reqBO.getCompleteDateEnd());
            }
            if (null != reqBO.getDueDateStart()) {
                historicTaskInstanceQuery.taskDueAfter(reqBO.getDueDateStart());
            }
            if (null != reqBO.getDueDateEnd()) {
                historicTaskInstanceQuery.taskDueBefore(reqBO.getDueDateEnd());
            }
            if (null != reqBO.getProcVariables()) {
                Map<String, Object> procVariables = reqBO.getProcVariables();
                for (String variableName : procVariables.keySet()) {
                    historicTaskInstanceQuery.processVariableValueEquals(variableName, procVariables.get(variableName));
                }
            }
            if (null != reqBO.getTaskVariables()) {
                Map<String, Object> taskVariables = reqBO.getTaskVariables();
                for (String variableName : taskVariables.keySet()) {
                    historicTaskInstanceQuery.taskVariableValueEquals(variableName, taskVariables.get(variableName));
                }
            }
            if (null != reqBO.getCountOnly() && reqBO.getCountOnly().booleanValue()) {
                totalCount = historicTaskInstanceQuery.count();
            } else if (null != reqBO.getPageNo() && null != reqBO.getPageSize()) {
                totalCount = historicTaskInstanceQuery.count();
                historicTaskInstanceList = historicTaskInstanceQuery.listPage((reqBO.getPageNo() - 1) * reqBO.getPageSize(), reqBO.getPageSize().intValue());
            } else {
                totalCount = historicTaskInstanceQuery.count();
                historicTaskInstanceList = historicTaskInstanceQuery.listPage((AtomCommonsConstant.DEFAULT_PAGE_NO - 1) * AtomCommonsConstant.DEFAULT_PAGE_SIZE, AtomCommonsConstant.DEFAULT_PAGE_SIZE.intValue());
            }
        } else {
            totalCount = historicTaskInstanceQuery.count();
            historicTaskInstanceList = historicTaskInstanceQuery.listPage((AtomCommonsConstant.DEFAULT_PAGE_NO - 1) * AtomCommonsConstant.DEFAULT_PAGE_SIZE, AtomCommonsConstant.DEFAULT_PAGE_SIZE.intValue());
        }
        if (null != historicTaskInstanceList && historicTaskInstanceList.size() > 0) {
            respBO.setRspCode("0000");
            respBO.setRspDesc("\u83b7\u53d6\u5386\u53f2\u4efb\u52a1\u4fe1\u606f\u6210\u529f");
            respBO.setTotalCount(totalCount);
            if (null != reqBO.getGetVariables() && reqBO.getGetVariables().booleanValue()) {
                respBO.setTaskList(this.setHisTaskDataList(historicTaskInstanceList, true));
            } else {
                respBO.setTaskList(this.setHisTaskDataList(historicTaskInstanceList, false));
            }
        } else {
            respBO.setRspCode("1006");
            respBO.setRspDesc("\u672a\u67e5\u8be2\u5230\u5386\u53f2\u4efb\u52a1\u4fe1\u606f");
        }
        return respBO;
    }

    private List<HistoricTaskInfoAtomBO> setHisTaskDataList(List<HistoricTaskInstance> list, Boolean getVariables) {
        if (null != list && list.size() > 0) {
            ArrayList<HistoricTaskInfoAtomBO> resultList = new ArrayList<HistoricTaskInfoAtomBO>();
            for (HistoricTaskInstance hti : list) {
                String taskId = hti.getId();
                String procInstId = hti.getProcessInstanceId();
                String executionId = hti.getExecutionId();
                HistoricTaskInfoAtomBO historicTaskInfoBO = new HistoricTaskInfoAtomBO();
                historicTaskInfoBO.setCreateTime(DateUtils.dateToStr((Date)hti.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                historicTaskInfoBO.setDeleteReason(hti.getDeleteReason());
                historicTaskInfoBO.setDueTime(DateUtils.dateToStr((Date)hti.getDueDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                historicTaskInfoBO.setEndTime(DateUtils.dateToStr((Date)hti.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                historicTaskInfoBO.setExecutionId(executionId);
                historicTaskInfoBO.setParentTaskId(hti.getParentTaskId());
                historicTaskInfoBO.setProcDefId(hti.getProcessDefinitionId());
                historicTaskInfoBO.setProcInstId(procInstId);
                historicTaskInfoBO.setStartTime(DateUtils.dateToStr((Date)hti.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                historicTaskInfoBO.setTaskAssignee(hti.getAssignee());
                historicTaskInfoBO.setTaskDefKey(hti.getTaskDefinitionKey());
                historicTaskInfoBO.setTaskDesc(hti.getDescription());
                historicTaskInfoBO.setTaskId(taskId);
                historicTaskInfoBO.setTaskName(hti.getName());
                historicTaskInfoBO.setTaskOwner(hti.getOwner());
                historicTaskInfoBO.setTenantId(hti.getTenantId());
                historicTaskInfoBO.setGroupId(String.valueOf(((HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().taskId(taskId).variableName("groupId").singleResult()).getValue()));
                historicTaskInfoBO.setBusiCode(String.valueOf(((HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(procInstId).variableName("busiCode").singleResult()).getValue()));
                historicTaskInfoBO.setBusiSn(String.valueOf(((HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(procInstId).variableName("busiSn").singleResult()).getValue()));
                if (getVariables.booleanValue()) {
                    HashMap<String, Object> taskLocalVariables = new HashMap<String, Object>();
                    List taskLocalVariablesList = this.historyService.createHistoricVariableInstanceQuery().taskId(taskId).list();
                    for (HistoricVariableInstance hvi : taskLocalVariablesList) {
                        taskLocalVariables.put(hvi.getVariableName(), hvi.getValue());
                    }
                    historicTaskInfoBO.setTaskLocalVariables(taskLocalVariables);
                    HashMap<String, Object> superProcVariables = new HashMap<String, Object>();
                    List superProcVariablesList = this.historyService.createHistoricVariableInstanceQuery().executionId(procInstId).list();
                    for (HistoricVariableInstance phvi : superProcVariablesList) {
                        superProcVariables.put(phvi.getVariableName(), phvi.getValue());
                    }
                    historicTaskInfoBO.setSuperProcVariables(superProcVariables);
                    if (procInstId.equals(executionId)) {
                        HashMap<String, Object> subProcVariables = new HashMap<String, Object>();
                        List subProcVariablesList = this.historyService.createHistoricVariableInstanceQuery().executionId(executionId).list();
                        for (HistoricVariableInstance phvi : subProcVariablesList) {
                            subProcVariables.put(phvi.getVariableName(), phvi.getValue());
                        }
                        historicTaskInfoBO.setSuperProcVariables(subProcVariables);
                    }
                }
                resultList.add(historicTaskInfoBO);
            }
            return resultList;
        }
        return null;
    }
}

