/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.prc.atom.impl;

import com.tydic.prc.atom.ActivitiRepositoryAtomService;
import com.tydic.prc.atom.bo.ProcessDefinitionAtomBO;
import com.tydic.prc.atom.bo.QueryRepositoryInfoAtomReqBO;
import com.tydic.prc.atom.bo.QueryRepositoryInfoAtomRespBO;
import com.tydic.prc.atom.constant.AtomCommonsConstant;
import java.util.ArrayList;
import java.util.List;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.repository.ProcessDefinitionQuery;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivitiRepositoryAtomServiceImpl
implements ActivitiRepositoryAtomService {
    @Autowired
    private RepositoryService repositoryService;

    @Override
    public QueryRepositoryInfoAtomRespBO queryRepositoryInfo(QueryRepositoryInfoAtomReqBO reqBO) {
        QueryRepositoryInfoAtomRespBO respBO = new QueryRepositoryInfoAtomRespBO();
        ProcessDefinitionQuery processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery();
        Long totalCount = 0L;
        List processDefinitionList = null;
        if (reqBO != null) {
            if (reqBO.getLastVersionFlag() != null && reqBO.getLastVersionFlag().booleanValue()) {
                processDefinitionQuery.latestVersion();
            }
            if ("ACTIVE".equals(reqBO.getActiveType())) {
                processDefinitionQuery.active();
            }
            if ("SUSPEND".equals(reqBO.getActiveType())) {
                processDefinitionQuery.suspended();
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getProcDefId())) {
                processDefinitionQuery.processDefinitionId(reqBO.getProcDefId());
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getProcDefKey())) {
                processDefinitionQuery.processDefinitionKey(reqBO.getProcDefKey());
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getProcDefName())) {
                processDefinitionQuery.processDefinitionNameLike("%" + reqBO.getProcDefName() + "%");
            }
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getTenantId())) {
                processDefinitionQuery.processDefinitionTenantId(reqBO.getTenantId());
            }
            if (reqBO.getCountOnly() != null && reqBO.getCountOnly().booleanValue()) {
                totalCount = processDefinitionQuery.count();
            } else if (reqBO.getPageNo() != null && reqBO.getPageSize() != null) {
                totalCount = processDefinitionQuery.count();
                processDefinitionList = processDefinitionQuery.listPage((reqBO.getPageNo() - 1) * reqBO.getPageSize(), reqBO.getPageSize().intValue());
            } else {
                totalCount = processDefinitionQuery.count();
                processDefinitionList = processDefinitionQuery.listPage((AtomCommonsConstant.DEFAULT_PAGE_NO - 1) * AtomCommonsConstant.DEFAULT_PAGE_SIZE, AtomCommonsConstant.DEFAULT_PAGE_SIZE.intValue());
            }
        } else {
            totalCount = processDefinitionQuery.count();
            processDefinitionList = processDefinitionQuery.listPage((AtomCommonsConstant.DEFAULT_PAGE_NO - 1) * AtomCommonsConstant.DEFAULT_PAGE_SIZE, AtomCommonsConstant.DEFAULT_PAGE_SIZE.intValue());
        }
        if (processDefinitionList != null && processDefinitionList.size() > 0) {
            respBO.setRspCode("0000");
            respBO.setRspDesc("\u67e5\u8be2\u6d41\u7a0b\u90e8\u7f72\u4fe1\u606f\u6210\u529f");
            respBO.setTotalCount(totalCount);
            respBO.setProcDefList(this.setProcDefInfoListData(processDefinitionList));
        } else {
            respBO.setRspCode("1007");
            respBO.setRspDesc("\u672a\u67e5\u8be2\u5230\u6d41\u7a0b\u90e8\u7f72\u4fe1\u606f");
        }
        return respBO;
    }

    private List<ProcessDefinitionAtomBO> setProcDefInfoListData(List<ProcessDefinition> list) {
        if (list != null && list.size() > 0) {
            ArrayList<ProcessDefinitionAtomBO> resultList = new ArrayList<ProcessDefinitionAtomBO>();
            for (ProcessDefinition pd : list) {
                ProcessDefinitionAtomBO processDefinitionBO = new ProcessDefinitionAtomBO();
                processDefinitionBO.setProcDefKey(pd.getKey());
                processDefinitionBO.setProcDefId(pd.getId());
                processDefinitionBO.setProcDefName(pd.getName());
                processDefinitionBO.setProcDefDesc(pd.getDescription());
                processDefinitionBO.setProcDefVersion(pd.getVersion());
                processDefinitionBO.setTenantId(pd.getTenantId());
                resultList.add(processDefinitionBO);
            }
            return resultList;
        }
        return null;
    }
}

