/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.prc.atom.impl;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.prc.atom.PrcTacheQueueCacheAtomService;
import com.tydic.prc.atom.bo.PrcCacheTacheQueueAtomReqBO;
import com.tydic.prc.atom.bo.PrcCacheTacheQueueAtomRespBO;
import com.tydic.prc.atom.bo.PrcGetTacheQueueCacheAtomReqBO;
import com.tydic.prc.atom.bo.PrcGetTacheQueueCacheAtomRespBO;
import com.tydic.prc.po.PrcReTacheQueuePO;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PrcTacheQueueCacheAtomServiceImpl
implements PrcTacheQueueCacheAtomService {
    private static final Logger logger = LoggerFactory.getLogger(PrcTacheQueueCacheAtomServiceImpl.class);
    @Autowired
    private CacheClient cacheClient;

    @Override
    public PrcCacheTacheQueueAtomRespBO cacheTacheQueue(PrcCacheTacheQueueAtomReqBO reqBO) {
        PrcCacheTacheQueueAtomRespBO respBO = new PrcCacheTacheQueueAtomRespBO();
        try {
            if (reqBO.getTacheQueueList() != null && reqBO.getTacheQueueList().size() > 0) {
                for (PrcReTacheQueuePO tacheQueuePO : reqBO.getTacheQueueList()) {
                    if (!StringUtils.isNotBlank((String)tacheQueuePO.getTacheCode())) continue;
                    if (StringUtils.isNotBlank((String)tacheQueuePO.getProcDefId())) {
                        String tacheIdKey = "PrcReTacheQueue_" + tacheQueuePO.getProcDefId() + "_" + tacheQueuePO.getTacheCode();
                        this.cacheClient.set(tacheIdKey, (Object)tacheQueuePO);
                    }
                    if (!StringUtils.isNotBlank((String)tacheQueuePO.getProcDefKey()) || !StringUtils.isNotBlank((String)tacheQueuePO.getSysCode())) continue;
                    String tacheModKey = "PrcReTacheQueue_" + tacheQueuePO.getProcDefKey() + "_" + tacheQueuePO.getSysCode() + "_" + tacheQueuePO.getTacheCode();
                    this.cacheClient.set(tacheModKey, (Object)tacheQueuePO);
                }
            }
            respBO.setRspCode("0000");
            respBO.setRspDesc("\u7f13\u5b58\u81ea\u52a8\u6d88\u606f\u961f\u5217\u6210\u529f");
            return respBO;
        }
        catch (Exception e) {
            logger.error("\u7f13\u5b58\u81ea\u52a8\u6d88\u606f\u961f\u5217\u5931\u8d25", (Throwable)e);
            respBO.setRspCode("8888");
            respBO.setRspDesc("\u7f13\u5b58\u81ea\u52a8\u6d88\u606f\u961f\u5217\u5931\u8d25");
            return respBO;
        }
    }

    @Override
    public PrcGetTacheQueueCacheAtomRespBO getTacheQueueCache(PrcGetTacheQueueCacheAtomReqBO reqBO) {
        PrcGetTacheQueueCacheAtomRespBO respBO = new PrcGetTacheQueueCacheAtomRespBO();
        try {
            String tacheIdKey = "PrcReTacheQueue_" + reqBO.getProcDefId() + "_" + reqBO.getTacheCode();
            if (this.cacheClient.get(tacheIdKey) != null) {
                respBO.setTacheQueuePO((PrcReTacheQueuePO)this.cacheClient.get(tacheIdKey));
            } else {
                String tacheModKey = "PrcReTacheQueue_" + reqBO.getProcDefKey() + "_" + reqBO.getSysCode() + "_" + reqBO.getTacheCode();
                if (this.cacheClient.get(tacheModKey) != null) {
                    respBO.setTacheQueuePO((PrcReTacheQueuePO)this.cacheClient.get(tacheModKey));
                } else {
                    respBO.setRspCode("1024");
                    respBO.setRspDesc("\u4ece\u7f13\u5b58\u672a\u83b7\u53d6\u5230\u81ea\u52a8\u73af\u8282\u6d88\u606f\u961f\u5217");
                }
            }
            respBO.setRspCode("0000");
            respBO.setRspDesc("\u4ece\u7f13\u5b58\u83b7\u53d6\u81ea\u52a8\u73af\u8282\u6d88\u606f\u961f\u5217\u6210\u529f");
            return respBO;
        }
        catch (Exception e) {
            logger.error("\u4ece\u7f13\u5b58\u83b7\u53d6\u81ea\u52a8\u73af\u8282\u6d88\u606f\u961f\u5217\u5931\u8d25", (Throwable)e);
            respBO.setRspCode("8888");
            respBO.setRspDesc("\u4ece\u7f13\u5b58\u83b7\u53d6\u81ea\u52a8\u73af\u8282\u6d88\u606f\u961f\u5217\u5931\u8d25");
            return respBO;
        }
    }
}

