/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.prc.busi.impl;

import com.tydic.prc.busi.PrcLogSignInOrOutBusiService;
import com.tydic.prc.busi.bo.PrcLogSignInOrOutBusiReqBO;
import com.tydic.prc.busi.bo.PrcLogSignInOrOutBusiRespBO;
import com.tydic.prc.busi.bo.StaffOnlineLogBusiBO;
import com.tydic.prc.busi.constant.BusiCommonsConstant;
import com.tydic.prc.dao.PrcStaffOnlineLogMapper;
import com.tydic.prc.po.PrcStaffOnlineLogPO;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PrcLogSignInOrOutBusiServiceImpl
implements PrcLogSignInOrOutBusiService {
    @Autowired
    private PrcStaffOnlineLogMapper prcStaffOnlineLogMapper;

    public PrcLogSignInOrOutBusiRespBO logSignInOrOut(PrcLogSignInOrOutBusiReqBO req) {
        PrcLogSignInOrOutBusiRespBO rsp = new PrcLogSignInOrOutBusiRespBO();
        PrcStaffOnlineLogPO po = new PrcStaffOnlineLogPO();
        BeanUtils.copyProperties((Object)req, (Object)po);
        po.setCheckObj(req.getGroupId());
        if ("IN".equals(req.getCheckType())) {
            po.setCheckFlag(BusiCommonsConstant.OPER_STATUS_SIGN_IN);
        } else if ("OUT".equals(req.getCheckType())) {
            po.setCheckFlag(BusiCommonsConstant.OPER_STATUS_SIGN_OUT);
        }
        if ("ADD".equals(req.getDealType())) {
            po.setObjType(BusiCommonsConstant.LOG_OBJ_TYPE_GROUP);
            int count = this.prcStaffOnlineLogMapper.insertPrcStaffOnlineLog(po);
            if (count == 0) {
                rsp.setRspCode("2019");
                rsp.setRspDesc("\u7b7e\u5165/\u7b7e\u51fa\u65e5\u5fd7\u63d2\u5165\u5931\u8d25!");
            } else {
                rsp.setRspCode("0000");
                rsp.setRspDesc("\u7b7e\u5165/\u7b7e\u51fa\u65e5\u5fd7\u63d2\u5165\u6210\u529f!");
            }
        } else if ("UPDATE".equals(req.getDealType())) {
            int count = this.prcStaffOnlineLogMapper.updateByCondition(po);
            if (count == 0) {
                rsp.setRspCode("2019");
                rsp.setRspDesc("\u7b7e\u5165/\u7b7e\u51fa\u65e5\u5fd7\u66f4\u65b0\u5931\u8d25!");
            } else {
                rsp.setRspCode("0000");
                rsp.setRspDesc("\u7b7e\u5165/\u7b7e\u51fa\u65e5\u5fd7\u66f4\u65b0\u6210\u529f!");
            }
        } else if ("DEL".equals(req.getDealType())) {
            int count = this.prcStaffOnlineLogMapper.deleteByCondition(po);
            if (count == 0) {
                rsp.setRspCode("2019");
                rsp.setRspDesc("\u7b7e\u5165/\u7b7e\u51fa\u65e5\u5fd7\u5220\u9664\u5931\u8d25!");
            } else {
                rsp.setRspCode("0000");
                rsp.setRspDesc("\u7b7e\u5165/\u7b7e\u51fa\u65e5\u5fd7\u5220\u9664\u6210\u529f!");
            }
        } else if ("QUERY".equals(req.getDealType())) {
            List<PrcStaffOnlineLogPO> logList = this.prcStaffOnlineLogMapper.selectByCondition(po);
            ArrayList<StaffOnlineLogBusiBO> staffOnlineLogList = new ArrayList<StaffOnlineLogBusiBO>();
            rsp.setStaffOnlineLogList(staffOnlineLogList);
            if (logList == null || logList.size() == 0) {
                rsp.setRspCode("0000");
                rsp.setRspDesc("\u7b7e\u5165/\u7b7e\u51fa\u65e5\u5fd7\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
            } else {
                for (PrcStaffOnlineLogPO prcPO : logList) {
                    StaffOnlineLogBusiBO logBo = new StaffOnlineLogBusiBO();
                    BeanUtils.copyProperties((Object)prcPO, (Object)logBo);
                    logBo.setGroupId(prcPO.getCheckObj());
                    staffOnlineLogList.add(logBo);
                }
                rsp.setTotalCount(Integer.valueOf(logList.size()));
                rsp.setRspCode("0000");
                rsp.setRspDesc("\u7b7e\u5165/\u7b7e\u51fa\u65e5\u5fd7\u67e5\u8be2\u6210\u529f!");
            }
        } else {
            rsp.setRspCode("2019");
            rsp.setRspDesc("\u6ca1\u6709\u5bf9\u5e94\u7684dealType!");
        }
        return rsp;
    }
}

