package com.tydic.pre.contest.common.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.fastjson.JSON;
import com.tydic.pre.contest.common.api.ExportService;
import com.tydic.pre.contest.common.api.OrderListQryService;
import com.tydic.pre.contest.common.bo.*;
import com.tydic.pre.contest.dao.OrderTaskLogMapper;
import com.tydic.pre.contest.po.OrderInfoPO;
import com.tydic.pre.contest.po.OrderTaskLogPO;
import com.tydic.pre.contest.utils.Consts;
import com.tydic.pre.contest.utils.MergeExcelUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Service;
import org.springframework.util.ResourceUtils;

import java.io.File;
import java.io.FileNotFoundException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.*;

@Service
public class ExportServiceImpl implements ExportService {

    @Autowired
    private OrderListQryService orderListQryService;
    @Autowired
    private OrderTaskLogMapper orderTaskLogMapper;

    @Async("exportThreadPool")
    @Override
    public Future<Integer> export(ExportReqBO reqBO) {
        // 注意 simpleWrite在数据量不大的情况下可以使用（5000以内，具体也要看实际情况），数据量大参照 重复多次写入

        // 写法1 JDK8+
        // since: 3.0.0-beta1
        String fileName = null;
        try {
            File fileMulu = new File(ResourceUtils.getURL("classpath:").getPath() + "files/" + reqBO.getTaskId());
            fileMulu.mkdir();
            fileName = fileMulu.getPath() + "/" + reqBO.getTaskCode() + ".xls";
            System.out.println(fileName);
        } catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        // 这里 需要指定写用哪个class去写，然后写到第一个sheet，名字为模板 然后文件流会自动关闭
        // 如果这里想使用03 则 传入excelType参数即可
        EasyExcel.write(fileName, OrderListQryInfoBO.class)
                .needHead(false)
                .excelType(ExcelTypeEnum.XLS)
                .sheet("模板")
                .doWrite(exportReal(reqBO));

        //更新任务表
        int completeNum = reqBO.getTaskResultBO().getSuccessTotal().addAndGet(1);
        List<OrderTaskLogPO> orderTaskLogPOS = new ArrayList<>();
        OrderTaskLogPO orderTaskLogPO = new OrderTaskLogPO();
        orderTaskLogPO.setId(reqBO.getTaskId());
        orderTaskLogPO.setCompleteNum(completeNum);
        BigDecimal ratio = ((new BigDecimal(completeNum).divide(new BigDecimal(reqBO.getRecordsTotal()))).multiply(new BigDecimal(100))).setScale(0, RoundingMode.DOWN);
        orderTaskLogPO.setProgressRatio(ratio.intValue());
        orderTaskLogPOS.add(orderTaskLogPO);
        this.orderTaskLogMapper.batchUpdate(orderTaskLogPOS);

        //任务表完成数量+1(redis里取)
        //todo
        //this.mergeAndUploadFile(reqBO);

        return new AsyncResult<>(1);
    }

    private void mergeAndUploadFile(ExportReqBO reqBO) {
        List<String> headColumnNames = new ArrayList<>();
        headColumnNames.add("用户编码");
        headColumnNames.add("商品名称");
        headColumnNames.add("商品编码");
        headColumnNames.add("订单编码");
        headColumnNames.add("订单状态");
        headColumnNames.add("订单时间");
        headColumnNames.add("订单金额");
        headColumnNames.add("用户名称");
        headColumnNames.add("商品原价");
        headColumnNames.add("商品促销价");
        String sourcePath = null;
        String targetFilePath = null;
        try {
            sourcePath = ResourceUtils.getURL("classpath:").getPath() + "files/" + reqBO.getTaskId() + "/";
            targetFilePath = ResourceUtils.getURL("classpath:").getPath() + "comfile/" + reqBO.getTaskId() + ".xls";
        } catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        //合并文件
        ExecutorService mergeFilePool = new ThreadPoolExecutor(3, 10, 300000000, TimeUnit.DAYS, new ArrayBlockingQueue<>(4), Executors.defaultThreadFactory(), new ThreadPoolExecutor.DiscardOldestPolicy());
        Long taskId = 1L;
        MergeExcelUtils excelUtil = new MergeExcelUtils(headColumnNames, sourcePath, targetFilePath, 50000, Consts.PAGE_SIZE_NUM, String.valueOf(taskId), mergeFilePool);
        excelUtil.merge();
    }

    private List exportReal(ExportReqBO reqBO) {
        OrderListQryReqBO qryReq = JSON.parseObject(JSON.toJSONString(reqBO), OrderListQryReqBO.class);
        OrderListQryRspBO resultRsp = this.orderListQryService.orderList(qryReq);
        return resultRsp.getRows();
    }

    private List<OrderInfoPO> exportTest(ExportReqBO reqBO) {
        List<OrderInfoPO> date = new ArrayList<>();
        for (int i=0; i< 100; i++) {
            OrderInfoPO orderInfoPO = new OrderInfoPO();
            orderInfoPO.setField1(reqBO.getTaskCode()+"内容" + i);
            orderInfoPO.setField2(reqBO.getTaskCode()+"容内" + i);
            date.add(orderInfoPO);
        }
        return date;
    }
}
