package com.tydic.pre.contest.common.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.pre.contest.common.api.OrderListQryService;
import com.tydic.pre.contest.common.bo.OrderListQryInfoBO;
import com.tydic.pre.contest.common.bo.OrderListQryReqBO;
import com.tydic.pre.contest.common.bo.OrderListQryRspBO;
import com.tydic.pre.contest.constants.OrderContants;
import com.tydic.pre.contest.dao.OrdersMapper;
import com.tydic.pre.contest.dao.ProductMapper;
import com.tydic.pre.contest.dao.UsersMapper;
import com.tydic.pre.contest.po.OrderListQryInfoPO;
import com.tydic.pre.contest.po.ProductPO;
import com.tydic.pre.contest.po.UsersPO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 标题：OrderListQryServiceImpl
 * 说明：
 * 时间：2023/7/22 14:22
 * 作者：Zhouhaifeng
 */
@Service
public class OrderListQryServiceImpl implements OrderListQryService {
    @Autowired
    private OrdersMapper ordersMapper;
    @Autowired
    private UsersMapper usersMapper;
    @Autowired
    private ProductMapper productMapper;
    @Resource(name = "orderTaskProducer")
    private ProxyMessageProducer orderTaskProducer;

    @Override
    public OrderListQryRspBO orderList(OrderListQryReqBO reqBO) {
        OrderListQryRspBO rspBO = new OrderListQryRspBO();
        List<Long> productIds = new ArrayList<>();
        if(!StringUtils.isEmpty(reqBO.getProductName())){
            List<ProductPO> productPOS = productMapper.qryByName(reqBO.getProductName());
            if(CollectionUtil.isNotEmpty(productPOS)){
                productIds = productPOS.stream().map(ProductPO::getProductId).collect(Collectors.toList());
            }
        }

        Page<OrderListQryInfoPO> page =  new Page<>();
        page.setPageSize(reqBO.getPageSize());
        page.setPageNo(reqBO.getPageNo());
        String orderBo = JSONObject.toJSONString(reqBO);
        OrderListQryInfoPO orderListQryInfoPO = JSONObject.parseObject(orderBo, OrderListQryInfoPO.class);
        orderListQryInfoPO.setList(productIds);
        List<OrderListQryInfoPO> orderListQryInfoPOS = ordersMapper.qryList(orderListQryInfoPO, page);
        List<OrderListQryInfoBO> rows = new ArrayList<>();
        if(CollectionUtil.isNotEmpty(orderListQryInfoPOS)){
            List<Long> userIds = orderListQryInfoPOS.stream().map(OrderListQryInfoPO::getUserId).collect(Collectors.toList());
            List<Long> productList = orderListQryInfoPOS.stream().map(OrderListQryInfoPO::getProductId).collect(Collectors.toList());
            List<UsersPO> usersPOS = usersMapper.qryList(userIds);
            List<ProductPO> productPOS = productMapper.qryProductList(productList);
            for (OrderListQryInfoPO listQryInfoPO : orderListQryInfoPOS) {
                String boStr = JSONObject.toJSONString(listQryInfoPO);
                OrderListQryInfoBO orderListQryInfoBO = JSONObject.parseObject(boStr, OrderListQryInfoBO.class);
                if (listQryInfoPO.getOrderStatus().equals(OrderContants.ORDER_STATUS_ZONE.getCode())) {
                    orderListQryInfoBO.setOrderStatusDesc(OrderContants.ORDER_STATUS_ZONE.getMessage());
                } else if (listQryInfoPO.getOrderStatus().equals(OrderContants.ORDER_STATUS_ONE.getCode())) {
                    orderListQryInfoBO.setOrderStatusDesc(OrderContants.ORDER_STATUS_ONE.getMessage());
                } else if (listQryInfoPO.getOrderStatus().equals(OrderContants.ORDER_STATUS_TWO.getCode())) {
                    orderListQryInfoBO.setOrderStatusDesc(OrderContants.ORDER_STATUS_TWO.getMessage());
                } else if (listQryInfoPO.getOrderStatus().equals(OrderContants.ORDER_STATUS_THREE.getCode())) {
                    orderListQryInfoBO.setOrderStatusDesc(OrderContants.ORDER_STATUS_THREE.getMessage());
                } else if (listQryInfoPO.getOrderStatus().equals(OrderContants.ORDER_STATUS_FOUR.getCode())) {
                    orderListQryInfoBO.setOrderStatusDesc(OrderContants.ORDER_STATUS_FOUR.getMessage());
                }
                for (UsersPO usersPO : usersPOS) {
                    if(usersPO.getUserId().equals(listQryInfoPO.getUserId())){
                        orderListQryInfoBO.setUserName(usersPO.getUserName());
                    }
                }
                for (ProductPO productPO : productPOS) {
                    if(productPO.getProductId().equals(listQryInfoPO.getProductId())){
                        orderListQryInfoBO.setOriginalPrice(productPO.getOriginalPrice());
                        orderListQryInfoBO.setPromotionPrice(productPO.getPromotionPrice());
                        orderListQryInfoBO.setProductName(productPO.getProductName());
                    }
                }
                rows.add(orderListQryInfoBO);
            }
            // 设置页码
            rspBO.setPageNo(page.getPageNo());
            rspBO.setRecordsTotal(page.getTotalCount());
            rspBO.setTotal(page.getTotalPages());
            rspBO.setRows(rows);
        }else {
            rspBO.setRows(null);
        }
        return rspBO;
    }

    @Override
    public void sendMq() {
        orderTaskProducer.send(new ProxyMessage("ORDER_TASK_TOPIC", "*","测试11" ));
    }


}
