package com.tydic.pre.contest.common.impl.customer;

import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.impl.ProxyProducerFactoryBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 标题：DycUccSkuPriceChangeMqConfig
 * 说明：价格变动同步一物一码
 * 时间：2023/3/27 16:52
 *
 * @author 文乐
 */
@Configuration
public class OrderTaskMqConfig {

    @Value("${ORDER_TASK_PID:ORDER_TASK_PID}")
    private String ORDER_TASK_PID;

    @Value("${ORDER_TASK_CID:ORDER_TASK_CID}")
    private String ORDER_TASK_CID;

    @Value("${ORDER_TASK_TOPIC:ORDER_TASK_TOPIC}")
    private String ORDER_TASK_TOPIC;

    @Bean("orderTaskConfig")
    public DefaultProxyMessageConfig defaultProxyMessageConfig() {
        DefaultProxyMessageConfig defaultProxyMessageConfig = new DefaultProxyMessageConfig();
        defaultProxyMessageConfig.setId(ORDER_TASK_PID);
        return defaultProxyMessageConfig;
    }

    @Bean(value = "orderTaskProducer", initMethod = "startup", destroyMethod = "shutdown")
    public ProxyProducerFactoryBean proxyProducerFactoryBean() {
        ProxyProducerFactoryBean proxyProducerFactoryBean = new ProxyProducerFactoryBean();
        proxyProducerFactoryBean.setMessageConfig(defaultProxyMessageConfig());
        return proxyProducerFactoryBean;
    }

    @Bean("orderTaskCustomer")
    public OrderTaskCustomer OrderTaskServiceCustomer() {
        OrderTaskCustomer dycUccSkuPriceChangeConsumer =
                new OrderTaskCustomer();
        dycUccSkuPriceChangeConsumer.setId(ORDER_TASK_CID);
        dycUccSkuPriceChangeConsumer.setSubject(ORDER_TASK_TOPIC);
        String[] tags = {"*"};
        dycUccSkuPriceChangeConsumer.setTags(tags);
        return dycUccSkuPriceChangeConsumer;
    }
}
