package com.tydic.pre.contest.po;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题：OrderListQryInfoBO
 * 说明：
 * 时间：2023/7/22 14:17
 * 作者：Zhouhaifeng
 */
@Data
public class OrderListQryInfoPO implements Serializable {
    private static final long serialVersionUID = -6182830884218095127L;

    /**
     * 用户编码
     */
    private Long userId;
    /**
     * 商品名称
     */
    private String productName;
    /**
     * 商品编码
     */
    private Long productId;
    /**
     * 订单编码
     */
    private Long orderId;
    /**
     * 订单状态
     * 0：代付款、1：已付款、2：待发货、3：已发货、4：已完成
     */
    private String orderStatus;
    /**
     * 订单状态翻译
     */
    private String orderStatusDesc;
    /**
     * 订单时间
     */
    private Date orderTime;
    /**
     * 订单金额
     */
    private BigDecimal orderAmount;
    /**
     * 用户名称
     */
    private String userName;
    /**
     * 商品原价
     */
    private BigDecimal originalPrice;
    /**
     * 商品促销价
     */
    private BigDecimal promotionPrice;
    /**
     * 订单开始时间
     */
    private Date orderStartTime;
    /**
     * 订单结束时间
     */
    private Date orderEndTime;
    /**
     * 商品编码集合
     */
    private List<Long> list;
}
