package com.tydic.pre.contest.utils;

import cn.hutool.core.io.FileUtil;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.metadata.Sheet;
import com.tydic.pre.contest.exception.FDSException;
import com.tydic.pre.contest.exception.FDSResponseInfoEnum;
import com.tydic.pre.contest.listen.ExcelListener;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.FileUtils;

import java.io.*;
import java.util.*;
import java.util.concurrent.ExecutorService;

/**
 * @author:jiliang
 * @Date:2019/6/12
 * @Time:9:59
 */
@Slf4j
public class MergeExcelUtils {

    /**
     * 合并后每个sheet最大行数
     */
    private int eachSheetMaxSize;
    /**
     * 列名集合
     */
    private List<String> columns;
    /**
     * 文件合并路径
     */
    private String targetPath;
    /**
     * 临时文件路径
     */
    private String sourcePath;
    /**
     * 每个临时文件行数
     */
    private int eachTmpExcelSize;
    /**
     * 任务id
     */
    private String taskId;
    /**
     * 合并excel线程池
     */
    private ExecutorService mergeFileExecutorService;
    /**
     * 待写入的map
     */
    private Map<String, ToWriteSheetData> toWriteSheetMap;
    /**
     * 存储每个sheet对应部分个数的map
     */
    private Map<Integer, Integer> eachSheetSizeMap;
    /**
     * 异步读取文件是否成功
     */
    private boolean executeFlag = true;

    private String mergeFilePath;

    private String mergeFileName;

    public MergeExcelUtils(List<String> columns, String sourcePath, String targetPath, int eachSheetMaxSize, int eachTmpExcelSize, String taskId, ExecutorService mergeFileExecutorService) {
        this.columns = columns;
        this.sourcePath = sourcePath;
        this.targetPath = targetPath;
        this.eachSheetMaxSize = eachSheetMaxSize;
        this.eachTmpExcelSize = eachTmpExcelSize;
        this.taskId = taskId;
        this.mergeFileExecutorService = mergeFileExecutorService;
    }

    public MergeExcelUtils(List<String> columns, String sourcePath, String targetPath, int eachSheetMaxSize,
                           int eachTmpExcelSize, String taskId, ExecutorService mergeFileExecutorService,
                           String mergeFilePath, String mergeFileName) {
        this.columns = columns;
        this.sourcePath = sourcePath;
        this.targetPath = targetPath;
        this.eachSheetMaxSize = eachSheetMaxSize;
        this.eachTmpExcelSize = eachTmpExcelSize;
        this.taskId = taskId;
        this.mergeFileExecutorService = mergeFileExecutorService;
        this.mergeFilePath = mergeFilePath;
        this.mergeFileName = mergeFileName;
    }

    public void merge() throws FDSException {
        log.info("## 开始合并文件, taskId: {}", this.taskId);
        Long startMerge = System.currentTimeMillis();
        //最终文件已合并的sheet索引
        int targetSheetIndex = 1;
        //每个sheet由多少个临时文件合成
        int eachSheetNum = this.eachSheetMaxSize / this.eachTmpExcelSize;

        ExcelWriter writer = null;
        try  {
            writer = EasyExcelFactory.write(new FileOutputStream(this.targetPath)).build();

            File sourcePathFile = new File(this.sourcePath);

            if (sourcePathFile.listFiles() != null) {
                //排序后的临时文件集合

                File[] files = FileUtil.ls(sourcePath);

//                for (File file : sourcePathFile.listFiles()) {
//
//                    int underLineIndex = file.getName().lastIndexOf("_");
//                    int index = Integer.parseInt(file.getName().substring(underLineIndex + 1, underLineIndex + 2));
//                    files[index - 1] = file;
//                }

                //商
                int quotient = sourcePathFile.listFiles().length / eachSheetNum;
                //余数
                int remainder = (sourcePathFile.listFiles().length % eachSheetNum) > 0 ? 1 : 0;
                //存储合并后每一个sheet对应的临时文件数组
                Map<Integer, File[]> eachSheetFiles = new HashMap<>(quotient + remainder);
                this.toWriteSheetMap = new LinkedHashMap<>(quotient + remainder);
                this.eachSheetSizeMap = new HashMap<>(quotient + remainder);

                //准备每个sheet页对应的数据
                int lastSheetIndex = prepareEachSheetData(files, eachSheetNum, targetSheetIndex, eachSheetFiles);

                for (Map.Entry entry : eachSheetFiles.entrySet()) {
                    //读取临时文件到map中
                    mergeFileExecutorService.submit(new ReadTmpFiles2SheetMap(entry, taskId));
                }

                //按顺序写入
                write(startMerge, writer, lastSheetIndex);
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("## 合并临时文件出错. ex: {}", e.getMessage());
            throw new FDSException(FDSResponseInfoEnum.MERGE_FILE_ERROR);
        } finally {
            if (writer != null) {
                writer.finish();
            }
        }
    }

    public void merge2() throws FDSException {
        log.info("## 开始合并文件, taskId: {}", this.taskId);
        Long startMerge = System.currentTimeMillis();
        //最终文件已合并的sheet索引
        int targetSheetIndex = 1;
        //每个excel由多少个临时文件合成
        int eachFileNum = this.eachSheetMaxSize / this.eachTmpExcelSize;

        File sourcePathFile = new File(this.sourcePath);

        //商
        int quotient = Objects.requireNonNull(sourcePathFile.listFiles()).length / eachFileNum;
        //余数
        int remainder = (Objects.requireNonNull(sourcePathFile.listFiles()).length % eachFileNum) > 0 ? 1 : 0;

        int fileNum = quotient + remainder;

        for (int i = 0; i < fileNum; i++){
            ExcelWriter writer = null;
            try  {
                String suffix = i + ".xlsx";

                String fileName = this.mergeFileName + suffix;

                try {
                    File targetFile = new File(mergeFilePath);
                    if (!targetFile.exists()) {
                        FileUtils.forceMkdir(targetFile);
                    }
                } catch (IOException e) {
                    log.error("创建合并文件目录失败", e);
                    throw new InterruptedException("创建合并文件目录失败");
                }


                writer = EasyExcelFactory.write(new FileOutputStream(fileName)).build();

                if (sourcePathFile.listFiles() != null) {
                    //排序后的临时文件集合

                    File[] files = FileUtil.ls(sourcePath);

                    //存储合并后每一个sheet对应的临时文件数组
                    Map<Integer, File[]> eachSheetFiles = new HashMap<>(fileNum);
                    this.toWriteSheetMap = new LinkedHashMap<>(fileNum);
                    this.eachSheetSizeMap = new HashMap<>(fileNum);

                    //准备每个excel对应的数据
                    int lastSheetIndex = prepareEachSheetData(files, eachFileNum, targetSheetIndex, eachSheetFiles);

                    for (Map.Entry<Integer, File[]> entry : eachSheetFiles.entrySet()) {
                        //读取临时文件到map中
                        mergeFileExecutorService.submit(new ReadTmpFiles2SheetMap(entry, taskId));
                    }

                    //按顺序写入
                    writeMid(startMerge, writer, lastSheetIndex);
                }
            } catch (Exception e) {
                e.printStackTrace();
                log.error("## 合并临时文件出错. ex: {}", e.getMessage());
                throw new FDSException(FDSResponseInfoEnum.MERGE_FILE_ERROR);
            } finally {
                if (writer != null) {
                    writer.finish();
                }
            }
        }

    }

    /**
     * 将文件数组按照每个 sheet 页可以容纳的文件数量分成多个部分，准备好每个 sheet 页的数据
     *
     * @param files         待处理的文件数组
     * @param eachSheetNum  每个 sheet 页可以容纳的文件数量
     * @param targetSheetIndex  目标 sheet 页的索引
     * @param eachSheetFiles    每个 sheet 页对应的文件数组
     * @return  目标 sheet 页的索引
     */
    private int prepareEachSheetData(File[] files, int eachSheetNum, int targetSheetIndex, Map<Integer, File[]> eachSheetFiles) {
        int k = 0;
        for (File file : files) {
            // 根据文件数量计算当前文件所在的 sheet 页索引
            int key = k / eachSheetNum + 1;
            if (eachSheetFiles.get(key) != null && eachSheetFiles.get(key).length > 0) {
                // 获取当前 sheet 页中文件数组的索引
                int index = k - (eachSheetNum * (targetSheetIndex - 2));
                eachSheetFiles.get(targetSheetIndex - 1)[index] = file;
                // 设置对应 sheet 页的总部分大小
                if (eachSheetSizeMap.get(targetSheetIndex - 1) != null) {
                    eachSheetSizeMap.put(targetSheetIndex - 1, index + 1);
                }
            } else {
                // 如果当前 sheet 页不存在对应的文件数组，则新建一个
                File[] tmpFiles = new File[eachSheetNum];
                tmpFiles[0] = file;
                eachSheetFiles.put(targetSheetIndex, tmpFiles);
                eachSheetSizeMap.put(targetSheetIndex, 1);
                targetSheetIndex++;
            }
            k++;
        }
        // 返回目标 sheet 页的索引
        return targetSheetIndex - 1;
    }

//    private int prepareEachSheetData(File[] files, int eachSheetNum, int targetSheetIndex, Map<Integer, File[]> eachSheetFiles) {
//        int k = 0;
//        for (File file : files) {
//            int key = k / eachSheetNum + 1;
//            if (eachSheetFiles.get(key) != null && eachSheetFiles.get(key).length > 0) {
//                int index = k - (eachSheetNum * (targetSheetIndex - 2));
//                eachSheetFiles.get(targetSheetIndex - 1)[index] = file;
//                //设置对应sheet页的总部分大小
//                if (eachSheetSizeMap.get(targetSheetIndex - 1) != null) {
//                    eachSheetSizeMap.put(targetSheetIndex - 1, index + 1);
//                }
//            } else {
//                File[] tmpFiles = new File[eachSheetNum];
//                tmpFiles[0] = file;
//                eachSheetFiles.put(targetSheetIndex, tmpFiles);
//                eachSheetSizeMap.put(targetSheetIndex, 1);
//                targetSheetIndex++;
//            }
//            k++;
//        }
//        return targetSheetIndex - 1;
//    }

    private void write(Long startMerge, ExcelWriter writer, int lastSheetIndex) throws Exception {
        try {
            int order = 1;
            int eachSheetInternalOrder = 0;
            for (; ; ) {
                if (!executeFlag) {
                    throw new Exception("## 读取临时文件过程中异常");
                }
                String key = order + "_" + eachSheetInternalOrder + "_" + this.eachSheetSizeMap.get(order);
                ToWriteSheetData toWriteSheetData = this.toWriteSheetMap.get(key);
                if (toWriteSheetData != null) {
                    log.info("## taskId: {}, 开始写入第 {} Sheet页, 第 {} 部分, 共 {} 行", this.taskId,
                            order, eachSheetInternalOrder + 1, toWriteSheetData.getEachSheetData().size());
                    //写入
                    writer.write0(toWriteSheetData.getEachSheetData(), toWriteSheetData.getSheet());
                    //控制内存
                    toWriteSheetMap.remove(key);
                    log.info("## taskId: {}, 结束写入第 {} Sheet页, 第 {} 部分", this.taskId, order, eachSheetInternalOrder + 1);

                    eachSheetInternalOrder++;
                    if (eachSheetInternalOrder == this.eachSheetSizeMap.get(order)) {
                        order++;
                        eachSheetInternalOrder = 0;
                    }
                }
                if (order - 1 == lastSheetIndex) {
                    log.info("## 结束合并文件, taskId: {}, 耗时 {}ms", this.taskId, System.currentTimeMillis() - startMerge);
                    break;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("## 写入出错.ex: {}  ", e.getMessage());
            throw new Exception(e.getMessage());
        }
    }

    private void writeMid(Long startMerge, ExcelWriter writer, int lastSheetIndex) throws Exception {
        try {
            int order = 1;
            int eachSheetInternalOrder = 0;
            for (; ; ) {
                if (!executeFlag) {
                    throw new Exception("## 读取临时文件过程中异常");
                }
                String key = order + "_" + eachSheetInternalOrder + "_" + this.eachSheetSizeMap.get(order);
                ToWriteSheetData toWriteSheetData = this.toWriteSheetMap.get(key);
                if (toWriteSheetData != null) {
                    log.info("## taskId: {}, 开始写入第 {} 个文件, 第 {} 部分, 共 {} 行", this.taskId,
                            order, eachSheetInternalOrder + 1, toWriteSheetData.getEachSheetData().size());
                    //写入
                    writer.write0(toWriteSheetData.getEachSheetData(), toWriteSheetData.getSheet());
                    //控制内存
                    toWriteSheetMap.remove(key);
                    log.info("## taskId: {}, 结束写入第 {} Sheet页, 第 {} 部分", this.taskId, order, eachSheetInternalOrder + 1);

                    eachSheetInternalOrder++;
                    if (eachSheetInternalOrder == this.eachSheetSizeMap.get(order)) {
                        order++;
                        eachSheetInternalOrder = 0;
                    }
                }
                if (order - 1 == lastSheetIndex) {
                    log.info("## 结束合并文件, taskId: {}, 耗时 {}ms", this.taskId, System.currentTimeMillis() - startMerge);
                    break;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("## 写入出错.ex: {}  ", e.getMessage());
            throw new Exception(e.getMessage());
        }
    }

    private List<List<String>> readTmpExcel(File file, int targetSheetSize) throws Exception {
        List<List<String>> list = new ArrayList<>();
        try (InputStream inputStream = new FileInputStream(file)) {
            ExcelListener excelListener = new ExcelListener(targetSheetSize, this.columns);

            EasyExcelFactory.readBySax(inputStream, new Sheet(1, 0), excelListener);
            if (excelListener.getIsAllAnalysed()) {
                list = excelListener.getData();
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("## 读取临时文件出错. ex:{} ", e.getMessage());
            throw new Exception(e.getMessage());
        }
        return list;
    }

//    private List<List<String>> readTmpExcel(File file, int targetSheetSize) throws Exception {
//        List<List<String>> list = new ArrayList<>();
//        try (InputStream inputStream = new FileInputStream(file)) {
//            ExcelListener excelListener = new ExcelListener(targetSheetSize, this.columns);
//
//            // 创建读取Excel的上下文对象
//            ReadContext readContext = EasyExcel.read(inputStream).build();
//
//            // 读取第一个工作表的数据
//            readContext.readSheet(0).registerReadListener(excelListener).doRead();
//
//            if (excelListener.getIsAllAnalysed()) {
//                list = excelListener.getData();
//            }
//        } catch (Exception e) {
//            e.printStackTrace();
//            log.error("## 读取临时文件出错. ex:{} ", e.getMessage());
//            throw new Exception(e.getMessage());
//        }
//        return list;
//    }

    class ReadTmpFiles2SheetMap implements Runnable {
        private Map.Entry entry;
        private String taskId;

        private ReadTmpFiles2SheetMap(Map.Entry entry, String taskId) {
            this.entry = entry;
            this.taskId = taskId;
        }

        @Override
        public void run() {
            try {
                long start = System.currentTimeMillis();
                int j = 0;
                int lastSize = 0;
                int length = eachSheetSizeMap.get(this.entry.getKey());
                for (File file : (File[]) this.entry.getValue()) {
                    if (file != null) {
                        if (toWriteSheetMap.size() > 20) {
                            Thread.sleep(500);
                        }

                        List<List<String>> list = readTmpExcel(file, j);
                        Sheet sheet = new Sheet(Integer.valueOf(this.entry.getKey().toString()), 0);
                        sheet.setSheetName("sheet" + this.entry.getKey());
                        sheet.setStartRow(lastSize);
                        //设置自适应宽度
                        sheet.setAutoWidth(Boolean.TRUE);

                        String key = this.entry.getKey() + "_" + j + "_" + length;
                        toWriteSheetMap.put(key, new ToWriteSheetData(list, sheet));
                        log.info("## 已准备完毕taskId: {} , 第 {} Sheet页, 第 {} 部分数据", this.taskId, this.entry.getKey(), j + 1);

                        lastSize = list.size();
                        j++;
                    }
                }

                log.info("## 已准备完毕taskId: {} , 第 {} Sheet页数据, 耗时: {}", this.taskId, this.entry.getKey(), System.currentTimeMillis() - start);
            } catch (Exception e) {
                executeFlag = false;
                e.printStackTrace();
                log.error("## 读取sheet页相应的临时文件出错. ex: {} ", e);
            }
        }
    }

}