/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.rpa.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.rpa.api.DocCatalogManageService;
import com.tydic.rpa.api.bo.DocCatalogReqBO;
import com.tydic.rpa.api.bo.base.RpaRspBO;
import com.tydic.rpa.dao.DocCatalogMapper;
import com.tydic.rpa.dao.DocMapper;
import com.tydic.rpa.exception.BaseBusinessException;
import com.tydic.rpa.po.DocCatalogPO;
import com.tydic.rpa.po.DocPO;
import com.tydic.rpa.utils.Sequence;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service(value="docCatalogManageService")
public class DocCatalogManageServiceImpl
implements DocCatalogManageService {
    private static final Logger log = LoggerFactory.getLogger(DocCatalogManageServiceImpl.class);
    private final DocCatalogMapper catalogMapper;
    private final DocMapper docMapper;

    public DocCatalogManageServiceImpl(DocCatalogMapper catalogMapper, DocMapper docMapper) {
        this.catalogMapper = catalogMapper;
        this.docMapper = docMapper;
    }

    public RpaRspBO<String> dealMange(DocCatalogReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("8888", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getOperType())) {
            throw new BaseBusinessException("8888", "\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        switch (reqBO.getOperType()) {
            case 1: {
                this.addDocCatalog(reqBO);
                break;
            }
            case 2: {
                this.editDocCatalog(reqBO);
                break;
            }
            case 3: {
                this.deleteDocCatalog(reqBO);
                break;
            }
            default: {
                throw new BaseBusinessException("8888", "\u64cd\u4f5c\u7c7b\u578b\u5f02\u5e38");
            }
        }
        return RpaRspBO.success((Object)"\u6210\u529f");
    }

    private void addDocCatalog(DocCatalogReqBO reqBO) {
        log.info("\u6267\u884c\u65b0\u589e\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        if (StringUtils.isEmpty((Object)reqBO.getDocModuleId())) {
            throw new BaseBusinessException("8888", "\u6a21\u5757Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getCatalogName())) {
            throw new BaseBusinessException("8888", "\u76ee\u5f55\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getParentId())) {
            throw new BaseBusinessException("8888", "\u7236\u8282\u70b9ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String docCatalogId = String.valueOf(Sequence.nextId());
        DocCatalogPO docCatalogPO = new DocCatalogPO();
        docCatalogPO.setId(docCatalogId);
        docCatalogPO.setCatalogName(reqBO.getCatalogName());
        docCatalogPO.setDisplay(1);
        docCatalogPO.setParentId(reqBO.getParentId());
        docCatalogPO.setSort(reqBO.getSort());
        docCatalogPO.setDocModuleId(reqBO.getDocModuleId());
        docCatalogPO.setExtField1(reqBO.getExtField1());
        docCatalogPO.setExtField2(reqBO.getExtField2());
        String parentId = reqBO.getParentId();
        DocCatalogPO qryPo = new DocCatalogPO();
        qryPo.setOrderBy("sort desc");
        qryPo.setParentId(parentId);
        List<DocCatalogPO> sortList = this.catalogMapper.getList(qryPo);
        if (CollectionUtils.isEmpty(sortList)) {
            docCatalogPO.setSort(1);
        } else if (ObjectUtils.isEmpty((Object)sortList.get(0).getSort())) {
            docCatalogPO.setSort(1);
        } else {
            docCatalogPO.setSort(sortList.get(0).getSort() + 1);
        }
        DocPO docPO = new DocPO();
        docPO.setDocId(String.valueOf(Sequence.nextId()));
        docPO.setDocCatalogId(docCatalogId);
        docPO.setContent("");
        docPO.setCreateBy(reqBO.getUserId());
        docPO.setCreateTime(this.catalogMapper.getDBDate());
        docPO.setUpdateBy(reqBO.getUserId());
        docPO.setUpdateTime(this.catalogMapper.getDBDate());
        try {
            this.catalogMapper.insert(docCatalogPO);
            this.docMapper.insert(docPO);
        }
        catch (Exception e) {
            throw new BaseBusinessException("8888", "\u65b0\u589e\u6587\u6863\u76ee\u5f55\u5f02\u5e38");
        }
    }

    private void editDocCatalog(DocCatalogReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getId())) {
            throw new BaseBusinessException("8888", "\u76ee\u5f55ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DocCatalogPO editPo = new DocCatalogPO();
        editPo.setId(reqBO.getId());
        if (!StringUtils.isEmpty((Object)reqBO.getCatalogName())) {
            editPo.setCatalogName(reqBO.getCatalogName());
        }
        if (!ObjectUtils.isEmpty((Object)reqBO.getDisplay())) {
            editPo.setDisplay(reqBO.getDisplay());
        }
        if (!ObjectUtils.isEmpty((Object)reqBO.getSort())) {
            editPo.setSort(reqBO.getSort());
        }
        try {
            this.catalogMapper.updateById(editPo);
        }
        catch (Exception e) {
            throw new BaseBusinessException("8888", "\u66f4\u65b0\u6587\u6863\u76ee\u5f55\u5f02\u5e38");
        }
    }

    private void deleteDocCatalog(DocCatalogReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getId())) {
            throw new BaseBusinessException("8888", "\u76ee\u5f55ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DocCatalogPO deletePo = new DocCatalogPO();
        deletePo.setId(reqBO.getId());
        try {
            this.catalogMapper.deleteBy(deletePo);
        }
        catch (Exception e) {
            throw new BaseBusinessException("8888", "\u5220\u9664\u6587\u6863\u76ee\u5f55\u5f02\u5e38");
        }
    }
}

