/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.rpa.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.rpa.api.DocCatalogQryService;
import com.tydic.rpa.api.bo.CatalogDataBO;
import com.tydic.rpa.api.bo.DocCatalogQryReqBO;
import com.tydic.rpa.api.bo.DocCatalogQryRspBO;
import com.tydic.rpa.api.bo.GetAllCatalogReqBO;
import com.tydic.rpa.api.bo.base.RpaRspBO;
import com.tydic.rpa.constants.RpaConstants;
import com.tydic.rpa.dao.DocCatalogMapper;
import com.tydic.rpa.dao.DocModuleMapper;
import com.tydic.rpa.exception.BaseBusinessException;
import com.tydic.rpa.po.DocCatalogPO;
import com.tydic.rpa.po.DocModulePO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service(value="docCatalogQryService")
public class DocCatalogQryServiceImpl
implements DocCatalogQryService {
    private static final Logger log = LoggerFactory.getLogger(DocCatalogQryServiceImpl.class);
    private final DocCatalogMapper catalogMapper;
    private final DocModuleMapper docModuleMapper;

    public DocCatalogQryServiceImpl(DocCatalogMapper catalogMapper, DocModuleMapper docModuleMapper) {
        this.catalogMapper = catalogMapper;
        this.docModuleMapper = docModuleMapper;
    }

    public RpaRspBO<DocCatalogQryRspBO> getList(DocCatalogQryReqBO reqBO) {
        DocCatalogQryRspBO catalogQryRspBO = new DocCatalogQryRspBO();
        if (StringUtils.isEmpty((Object)reqBO.getModuleId())) {
            throw new BaseBusinessException("8888", "\u6a21\u5757ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getParentid())) {
            throw new BaseBusinessException("8888", "\u7236\u76ee\u5f55ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DocCatalogPO catalogPO = new DocCatalogPO();
        catalogPO.setDocModuleId(reqBO.getModuleId());
        catalogPO.setParentId(reqBO.getParentid());
        List<DocCatalogPO> resultList = this.catalogMapper.getList(catalogPO);
        if (!CollectionUtils.isEmpty(resultList)) {
            List catalogDataBOS = JSON.parseArray((String)JSON.toJSONString(resultList), CatalogDataBO.class);
            catalogQryRspBO.setCatalogList(catalogDataBOS);
        }
        return RpaRspBO.success((Object)catalogQryRspBO);
    }

    public RpaRspBO<CatalogDataBO> getAllCatalog(GetAllCatalogReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getModuleId())) {
            throw new BaseBusinessException("8888", "\u6a21\u5757ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        GetAllCatalogReqBO getAllCatalogReqBO = new GetAllCatalogReqBO();
        getAllCatalogReqBO.setModuleId(reqBO.getModuleId());
        if (!ObjectUtils.isEmpty((Object)reqBO.getDisplay())) {
            getAllCatalogReqBO.setDisplay(reqBO.getDisplay());
        }
        CatalogDataBO allCatalog = this.catalogMapper.getAllCatalog(reqBO);
        return RpaRspBO.success((Object)allCatalog);
    }

    public RpaRspBO<List<CatalogDataBO>> getAllStartCatalog(GetAllCatalogReqBO reqBO) {
        ArrayList catalogDataBOList = new ArrayList();
        DocModulePO docModulePo = new DocModulePO();
        docModulePo.setModuleStatus(RpaConstants.MODULE_STATUS_ENABLE);
        List<DocModulePO> docModulePoList = this.docModuleMapper.getList(docModulePo);
        List<String> moduleIdList = docModulePoList.stream().map(DocModulePO::getModuleId).collect(Collectors.toList());
        DocCatalogPO docCatalogPo = new DocCatalogPO();
        docCatalogPo.setDocModuleIdList(moduleIdList);
        List<DocCatalogPO> docCatalogPoList = this.catalogMapper.getList(docCatalogPo);
        List tempCataLogDataBOList = JSON.parseArray((String)JSON.toJSONString(docCatalogPoList), CatalogDataBO.class);
        Map<String, List<CatalogDataBO>> catalogDataBOMap = tempCataLogDataBOList.stream().collect(Collectors.groupingBy(CatalogDataBO::getParentId));
        catalogDataBOList.addAll(catalogDataBOMap.get("0"));
        for (CatalogDataBO tempCatalogDataBO : catalogDataBOList) {
            tempCatalogDataBO.setChild((List)catalogDataBOMap.getOrDefault(tempCatalogDataBO.getId(), new ArrayList()));
        }
        return RpaRspBO.success(catalogDataBOList);
    }
}

