/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.rpa.ability.impl;

import com.tydic.rpa.api.DocModuleManageService;
import com.tydic.rpa.api.bo.DocModuleManageReqBO;
import com.tydic.rpa.api.bo.base.RpaRspBO;
import com.tydic.rpa.dao.DocCatalogMapper;
import com.tydic.rpa.dao.DocMapper;
import com.tydic.rpa.dao.DocModuleMapper;
import com.tydic.rpa.exception.BaseBusinessException;
import com.tydic.rpa.po.DocCatalogPO;
import com.tydic.rpa.po.DocModulePO;
import com.tydic.rpa.po.DocPO;
import com.tydic.rpa.utils.Sequence;
import com.tydic.rpa.utils.ValidBatchUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service(value="docModuleManageService")
public class DocModuleManageServiceImpl
implements DocModuleManageService {
    private static final Logger log = LoggerFactory.getLogger(DocModuleManageServiceImpl.class);
    @Autowired
    private DocModuleMapper docModuleMapper;
    @Autowired
    private DocCatalogMapper catalogMapper;
    @Autowired
    private DocMapper docMapper;
    private static final String OPER_TYPE = "operType";
    private static final String STATUS_ENABLE = "\u542f\u7528";
    private static final String STATUS_UNENABLE = "\u505c\u7528";

    public RpaRspBO<String> dealManage(DocModuleManageReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("8888", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        ValidBatchUtils.isNotEmpty(reqBO, OPER_TYPE);
        switch (reqBO.getOperType()) {
            case 1: {
                this.addDocModule(reqBO);
                break;
            }
            case 2: {
                this.editDocModule(reqBO);
                break;
            }
            case 3: {
                this.deleteDocModule(reqBO);
                break;
            }
            default: {
                throw new BaseBusinessException("8888", "\u64cd\u4f5c\u7c7b\u578b\u5f02\u5e38");
            }
        }
        return RpaRspBO.success((Object)"\u6210\u529f");
    }

    private void addDocModule(DocModuleManageReqBO reqBO) {
        String validAdd = this.validAdd(reqBO);
        if (!StringUtils.isEmpty((Object)validAdd)) {
            throw new BaseBusinessException("8888", validAdd);
        }
        String moduleName = reqBO.getModuleName();
        DocModulePO checkPo = new DocModulePO();
        checkPo.setModuleName(moduleName);
        int checkBy = this.docModuleMapper.getCheckBy(checkPo);
        if (checkBy > 0) {
            throw new BaseBusinessException("8888", "\u6a21\u5757\u540d\u79f0\u91cd\u590d");
        }
        DocModulePO docModulePO = new DocModulePO();
        BeanUtils.copyProperties((Object)reqBO, (Object)docModulePO);
        String docModuleId = String.valueOf(Sequence.nextId());
        docModulePO.setModuleId(docModuleId);
        docModulePO.setCreateBy(reqBO.getUserId());
        docModulePO.setCreateTime(this.docModuleMapper.getDBDate());
        docModulePO.setModuleStatus(1);
        docModulePO.setModuleStatusDesc(STATUS_ENABLE);
        docModulePO.setCategory(reqBO.getCategory());
        docModulePO.setImgUrl(reqBO.getImgUrl());
        DocCatalogPO catalogPO = new DocCatalogPO();
        String catalogId = String.valueOf(Sequence.nextId());
        catalogPO.setId(catalogId);
        catalogPO.setCatalogName(reqBO.getModuleName());
        catalogPO.setDocModuleId(docModuleId);
        catalogPO.setDisplay(1);
        catalogPO.setParentId("0");
        DocPO docPO = new DocPO();
        docPO.setDocCatalogId(catalogId);
        docPO.setCreateTime(this.docMapper.getDBDate());
        docPO.setCreateBy(reqBO.getUserId());
        docPO.setDocId(String.valueOf(Sequence.nextId()));
        docPO.setContent("");
        try {
            this.docModuleMapper.insert(docModulePO);
            this.catalogMapper.insert(catalogPO);
            this.docMapper.insert(docPO);
        }
        catch (Exception e) {
            throw new BaseBusinessException("8888", "\u65b0\u589e\u5931\u8d25:" + e.getMessage());
        }
    }

    private void deleteDocModule(DocModuleManageReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getModuleId())) {
            throw new BaseBusinessException("8888", "\u6a21\u5757ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DocModulePO checkPo = new DocModulePO();
        checkPo.setModuleId(reqBO.getModuleId());
        int checkBy = this.docModuleMapper.getCheckBy(checkPo);
        if (checkBy < 1) {
            throw new BaseBusinessException("8888", "\u5220\u9664\u6a21\u5757\u4e0d\u5b58\u5728");
        }
        DocModulePO deletePo = new DocModulePO();
        deletePo.setModuleId(reqBO.getModuleId());
        try {
            this.docModuleMapper.deleteBy(deletePo);
        }
        catch (Exception e) {
            throw new BaseBusinessException("8888", "\u5220\u9664\u5931\u8d25");
        }
    }

    private void editDocModule(DocModuleManageReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getModuleId())) {
            throw new BaseBusinessException("8888", "\u6a21\u5757ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DocModulePO docModulePO = new DocModulePO();
        docModulePO.setModuleId(reqBO.getModuleId());
        DocModulePO modelBy = this.docModuleMapper.getModelBy(docModulePO);
        if (!StringUtils.isEmpty((Object)reqBO.getModuleName()) && !reqBO.getModuleName().equals(modelBy.getModuleName())) {
            DocModulePO checkPo = new DocModulePO();
            checkPo.setModuleName(reqBO.getModuleName());
            int checkBy = this.docModuleMapper.getCheckBy(checkPo);
            if (checkBy > 0) {
                throw new BaseBusinessException("8888", "\u6a21\u5757\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
            }
        }
        if (!StringUtils.isEmpty((Object)reqBO.getModuleName())) {
            docModulePO.setModuleName(reqBO.getModuleName());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getCategory())) {
            docModulePO.setCategory(reqBO.getCategory());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getImgUrl())) {
            docModulePO.setImgUrl(reqBO.getImgUrl());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getModuleDesc())) {
            docModulePO.setModuleDesc(reqBO.getModuleDesc());
        }
        if (!ObjectUtils.isEmpty((Object)reqBO.getModuleStatus())) {
            docModulePO.setModuleStatus(reqBO.getModuleStatus());
            if (reqBO.getModuleStatus() == 1) {
                docModulePO.setModuleStatusDesc(STATUS_ENABLE);
            } else {
                docModulePO.setModuleStatusDesc(STATUS_UNENABLE);
            }
        }
        if (!StringUtils.isEmpty((Object)reqBO.getModuleCode())) {
            docModulePO.setModuleCode(reqBO.getModuleCode());
        }
        try {
            this.docModuleMapper.updateById(docModulePO);
        }
        catch (Exception e) {
            throw new BaseBusinessException("8888", "\u66f4\u65b0\u5931\u8d25");
        }
    }

    private String validAdd(DocModuleManageReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getModuleName())) {
            return "\u6a21\u5757\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBO.getModuleCode())) {
            return "\u6a21\u5757\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

