/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.rpa.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.rpa.api.DocQryService;
import com.tydic.rpa.api.bo.DocDataBO;
import com.tydic.rpa.api.bo.DocQryDetailReqBO;
import com.tydic.rpa.api.bo.DocQryPageReqBO;
import com.tydic.rpa.api.bo.base.RpaRspBO;
import com.tydic.rpa.api.bo.base.RpaRspPageBaseBO;
import com.tydic.rpa.dao.DocCatalogMapper;
import com.tydic.rpa.dao.DocMapper;
import com.tydic.rpa.exception.BaseBusinessException;
import com.tydic.rpa.po.DocCatalogPO;
import com.tydic.rpa.po.DocPO;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service(value="docQryService")
public class DocQryServiceImpl
implements DocQryService {
    @Autowired
    private DocMapper docMapper;
    @Autowired
    private DocCatalogMapper catalogMapper;

    public RpaRspBO<DocDataBO> getDetail(DocQryDetailReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("8888", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getDocCatalogId())) {
            throw new BaseBusinessException("8888", "\u6587\u6863\u76ee\u5f55ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DocCatalogPO catalogPO = new DocCatalogPO();
        catalogPO.setId(reqBO.getDocCatalogId());
        catalogPO = this.catalogMapper.getModelBy(catalogPO);
        DocPO docPO = new DocPO();
        docPO.setDocCatalogId(reqBO.getDocCatalogId());
        List<DocPO> list = this.docMapper.getList(docPO);
        DocDataBO docDataBO = new DocDataBO();
        if (!CollectionUtils.isEmpty(list)) {
            docDataBO = (DocDataBO)JSON.parseObject((String)JSON.toJSONString((Object)list.get(0)), DocDataBO.class);
        }
        docDataBO.setCatalogName(catalogPO.getCatalogName());
        return RpaRspBO.success((Object)docDataBO);
    }

    public RpaRspBO<RpaRspPageBaseBO<DocDataBO>> qryPage(DocQryPageReqBO reqBO) {
        RpaRspPageBaseBO rspPage = new RpaRspPageBaseBO();
        DocPO docPO = new DocPO();
        docPO.setOrderBy("update_time desc");
        Page<DocPO> page = this.getDocPage(reqBO);
        List<DocPO> docPoList = this.docMapper.getListPage(docPO, page);
        List docModuleDataBOS = new ArrayList();
        if (!CollectionUtils.isEmpty(docPoList)) {
            docModuleDataBOS = JSON.parseArray((String)JSON.toJSONString(docPoList), DocDataBO.class);
        }
        rspPage.setPageNo(Integer.valueOf(page.getPageNo()));
        rspPage.setRows(docModuleDataBOS);
        rspPage.setTotal(Integer.valueOf(page.getTotalPages()));
        rspPage.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        return RpaRspBO.success((Object)rspPage);
    }

    private Page<DocPO> getDocPage(DocQryPageReqBO reqBO) {
        Page page;
        if (1 < reqBO.getPageNo()) {
            page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        } else {
            page = new Page();
            BeanUtils.copyProperties((Object)reqBO, (Object)page);
            if (1 > page.getPageNo()) {
                page.setPageNo(1);
            }
            if (1 > page.getPageSize()) {
                page.setPageSize(10);
            }
        }
        return page;
    }
}

