/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.rpa.ability.impl;

import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.oss.OssConfig;
import com.tydic.rpa.api.RpaUploadService;
import com.tydic.rpa.api.bo.UploadRspBO;
import com.tydic.rpa.api.bo.base.RpaRspBO;
import com.tydic.rpa.exception.BaseBusinessException;
import com.tydic.rpa.utils.CodeUtils;
import com.tydic.rpa.utils.FileCalculateUtil;
import com.tydic.rpa.utils.Mp4Util;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="rpaUploadService")
public class RpaUploadServiceImpl
implements RpaUploadService {
    private static final Logger log = LoggerFactory.getLogger(RpaUploadServiceImpl.class);
    @Autowired
    private FileClient fileClient;
    @Value(value="${oss.filePath:upload/aries/file/}")
    private String ossfilePath;
    @Autowired
    private OssConfig ossConfig;

    public RpaRspBO<UploadRspBO> upload(MultipartFile file) {
        long l = System.currentTimeMillis();
        log.info("\u8fdb\u5165upload\u65b9\u6cd5");
        UploadRspBO uploadRspBO = new UploadRspBO();
        try {
            String fileNameSuffix = file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf("."));
            if (fileNameSuffix.endsWith(".mp4")) {
                File convert = RpaUploadServiceImpl.convert(file);
                String fileSizeWithUnit = FileCalculateUtil.getFileSizeWithUnit(convert);
                uploadRspBO.setFileSize(fileSizeWithUnit);
                Integer second = Mp4Util.getMp4During(convert);
                uploadRspBO.setDuring(second);
                if (convert.exists()) {
                    convert.delete();
                }
            }
            String ossFileName = CodeUtils.generateCodeByTimestampAndRandom(4) + fileNameSuffix;
            String path = this.fileClient.uploadFileByInputStream(this.ossfilePath, ossFileName, file.getInputStream());
            String url = this.ossConfig.getAccessUrl() + "/" + path;
            uploadRspBO.setUrl(url);
            log.info("\u4e0a\u4f20\u82b1\u8d39\uff1a{}ms", (Object)(System.currentTimeMillis() - l));
            return RpaRspBO.success((Object)uploadRspBO);
        }
        catch (Exception e) {
            throw new BaseBusinessException("8888", "\u4e0a\u4f20\u5931\u8d25\uff01" + e.getMessage());
        }
    }

    public static File convert(MultipartFile multipartFile) {
        File file = new File(multipartFile.getOriginalFilename());
        try {
            FileUtils.copyInputStreamToFile((InputStream)multipartFile.getInputStream(), (File)file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }
}

