/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.behavior.controller;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.se.base.JsonBusiResponseBody;
import com.tydic.se.behavior.ability.SeCorrectionService;
import com.tydic.se.behavior.ability.SeSynonymService;
import com.tydic.se.behavior.ability.bo.ComUocFileAppBO;
import com.tydic.se.behavior.ability.bo.ComUocFileUploadAppReqBO;
import com.tydic.se.behavior.ability.bo.ComUocFileUploadAppRspBO;
import com.tydic.se.behavior.ability.bo.SeCorrectionBO;
import com.tydic.se.behavior.ability.bo.SeCorrectionListRspBO;
import com.tydic.se.behavior.ability.bo.SeCorrectionReqBO;
import com.tydic.se.behavior.ability.bo.SeSynonymBO;
import com.tydic.se.behavior.ability.bo.SeSynonymListRspBO;
import com.tydic.se.behavior.ability.bo.SeSynonymReqBO;
import com.tydic.se.behavior.constant.WebRequestParameterEnum;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"synchronize"})
public class SynonymAndCorrectionSynchronizeController {
    private static final Logger log = LoggerFactory.getLogger(SynonymAndCorrectionSynchronizeController.class);
    @Autowired
    private SeSynonymService seSynonymService;
    @Autowired
    private SeCorrectionService seCorrectionService;
    @Autowired
    private FileClient fileClient;
    private static final String PATH = "search-engine";
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${oss.accessUrl}")
    private String accessUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;

    @PostMapping(value={"/noauth/synchro"})
    @JsonBusiResponseBody
    public ComUocFileUploadAppRspBO synchroByNoauth(@RequestBody SeSynonymReqBO seSynonymReqBO, SeCorrectionReqBO seCorrectionReqBO) {
        return this.synchro(seSynonymReqBO, seCorrectionReqBO);
    }

    @PostMapping(value={"synchro"})
    @JsonBusiResponseBody
    public ComUocFileUploadAppRspBO synchro(@RequestBody SeSynonymReqBO seSynonymReqBO, SeCorrectionReqBO seCorrectionReqBO) {
        SeSynonymListRspBO seSynonymListRspBO = this.seSynonymService.querySeSynonymList(seSynonymReqBO);
        List data = seSynonymListRspBO.getData();
        StringBuffer stringBuffer = new StringBuffer();
        List collect = data.stream().map(SeSynonymBO::getSynonymList).collect(Collectors.toList());
        for (String synony : collect) {
            synony = this.parse(synony);
            stringBuffer.append(synony).append("\r\n");
        }
        SeCorrectionListRspBO seCorrectionListRspBO = this.seCorrectionService.querySeCorrectionList(seCorrectionReqBO);
        List data1 = seCorrectionListRspBO.getData();
        List collect1 = data1.stream().map(SeCorrectionBO::getSynonymList).collect(Collectors.toList());
        List collect2 = data1.stream().map(SeCorrectionBO::getCorrectionList).collect(Collectors.toList());
        for (int i = 0; i < collect1.size(); ++i) {
            String synony = this.parse((String)collect1.get(i));
            String correction = this.parse((String)collect2.get(i));
            stringBuffer.append(synony).append(" => ").append(correction).append("\r\n");
        }
        ArrayList<ComUocFileAppBO> list = new ArrayList<ComUocFileAppBO>();
        ComUocFileAppBO comUocFileAppBO = new ComUocFileAppBO();
        comUocFileAppBO.setFileName("synonyms.txt");
        comUocFileAppBO.setFileType(".txt");
        comUocFileAppBO.setFile(stringBuffer.toString().getBytes(StandardCharsets.UTF_8));
        list.add(comUocFileAppBO);
        ComUocFileUploadAppReqBO reqBO = new ComUocFileUploadAppReqBO();
        reqBO.setFiles(list);
        return this.upload(reqBO);
    }

    @PostMapping(value={"/noauth/upload"})
    @JsonBusiResponseBody
    public ComUocFileUploadAppRspBO uploadByNoauth(MultipartFile[] files) {
        return this.upload(files);
    }

    @PostMapping(value={"/upload"})
    @JsonBusiResponseBody
    public ComUocFileUploadAppRspBO upload(MultipartFile[] files) {
        if (files == null || files.length == 0) {
            log.info("\u4e0a\u4f20\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\uff01");
            return null;
        }
        ArrayList<ComUocFileAppBO> list = new ArrayList<ComUocFileAppBO>();
        for (MultipartFile file : files) {
            InputStream inputStream = null;
            try {
                String[] videoTypeList;
                inputStream = file.getInputStream();
                String fileName = file.getOriginalFilename();
                String suffix = fileName.substring(fileName.lastIndexOf("."));
                if (StringUtils.isEmpty((String)suffix)) {
                    throw new ZTBusinessException("\u4e0d\u660e\u786e\u7684\u6587\u4ef6\u7c7b\u578b");
                }
                long size = file.getSize();
                for (String type : videoTypeList = WebRequestParameterEnum.videoFileType.getComments().split(",")) {
                    if (suffix.toUpperCase().endsWith(type)) {
                        int videoLimit = 0xA00000;
                        if (size <= (long)videoLimit) continue;
                        throw new ZTBusinessException("\u89c6\u9891\u6587\u4ef6\u8fc7\u5927");
                    }
                    int pictureLimit = 0xA00000;
                    if (size <= (long)pictureLimit) continue;
                    throw new ZTBusinessException("\u4e0a\u4f20\u6587\u4ef6\u8fc7\u5927");
                }
                byte[] bytes = new byte[inputStream.available()];
                inputStream.read(bytes);
                ComUocFileAppBO comUocFileAppBO = new ComUocFileAppBO();
                comUocFileAppBO.setFile(bytes);
                comUocFileAppBO.setFileName(fileName);
                comUocFileAppBO.setFileType(suffix);
                list.add(comUocFileAppBO);
            }
            catch (Exception e) {
                throw new ZTBusinessException(e.getMessage() == null ? "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25" : e.getMessage());
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.debug("\u6587\u4ef6\u4e0a\u4f20\u5173\u95ed\u6d41\u5931\u8d25");
                }
            }
        }
        ComUocFileUploadAppReqBO reqBO = new ComUocFileUploadAppReqBO();
        reqBO.setFiles(list);
        return this.upload(reqBO);
    }

    private ComUocFileUploadAppRspBO upload(ComUocFileUploadAppReqBO reqBO) {
        ArrayList fileList = new ArrayList();
        for (ComUocFileAppBO file : reqBO.getFiles()) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(file.getFile());
            String fileName = file.getFileName();
            String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
            String fileUrl = null;
            String innerFileUrl = null;
            if ("OSS".equals(this.fileType)) {
                innerFileUrl = this.accessUrl + path;
                fileUrl = this.ossFileUrl + path;
            } else if ("FASTDFS".equals(this.fileType)) {
                FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
                innerFileUrl = "http://" + this.fastdfsTrackerServers.substring(0, this.fastdfsTrackerServers.indexOf(":") + 1) + this.fastdfsHttpTrackerHttpPort + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
                fileUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            } else {
                throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", file.getFileName());
            map.put("url", fileUrl);
            map.put("innerUrl", innerFileUrl);
            fileList.add(map);
        }
        ComUocFileUploadAppRspBO rspBO = new ComUocFileUploadAppRspBO();
        rspBO.setFileList(fileList);
        return rspBO;
    }

    private String parse(String str) {
        str = str.replaceAll(" ", "");
        str = str.replaceAll(",", " , ");
        str = str.replaceAll("\uff0c", " , ");
        return str;
    }
}

