/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.behavior.controller;

import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.se.base.JsonBusiResponseBody;
import com.tydic.se.behavior.ability.SeCorrectionService;
import com.tydic.se.behavior.ability.SeSynonymService;
import com.tydic.se.behavior.ability.bo.ComUocFileAppBO;
import com.tydic.se.behavior.ability.bo.ComUocFileUploadAppReqBO;
import com.tydic.se.behavior.ability.bo.ComUocFileUploadAppRspBO;
import com.tydic.se.behavior.ability.bo.SeCorrectionBO;
import com.tydic.se.behavior.ability.bo.SeCorrectionListRspBO;
import com.tydic.se.behavior.ability.bo.SeCorrectionReqBO;
import com.tydic.se.behavior.ability.bo.SeSynonymBO;
import com.tydic.se.behavior.ability.bo.SeSynonymListRspBO;
import com.tydic.se.behavior.ability.bo.SeSynonymReqBO;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"synchronize"})
public class SynonymAndCorrectionSynchronizeController {
    private static final Logger log = LoggerFactory.getLogger(SynonymAndCorrectionSynchronizeController.class);
    @Autowired
    private SeSynonymService seSynonymService;
    @Autowired
    private SeCorrectionService seCorrectionService;
    @Autowired
    private FileClient fileClient;
    private static final String PATH = "search-engine";
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${oss.accessUrl}")
    private String accessUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;

    @PostMapping(value={"importUrl"})
    @JsonBusiResponseBody
    public String importFile(String accessUrl, HttpServletResponse response) {
        return this.seSynonymService.importUrl(accessUrl, response);
    }

    @PostMapping(value={"importFile"})
    @BusiResponseBody
    public String importFile(MultipartFile[] files) {
        return this.seSynonymService.importFile(files);
    }

    @PostMapping(value={"/noauth/synchro"})
    @JsonBusiResponseBody
    public ComUocFileUploadAppRspBO synchroByNoauth(@RequestBody SeSynonymReqBO seSynonymReqBO, SeCorrectionReqBO seCorrectionReqBO) {
        return this.synchro(seSynonymReqBO, seCorrectionReqBO);
    }

    @PostMapping(value={"synchro"})
    @JsonBusiResponseBody
    public ComUocFileUploadAppRspBO synchro(@RequestBody SeSynonymReqBO seSynonymReqBO, SeCorrectionReqBO seCorrectionReqBO) {
        SeSynonymListRspBO seSynonymListRspBO = this.seSynonymService.querySeSynonymList(seSynonymReqBO);
        List data = seSynonymListRspBO.getData();
        StringBuffer stringBuffer = new StringBuffer();
        List collect = data.stream().map(SeSynonymBO::getSynonymList).collect(Collectors.toList());
        for (String synony : collect) {
            synony = this.parse(synony);
            stringBuffer.append(synony).append("\r\n");
        }
        SeCorrectionListRspBO seCorrectionListRspBO = this.seCorrectionService.querySeCorrectionList(seCorrectionReqBO);
        List data1 = seCorrectionListRspBO.getData();
        List collect1 = data1.stream().map(SeCorrectionBO::getSynonymList).collect(Collectors.toList());
        List collect2 = data1.stream().map(SeCorrectionBO::getCorrectionList).collect(Collectors.toList());
        for (int i = 0; i < collect1.size(); ++i) {
            String synony = this.parse((String)collect1.get(i));
            String correction = this.parse((String)collect2.get(i));
            stringBuffer.append(synony).append(" => ").append(correction).append("\r\n");
        }
        ArrayList<ComUocFileAppBO> list = new ArrayList<ComUocFileAppBO>();
        ComUocFileAppBO comUocFileAppBO = new ComUocFileAppBO();
        comUocFileAppBO.setFileName("synonyms.txt");
        comUocFileAppBO.setFileType(".txt");
        comUocFileAppBO.setFile(stringBuffer.toString().getBytes(StandardCharsets.UTF_8));
        list.add(comUocFileAppBO);
        ComUocFileUploadAppReqBO reqBO = new ComUocFileUploadAppReqBO();
        reqBO.setFiles(list);
        return this.upload(reqBO);
    }

    private ComUocFileUploadAppRspBO upload(ComUocFileUploadAppReqBO reqBO) {
        ArrayList fileList = new ArrayList();
        for (ComUocFileAppBO file : reqBO.getFiles()) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(file.getFile());
            String fileName = file.getFileName();
            String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
            String fileUrl = null;
            String innerFileUrl = null;
            if ("OSS".equals(this.fileType)) {
                innerFileUrl = this.accessUrl + path;
                fileUrl = this.ossFileUrl + path;
            } else if ("FASTDFS".equals(this.fileType)) {
                FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
                innerFileUrl = "http://" + this.fastdfsTrackerServers.substring(0, this.fastdfsTrackerServers.indexOf(":") + 1) + this.fastdfsHttpTrackerHttpPort + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
                fileUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            } else {
                throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", file.getFileName());
            map.put("url", fileUrl);
            map.put("innerUrl", innerFileUrl);
            fileList.add(map);
        }
        ComUocFileUploadAppRspBO rspBO = new ComUocFileUploadAppRspBO();
        rspBO.setFileList(fileList);
        return rspBO;
    }

    private String parse(String str) {
        str = str.replaceAll(" ", "");
        str = str.replaceAll(",", " , ");
        str = str.replaceAll("\uff0c", " , ");
        return str;
    }
}

