/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.behavior.controller;

import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.UUID;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/pesapp/common"})
public class ComDownloadController {
    private static final Logger log = LoggerFactory.getLogger(ComDownloadController.class);

    @RequestMapping(value={"noauth/download"})
    @BusiResponseBody
    public void download(String netAddress, String filename, boolean isOnLine, HttpServletResponse response) {
        if (StringUtils.isBlank((CharSequence)netAddress)) {
            throw new ZTBusinessException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u4e0b\u8f7d\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            int len;
            URL url = new URL(netAddress);
            URLConnection conn = url.openConnection();
            InputStream inputStream = conn.getInputStream();
            response.reset();
            if (isOnLine) {
                response.setHeader("Content-Disposition", "inline; filename=" + URLEncoder.encode(filename, "UTF-8"));
            } else {
                response.setContentType("application/x-msdownload");
                if (StringUtils.isBlank((CharSequence)filename)) {
                    try {
                        filename = netAddress.substring(netAddress.lastIndexOf("/") + 1);
                    }
                    catch (Exception e) {
                        filename = UUID.randomUUID().toString().replaceAll("-", "");
                    }
                }
                response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(filename, "UTF-8"));
            }
            byte[] buffer = new byte[1024];
            ServletOutputStream outputStream = response.getOutputStream();
            while ((len = inputStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, len);
            }
            inputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ZTBusinessException("\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
    }
}

