/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.config;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.tydic.se.base.bo.SearchSortConfigCacheBO;
import com.tydic.se.base.bo.SortConfigBO;
import com.tydic.se.base.dao.SearchChannelConfigMapper;
import com.tydic.se.base.dao.SearchConfigNewDao;
import com.tydic.se.base.dao.po.SearchChannelConfigPO;
import com.tydic.se.base.dao.po.SearchConfigNew;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ObjectUtils;

@Configuration
public class SearchProcessConfig
implements CommandLineRunner,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(SearchProcessConfig.class);
    private Map<Long, Map<String, BigDecimal>> esFields = new HashMap<Long, Map<String, BigDecimal>>();
    private Map<Long, String> relevanceFieldMatching = new HashMap<Long, String>();
    private Map<Long, String> relevanceChineseFieldMatching = new HashMap<Long, String>();
    private Map<Long, List<Double>> smoothingParameters = new HashMap<Long, List<Double>>();
    @Autowired
    private SearchConfigNewDao searchConfigNewDao;
    @Autowired
    private SearchChannelConfigMapper searchChannelConfigMapper;
    @Value(value="${spring.datasource.url}")
    private String mainDbUrl;
    @Value(value="${config.specified.port:192.168.10.38:3306}")
    private String portUrl;
    @Value(value="${spring.datasource.driver-class-name}")
    private String driverName;
    private Map<Long, ReCallConfig> reCall = new HashMap<Long, ReCallConfig>();
    private Map<Long, SortConfig> sort = new HashMap<Long, SortConfig>();
    private Map<Long, ManageConfig> manage = new HashMap<Long, ManageConfig>();
    private Map<Long, VectorConfig> vector = new HashMap<Long, VectorConfig>();
    private Map<Long, ElseConfig> elseConfig = new HashMap<Long, ElseConfig>();

    public void run(String ... args) throws Exception {
        try {
            SearchChannelConfigPO searchChannelConfigPO = new SearchChannelConfigPO();
            List searchChannelConfigPOS = this.searchChannelConfigMapper.selectByCondition(searchChannelConfigPO);
            if (!searchChannelConfigPOS.isEmpty()) {
                searchChannelConfigPOS.forEach(configPO -> {
                    Long seChannelType = configPO.getId();
                    ArrayList<Double> params = new ArrayList<Double>();
                    for (int i = 10; i >= 3; --i) {
                        params.add(Math.log(i));
                    }
                    this.smoothingParameters.put(seChannelType, params);
                });
            }
            log.info("\u5e73\u6ed1\u6743\u91cd\u521d\u59cb\u5316\u5b8c\u6210\uff01 list:{}", this.smoothingParameters);
        }
        catch (Exception e) {
            throw new Exception("\u6570\u636e\u521d\u59cb\u5316\u5931\u8d25\uff01", e);
        }
    }

    public void refreshConfig(List<SortConfigBO> configs) {
        List searchSortConfigCacheBOList = this.searchConfigNewDao.queryAllChannelCacheInfo();
        Map<Long, Map<String, SearchSortConfigCacheBO>> channelConfigMap = searchSortConfigCacheBOList.stream().collect(Collectors.groupingBy(SearchSortConfigCacheBO::getSeChannelType, Collectors.toMap(SearchSortConfigCacheBO::getConfName, config -> config)));
        String dbHostPort = null;
        dbHostPort = this.driverName.contains("dm") ? this.mainDbUrl.replace("jdbc:dm://", "").split("/")[0].split("\\?")[0] : this.mainDbUrl.replace("jdbc:mysql://", "").split("/")[0].split("\\?")[0];
        for (Map.Entry<Long, Map<String, SearchSortConfigCacheBO>> channelEntry : channelConfigMap.entrySet()) {
            Long seChannelType = channelEntry.getKey();
            Map<String, SearchSortConfigCacheBO> configMap = channelEntry.getValue();
            ReCallConfig reCallConfig = new ReCallConfig();
            this.changeConfig(reCallConfig, configMap);
            this.reCall.put(seChannelType, reCallConfig);
            SortConfig sortConfig = new SortConfig();
            this.changeConfig(sortConfig, configMap);
            this.sort.put(seChannelType, sortConfig);
            ManageConfig manageConfig = new ManageConfig();
            this.changeConfig(manageConfig, configMap);
            this.manage.put(seChannelType, manageConfig);
            VectorConfig vectorConfig = new VectorConfig();
            this.changeConfig(vectorConfig, configMap);
            this.vector.put(seChannelType, vectorConfig);
            ElseConfig elseConfig = new ElseConfig();
            this.changeConfig(elseConfig, configMap);
            this.elseConfig.put(seChannelType, elseConfig);
            log.info("\u9891\u9053\u7c7b\u578b {} \u7684\u914d\u7f6e\u521d\u59cb\u5316\u5b8c\u6210", (Object)seChannelType);
        }
    }

    private void changeConfig(Object config, Map<String, SearchSortConfigCacheBO> searchSortConfigCacheBoMap) {
        Field[] fields;
        for (Field field : fields = config.getClass().getDeclaredFields()) {
            try {
                field.setAccessible(true);
                SearchSortConfigCacheBO configBo = searchSortConfigCacheBoMap.get(field.getName());
                if (!ObjectUtils.isEmpty((Object)configBo)) {
                    String value = configBo.getIsComplex() != null && configBo.getIsComplex() != 0 ? JSONObject.toJSONString((Object)configBo) : configBo.getConfValue();
                    field.set(config, value);
                    log.error("{}\u914d\u7f6e\u66f4\u65b0:{}={}", new Object[]{this.getClass().getSimpleName(), field.getName(), value});
                    continue;
                }
                log.error("{}\u914d\u7f6e\u83b7\u53d6\u5f02\u5e38\uff01\u5df2\u5c1d\u8bd5\u521d\u59cb\u5316", (Object)field.getName());
            }
            catch (IllegalAccessException e) {
                log.error("{}\u914d\u7f6e\u521d\u59cb\u5316\u5f02\u5e38:{},{}", new Object[]{this.getClass().getSimpleName(), field.getName(), e.getMessage()});
            }
        }
    }

    private void createConfNameSql() {
        List searchConfigNews = this.searchConfigNewDao.queryAllConfig();
        try {
            String jsonPath = "service-boot/src/main/resources/basic/config-field-sql.json";
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            HashMap<Integer, Object> idToConfigMap = new HashMap<Integer, Object>();
            HashMap<Integer, String> idToSqlMap = new HashMap<Integer, String>();
            for (Object config : searchConfigNews) {
                idToConfigMap.put(config.getId(), config);
                String sql = this.driverName.contains("dm") ? String.format("INSERT INTO STAND_SE_CONFIG_NEW (ID, P_ID, CONF_NAME, CONF_VALUE, CONF_TITLE, CONF_REMARK, S_TYPE, VALUE_TYPE, IS_LEAF, IS_OPEN, IS_COMPLEX, CONF_SORT, CREATE_TIME, UPDATE_TIME) VALUES (%d, %s, %s, %s, %s, %s, %d, %s, %d, %s, %d, %d, %s, %s)", config.getId(), config.getPId() == null ? "NULL" : config.getPId(), config.getConfName() == null ? "NULL" : "'" + config.getConfName().replace("'", "''") + "'", config.getConfValue() == null ? "NULL" : "'" + config.getConfValue().replace("'", "''") + "'", config.getConfTitle() == null ? "NULL" : "'" + config.getConfTitle().replace("'", "''") + "'", config.getConfRemark() == null ? "NULL" : "'" + config.getConfRemark().replace("'", "''") + "'", config.getSType(), config.getValueType() == null ? "NULL" : "'" + config.getValueType() + "'", config.getIsLeaf(), config.getIsOpen() == null ? "NULL" : config.getIsOpen(), config.getIsComplex(), config.getConfSort(), config.getCreateTime() == null ? "NULL" : "TO_TIMESTAMP('" + dateFormat.format(config.getCreateTime()) + "', 'YYYY-MM-DD HH24:MI:SS')", config.getUpdateTime() == null ? "NULL" : "TO_TIMESTAMP('" + dateFormat.format(config.getUpdateTime()) + "', 'YYYY-MM-DD HH24:MI:SS')") : String.format("INSERT INTO stand_se_config_new (id, p_id, conf_name, conf_value, conf_title, conf_remark, s_type, value_type, is_leaf, is_open, is_complex, conf_sort, create_time, update_time) VALUES (%d, %s, %s, %s, %s, %s, %d, %s, %d, %s, %d, %d, %s, %s);", config.getId(), config.getPId() == null ? "null" : config.getPId(), config.getConfName() == null ? "null" : "'" + config.getConfName().replace("'", "''") + "'", config.getConfValue() == null ? "null" : "'" + config.getConfValue().replace("'", "''") + "'", config.getConfTitle() == null ? "null" : "'" + config.getConfTitle().replace("'", "''") + "'", config.getConfRemark() == null ? "null" : "'" + config.getConfRemark().replace("'", "''") + "'", config.getSType(), config.getValueType() == null ? "null" : "'" + config.getValueType() + "'", config.getIsLeaf(), config.getIsOpen() == null ? "null" : config.getIsOpen(), config.getIsComplex(), config.getConfSort(), config.getCreateTime() == null ? "null" : "'" + dateFormat.format(config.getCreateTime()) + "'", config.getUpdateTime() == null ? "null" : "'" + dateFormat.format(config.getUpdateTime()) + "'");
                idToSqlMap.put(config.getId(), sql);
            }
            LinkedHashMap jsonMap = new LinkedHashMap();
            for (SearchConfigNew config : searchConfigNews) {
                SearchConfigNew parent;
                String confName = config.getConfName();
                if (confName == null || confName.isEmpty()) continue;
                ArrayList sqlChain = new ArrayList();
                Integer currentParentId = config.getPId();
                while (currentParentId != null && (parent = (SearchConfigNew)idToConfigMap.get(currentParentId)) != null) {
                    sqlChain.add(0, idToSqlMap.get(parent.getId()));
                    if (parent.getConfSort() == 1 && parent.getPId() != null) {
                        currentParentId = parent.getPId();
                        continue;
                    }
                    currentParentId = null;
                }
                sqlChain.add(idToSqlMap.get(config.getId()));
                jsonMap.put(confName, sqlChain);
            }
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(SerializationFeature.INDENT_OUTPUT);
            String jsonContent = mapper.writeValueAsString(jsonMap);
            Files.write(Paths.get(jsonPath, new String[0]), jsonContent.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            log.info("\u5df2\u751f\u6210\u914d\u7f6e\u6587\u4ef6: {}", (Object)jsonPath);
        }
        catch (IOException e) {
            log.error("\u751f\u6210\u914d\u7f6e\u6587\u4ef6\u5931\u8d25: {}", (Object)e.getMessage());
        }
    }

    public Map<Long, Map<String, BigDecimal>> getEsFields() {
        return this.esFields;
    }

    public Map<Long, String> getRelevanceFieldMatching() {
        return this.relevanceFieldMatching;
    }

    public Map<Long, String> getRelevanceChineseFieldMatching() {
        return this.relevanceChineseFieldMatching;
    }

    public Map<Long, List<Double>> getSmoothingParameters() {
        return this.smoothingParameters;
    }

    public SearchConfigNewDao getSearchConfigNewDao() {
        return this.searchConfigNewDao;
    }

    public SearchChannelConfigMapper getSearchChannelConfigMapper() {
        return this.searchChannelConfigMapper;
    }

    public String getMainDbUrl() {
        return this.mainDbUrl;
    }

    public String getPortUrl() {
        return this.portUrl;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public Map<Long, ReCallConfig> getReCall() {
        return this.reCall;
    }

    public Map<Long, SortConfig> getSort() {
        return this.sort;
    }

    public Map<Long, ManageConfig> getManage() {
        return this.manage;
    }

    public Map<Long, VectorConfig> getVector() {
        return this.vector;
    }

    public Map<Long, ElseConfig> getElseConfig() {
        return this.elseConfig;
    }

    public void setEsFields(Map<Long, Map<String, BigDecimal>> esFields) {
        this.esFields = esFields;
    }

    public void setRelevanceFieldMatching(Map<Long, String> relevanceFieldMatching) {
        this.relevanceFieldMatching = relevanceFieldMatching;
    }

    public void setRelevanceChineseFieldMatching(Map<Long, String> relevanceChineseFieldMatching) {
        this.relevanceChineseFieldMatching = relevanceChineseFieldMatching;
    }

    public void setSmoothingParameters(Map<Long, List<Double>> smoothingParameters) {
        this.smoothingParameters = smoothingParameters;
    }

    public void setSearchConfigNewDao(SearchConfigNewDao searchConfigNewDao) {
        this.searchConfigNewDao = searchConfigNewDao;
    }

    public void setSearchChannelConfigMapper(SearchChannelConfigMapper searchChannelConfigMapper) {
        this.searchChannelConfigMapper = searchChannelConfigMapper;
    }

    public void setMainDbUrl(String mainDbUrl) {
        this.mainDbUrl = mainDbUrl;
    }

    public void setPortUrl(String portUrl) {
        this.portUrl = portUrl;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public void setReCall(Map<Long, ReCallConfig> reCall) {
        this.reCall = reCall;
    }

    public void setSort(Map<Long, SortConfig> sort) {
        this.sort = sort;
    }

    public void setManage(Map<Long, ManageConfig> manage) {
        this.manage = manage;
    }

    public void setVector(Map<Long, VectorConfig> vector) {
        this.vector = vector;
    }

    public void setElseConfig(Map<Long, ElseConfig> elseConfig) {
        this.elseConfig = elseConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchProcessConfig)) {
            return false;
        }
        SearchProcessConfig other = (SearchProcessConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<Long, Map<String, BigDecimal>> this$esFields = this.getEsFields();
        Map<Long, Map<String, BigDecimal>> other$esFields = other.getEsFields();
        if (this$esFields == null ? other$esFields != null : !((Object)this$esFields).equals(other$esFields)) {
            return false;
        }
        Map<Long, String> this$relevanceFieldMatching = this.getRelevanceFieldMatching();
        Map<Long, String> other$relevanceFieldMatching = other.getRelevanceFieldMatching();
        if (this$relevanceFieldMatching == null ? other$relevanceFieldMatching != null : !((Object)this$relevanceFieldMatching).equals(other$relevanceFieldMatching)) {
            return false;
        }
        Map<Long, String> this$relevanceChineseFieldMatching = this.getRelevanceChineseFieldMatching();
        Map<Long, String> other$relevanceChineseFieldMatching = other.getRelevanceChineseFieldMatching();
        if (this$relevanceChineseFieldMatching == null ? other$relevanceChineseFieldMatching != null : !((Object)this$relevanceChineseFieldMatching).equals(other$relevanceChineseFieldMatching)) {
            return false;
        }
        Map<Long, List<Double>> this$smoothingParameters = this.getSmoothingParameters();
        Map<Long, List<Double>> other$smoothingParameters = other.getSmoothingParameters();
        if (this$smoothingParameters == null ? other$smoothingParameters != null : !((Object)this$smoothingParameters).equals(other$smoothingParameters)) {
            return false;
        }
        SearchConfigNewDao this$searchConfigNewDao = this.getSearchConfigNewDao();
        SearchConfigNewDao other$searchConfigNewDao = other.getSearchConfigNewDao();
        if (this$searchConfigNewDao == null ? other$searchConfigNewDao != null : !this$searchConfigNewDao.equals(other$searchConfigNewDao)) {
            return false;
        }
        SearchChannelConfigMapper this$searchChannelConfigMapper = this.getSearchChannelConfigMapper();
        SearchChannelConfigMapper other$searchChannelConfigMapper = other.getSearchChannelConfigMapper();
        if (this$searchChannelConfigMapper == null ? other$searchChannelConfigMapper != null : !this$searchChannelConfigMapper.equals(other$searchChannelConfigMapper)) {
            return false;
        }
        String this$mainDbUrl = this.getMainDbUrl();
        String other$mainDbUrl = other.getMainDbUrl();
        if (this$mainDbUrl == null ? other$mainDbUrl != null : !this$mainDbUrl.equals(other$mainDbUrl)) {
            return false;
        }
        String this$portUrl = this.getPortUrl();
        String other$portUrl = other.getPortUrl();
        if (this$portUrl == null ? other$portUrl != null : !this$portUrl.equals(other$portUrl)) {
            return false;
        }
        String this$driverName = this.getDriverName();
        String other$driverName = other.getDriverName();
        if (this$driverName == null ? other$driverName != null : !this$driverName.equals(other$driverName)) {
            return false;
        }
        Map<Long, ReCallConfig> this$reCall = this.getReCall();
        Map<Long, ReCallConfig> other$reCall = other.getReCall();
        if (this$reCall == null ? other$reCall != null : !((Object)this$reCall).equals(other$reCall)) {
            return false;
        }
        Map<Long, SortConfig> this$sort = this.getSort();
        Map<Long, SortConfig> other$sort = other.getSort();
        if (this$sort == null ? other$sort != null : !((Object)this$sort).equals(other$sort)) {
            return false;
        }
        Map<Long, ManageConfig> this$manage = this.getManage();
        Map<Long, ManageConfig> other$manage = other.getManage();
        if (this$manage == null ? other$manage != null : !((Object)this$manage).equals(other$manage)) {
            return false;
        }
        Map<Long, VectorConfig> this$vector = this.getVector();
        Map<Long, VectorConfig> other$vector = other.getVector();
        if (this$vector == null ? other$vector != null : !((Object)this$vector).equals(other$vector)) {
            return false;
        }
        Map<Long, ElseConfig> this$elseConfig = this.getElseConfig();
        Map<Long, ElseConfig> other$elseConfig = other.getElseConfig();
        return !(this$elseConfig == null ? other$elseConfig != null : !((Object)this$elseConfig).equals(other$elseConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SearchProcessConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<Long, Map<String, BigDecimal>> $esFields = this.getEsFields();
        result = result * 59 + ($esFields == null ? 43 : ((Object)$esFields).hashCode());
        Map<Long, String> $relevanceFieldMatching = this.getRelevanceFieldMatching();
        result = result * 59 + ($relevanceFieldMatching == null ? 43 : ((Object)$relevanceFieldMatching).hashCode());
        Map<Long, String> $relevanceChineseFieldMatching = this.getRelevanceChineseFieldMatching();
        result = result * 59 + ($relevanceChineseFieldMatching == null ? 43 : ((Object)$relevanceChineseFieldMatching).hashCode());
        Map<Long, List<Double>> $smoothingParameters = this.getSmoothingParameters();
        result = result * 59 + ($smoothingParameters == null ? 43 : ((Object)$smoothingParameters).hashCode());
        SearchConfigNewDao $searchConfigNewDao = this.getSearchConfigNewDao();
        result = result * 59 + ($searchConfigNewDao == null ? 43 : $searchConfigNewDao.hashCode());
        SearchChannelConfigMapper $searchChannelConfigMapper = this.getSearchChannelConfigMapper();
        result = result * 59 + ($searchChannelConfigMapper == null ? 43 : $searchChannelConfigMapper.hashCode());
        String $mainDbUrl = this.getMainDbUrl();
        result = result * 59 + ($mainDbUrl == null ? 43 : $mainDbUrl.hashCode());
        String $portUrl = this.getPortUrl();
        result = result * 59 + ($portUrl == null ? 43 : $portUrl.hashCode());
        String $driverName = this.getDriverName();
        result = result * 59 + ($driverName == null ? 43 : $driverName.hashCode());
        Map<Long, ReCallConfig> $reCall = this.getReCall();
        result = result * 59 + ($reCall == null ? 43 : ((Object)$reCall).hashCode());
        Map<Long, SortConfig> $sort = this.getSort();
        result = result * 59 + ($sort == null ? 43 : ((Object)$sort).hashCode());
        Map<Long, ManageConfig> $manage = this.getManage();
        result = result * 59 + ($manage == null ? 43 : ((Object)$manage).hashCode());
        Map<Long, VectorConfig> $vector = this.getVector();
        result = result * 59 + ($vector == null ? 43 : ((Object)$vector).hashCode());
        Map<Long, ElseConfig> $elseConfig = this.getElseConfig();
        result = result * 59 + ($elseConfig == null ? 43 : ((Object)$elseConfig).hashCode());
        return result;
    }

    public String toString() {
        return "SearchProcessConfig(esFields=" + this.getEsFields() + ", relevanceFieldMatching=" + this.getRelevanceFieldMatching() + ", relevanceChineseFieldMatching=" + this.getRelevanceChineseFieldMatching() + ", smoothingParameters=" + this.getSmoothingParameters() + ", searchConfigNewDao=" + this.getSearchConfigNewDao() + ", searchChannelConfigMapper=" + this.getSearchChannelConfigMapper() + ", mainDbUrl=" + this.getMainDbUrl() + ", portUrl=" + this.getPortUrl() + ", driverName=" + this.getDriverName() + ", reCall=" + this.getReCall() + ", sort=" + this.getSort() + ", manage=" + this.getManage() + ", vector=" + this.getVector() + ", elseConfig=" + this.getElseConfig() + ")";
    }

    public static class ElseConfig {
        public String soleNumber;
        public String collectionNumber;
        public String pageViews;
        public String onShelveTime;
        public String shelfFirst;
        public String selfSupportFirst;
        public String searchAccurateSortSize;
        public String searchAccurateSortMaxDifScore;

        public String getSoleNumber() {
            return this.soleNumber;
        }

        public String getCollectionNumber() {
            return this.collectionNumber;
        }

        public String getPageViews() {
            return this.pageViews;
        }

        public String getOnShelveTime() {
            return this.onShelveTime;
        }

        public String getShelfFirst() {
            return this.shelfFirst;
        }

        public String getSelfSupportFirst() {
            return this.selfSupportFirst;
        }

        public String getSearchAccurateSortSize() {
            return this.searchAccurateSortSize;
        }

        public String getSearchAccurateSortMaxDifScore() {
            return this.searchAccurateSortMaxDifScore;
        }

        public void setSoleNumber(String soleNumber) {
            this.soleNumber = soleNumber;
        }

        public void setCollectionNumber(String collectionNumber) {
            this.collectionNumber = collectionNumber;
        }

        public void setPageViews(String pageViews) {
            this.pageViews = pageViews;
        }

        public void setOnShelveTime(String onShelveTime) {
            this.onShelveTime = onShelveTime;
        }

        public void setShelfFirst(String shelfFirst) {
            this.shelfFirst = shelfFirst;
        }

        public void setSelfSupportFirst(String selfSupportFirst) {
            this.selfSupportFirst = selfSupportFirst;
        }

        public void setSearchAccurateSortSize(String searchAccurateSortSize) {
            this.searchAccurateSortSize = searchAccurateSortSize;
        }

        public void setSearchAccurateSortMaxDifScore(String searchAccurateSortMaxDifScore) {
            this.searchAccurateSortMaxDifScore = searchAccurateSortMaxDifScore;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ElseConfig)) {
                return false;
            }
            ElseConfig other = (ElseConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$soleNumber = this.getSoleNumber();
            String other$soleNumber = other.getSoleNumber();
            if (this$soleNumber == null ? other$soleNumber != null : !this$soleNumber.equals(other$soleNumber)) {
                return false;
            }
            String this$collectionNumber = this.getCollectionNumber();
            String other$collectionNumber = other.getCollectionNumber();
            if (this$collectionNumber == null ? other$collectionNumber != null : !this$collectionNumber.equals(other$collectionNumber)) {
                return false;
            }
            String this$pageViews = this.getPageViews();
            String other$pageViews = other.getPageViews();
            if (this$pageViews == null ? other$pageViews != null : !this$pageViews.equals(other$pageViews)) {
                return false;
            }
            String this$onShelveTime = this.getOnShelveTime();
            String other$onShelveTime = other.getOnShelveTime();
            if (this$onShelveTime == null ? other$onShelveTime != null : !this$onShelveTime.equals(other$onShelveTime)) {
                return false;
            }
            String this$shelfFirst = this.getShelfFirst();
            String other$shelfFirst = other.getShelfFirst();
            if (this$shelfFirst == null ? other$shelfFirst != null : !this$shelfFirst.equals(other$shelfFirst)) {
                return false;
            }
            String this$selfSupportFirst = this.getSelfSupportFirst();
            String other$selfSupportFirst = other.getSelfSupportFirst();
            if (this$selfSupportFirst == null ? other$selfSupportFirst != null : !this$selfSupportFirst.equals(other$selfSupportFirst)) {
                return false;
            }
            String this$searchAccurateSortSize = this.getSearchAccurateSortSize();
            String other$searchAccurateSortSize = other.getSearchAccurateSortSize();
            if (this$searchAccurateSortSize == null ? other$searchAccurateSortSize != null : !this$searchAccurateSortSize.equals(other$searchAccurateSortSize)) {
                return false;
            }
            String this$searchAccurateSortMaxDifScore = this.getSearchAccurateSortMaxDifScore();
            String other$searchAccurateSortMaxDifScore = other.getSearchAccurateSortMaxDifScore();
            return !(this$searchAccurateSortMaxDifScore == null ? other$searchAccurateSortMaxDifScore != null : !this$searchAccurateSortMaxDifScore.equals(other$searchAccurateSortMaxDifScore));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ElseConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $soleNumber = this.getSoleNumber();
            result = result * 59 + ($soleNumber == null ? 43 : $soleNumber.hashCode());
            String $collectionNumber = this.getCollectionNumber();
            result = result * 59 + ($collectionNumber == null ? 43 : $collectionNumber.hashCode());
            String $pageViews = this.getPageViews();
            result = result * 59 + ($pageViews == null ? 43 : $pageViews.hashCode());
            String $onShelveTime = this.getOnShelveTime();
            result = result * 59 + ($onShelveTime == null ? 43 : $onShelveTime.hashCode());
            String $shelfFirst = this.getShelfFirst();
            result = result * 59 + ($shelfFirst == null ? 43 : $shelfFirst.hashCode());
            String $selfSupportFirst = this.getSelfSupportFirst();
            result = result * 59 + ($selfSupportFirst == null ? 43 : $selfSupportFirst.hashCode());
            String $searchAccurateSortSize = this.getSearchAccurateSortSize();
            result = result * 59 + ($searchAccurateSortSize == null ? 43 : $searchAccurateSortSize.hashCode());
            String $searchAccurateSortMaxDifScore = this.getSearchAccurateSortMaxDifScore();
            result = result * 59 + ($searchAccurateSortMaxDifScore == null ? 43 : $searchAccurateSortMaxDifScore.hashCode());
            return result;
        }

        public String toString() {
            return "SearchProcessConfig.ElseConfig(soleNumber=" + this.getSoleNumber() + ", collectionNumber=" + this.getCollectionNumber() + ", pageViews=" + this.getPageViews() + ", onShelveTime=" + this.getOnShelveTime() + ", shelfFirst=" + this.getShelfFirst() + ", selfSupportFirst=" + this.getSelfSupportFirst() + ", searchAccurateSortSize=" + this.getSearchAccurateSortSize() + ", searchAccurateSortMaxDifScore=" + this.getSearchAccurateSortMaxDifScore() + ")";
        }
    }

    public static class VectorConfig {
        public String searchUseVector;
        public String searchVectorUrl;
        public String searchUseRaner;
        public String searchVendorMinCcore;
        public String searchRanerUrl;
        public String elasticsearchAnalyzer;
        public String esAnalyzer;
        public String cacheEsEeRanerTime;
        public String thirdPartyApiTimeout;
        public String elasticsearchPreference;
        public String elasticsearchVectorField;
        public String searchMaxAnalyerOpen;

        public String getSearchUseVector() {
            return this.searchUseVector;
        }

        public String getSearchVectorUrl() {
            return this.searchVectorUrl;
        }

        public String getSearchUseRaner() {
            return this.searchUseRaner;
        }

        public String getSearchVendorMinCcore() {
            return this.searchVendorMinCcore;
        }

        public String getSearchRanerUrl() {
            return this.searchRanerUrl;
        }

        public String getElasticsearchAnalyzer() {
            return this.elasticsearchAnalyzer;
        }

        public String getEsAnalyzer() {
            return this.esAnalyzer;
        }

        public String getCacheEsEeRanerTime() {
            return this.cacheEsEeRanerTime;
        }

        public String getThirdPartyApiTimeout() {
            return this.thirdPartyApiTimeout;
        }

        public String getElasticsearchPreference() {
            return this.elasticsearchPreference;
        }

        public String getElasticsearchVectorField() {
            return this.elasticsearchVectorField;
        }

        public String getSearchMaxAnalyerOpen() {
            return this.searchMaxAnalyerOpen;
        }

        public void setSearchUseVector(String searchUseVector) {
            this.searchUseVector = searchUseVector;
        }

        public void setSearchVectorUrl(String searchVectorUrl) {
            this.searchVectorUrl = searchVectorUrl;
        }

        public void setSearchUseRaner(String searchUseRaner) {
            this.searchUseRaner = searchUseRaner;
        }

        public void setSearchVendorMinCcore(String searchVendorMinCcore) {
            this.searchVendorMinCcore = searchVendorMinCcore;
        }

        public void setSearchRanerUrl(String searchRanerUrl) {
            this.searchRanerUrl = searchRanerUrl;
        }

        public void setElasticsearchAnalyzer(String elasticsearchAnalyzer) {
            this.elasticsearchAnalyzer = elasticsearchAnalyzer;
        }

        public void setEsAnalyzer(String esAnalyzer) {
            this.esAnalyzer = esAnalyzer;
        }

        public void setCacheEsEeRanerTime(String cacheEsEeRanerTime) {
            this.cacheEsEeRanerTime = cacheEsEeRanerTime;
        }

        public void setThirdPartyApiTimeout(String thirdPartyApiTimeout) {
            this.thirdPartyApiTimeout = thirdPartyApiTimeout;
        }

        public void setElasticsearchPreference(String elasticsearchPreference) {
            this.elasticsearchPreference = elasticsearchPreference;
        }

        public void setElasticsearchVectorField(String elasticsearchVectorField) {
            this.elasticsearchVectorField = elasticsearchVectorField;
        }

        public void setSearchMaxAnalyerOpen(String searchMaxAnalyerOpen) {
            this.searchMaxAnalyerOpen = searchMaxAnalyerOpen;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VectorConfig)) {
                return false;
            }
            VectorConfig other = (VectorConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$searchUseVector = this.getSearchUseVector();
            String other$searchUseVector = other.getSearchUseVector();
            if (this$searchUseVector == null ? other$searchUseVector != null : !this$searchUseVector.equals(other$searchUseVector)) {
                return false;
            }
            String this$searchVectorUrl = this.getSearchVectorUrl();
            String other$searchVectorUrl = other.getSearchVectorUrl();
            if (this$searchVectorUrl == null ? other$searchVectorUrl != null : !this$searchVectorUrl.equals(other$searchVectorUrl)) {
                return false;
            }
            String this$searchUseRaner = this.getSearchUseRaner();
            String other$searchUseRaner = other.getSearchUseRaner();
            if (this$searchUseRaner == null ? other$searchUseRaner != null : !this$searchUseRaner.equals(other$searchUseRaner)) {
                return false;
            }
            String this$searchVendorMinCcore = this.getSearchVendorMinCcore();
            String other$searchVendorMinCcore = other.getSearchVendorMinCcore();
            if (this$searchVendorMinCcore == null ? other$searchVendorMinCcore != null : !this$searchVendorMinCcore.equals(other$searchVendorMinCcore)) {
                return false;
            }
            String this$searchRanerUrl = this.getSearchRanerUrl();
            String other$searchRanerUrl = other.getSearchRanerUrl();
            if (this$searchRanerUrl == null ? other$searchRanerUrl != null : !this$searchRanerUrl.equals(other$searchRanerUrl)) {
                return false;
            }
            String this$elasticsearchAnalyzer = this.getElasticsearchAnalyzer();
            String other$elasticsearchAnalyzer = other.getElasticsearchAnalyzer();
            if (this$elasticsearchAnalyzer == null ? other$elasticsearchAnalyzer != null : !this$elasticsearchAnalyzer.equals(other$elasticsearchAnalyzer)) {
                return false;
            }
            String this$esAnalyzer = this.getEsAnalyzer();
            String other$esAnalyzer = other.getEsAnalyzer();
            if (this$esAnalyzer == null ? other$esAnalyzer != null : !this$esAnalyzer.equals(other$esAnalyzer)) {
                return false;
            }
            String this$cacheEsEeRanerTime = this.getCacheEsEeRanerTime();
            String other$cacheEsEeRanerTime = other.getCacheEsEeRanerTime();
            if (this$cacheEsEeRanerTime == null ? other$cacheEsEeRanerTime != null : !this$cacheEsEeRanerTime.equals(other$cacheEsEeRanerTime)) {
                return false;
            }
            String this$thirdPartyApiTimeout = this.getThirdPartyApiTimeout();
            String other$thirdPartyApiTimeout = other.getThirdPartyApiTimeout();
            if (this$thirdPartyApiTimeout == null ? other$thirdPartyApiTimeout != null : !this$thirdPartyApiTimeout.equals(other$thirdPartyApiTimeout)) {
                return false;
            }
            String this$elasticsearchPreference = this.getElasticsearchPreference();
            String other$elasticsearchPreference = other.getElasticsearchPreference();
            if (this$elasticsearchPreference == null ? other$elasticsearchPreference != null : !this$elasticsearchPreference.equals(other$elasticsearchPreference)) {
                return false;
            }
            String this$elasticsearchVectorField = this.getElasticsearchVectorField();
            String other$elasticsearchVectorField = other.getElasticsearchVectorField();
            if (this$elasticsearchVectorField == null ? other$elasticsearchVectorField != null : !this$elasticsearchVectorField.equals(other$elasticsearchVectorField)) {
                return false;
            }
            String this$searchMaxAnalyerOpen = this.getSearchMaxAnalyerOpen();
            String other$searchMaxAnalyerOpen = other.getSearchMaxAnalyerOpen();
            return !(this$searchMaxAnalyerOpen == null ? other$searchMaxAnalyerOpen != null : !this$searchMaxAnalyerOpen.equals(other$searchMaxAnalyerOpen));
        }

        protected boolean canEqual(Object other) {
            return other instanceof VectorConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $searchUseVector = this.getSearchUseVector();
            result = result * 59 + ($searchUseVector == null ? 43 : $searchUseVector.hashCode());
            String $searchVectorUrl = this.getSearchVectorUrl();
            result = result * 59 + ($searchVectorUrl == null ? 43 : $searchVectorUrl.hashCode());
            String $searchUseRaner = this.getSearchUseRaner();
            result = result * 59 + ($searchUseRaner == null ? 43 : $searchUseRaner.hashCode());
            String $searchVendorMinCcore = this.getSearchVendorMinCcore();
            result = result * 59 + ($searchVendorMinCcore == null ? 43 : $searchVendorMinCcore.hashCode());
            String $searchRanerUrl = this.getSearchRanerUrl();
            result = result * 59 + ($searchRanerUrl == null ? 43 : $searchRanerUrl.hashCode());
            String $elasticsearchAnalyzer = this.getElasticsearchAnalyzer();
            result = result * 59 + ($elasticsearchAnalyzer == null ? 43 : $elasticsearchAnalyzer.hashCode());
            String $esAnalyzer = this.getEsAnalyzer();
            result = result * 59 + ($esAnalyzer == null ? 43 : $esAnalyzer.hashCode());
            String $cacheEsEeRanerTime = this.getCacheEsEeRanerTime();
            result = result * 59 + ($cacheEsEeRanerTime == null ? 43 : $cacheEsEeRanerTime.hashCode());
            String $thirdPartyApiTimeout = this.getThirdPartyApiTimeout();
            result = result * 59 + ($thirdPartyApiTimeout == null ? 43 : $thirdPartyApiTimeout.hashCode());
            String $elasticsearchPreference = this.getElasticsearchPreference();
            result = result * 59 + ($elasticsearchPreference == null ? 43 : $elasticsearchPreference.hashCode());
            String $elasticsearchVectorField = this.getElasticsearchVectorField();
            result = result * 59 + ($elasticsearchVectorField == null ? 43 : $elasticsearchVectorField.hashCode());
            String $searchMaxAnalyerOpen = this.getSearchMaxAnalyerOpen();
            result = result * 59 + ($searchMaxAnalyerOpen == null ? 43 : $searchMaxAnalyerOpen.hashCode());
            return result;
        }

        public String toString() {
            return "SearchProcessConfig.VectorConfig(searchUseVector=" + this.getSearchUseVector() + ", searchVectorUrl=" + this.getSearchVectorUrl() + ", searchUseRaner=" + this.getSearchUseRaner() + ", searchVendorMinCcore=" + this.getSearchVendorMinCcore() + ", searchRanerUrl=" + this.getSearchRanerUrl() + ", elasticsearchAnalyzer=" + this.getElasticsearchAnalyzer() + ", esAnalyzer=" + this.getEsAnalyzer() + ", cacheEsEeRanerTime=" + this.getCacheEsEeRanerTime() + ", thirdPartyApiTimeout=" + this.getThirdPartyApiTimeout() + ", elasticsearchPreference=" + this.getElasticsearchPreference() + ", elasticsearchVectorField=" + this.getElasticsearchVectorField() + ", searchMaxAnalyerOpen=" + this.getSearchMaxAnalyerOpen() + ")";
        }
    }

    public static class ManageConfig {
        public String searchOpenPrintCommodityName;
        public String logLifeMonth;

        public String getSearchOpenPrintCommodityName() {
            return this.searchOpenPrintCommodityName;
        }

        public String getLogLifeMonth() {
            return this.logLifeMonth;
        }

        public void setSearchOpenPrintCommodityName(String searchOpenPrintCommodityName) {
            this.searchOpenPrintCommodityName = searchOpenPrintCommodityName;
        }

        public void setLogLifeMonth(String logLifeMonth) {
            this.logLifeMonth = logLifeMonth;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ManageConfig)) {
                return false;
            }
            ManageConfig other = (ManageConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$searchOpenPrintCommodityName = this.getSearchOpenPrintCommodityName();
            String other$searchOpenPrintCommodityName = other.getSearchOpenPrintCommodityName();
            if (this$searchOpenPrintCommodityName == null ? other$searchOpenPrintCommodityName != null : !this$searchOpenPrintCommodityName.equals(other$searchOpenPrintCommodityName)) {
                return false;
            }
            String this$logLifeMonth = this.getLogLifeMonth();
            String other$logLifeMonth = other.getLogLifeMonth();
            return !(this$logLifeMonth == null ? other$logLifeMonth != null : !this$logLifeMonth.equals(other$logLifeMonth));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ManageConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $searchOpenPrintCommodityName = this.getSearchOpenPrintCommodityName();
            result = result * 59 + ($searchOpenPrintCommodityName == null ? 43 : $searchOpenPrintCommodityName.hashCode());
            String $logLifeMonth = this.getLogLifeMonth();
            result = result * 59 + ($logLifeMonth == null ? 43 : $logLifeMonth.hashCode());
            return result;
        }

        public String toString() {
            return "SearchProcessConfig.ManageConfig(searchOpenPrintCommodityName=" + this.getSearchOpenPrintCommodityName() + ", logLifeMonth=" + this.getLogLifeMonth() + ")";
        }
    }

    public static class SortConfig {
        public String searchGlobalProductFiltering;
        public String searchPredictiveDynamicEnable;
        public String searchSortL3Category;
        public String searchSortL3CategoryConfig;
        public String searchSortStartSortThreshold;
        public String searchSortRedisUse;
        public String searchSortRedisCacheTime;
        public String searchSortRedisCacheNumber;
        public String searchSortIrrelevantRatioLowest;
        public String searchSortIrrelevantRatioPass;
        public String searchSortWeightWay;
        public String searchSortHumanInterventionValue;
        public String searchSortBitwiseCorrelationWeight;
        public String searchSortSmoothing;
        public String searchSortSmoothingPredictiveSort;
        public String searchSortSmoothingStartNum;
        public String searchChannelPriorityRecallEnable;
        public String searchChannelPriorityRecallBoost;
        public String searchSortSmoothingInternal;
        public String searchSortSmoothingInternalStepLength;
        public String searchSortSmoothingInternalScope;
        public String searchSortChannelInternal;
        public String searchSortChannelShard;
        public String searchSortChannelNameSort;
        public String searchSortEarmarkEnable;
        public String searchSortSupplierEnable;
        public String searchSortSupplierDisrupt;
        public String searchSortNoPictureMode;
        public String searchSortRecommendUrl;
        public String searchSortRecommendSortFusion;
        public String searchRecallSupplierNotSupport;
        public String searchRecallGetNewStockById;
        public String searchRecallGetNewStockByIdNumber;
        public String searchRecallGetNewStockByIdSize;
        public String searchRecallCheckAreaLimit;
        public String searchRecallCheckAreaLimitNumber;
        public String searchRecallCheckAreaLimitSize;
        public String searchSynonymFollowedBySynonyms;
        public String searchSynonymFollowedBySynonymsWeight;
        public String searchSynonymFollowedBySynonymsUp;
        public String searchSortGiveUp;
        public String searchSynonymEnable;
        public String searchSynonymDisplay;
        public String searchSortArtificial;
        public String searchSortArtificialTolerance;
        public String searchSortSmoothingInternalSameSkuCount;
        public String searchSortPropertyListByWeight;
        public String searchSortSegLength;
        public String searchSortByMethod;
        public String searchSortQuerySkuName;
        public String searchSortBaseTimeout;
        public String searchSortRecommendTimeout;
        public String searchPredictiveRowSize;
        public String smartChoiceEnable;
        public String smartWeightGradientDescent;
        public String isOpenStandardSort;
        public String standardSortField;
        public String standardSortType;

        public String getSearchGlobalProductFiltering() {
            return this.searchGlobalProductFiltering;
        }

        public String getSearchPredictiveDynamicEnable() {
            return this.searchPredictiveDynamicEnable;
        }

        public String getSearchSortL3Category() {
            return this.searchSortL3Category;
        }

        public String getSearchSortL3CategoryConfig() {
            return this.searchSortL3CategoryConfig;
        }

        public String getSearchSortStartSortThreshold() {
            return this.searchSortStartSortThreshold;
        }

        public String getSearchSortRedisUse() {
            return this.searchSortRedisUse;
        }

        public String getSearchSortRedisCacheTime() {
            return this.searchSortRedisCacheTime;
        }

        public String getSearchSortRedisCacheNumber() {
            return this.searchSortRedisCacheNumber;
        }

        public String getSearchSortIrrelevantRatioLowest() {
            return this.searchSortIrrelevantRatioLowest;
        }

        public String getSearchSortIrrelevantRatioPass() {
            return this.searchSortIrrelevantRatioPass;
        }

        public String getSearchSortWeightWay() {
            return this.searchSortWeightWay;
        }

        public String getSearchSortHumanInterventionValue() {
            return this.searchSortHumanInterventionValue;
        }

        public String getSearchSortBitwiseCorrelationWeight() {
            return this.searchSortBitwiseCorrelationWeight;
        }

        public String getSearchSortSmoothing() {
            return this.searchSortSmoothing;
        }

        public String getSearchSortSmoothingPredictiveSort() {
            return this.searchSortSmoothingPredictiveSort;
        }

        public String getSearchSortSmoothingStartNum() {
            return this.searchSortSmoothingStartNum;
        }

        public String getSearchChannelPriorityRecallEnable() {
            return this.searchChannelPriorityRecallEnable;
        }

        public String getSearchChannelPriorityRecallBoost() {
            return this.searchChannelPriorityRecallBoost;
        }

        public String getSearchSortSmoothingInternal() {
            return this.searchSortSmoothingInternal;
        }

        public String getSearchSortSmoothingInternalStepLength() {
            return this.searchSortSmoothingInternalStepLength;
        }

        public String getSearchSortSmoothingInternalScope() {
            return this.searchSortSmoothingInternalScope;
        }

        public String getSearchSortChannelInternal() {
            return this.searchSortChannelInternal;
        }

        public String getSearchSortChannelShard() {
            return this.searchSortChannelShard;
        }

        public String getSearchSortChannelNameSort() {
            return this.searchSortChannelNameSort;
        }

        public String getSearchSortEarmarkEnable() {
            return this.searchSortEarmarkEnable;
        }

        public String getSearchSortSupplierEnable() {
            return this.searchSortSupplierEnable;
        }

        public String getSearchSortSupplierDisrupt() {
            return this.searchSortSupplierDisrupt;
        }

        public String getSearchSortNoPictureMode() {
            return this.searchSortNoPictureMode;
        }

        public String getSearchSortRecommendUrl() {
            return this.searchSortRecommendUrl;
        }

        public String getSearchSortRecommendSortFusion() {
            return this.searchSortRecommendSortFusion;
        }

        public String getSearchRecallSupplierNotSupport() {
            return this.searchRecallSupplierNotSupport;
        }

        public String getSearchRecallGetNewStockById() {
            return this.searchRecallGetNewStockById;
        }

        public String getSearchRecallGetNewStockByIdNumber() {
            return this.searchRecallGetNewStockByIdNumber;
        }

        public String getSearchRecallGetNewStockByIdSize() {
            return this.searchRecallGetNewStockByIdSize;
        }

        public String getSearchRecallCheckAreaLimit() {
            return this.searchRecallCheckAreaLimit;
        }

        public String getSearchRecallCheckAreaLimitNumber() {
            return this.searchRecallCheckAreaLimitNumber;
        }

        public String getSearchRecallCheckAreaLimitSize() {
            return this.searchRecallCheckAreaLimitSize;
        }

        public String getSearchSynonymFollowedBySynonyms() {
            return this.searchSynonymFollowedBySynonyms;
        }

        public String getSearchSynonymFollowedBySynonymsWeight() {
            return this.searchSynonymFollowedBySynonymsWeight;
        }

        public String getSearchSynonymFollowedBySynonymsUp() {
            return this.searchSynonymFollowedBySynonymsUp;
        }

        public String getSearchSortGiveUp() {
            return this.searchSortGiveUp;
        }

        public String getSearchSynonymEnable() {
            return this.searchSynonymEnable;
        }

        public String getSearchSynonymDisplay() {
            return this.searchSynonymDisplay;
        }

        public String getSearchSortArtificial() {
            return this.searchSortArtificial;
        }

        public String getSearchSortArtificialTolerance() {
            return this.searchSortArtificialTolerance;
        }

        public String getSearchSortSmoothingInternalSameSkuCount() {
            return this.searchSortSmoothingInternalSameSkuCount;
        }

        public String getSearchSortPropertyListByWeight() {
            return this.searchSortPropertyListByWeight;
        }

        public String getSearchSortSegLength() {
            return this.searchSortSegLength;
        }

        public String getSearchSortByMethod() {
            return this.searchSortByMethod;
        }

        public String getSearchSortQuerySkuName() {
            return this.searchSortQuerySkuName;
        }

        public String getSearchSortBaseTimeout() {
            return this.searchSortBaseTimeout;
        }

        public String getSearchSortRecommendTimeout() {
            return this.searchSortRecommendTimeout;
        }

        public String getSearchPredictiveRowSize() {
            return this.searchPredictiveRowSize;
        }

        public String getSmartChoiceEnable() {
            return this.smartChoiceEnable;
        }

        public String getSmartWeightGradientDescent() {
            return this.smartWeightGradientDescent;
        }

        public String getIsOpenStandardSort() {
            return this.isOpenStandardSort;
        }

        public String getStandardSortField() {
            return this.standardSortField;
        }

        public String getStandardSortType() {
            return this.standardSortType;
        }

        public void setSearchGlobalProductFiltering(String searchGlobalProductFiltering) {
            this.searchGlobalProductFiltering = searchGlobalProductFiltering;
        }

        public void setSearchPredictiveDynamicEnable(String searchPredictiveDynamicEnable) {
            this.searchPredictiveDynamicEnable = searchPredictiveDynamicEnable;
        }

        public void setSearchSortL3Category(String searchSortL3Category) {
            this.searchSortL3Category = searchSortL3Category;
        }

        public void setSearchSortL3CategoryConfig(String searchSortL3CategoryConfig) {
            this.searchSortL3CategoryConfig = searchSortL3CategoryConfig;
        }

        public void setSearchSortStartSortThreshold(String searchSortStartSortThreshold) {
            this.searchSortStartSortThreshold = searchSortStartSortThreshold;
        }

        public void setSearchSortRedisUse(String searchSortRedisUse) {
            this.searchSortRedisUse = searchSortRedisUse;
        }

        public void setSearchSortRedisCacheTime(String searchSortRedisCacheTime) {
            this.searchSortRedisCacheTime = searchSortRedisCacheTime;
        }

        public void setSearchSortRedisCacheNumber(String searchSortRedisCacheNumber) {
            this.searchSortRedisCacheNumber = searchSortRedisCacheNumber;
        }

        public void setSearchSortIrrelevantRatioLowest(String searchSortIrrelevantRatioLowest) {
            this.searchSortIrrelevantRatioLowest = searchSortIrrelevantRatioLowest;
        }

        public void setSearchSortIrrelevantRatioPass(String searchSortIrrelevantRatioPass) {
            this.searchSortIrrelevantRatioPass = searchSortIrrelevantRatioPass;
        }

        public void setSearchSortWeightWay(String searchSortWeightWay) {
            this.searchSortWeightWay = searchSortWeightWay;
        }

        public void setSearchSortHumanInterventionValue(String searchSortHumanInterventionValue) {
            this.searchSortHumanInterventionValue = searchSortHumanInterventionValue;
        }

        public void setSearchSortBitwiseCorrelationWeight(String searchSortBitwiseCorrelationWeight) {
            this.searchSortBitwiseCorrelationWeight = searchSortBitwiseCorrelationWeight;
        }

        public void setSearchSortSmoothing(String searchSortSmoothing) {
            this.searchSortSmoothing = searchSortSmoothing;
        }

        public void setSearchSortSmoothingPredictiveSort(String searchSortSmoothingPredictiveSort) {
            this.searchSortSmoothingPredictiveSort = searchSortSmoothingPredictiveSort;
        }

        public void setSearchSortSmoothingStartNum(String searchSortSmoothingStartNum) {
            this.searchSortSmoothingStartNum = searchSortSmoothingStartNum;
        }

        public void setSearchChannelPriorityRecallEnable(String searchChannelPriorityRecallEnable) {
            this.searchChannelPriorityRecallEnable = searchChannelPriorityRecallEnable;
        }

        public void setSearchChannelPriorityRecallBoost(String searchChannelPriorityRecallBoost) {
            this.searchChannelPriorityRecallBoost = searchChannelPriorityRecallBoost;
        }

        public void setSearchSortSmoothingInternal(String searchSortSmoothingInternal) {
            this.searchSortSmoothingInternal = searchSortSmoothingInternal;
        }

        public void setSearchSortSmoothingInternalStepLength(String searchSortSmoothingInternalStepLength) {
            this.searchSortSmoothingInternalStepLength = searchSortSmoothingInternalStepLength;
        }

        public void setSearchSortSmoothingInternalScope(String searchSortSmoothingInternalScope) {
            this.searchSortSmoothingInternalScope = searchSortSmoothingInternalScope;
        }

        public void setSearchSortChannelInternal(String searchSortChannelInternal) {
            this.searchSortChannelInternal = searchSortChannelInternal;
        }

        public void setSearchSortChannelShard(String searchSortChannelShard) {
            this.searchSortChannelShard = searchSortChannelShard;
        }

        public void setSearchSortChannelNameSort(String searchSortChannelNameSort) {
            this.searchSortChannelNameSort = searchSortChannelNameSort;
        }

        public void setSearchSortEarmarkEnable(String searchSortEarmarkEnable) {
            this.searchSortEarmarkEnable = searchSortEarmarkEnable;
        }

        public void setSearchSortSupplierEnable(String searchSortSupplierEnable) {
            this.searchSortSupplierEnable = searchSortSupplierEnable;
        }

        public void setSearchSortSupplierDisrupt(String searchSortSupplierDisrupt) {
            this.searchSortSupplierDisrupt = searchSortSupplierDisrupt;
        }

        public void setSearchSortNoPictureMode(String searchSortNoPictureMode) {
            this.searchSortNoPictureMode = searchSortNoPictureMode;
        }

        public void setSearchSortRecommendUrl(String searchSortRecommendUrl) {
            this.searchSortRecommendUrl = searchSortRecommendUrl;
        }

        public void setSearchSortRecommendSortFusion(String searchSortRecommendSortFusion) {
            this.searchSortRecommendSortFusion = searchSortRecommendSortFusion;
        }

        public void setSearchRecallSupplierNotSupport(String searchRecallSupplierNotSupport) {
            this.searchRecallSupplierNotSupport = searchRecallSupplierNotSupport;
        }

        public void setSearchRecallGetNewStockById(String searchRecallGetNewStockById) {
            this.searchRecallGetNewStockById = searchRecallGetNewStockById;
        }

        public void setSearchRecallGetNewStockByIdNumber(String searchRecallGetNewStockByIdNumber) {
            this.searchRecallGetNewStockByIdNumber = searchRecallGetNewStockByIdNumber;
        }

        public void setSearchRecallGetNewStockByIdSize(String searchRecallGetNewStockByIdSize) {
            this.searchRecallGetNewStockByIdSize = searchRecallGetNewStockByIdSize;
        }

        public void setSearchRecallCheckAreaLimit(String searchRecallCheckAreaLimit) {
            this.searchRecallCheckAreaLimit = searchRecallCheckAreaLimit;
        }

        public void setSearchRecallCheckAreaLimitNumber(String searchRecallCheckAreaLimitNumber) {
            this.searchRecallCheckAreaLimitNumber = searchRecallCheckAreaLimitNumber;
        }

        public void setSearchRecallCheckAreaLimitSize(String searchRecallCheckAreaLimitSize) {
            this.searchRecallCheckAreaLimitSize = searchRecallCheckAreaLimitSize;
        }

        public void setSearchSynonymFollowedBySynonyms(String searchSynonymFollowedBySynonyms) {
            this.searchSynonymFollowedBySynonyms = searchSynonymFollowedBySynonyms;
        }

        public void setSearchSynonymFollowedBySynonymsWeight(String searchSynonymFollowedBySynonymsWeight) {
            this.searchSynonymFollowedBySynonymsWeight = searchSynonymFollowedBySynonymsWeight;
        }

        public void setSearchSynonymFollowedBySynonymsUp(String searchSynonymFollowedBySynonymsUp) {
            this.searchSynonymFollowedBySynonymsUp = searchSynonymFollowedBySynonymsUp;
        }

        public void setSearchSortGiveUp(String searchSortGiveUp) {
            this.searchSortGiveUp = searchSortGiveUp;
        }

        public void setSearchSynonymEnable(String searchSynonymEnable) {
            this.searchSynonymEnable = searchSynonymEnable;
        }

        public void setSearchSynonymDisplay(String searchSynonymDisplay) {
            this.searchSynonymDisplay = searchSynonymDisplay;
        }

        public void setSearchSortArtificial(String searchSortArtificial) {
            this.searchSortArtificial = searchSortArtificial;
        }

        public void setSearchSortArtificialTolerance(String searchSortArtificialTolerance) {
            this.searchSortArtificialTolerance = searchSortArtificialTolerance;
        }

        public void setSearchSortSmoothingInternalSameSkuCount(String searchSortSmoothingInternalSameSkuCount) {
            this.searchSortSmoothingInternalSameSkuCount = searchSortSmoothingInternalSameSkuCount;
        }

        public void setSearchSortPropertyListByWeight(String searchSortPropertyListByWeight) {
            this.searchSortPropertyListByWeight = searchSortPropertyListByWeight;
        }

        public void setSearchSortSegLength(String searchSortSegLength) {
            this.searchSortSegLength = searchSortSegLength;
        }

        public void setSearchSortByMethod(String searchSortByMethod) {
            this.searchSortByMethod = searchSortByMethod;
        }

        public void setSearchSortQuerySkuName(String searchSortQuerySkuName) {
            this.searchSortQuerySkuName = searchSortQuerySkuName;
        }

        public void setSearchSortBaseTimeout(String searchSortBaseTimeout) {
            this.searchSortBaseTimeout = searchSortBaseTimeout;
        }

        public void setSearchSortRecommendTimeout(String searchSortRecommendTimeout) {
            this.searchSortRecommendTimeout = searchSortRecommendTimeout;
        }

        public void setSearchPredictiveRowSize(String searchPredictiveRowSize) {
            this.searchPredictiveRowSize = searchPredictiveRowSize;
        }

        public void setSmartChoiceEnable(String smartChoiceEnable) {
            this.smartChoiceEnable = smartChoiceEnable;
        }

        public void setSmartWeightGradientDescent(String smartWeightGradientDescent) {
            this.smartWeightGradientDescent = smartWeightGradientDescent;
        }

        public void setIsOpenStandardSort(String isOpenStandardSort) {
            this.isOpenStandardSort = isOpenStandardSort;
        }

        public void setStandardSortField(String standardSortField) {
            this.standardSortField = standardSortField;
        }

        public void setStandardSortType(String standardSortType) {
            this.standardSortType = standardSortType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SortConfig)) {
                return false;
            }
            SortConfig other = (SortConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$searchGlobalProductFiltering = this.getSearchGlobalProductFiltering();
            String other$searchGlobalProductFiltering = other.getSearchGlobalProductFiltering();
            if (this$searchGlobalProductFiltering == null ? other$searchGlobalProductFiltering != null : !this$searchGlobalProductFiltering.equals(other$searchGlobalProductFiltering)) {
                return false;
            }
            String this$searchPredictiveDynamicEnable = this.getSearchPredictiveDynamicEnable();
            String other$searchPredictiveDynamicEnable = other.getSearchPredictiveDynamicEnable();
            if (this$searchPredictiveDynamicEnable == null ? other$searchPredictiveDynamicEnable != null : !this$searchPredictiveDynamicEnable.equals(other$searchPredictiveDynamicEnable)) {
                return false;
            }
            String this$searchSortL3Category = this.getSearchSortL3Category();
            String other$searchSortL3Category = other.getSearchSortL3Category();
            if (this$searchSortL3Category == null ? other$searchSortL3Category != null : !this$searchSortL3Category.equals(other$searchSortL3Category)) {
                return false;
            }
            String this$searchSortL3CategoryConfig = this.getSearchSortL3CategoryConfig();
            String other$searchSortL3CategoryConfig = other.getSearchSortL3CategoryConfig();
            if (this$searchSortL3CategoryConfig == null ? other$searchSortL3CategoryConfig != null : !this$searchSortL3CategoryConfig.equals(other$searchSortL3CategoryConfig)) {
                return false;
            }
            String this$searchSortStartSortThreshold = this.getSearchSortStartSortThreshold();
            String other$searchSortStartSortThreshold = other.getSearchSortStartSortThreshold();
            if (this$searchSortStartSortThreshold == null ? other$searchSortStartSortThreshold != null : !this$searchSortStartSortThreshold.equals(other$searchSortStartSortThreshold)) {
                return false;
            }
            String this$searchSortRedisUse = this.getSearchSortRedisUse();
            String other$searchSortRedisUse = other.getSearchSortRedisUse();
            if (this$searchSortRedisUse == null ? other$searchSortRedisUse != null : !this$searchSortRedisUse.equals(other$searchSortRedisUse)) {
                return false;
            }
            String this$searchSortRedisCacheTime = this.getSearchSortRedisCacheTime();
            String other$searchSortRedisCacheTime = other.getSearchSortRedisCacheTime();
            if (this$searchSortRedisCacheTime == null ? other$searchSortRedisCacheTime != null : !this$searchSortRedisCacheTime.equals(other$searchSortRedisCacheTime)) {
                return false;
            }
            String this$searchSortRedisCacheNumber = this.getSearchSortRedisCacheNumber();
            String other$searchSortRedisCacheNumber = other.getSearchSortRedisCacheNumber();
            if (this$searchSortRedisCacheNumber == null ? other$searchSortRedisCacheNumber != null : !this$searchSortRedisCacheNumber.equals(other$searchSortRedisCacheNumber)) {
                return false;
            }
            String this$searchSortIrrelevantRatioLowest = this.getSearchSortIrrelevantRatioLowest();
            String other$searchSortIrrelevantRatioLowest = other.getSearchSortIrrelevantRatioLowest();
            if (this$searchSortIrrelevantRatioLowest == null ? other$searchSortIrrelevantRatioLowest != null : !this$searchSortIrrelevantRatioLowest.equals(other$searchSortIrrelevantRatioLowest)) {
                return false;
            }
            String this$searchSortIrrelevantRatioPass = this.getSearchSortIrrelevantRatioPass();
            String other$searchSortIrrelevantRatioPass = other.getSearchSortIrrelevantRatioPass();
            if (this$searchSortIrrelevantRatioPass == null ? other$searchSortIrrelevantRatioPass != null : !this$searchSortIrrelevantRatioPass.equals(other$searchSortIrrelevantRatioPass)) {
                return false;
            }
            String this$searchSortWeightWay = this.getSearchSortWeightWay();
            String other$searchSortWeightWay = other.getSearchSortWeightWay();
            if (this$searchSortWeightWay == null ? other$searchSortWeightWay != null : !this$searchSortWeightWay.equals(other$searchSortWeightWay)) {
                return false;
            }
            String this$searchSortHumanInterventionValue = this.getSearchSortHumanInterventionValue();
            String other$searchSortHumanInterventionValue = other.getSearchSortHumanInterventionValue();
            if (this$searchSortHumanInterventionValue == null ? other$searchSortHumanInterventionValue != null : !this$searchSortHumanInterventionValue.equals(other$searchSortHumanInterventionValue)) {
                return false;
            }
            String this$searchSortBitwiseCorrelationWeight = this.getSearchSortBitwiseCorrelationWeight();
            String other$searchSortBitwiseCorrelationWeight = other.getSearchSortBitwiseCorrelationWeight();
            if (this$searchSortBitwiseCorrelationWeight == null ? other$searchSortBitwiseCorrelationWeight != null : !this$searchSortBitwiseCorrelationWeight.equals(other$searchSortBitwiseCorrelationWeight)) {
                return false;
            }
            String this$searchSortSmoothing = this.getSearchSortSmoothing();
            String other$searchSortSmoothing = other.getSearchSortSmoothing();
            if (this$searchSortSmoothing == null ? other$searchSortSmoothing != null : !this$searchSortSmoothing.equals(other$searchSortSmoothing)) {
                return false;
            }
            String this$searchSortSmoothingPredictiveSort = this.getSearchSortSmoothingPredictiveSort();
            String other$searchSortSmoothingPredictiveSort = other.getSearchSortSmoothingPredictiveSort();
            if (this$searchSortSmoothingPredictiveSort == null ? other$searchSortSmoothingPredictiveSort != null : !this$searchSortSmoothingPredictiveSort.equals(other$searchSortSmoothingPredictiveSort)) {
                return false;
            }
            String this$searchSortSmoothingStartNum = this.getSearchSortSmoothingStartNum();
            String other$searchSortSmoothingStartNum = other.getSearchSortSmoothingStartNum();
            if (this$searchSortSmoothingStartNum == null ? other$searchSortSmoothingStartNum != null : !this$searchSortSmoothingStartNum.equals(other$searchSortSmoothingStartNum)) {
                return false;
            }
            String this$searchChannelPriorityRecallEnable = this.getSearchChannelPriorityRecallEnable();
            String other$searchChannelPriorityRecallEnable = other.getSearchChannelPriorityRecallEnable();
            if (this$searchChannelPriorityRecallEnable == null ? other$searchChannelPriorityRecallEnable != null : !this$searchChannelPriorityRecallEnable.equals(other$searchChannelPriorityRecallEnable)) {
                return false;
            }
            String this$searchChannelPriorityRecallBoost = this.getSearchChannelPriorityRecallBoost();
            String other$searchChannelPriorityRecallBoost = other.getSearchChannelPriorityRecallBoost();
            if (this$searchChannelPriorityRecallBoost == null ? other$searchChannelPriorityRecallBoost != null : !this$searchChannelPriorityRecallBoost.equals(other$searchChannelPriorityRecallBoost)) {
                return false;
            }
            String this$searchSortSmoothingInternal = this.getSearchSortSmoothingInternal();
            String other$searchSortSmoothingInternal = other.getSearchSortSmoothingInternal();
            if (this$searchSortSmoothingInternal == null ? other$searchSortSmoothingInternal != null : !this$searchSortSmoothingInternal.equals(other$searchSortSmoothingInternal)) {
                return false;
            }
            String this$searchSortSmoothingInternalStepLength = this.getSearchSortSmoothingInternalStepLength();
            String other$searchSortSmoothingInternalStepLength = other.getSearchSortSmoothingInternalStepLength();
            if (this$searchSortSmoothingInternalStepLength == null ? other$searchSortSmoothingInternalStepLength != null : !this$searchSortSmoothingInternalStepLength.equals(other$searchSortSmoothingInternalStepLength)) {
                return false;
            }
            String this$searchSortSmoothingInternalScope = this.getSearchSortSmoothingInternalScope();
            String other$searchSortSmoothingInternalScope = other.getSearchSortSmoothingInternalScope();
            if (this$searchSortSmoothingInternalScope == null ? other$searchSortSmoothingInternalScope != null : !this$searchSortSmoothingInternalScope.equals(other$searchSortSmoothingInternalScope)) {
                return false;
            }
            String this$searchSortChannelInternal = this.getSearchSortChannelInternal();
            String other$searchSortChannelInternal = other.getSearchSortChannelInternal();
            if (this$searchSortChannelInternal == null ? other$searchSortChannelInternal != null : !this$searchSortChannelInternal.equals(other$searchSortChannelInternal)) {
                return false;
            }
            String this$searchSortChannelShard = this.getSearchSortChannelShard();
            String other$searchSortChannelShard = other.getSearchSortChannelShard();
            if (this$searchSortChannelShard == null ? other$searchSortChannelShard != null : !this$searchSortChannelShard.equals(other$searchSortChannelShard)) {
                return false;
            }
            String this$searchSortChannelNameSort = this.getSearchSortChannelNameSort();
            String other$searchSortChannelNameSort = other.getSearchSortChannelNameSort();
            if (this$searchSortChannelNameSort == null ? other$searchSortChannelNameSort != null : !this$searchSortChannelNameSort.equals(other$searchSortChannelNameSort)) {
                return false;
            }
            String this$searchSortEarmarkEnable = this.getSearchSortEarmarkEnable();
            String other$searchSortEarmarkEnable = other.getSearchSortEarmarkEnable();
            if (this$searchSortEarmarkEnable == null ? other$searchSortEarmarkEnable != null : !this$searchSortEarmarkEnable.equals(other$searchSortEarmarkEnable)) {
                return false;
            }
            String this$searchSortSupplierEnable = this.getSearchSortSupplierEnable();
            String other$searchSortSupplierEnable = other.getSearchSortSupplierEnable();
            if (this$searchSortSupplierEnable == null ? other$searchSortSupplierEnable != null : !this$searchSortSupplierEnable.equals(other$searchSortSupplierEnable)) {
                return false;
            }
            String this$searchSortSupplierDisrupt = this.getSearchSortSupplierDisrupt();
            String other$searchSortSupplierDisrupt = other.getSearchSortSupplierDisrupt();
            if (this$searchSortSupplierDisrupt == null ? other$searchSortSupplierDisrupt != null : !this$searchSortSupplierDisrupt.equals(other$searchSortSupplierDisrupt)) {
                return false;
            }
            String this$searchSortNoPictureMode = this.getSearchSortNoPictureMode();
            String other$searchSortNoPictureMode = other.getSearchSortNoPictureMode();
            if (this$searchSortNoPictureMode == null ? other$searchSortNoPictureMode != null : !this$searchSortNoPictureMode.equals(other$searchSortNoPictureMode)) {
                return false;
            }
            String this$searchSortRecommendUrl = this.getSearchSortRecommendUrl();
            String other$searchSortRecommendUrl = other.getSearchSortRecommendUrl();
            if (this$searchSortRecommendUrl == null ? other$searchSortRecommendUrl != null : !this$searchSortRecommendUrl.equals(other$searchSortRecommendUrl)) {
                return false;
            }
            String this$searchSortRecommendSortFusion = this.getSearchSortRecommendSortFusion();
            String other$searchSortRecommendSortFusion = other.getSearchSortRecommendSortFusion();
            if (this$searchSortRecommendSortFusion == null ? other$searchSortRecommendSortFusion != null : !this$searchSortRecommendSortFusion.equals(other$searchSortRecommendSortFusion)) {
                return false;
            }
            String this$searchRecallSupplierNotSupport = this.getSearchRecallSupplierNotSupport();
            String other$searchRecallSupplierNotSupport = other.getSearchRecallSupplierNotSupport();
            if (this$searchRecallSupplierNotSupport == null ? other$searchRecallSupplierNotSupport != null : !this$searchRecallSupplierNotSupport.equals(other$searchRecallSupplierNotSupport)) {
                return false;
            }
            String this$searchRecallGetNewStockById = this.getSearchRecallGetNewStockById();
            String other$searchRecallGetNewStockById = other.getSearchRecallGetNewStockById();
            if (this$searchRecallGetNewStockById == null ? other$searchRecallGetNewStockById != null : !this$searchRecallGetNewStockById.equals(other$searchRecallGetNewStockById)) {
                return false;
            }
            String this$searchRecallGetNewStockByIdNumber = this.getSearchRecallGetNewStockByIdNumber();
            String other$searchRecallGetNewStockByIdNumber = other.getSearchRecallGetNewStockByIdNumber();
            if (this$searchRecallGetNewStockByIdNumber == null ? other$searchRecallGetNewStockByIdNumber != null : !this$searchRecallGetNewStockByIdNumber.equals(other$searchRecallGetNewStockByIdNumber)) {
                return false;
            }
            String this$searchRecallGetNewStockByIdSize = this.getSearchRecallGetNewStockByIdSize();
            String other$searchRecallGetNewStockByIdSize = other.getSearchRecallGetNewStockByIdSize();
            if (this$searchRecallGetNewStockByIdSize == null ? other$searchRecallGetNewStockByIdSize != null : !this$searchRecallGetNewStockByIdSize.equals(other$searchRecallGetNewStockByIdSize)) {
                return false;
            }
            String this$searchRecallCheckAreaLimit = this.getSearchRecallCheckAreaLimit();
            String other$searchRecallCheckAreaLimit = other.getSearchRecallCheckAreaLimit();
            if (this$searchRecallCheckAreaLimit == null ? other$searchRecallCheckAreaLimit != null : !this$searchRecallCheckAreaLimit.equals(other$searchRecallCheckAreaLimit)) {
                return false;
            }
            String this$searchRecallCheckAreaLimitNumber = this.getSearchRecallCheckAreaLimitNumber();
            String other$searchRecallCheckAreaLimitNumber = other.getSearchRecallCheckAreaLimitNumber();
            if (this$searchRecallCheckAreaLimitNumber == null ? other$searchRecallCheckAreaLimitNumber != null : !this$searchRecallCheckAreaLimitNumber.equals(other$searchRecallCheckAreaLimitNumber)) {
                return false;
            }
            String this$searchRecallCheckAreaLimitSize = this.getSearchRecallCheckAreaLimitSize();
            String other$searchRecallCheckAreaLimitSize = other.getSearchRecallCheckAreaLimitSize();
            if (this$searchRecallCheckAreaLimitSize == null ? other$searchRecallCheckAreaLimitSize != null : !this$searchRecallCheckAreaLimitSize.equals(other$searchRecallCheckAreaLimitSize)) {
                return false;
            }
            String this$searchSynonymFollowedBySynonyms = this.getSearchSynonymFollowedBySynonyms();
            String other$searchSynonymFollowedBySynonyms = other.getSearchSynonymFollowedBySynonyms();
            if (this$searchSynonymFollowedBySynonyms == null ? other$searchSynonymFollowedBySynonyms != null : !this$searchSynonymFollowedBySynonyms.equals(other$searchSynonymFollowedBySynonyms)) {
                return false;
            }
            String this$searchSynonymFollowedBySynonymsWeight = this.getSearchSynonymFollowedBySynonymsWeight();
            String other$searchSynonymFollowedBySynonymsWeight = other.getSearchSynonymFollowedBySynonymsWeight();
            if (this$searchSynonymFollowedBySynonymsWeight == null ? other$searchSynonymFollowedBySynonymsWeight != null : !this$searchSynonymFollowedBySynonymsWeight.equals(other$searchSynonymFollowedBySynonymsWeight)) {
                return false;
            }
            String this$searchSynonymFollowedBySynonymsUp = this.getSearchSynonymFollowedBySynonymsUp();
            String other$searchSynonymFollowedBySynonymsUp = other.getSearchSynonymFollowedBySynonymsUp();
            if (this$searchSynonymFollowedBySynonymsUp == null ? other$searchSynonymFollowedBySynonymsUp != null : !this$searchSynonymFollowedBySynonymsUp.equals(other$searchSynonymFollowedBySynonymsUp)) {
                return false;
            }
            String this$searchSortGiveUp = this.getSearchSortGiveUp();
            String other$searchSortGiveUp = other.getSearchSortGiveUp();
            if (this$searchSortGiveUp == null ? other$searchSortGiveUp != null : !this$searchSortGiveUp.equals(other$searchSortGiveUp)) {
                return false;
            }
            String this$searchSynonymEnable = this.getSearchSynonymEnable();
            String other$searchSynonymEnable = other.getSearchSynonymEnable();
            if (this$searchSynonymEnable == null ? other$searchSynonymEnable != null : !this$searchSynonymEnable.equals(other$searchSynonymEnable)) {
                return false;
            }
            String this$searchSynonymDisplay = this.getSearchSynonymDisplay();
            String other$searchSynonymDisplay = other.getSearchSynonymDisplay();
            if (this$searchSynonymDisplay == null ? other$searchSynonymDisplay != null : !this$searchSynonymDisplay.equals(other$searchSynonymDisplay)) {
                return false;
            }
            String this$searchSortArtificial = this.getSearchSortArtificial();
            String other$searchSortArtificial = other.getSearchSortArtificial();
            if (this$searchSortArtificial == null ? other$searchSortArtificial != null : !this$searchSortArtificial.equals(other$searchSortArtificial)) {
                return false;
            }
            String this$searchSortArtificialTolerance = this.getSearchSortArtificialTolerance();
            String other$searchSortArtificialTolerance = other.getSearchSortArtificialTolerance();
            if (this$searchSortArtificialTolerance == null ? other$searchSortArtificialTolerance != null : !this$searchSortArtificialTolerance.equals(other$searchSortArtificialTolerance)) {
                return false;
            }
            String this$searchSortSmoothingInternalSameSkuCount = this.getSearchSortSmoothingInternalSameSkuCount();
            String other$searchSortSmoothingInternalSameSkuCount = other.getSearchSortSmoothingInternalSameSkuCount();
            if (this$searchSortSmoothingInternalSameSkuCount == null ? other$searchSortSmoothingInternalSameSkuCount != null : !this$searchSortSmoothingInternalSameSkuCount.equals(other$searchSortSmoothingInternalSameSkuCount)) {
                return false;
            }
            String this$searchSortPropertyListByWeight = this.getSearchSortPropertyListByWeight();
            String other$searchSortPropertyListByWeight = other.getSearchSortPropertyListByWeight();
            if (this$searchSortPropertyListByWeight == null ? other$searchSortPropertyListByWeight != null : !this$searchSortPropertyListByWeight.equals(other$searchSortPropertyListByWeight)) {
                return false;
            }
            String this$searchSortSegLength = this.getSearchSortSegLength();
            String other$searchSortSegLength = other.getSearchSortSegLength();
            if (this$searchSortSegLength == null ? other$searchSortSegLength != null : !this$searchSortSegLength.equals(other$searchSortSegLength)) {
                return false;
            }
            String this$searchSortByMethod = this.getSearchSortByMethod();
            String other$searchSortByMethod = other.getSearchSortByMethod();
            if (this$searchSortByMethod == null ? other$searchSortByMethod != null : !this$searchSortByMethod.equals(other$searchSortByMethod)) {
                return false;
            }
            String this$searchSortQuerySkuName = this.getSearchSortQuerySkuName();
            String other$searchSortQuerySkuName = other.getSearchSortQuerySkuName();
            if (this$searchSortQuerySkuName == null ? other$searchSortQuerySkuName != null : !this$searchSortQuerySkuName.equals(other$searchSortQuerySkuName)) {
                return false;
            }
            String this$searchSortBaseTimeout = this.getSearchSortBaseTimeout();
            String other$searchSortBaseTimeout = other.getSearchSortBaseTimeout();
            if (this$searchSortBaseTimeout == null ? other$searchSortBaseTimeout != null : !this$searchSortBaseTimeout.equals(other$searchSortBaseTimeout)) {
                return false;
            }
            String this$searchSortRecommendTimeout = this.getSearchSortRecommendTimeout();
            String other$searchSortRecommendTimeout = other.getSearchSortRecommendTimeout();
            if (this$searchSortRecommendTimeout == null ? other$searchSortRecommendTimeout != null : !this$searchSortRecommendTimeout.equals(other$searchSortRecommendTimeout)) {
                return false;
            }
            String this$searchPredictiveRowSize = this.getSearchPredictiveRowSize();
            String other$searchPredictiveRowSize = other.getSearchPredictiveRowSize();
            if (this$searchPredictiveRowSize == null ? other$searchPredictiveRowSize != null : !this$searchPredictiveRowSize.equals(other$searchPredictiveRowSize)) {
                return false;
            }
            String this$smartChoiceEnable = this.getSmartChoiceEnable();
            String other$smartChoiceEnable = other.getSmartChoiceEnable();
            if (this$smartChoiceEnable == null ? other$smartChoiceEnable != null : !this$smartChoiceEnable.equals(other$smartChoiceEnable)) {
                return false;
            }
            String this$smartWeightGradientDescent = this.getSmartWeightGradientDescent();
            String other$smartWeightGradientDescent = other.getSmartWeightGradientDescent();
            if (this$smartWeightGradientDescent == null ? other$smartWeightGradientDescent != null : !this$smartWeightGradientDescent.equals(other$smartWeightGradientDescent)) {
                return false;
            }
            String this$isOpenStandardSort = this.getIsOpenStandardSort();
            String other$isOpenStandardSort = other.getIsOpenStandardSort();
            if (this$isOpenStandardSort == null ? other$isOpenStandardSort != null : !this$isOpenStandardSort.equals(other$isOpenStandardSort)) {
                return false;
            }
            String this$standardSortField = this.getStandardSortField();
            String other$standardSortField = other.getStandardSortField();
            if (this$standardSortField == null ? other$standardSortField != null : !this$standardSortField.equals(other$standardSortField)) {
                return false;
            }
            String this$standardSortType = this.getStandardSortType();
            String other$standardSortType = other.getStandardSortType();
            return !(this$standardSortType == null ? other$standardSortType != null : !this$standardSortType.equals(other$standardSortType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SortConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $searchGlobalProductFiltering = this.getSearchGlobalProductFiltering();
            result = result * 59 + ($searchGlobalProductFiltering == null ? 43 : $searchGlobalProductFiltering.hashCode());
            String $searchPredictiveDynamicEnable = this.getSearchPredictiveDynamicEnable();
            result = result * 59 + ($searchPredictiveDynamicEnable == null ? 43 : $searchPredictiveDynamicEnable.hashCode());
            String $searchSortL3Category = this.getSearchSortL3Category();
            result = result * 59 + ($searchSortL3Category == null ? 43 : $searchSortL3Category.hashCode());
            String $searchSortL3CategoryConfig = this.getSearchSortL3CategoryConfig();
            result = result * 59 + ($searchSortL3CategoryConfig == null ? 43 : $searchSortL3CategoryConfig.hashCode());
            String $searchSortStartSortThreshold = this.getSearchSortStartSortThreshold();
            result = result * 59 + ($searchSortStartSortThreshold == null ? 43 : $searchSortStartSortThreshold.hashCode());
            String $searchSortRedisUse = this.getSearchSortRedisUse();
            result = result * 59 + ($searchSortRedisUse == null ? 43 : $searchSortRedisUse.hashCode());
            String $searchSortRedisCacheTime = this.getSearchSortRedisCacheTime();
            result = result * 59 + ($searchSortRedisCacheTime == null ? 43 : $searchSortRedisCacheTime.hashCode());
            String $searchSortRedisCacheNumber = this.getSearchSortRedisCacheNumber();
            result = result * 59 + ($searchSortRedisCacheNumber == null ? 43 : $searchSortRedisCacheNumber.hashCode());
            String $searchSortIrrelevantRatioLowest = this.getSearchSortIrrelevantRatioLowest();
            result = result * 59 + ($searchSortIrrelevantRatioLowest == null ? 43 : $searchSortIrrelevantRatioLowest.hashCode());
            String $searchSortIrrelevantRatioPass = this.getSearchSortIrrelevantRatioPass();
            result = result * 59 + ($searchSortIrrelevantRatioPass == null ? 43 : $searchSortIrrelevantRatioPass.hashCode());
            String $searchSortWeightWay = this.getSearchSortWeightWay();
            result = result * 59 + ($searchSortWeightWay == null ? 43 : $searchSortWeightWay.hashCode());
            String $searchSortHumanInterventionValue = this.getSearchSortHumanInterventionValue();
            result = result * 59 + ($searchSortHumanInterventionValue == null ? 43 : $searchSortHumanInterventionValue.hashCode());
            String $searchSortBitwiseCorrelationWeight = this.getSearchSortBitwiseCorrelationWeight();
            result = result * 59 + ($searchSortBitwiseCorrelationWeight == null ? 43 : $searchSortBitwiseCorrelationWeight.hashCode());
            String $searchSortSmoothing = this.getSearchSortSmoothing();
            result = result * 59 + ($searchSortSmoothing == null ? 43 : $searchSortSmoothing.hashCode());
            String $searchSortSmoothingPredictiveSort = this.getSearchSortSmoothingPredictiveSort();
            result = result * 59 + ($searchSortSmoothingPredictiveSort == null ? 43 : $searchSortSmoothingPredictiveSort.hashCode());
            String $searchSortSmoothingStartNum = this.getSearchSortSmoothingStartNum();
            result = result * 59 + ($searchSortSmoothingStartNum == null ? 43 : $searchSortSmoothingStartNum.hashCode());
            String $searchChannelPriorityRecallEnable = this.getSearchChannelPriorityRecallEnable();
            result = result * 59 + ($searchChannelPriorityRecallEnable == null ? 43 : $searchChannelPriorityRecallEnable.hashCode());
            String $searchChannelPriorityRecallBoost = this.getSearchChannelPriorityRecallBoost();
            result = result * 59 + ($searchChannelPriorityRecallBoost == null ? 43 : $searchChannelPriorityRecallBoost.hashCode());
            String $searchSortSmoothingInternal = this.getSearchSortSmoothingInternal();
            result = result * 59 + ($searchSortSmoothingInternal == null ? 43 : $searchSortSmoothingInternal.hashCode());
            String $searchSortSmoothingInternalStepLength = this.getSearchSortSmoothingInternalStepLength();
            result = result * 59 + ($searchSortSmoothingInternalStepLength == null ? 43 : $searchSortSmoothingInternalStepLength.hashCode());
            String $searchSortSmoothingInternalScope = this.getSearchSortSmoothingInternalScope();
            result = result * 59 + ($searchSortSmoothingInternalScope == null ? 43 : $searchSortSmoothingInternalScope.hashCode());
            String $searchSortChannelInternal = this.getSearchSortChannelInternal();
            result = result * 59 + ($searchSortChannelInternal == null ? 43 : $searchSortChannelInternal.hashCode());
            String $searchSortChannelShard = this.getSearchSortChannelShard();
            result = result * 59 + ($searchSortChannelShard == null ? 43 : $searchSortChannelShard.hashCode());
            String $searchSortChannelNameSort = this.getSearchSortChannelNameSort();
            result = result * 59 + ($searchSortChannelNameSort == null ? 43 : $searchSortChannelNameSort.hashCode());
            String $searchSortEarmarkEnable = this.getSearchSortEarmarkEnable();
            result = result * 59 + ($searchSortEarmarkEnable == null ? 43 : $searchSortEarmarkEnable.hashCode());
            String $searchSortSupplierEnable = this.getSearchSortSupplierEnable();
            result = result * 59 + ($searchSortSupplierEnable == null ? 43 : $searchSortSupplierEnable.hashCode());
            String $searchSortSupplierDisrupt = this.getSearchSortSupplierDisrupt();
            result = result * 59 + ($searchSortSupplierDisrupt == null ? 43 : $searchSortSupplierDisrupt.hashCode());
            String $searchSortNoPictureMode = this.getSearchSortNoPictureMode();
            result = result * 59 + ($searchSortNoPictureMode == null ? 43 : $searchSortNoPictureMode.hashCode());
            String $searchSortRecommendUrl = this.getSearchSortRecommendUrl();
            result = result * 59 + ($searchSortRecommendUrl == null ? 43 : $searchSortRecommendUrl.hashCode());
            String $searchSortRecommendSortFusion = this.getSearchSortRecommendSortFusion();
            result = result * 59 + ($searchSortRecommendSortFusion == null ? 43 : $searchSortRecommendSortFusion.hashCode());
            String $searchRecallSupplierNotSupport = this.getSearchRecallSupplierNotSupport();
            result = result * 59 + ($searchRecallSupplierNotSupport == null ? 43 : $searchRecallSupplierNotSupport.hashCode());
            String $searchRecallGetNewStockById = this.getSearchRecallGetNewStockById();
            result = result * 59 + ($searchRecallGetNewStockById == null ? 43 : $searchRecallGetNewStockById.hashCode());
            String $searchRecallGetNewStockByIdNumber = this.getSearchRecallGetNewStockByIdNumber();
            result = result * 59 + ($searchRecallGetNewStockByIdNumber == null ? 43 : $searchRecallGetNewStockByIdNumber.hashCode());
            String $searchRecallGetNewStockByIdSize = this.getSearchRecallGetNewStockByIdSize();
            result = result * 59 + ($searchRecallGetNewStockByIdSize == null ? 43 : $searchRecallGetNewStockByIdSize.hashCode());
            String $searchRecallCheckAreaLimit = this.getSearchRecallCheckAreaLimit();
            result = result * 59 + ($searchRecallCheckAreaLimit == null ? 43 : $searchRecallCheckAreaLimit.hashCode());
            String $searchRecallCheckAreaLimitNumber = this.getSearchRecallCheckAreaLimitNumber();
            result = result * 59 + ($searchRecallCheckAreaLimitNumber == null ? 43 : $searchRecallCheckAreaLimitNumber.hashCode());
            String $searchRecallCheckAreaLimitSize = this.getSearchRecallCheckAreaLimitSize();
            result = result * 59 + ($searchRecallCheckAreaLimitSize == null ? 43 : $searchRecallCheckAreaLimitSize.hashCode());
            String $searchSynonymFollowedBySynonyms = this.getSearchSynonymFollowedBySynonyms();
            result = result * 59 + ($searchSynonymFollowedBySynonyms == null ? 43 : $searchSynonymFollowedBySynonyms.hashCode());
            String $searchSynonymFollowedBySynonymsWeight = this.getSearchSynonymFollowedBySynonymsWeight();
            result = result * 59 + ($searchSynonymFollowedBySynonymsWeight == null ? 43 : $searchSynonymFollowedBySynonymsWeight.hashCode());
            String $searchSynonymFollowedBySynonymsUp = this.getSearchSynonymFollowedBySynonymsUp();
            result = result * 59 + ($searchSynonymFollowedBySynonymsUp == null ? 43 : $searchSynonymFollowedBySynonymsUp.hashCode());
            String $searchSortGiveUp = this.getSearchSortGiveUp();
            result = result * 59 + ($searchSortGiveUp == null ? 43 : $searchSortGiveUp.hashCode());
            String $searchSynonymEnable = this.getSearchSynonymEnable();
            result = result * 59 + ($searchSynonymEnable == null ? 43 : $searchSynonymEnable.hashCode());
            String $searchSynonymDisplay = this.getSearchSynonymDisplay();
            result = result * 59 + ($searchSynonymDisplay == null ? 43 : $searchSynonymDisplay.hashCode());
            String $searchSortArtificial = this.getSearchSortArtificial();
            result = result * 59 + ($searchSortArtificial == null ? 43 : $searchSortArtificial.hashCode());
            String $searchSortArtificialTolerance = this.getSearchSortArtificialTolerance();
            result = result * 59 + ($searchSortArtificialTolerance == null ? 43 : $searchSortArtificialTolerance.hashCode());
            String $searchSortSmoothingInternalSameSkuCount = this.getSearchSortSmoothingInternalSameSkuCount();
            result = result * 59 + ($searchSortSmoothingInternalSameSkuCount == null ? 43 : $searchSortSmoothingInternalSameSkuCount.hashCode());
            String $searchSortPropertyListByWeight = this.getSearchSortPropertyListByWeight();
            result = result * 59 + ($searchSortPropertyListByWeight == null ? 43 : $searchSortPropertyListByWeight.hashCode());
            String $searchSortSegLength = this.getSearchSortSegLength();
            result = result * 59 + ($searchSortSegLength == null ? 43 : $searchSortSegLength.hashCode());
            String $searchSortByMethod = this.getSearchSortByMethod();
            result = result * 59 + ($searchSortByMethod == null ? 43 : $searchSortByMethod.hashCode());
            String $searchSortQuerySkuName = this.getSearchSortQuerySkuName();
            result = result * 59 + ($searchSortQuerySkuName == null ? 43 : $searchSortQuerySkuName.hashCode());
            String $searchSortBaseTimeout = this.getSearchSortBaseTimeout();
            result = result * 59 + ($searchSortBaseTimeout == null ? 43 : $searchSortBaseTimeout.hashCode());
            String $searchSortRecommendTimeout = this.getSearchSortRecommendTimeout();
            result = result * 59 + ($searchSortRecommendTimeout == null ? 43 : $searchSortRecommendTimeout.hashCode());
            String $searchPredictiveRowSize = this.getSearchPredictiveRowSize();
            result = result * 59 + ($searchPredictiveRowSize == null ? 43 : $searchPredictiveRowSize.hashCode());
            String $smartChoiceEnable = this.getSmartChoiceEnable();
            result = result * 59 + ($smartChoiceEnable == null ? 43 : $smartChoiceEnable.hashCode());
            String $smartWeightGradientDescent = this.getSmartWeightGradientDescent();
            result = result * 59 + ($smartWeightGradientDescent == null ? 43 : $smartWeightGradientDescent.hashCode());
            String $isOpenStandardSort = this.getIsOpenStandardSort();
            result = result * 59 + ($isOpenStandardSort == null ? 43 : $isOpenStandardSort.hashCode());
            String $standardSortField = this.getStandardSortField();
            result = result * 59 + ($standardSortField == null ? 43 : $standardSortField.hashCode());
            String $standardSortType = this.getStandardSortType();
            result = result * 59 + ($standardSortType == null ? 43 : $standardSortType.hashCode());
            return result;
        }

        public String toString() {
            return "SearchProcessConfig.SortConfig(searchGlobalProductFiltering=" + this.getSearchGlobalProductFiltering() + ", searchPredictiveDynamicEnable=" + this.getSearchPredictiveDynamicEnable() + ", searchSortL3Category=" + this.getSearchSortL3Category() + ", searchSortL3CategoryConfig=" + this.getSearchSortL3CategoryConfig() + ", searchSortStartSortThreshold=" + this.getSearchSortStartSortThreshold() + ", searchSortRedisUse=" + this.getSearchSortRedisUse() + ", searchSortRedisCacheTime=" + this.getSearchSortRedisCacheTime() + ", searchSortRedisCacheNumber=" + this.getSearchSortRedisCacheNumber() + ", searchSortIrrelevantRatioLowest=" + this.getSearchSortIrrelevantRatioLowest() + ", searchSortIrrelevantRatioPass=" + this.getSearchSortIrrelevantRatioPass() + ", searchSortWeightWay=" + this.getSearchSortWeightWay() + ", searchSortHumanInterventionValue=" + this.getSearchSortHumanInterventionValue() + ", searchSortBitwiseCorrelationWeight=" + this.getSearchSortBitwiseCorrelationWeight() + ", searchSortSmoothing=" + this.getSearchSortSmoothing() + ", searchSortSmoothingPredictiveSort=" + this.getSearchSortSmoothingPredictiveSort() + ", searchSortSmoothingStartNum=" + this.getSearchSortSmoothingStartNum() + ", searchChannelPriorityRecallEnable=" + this.getSearchChannelPriorityRecallEnable() + ", searchChannelPriorityRecallBoost=" + this.getSearchChannelPriorityRecallBoost() + ", searchSortSmoothingInternal=" + this.getSearchSortSmoothingInternal() + ", searchSortSmoothingInternalStepLength=" + this.getSearchSortSmoothingInternalStepLength() + ", searchSortSmoothingInternalScope=" + this.getSearchSortSmoothingInternalScope() + ", searchSortChannelInternal=" + this.getSearchSortChannelInternal() + ", searchSortChannelShard=" + this.getSearchSortChannelShard() + ", searchSortChannelNameSort=" + this.getSearchSortChannelNameSort() + ", searchSortEarmarkEnable=" + this.getSearchSortEarmarkEnable() + ", searchSortSupplierEnable=" + this.getSearchSortSupplierEnable() + ", searchSortSupplierDisrupt=" + this.getSearchSortSupplierDisrupt() + ", searchSortNoPictureMode=" + this.getSearchSortNoPictureMode() + ", searchSortRecommendUrl=" + this.getSearchSortRecommendUrl() + ", searchSortRecommendSortFusion=" + this.getSearchSortRecommendSortFusion() + ", searchRecallSupplierNotSupport=" + this.getSearchRecallSupplierNotSupport() + ", searchRecallGetNewStockById=" + this.getSearchRecallGetNewStockById() + ", searchRecallGetNewStockByIdNumber=" + this.getSearchRecallGetNewStockByIdNumber() + ", searchRecallGetNewStockByIdSize=" + this.getSearchRecallGetNewStockByIdSize() + ", searchRecallCheckAreaLimit=" + this.getSearchRecallCheckAreaLimit() + ", searchRecallCheckAreaLimitNumber=" + this.getSearchRecallCheckAreaLimitNumber() + ", searchRecallCheckAreaLimitSize=" + this.getSearchRecallCheckAreaLimitSize() + ", searchSynonymFollowedBySynonyms=" + this.getSearchSynonymFollowedBySynonyms() + ", searchSynonymFollowedBySynonymsWeight=" + this.getSearchSynonymFollowedBySynonymsWeight() + ", searchSynonymFollowedBySynonymsUp=" + this.getSearchSynonymFollowedBySynonymsUp() + ", searchSortGiveUp=" + this.getSearchSortGiveUp() + ", searchSynonymEnable=" + this.getSearchSynonymEnable() + ", searchSynonymDisplay=" + this.getSearchSynonymDisplay() + ", searchSortArtificial=" + this.getSearchSortArtificial() + ", searchSortArtificialTolerance=" + this.getSearchSortArtificialTolerance() + ", searchSortSmoothingInternalSameSkuCount=" + this.getSearchSortSmoothingInternalSameSkuCount() + ", searchSortPropertyListByWeight=" + this.getSearchSortPropertyListByWeight() + ", searchSortSegLength=" + this.getSearchSortSegLength() + ", searchSortByMethod=" + this.getSearchSortByMethod() + ", searchSortQuerySkuName=" + this.getSearchSortQuerySkuName() + ", searchSortBaseTimeout=" + this.getSearchSortBaseTimeout() + ", searchSortRecommendTimeout=" + this.getSearchSortRecommendTimeout() + ", searchPredictiveRowSize=" + this.getSearchPredictiveRowSize() + ", smartChoiceEnable=" + this.getSmartChoiceEnable() + ", smartWeightGradientDescent=" + this.getSmartWeightGradientDescent() + ", isOpenStandardSort=" + this.getIsOpenStandardSort() + ", standardSortField=" + this.getStandardSortField() + ", standardSortType=" + this.getStandardSortType() + ")";
        }
    }

    public static class ReCallConfig {
        public String esOpenClients;
        public String searchIsAccordingCommodity;
        public String esConfigSearchSize;
        public String esFields;
        public String isParticiple;
        public String isSynonymRewrite;
        public String esAccurateFields;
        public String esAccurateTextFields;
        public String esAccurateChineseFields;
        public String esConfigSearchExpire;
        public String esAccurateTextBlurry;
        public String esMinMumShouldMatch;
        public String esMinMustTermsListSize;
        public String esConfigSearchOpenL3C;
        public String esIndexPreference;
        public String esAnalyzer;
        public String esParticipleAnalyzer;
        public String esMaxLong;
        public String esShelvesFilter;
        public String esAccurateCompleteParticipleFields;
        public String esAccurateSize;
        public String esMinScore;
        public String esSeedField;
        public String esSeedScore;
        public String esSeedQueryFilterListNeedEmpty;
        public String searchEsRecallPropertiesUnion;
        public String searchFilterProperties;
        public String searchFilterPropertiesCondition;
        public String httpDomain;
        public String elasticsearchBatchSize;
        public String elasticsearchVectorSentencesMaxSize;
        public String tokenExpireTime;
        public String isOpenSync;
        public String isOpenHotSearch;
        public String filterMostImpressions;
        public String isOpenBansRule;
        public String commodityStandardReplaceLogOpen;
        public String commodityStandardAggField;
        public String commodityStandardBanedField;
        public String commodityStandardBanedValues;
        public String commodityStandardAggDsl;

        public String getEsOpenClients() {
            return this.esOpenClients;
        }

        public String getSearchIsAccordingCommodity() {
            return this.searchIsAccordingCommodity;
        }

        public String getEsConfigSearchSize() {
            return this.esConfigSearchSize;
        }

        public String getEsFields() {
            return this.esFields;
        }

        public String getIsParticiple() {
            return this.isParticiple;
        }

        public String getIsSynonymRewrite() {
            return this.isSynonymRewrite;
        }

        public String getEsAccurateFields() {
            return this.esAccurateFields;
        }

        public String getEsAccurateTextFields() {
            return this.esAccurateTextFields;
        }

        public String getEsAccurateChineseFields() {
            return this.esAccurateChineseFields;
        }

        public String getEsConfigSearchExpire() {
            return this.esConfigSearchExpire;
        }

        public String getEsAccurateTextBlurry() {
            return this.esAccurateTextBlurry;
        }

        public String getEsMinMumShouldMatch() {
            return this.esMinMumShouldMatch;
        }

        public String getEsMinMustTermsListSize() {
            return this.esMinMustTermsListSize;
        }

        public String getEsConfigSearchOpenL3C() {
            return this.esConfigSearchOpenL3C;
        }

        public String getEsIndexPreference() {
            return this.esIndexPreference;
        }

        public String getEsAnalyzer() {
            return this.esAnalyzer;
        }

        public String getEsParticipleAnalyzer() {
            return this.esParticipleAnalyzer;
        }

        public String getEsMaxLong() {
            return this.esMaxLong;
        }

        public String getEsShelvesFilter() {
            return this.esShelvesFilter;
        }

        public String getEsAccurateCompleteParticipleFields() {
            return this.esAccurateCompleteParticipleFields;
        }

        public String getEsAccurateSize() {
            return this.esAccurateSize;
        }

        public String getEsMinScore() {
            return this.esMinScore;
        }

        public String getEsSeedField() {
            return this.esSeedField;
        }

        public String getEsSeedScore() {
            return this.esSeedScore;
        }

        public String getEsSeedQueryFilterListNeedEmpty() {
            return this.esSeedQueryFilterListNeedEmpty;
        }

        public String getSearchEsRecallPropertiesUnion() {
            return this.searchEsRecallPropertiesUnion;
        }

        public String getSearchFilterProperties() {
            return this.searchFilterProperties;
        }

        public String getSearchFilterPropertiesCondition() {
            return this.searchFilterPropertiesCondition;
        }

        public String getHttpDomain() {
            return this.httpDomain;
        }

        public String getElasticsearchBatchSize() {
            return this.elasticsearchBatchSize;
        }

        public String getElasticsearchVectorSentencesMaxSize() {
            return this.elasticsearchVectorSentencesMaxSize;
        }

        public String getTokenExpireTime() {
            return this.tokenExpireTime;
        }

        public String getIsOpenSync() {
            return this.isOpenSync;
        }

        public String getIsOpenHotSearch() {
            return this.isOpenHotSearch;
        }

        public String getFilterMostImpressions() {
            return this.filterMostImpressions;
        }

        public String getIsOpenBansRule() {
            return this.isOpenBansRule;
        }

        public String getCommodityStandardReplaceLogOpen() {
            return this.commodityStandardReplaceLogOpen;
        }

        public String getCommodityStandardAggField() {
            return this.commodityStandardAggField;
        }

        public String getCommodityStandardBanedField() {
            return this.commodityStandardBanedField;
        }

        public String getCommodityStandardBanedValues() {
            return this.commodityStandardBanedValues;
        }

        public String getCommodityStandardAggDsl() {
            return this.commodityStandardAggDsl;
        }

        public void setEsOpenClients(String esOpenClients) {
            this.esOpenClients = esOpenClients;
        }

        public void setSearchIsAccordingCommodity(String searchIsAccordingCommodity) {
            this.searchIsAccordingCommodity = searchIsAccordingCommodity;
        }

        public void setEsConfigSearchSize(String esConfigSearchSize) {
            this.esConfigSearchSize = esConfigSearchSize;
        }

        public void setEsFields(String esFields) {
            this.esFields = esFields;
        }

        public void setIsParticiple(String isParticiple) {
            this.isParticiple = isParticiple;
        }

        public void setIsSynonymRewrite(String isSynonymRewrite) {
            this.isSynonymRewrite = isSynonymRewrite;
        }

        public void setEsAccurateFields(String esAccurateFields) {
            this.esAccurateFields = esAccurateFields;
        }

        public void setEsAccurateTextFields(String esAccurateTextFields) {
            this.esAccurateTextFields = esAccurateTextFields;
        }

        public void setEsAccurateChineseFields(String esAccurateChineseFields) {
            this.esAccurateChineseFields = esAccurateChineseFields;
        }

        public void setEsConfigSearchExpire(String esConfigSearchExpire) {
            this.esConfigSearchExpire = esConfigSearchExpire;
        }

        public void setEsAccurateTextBlurry(String esAccurateTextBlurry) {
            this.esAccurateTextBlurry = esAccurateTextBlurry;
        }

        public void setEsMinMumShouldMatch(String esMinMumShouldMatch) {
            this.esMinMumShouldMatch = esMinMumShouldMatch;
        }

        public void setEsMinMustTermsListSize(String esMinMustTermsListSize) {
            this.esMinMustTermsListSize = esMinMustTermsListSize;
        }

        public void setEsConfigSearchOpenL3C(String esConfigSearchOpenL3C) {
            this.esConfigSearchOpenL3C = esConfigSearchOpenL3C;
        }

        public void setEsIndexPreference(String esIndexPreference) {
            this.esIndexPreference = esIndexPreference;
        }

        public void setEsAnalyzer(String esAnalyzer) {
            this.esAnalyzer = esAnalyzer;
        }

        public void setEsParticipleAnalyzer(String esParticipleAnalyzer) {
            this.esParticipleAnalyzer = esParticipleAnalyzer;
        }

        public void setEsMaxLong(String esMaxLong) {
            this.esMaxLong = esMaxLong;
        }

        public void setEsShelvesFilter(String esShelvesFilter) {
            this.esShelvesFilter = esShelvesFilter;
        }

        public void setEsAccurateCompleteParticipleFields(String esAccurateCompleteParticipleFields) {
            this.esAccurateCompleteParticipleFields = esAccurateCompleteParticipleFields;
        }

        public void setEsAccurateSize(String esAccurateSize) {
            this.esAccurateSize = esAccurateSize;
        }

        public void setEsMinScore(String esMinScore) {
            this.esMinScore = esMinScore;
        }

        public void setEsSeedField(String esSeedField) {
            this.esSeedField = esSeedField;
        }

        public void setEsSeedScore(String esSeedScore) {
            this.esSeedScore = esSeedScore;
        }

        public void setEsSeedQueryFilterListNeedEmpty(String esSeedQueryFilterListNeedEmpty) {
            this.esSeedQueryFilterListNeedEmpty = esSeedQueryFilterListNeedEmpty;
        }

        public void setSearchEsRecallPropertiesUnion(String searchEsRecallPropertiesUnion) {
            this.searchEsRecallPropertiesUnion = searchEsRecallPropertiesUnion;
        }

        public void setSearchFilterProperties(String searchFilterProperties) {
            this.searchFilterProperties = searchFilterProperties;
        }

        public void setSearchFilterPropertiesCondition(String searchFilterPropertiesCondition) {
            this.searchFilterPropertiesCondition = searchFilterPropertiesCondition;
        }

        public void setHttpDomain(String httpDomain) {
            this.httpDomain = httpDomain;
        }

        public void setElasticsearchBatchSize(String elasticsearchBatchSize) {
            this.elasticsearchBatchSize = elasticsearchBatchSize;
        }

        public void setElasticsearchVectorSentencesMaxSize(String elasticsearchVectorSentencesMaxSize) {
            this.elasticsearchVectorSentencesMaxSize = elasticsearchVectorSentencesMaxSize;
        }

        public void setTokenExpireTime(String tokenExpireTime) {
            this.tokenExpireTime = tokenExpireTime;
        }

        public void setIsOpenSync(String isOpenSync) {
            this.isOpenSync = isOpenSync;
        }

        public void setIsOpenHotSearch(String isOpenHotSearch) {
            this.isOpenHotSearch = isOpenHotSearch;
        }

        public void setFilterMostImpressions(String filterMostImpressions) {
            this.filterMostImpressions = filterMostImpressions;
        }

        public void setIsOpenBansRule(String isOpenBansRule) {
            this.isOpenBansRule = isOpenBansRule;
        }

        public void setCommodityStandardReplaceLogOpen(String commodityStandardReplaceLogOpen) {
            this.commodityStandardReplaceLogOpen = commodityStandardReplaceLogOpen;
        }

        public void setCommodityStandardAggField(String commodityStandardAggField) {
            this.commodityStandardAggField = commodityStandardAggField;
        }

        public void setCommodityStandardBanedField(String commodityStandardBanedField) {
            this.commodityStandardBanedField = commodityStandardBanedField;
        }

        public void setCommodityStandardBanedValues(String commodityStandardBanedValues) {
            this.commodityStandardBanedValues = commodityStandardBanedValues;
        }

        public void setCommodityStandardAggDsl(String commodityStandardAggDsl) {
            this.commodityStandardAggDsl = commodityStandardAggDsl;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReCallConfig)) {
                return false;
            }
            ReCallConfig other = (ReCallConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$esOpenClients = this.getEsOpenClients();
            String other$esOpenClients = other.getEsOpenClients();
            if (this$esOpenClients == null ? other$esOpenClients != null : !this$esOpenClients.equals(other$esOpenClients)) {
                return false;
            }
            String this$searchIsAccordingCommodity = this.getSearchIsAccordingCommodity();
            String other$searchIsAccordingCommodity = other.getSearchIsAccordingCommodity();
            if (this$searchIsAccordingCommodity == null ? other$searchIsAccordingCommodity != null : !this$searchIsAccordingCommodity.equals(other$searchIsAccordingCommodity)) {
                return false;
            }
            String this$esConfigSearchSize = this.getEsConfigSearchSize();
            String other$esConfigSearchSize = other.getEsConfigSearchSize();
            if (this$esConfigSearchSize == null ? other$esConfigSearchSize != null : !this$esConfigSearchSize.equals(other$esConfigSearchSize)) {
                return false;
            }
            String this$esFields = this.getEsFields();
            String other$esFields = other.getEsFields();
            if (this$esFields == null ? other$esFields != null : !this$esFields.equals(other$esFields)) {
                return false;
            }
            String this$isParticiple = this.getIsParticiple();
            String other$isParticiple = other.getIsParticiple();
            if (this$isParticiple == null ? other$isParticiple != null : !this$isParticiple.equals(other$isParticiple)) {
                return false;
            }
            String this$isSynonymRewrite = this.getIsSynonymRewrite();
            String other$isSynonymRewrite = other.getIsSynonymRewrite();
            if (this$isSynonymRewrite == null ? other$isSynonymRewrite != null : !this$isSynonymRewrite.equals(other$isSynonymRewrite)) {
                return false;
            }
            String this$esAccurateFields = this.getEsAccurateFields();
            String other$esAccurateFields = other.getEsAccurateFields();
            if (this$esAccurateFields == null ? other$esAccurateFields != null : !this$esAccurateFields.equals(other$esAccurateFields)) {
                return false;
            }
            String this$esAccurateTextFields = this.getEsAccurateTextFields();
            String other$esAccurateTextFields = other.getEsAccurateTextFields();
            if (this$esAccurateTextFields == null ? other$esAccurateTextFields != null : !this$esAccurateTextFields.equals(other$esAccurateTextFields)) {
                return false;
            }
            String this$esAccurateChineseFields = this.getEsAccurateChineseFields();
            String other$esAccurateChineseFields = other.getEsAccurateChineseFields();
            if (this$esAccurateChineseFields == null ? other$esAccurateChineseFields != null : !this$esAccurateChineseFields.equals(other$esAccurateChineseFields)) {
                return false;
            }
            String this$esConfigSearchExpire = this.getEsConfigSearchExpire();
            String other$esConfigSearchExpire = other.getEsConfigSearchExpire();
            if (this$esConfigSearchExpire == null ? other$esConfigSearchExpire != null : !this$esConfigSearchExpire.equals(other$esConfigSearchExpire)) {
                return false;
            }
            String this$esAccurateTextBlurry = this.getEsAccurateTextBlurry();
            String other$esAccurateTextBlurry = other.getEsAccurateTextBlurry();
            if (this$esAccurateTextBlurry == null ? other$esAccurateTextBlurry != null : !this$esAccurateTextBlurry.equals(other$esAccurateTextBlurry)) {
                return false;
            }
            String this$esMinMumShouldMatch = this.getEsMinMumShouldMatch();
            String other$esMinMumShouldMatch = other.getEsMinMumShouldMatch();
            if (this$esMinMumShouldMatch == null ? other$esMinMumShouldMatch != null : !this$esMinMumShouldMatch.equals(other$esMinMumShouldMatch)) {
                return false;
            }
            String this$esMinMustTermsListSize = this.getEsMinMustTermsListSize();
            String other$esMinMustTermsListSize = other.getEsMinMustTermsListSize();
            if (this$esMinMustTermsListSize == null ? other$esMinMustTermsListSize != null : !this$esMinMustTermsListSize.equals(other$esMinMustTermsListSize)) {
                return false;
            }
            String this$esConfigSearchOpenL3C = this.getEsConfigSearchOpenL3C();
            String other$esConfigSearchOpenL3C = other.getEsConfigSearchOpenL3C();
            if (this$esConfigSearchOpenL3C == null ? other$esConfigSearchOpenL3C != null : !this$esConfigSearchOpenL3C.equals(other$esConfigSearchOpenL3C)) {
                return false;
            }
            String this$esIndexPreference = this.getEsIndexPreference();
            String other$esIndexPreference = other.getEsIndexPreference();
            if (this$esIndexPreference == null ? other$esIndexPreference != null : !this$esIndexPreference.equals(other$esIndexPreference)) {
                return false;
            }
            String this$esAnalyzer = this.getEsAnalyzer();
            String other$esAnalyzer = other.getEsAnalyzer();
            if (this$esAnalyzer == null ? other$esAnalyzer != null : !this$esAnalyzer.equals(other$esAnalyzer)) {
                return false;
            }
            String this$esParticipleAnalyzer = this.getEsParticipleAnalyzer();
            String other$esParticipleAnalyzer = other.getEsParticipleAnalyzer();
            if (this$esParticipleAnalyzer == null ? other$esParticipleAnalyzer != null : !this$esParticipleAnalyzer.equals(other$esParticipleAnalyzer)) {
                return false;
            }
            String this$esMaxLong = this.getEsMaxLong();
            String other$esMaxLong = other.getEsMaxLong();
            if (this$esMaxLong == null ? other$esMaxLong != null : !this$esMaxLong.equals(other$esMaxLong)) {
                return false;
            }
            String this$esShelvesFilter = this.getEsShelvesFilter();
            String other$esShelvesFilter = other.getEsShelvesFilter();
            if (this$esShelvesFilter == null ? other$esShelvesFilter != null : !this$esShelvesFilter.equals(other$esShelvesFilter)) {
                return false;
            }
            String this$esAccurateCompleteParticipleFields = this.getEsAccurateCompleteParticipleFields();
            String other$esAccurateCompleteParticipleFields = other.getEsAccurateCompleteParticipleFields();
            if (this$esAccurateCompleteParticipleFields == null ? other$esAccurateCompleteParticipleFields != null : !this$esAccurateCompleteParticipleFields.equals(other$esAccurateCompleteParticipleFields)) {
                return false;
            }
            String this$esAccurateSize = this.getEsAccurateSize();
            String other$esAccurateSize = other.getEsAccurateSize();
            if (this$esAccurateSize == null ? other$esAccurateSize != null : !this$esAccurateSize.equals(other$esAccurateSize)) {
                return false;
            }
            String this$esMinScore = this.getEsMinScore();
            String other$esMinScore = other.getEsMinScore();
            if (this$esMinScore == null ? other$esMinScore != null : !this$esMinScore.equals(other$esMinScore)) {
                return false;
            }
            String this$esSeedField = this.getEsSeedField();
            String other$esSeedField = other.getEsSeedField();
            if (this$esSeedField == null ? other$esSeedField != null : !this$esSeedField.equals(other$esSeedField)) {
                return false;
            }
            String this$esSeedScore = this.getEsSeedScore();
            String other$esSeedScore = other.getEsSeedScore();
            if (this$esSeedScore == null ? other$esSeedScore != null : !this$esSeedScore.equals(other$esSeedScore)) {
                return false;
            }
            String this$esSeedQueryFilterListNeedEmpty = this.getEsSeedQueryFilterListNeedEmpty();
            String other$esSeedQueryFilterListNeedEmpty = other.getEsSeedQueryFilterListNeedEmpty();
            if (this$esSeedQueryFilterListNeedEmpty == null ? other$esSeedQueryFilterListNeedEmpty != null : !this$esSeedQueryFilterListNeedEmpty.equals(other$esSeedQueryFilterListNeedEmpty)) {
                return false;
            }
            String this$searchEsRecallPropertiesUnion = this.getSearchEsRecallPropertiesUnion();
            String other$searchEsRecallPropertiesUnion = other.getSearchEsRecallPropertiesUnion();
            if (this$searchEsRecallPropertiesUnion == null ? other$searchEsRecallPropertiesUnion != null : !this$searchEsRecallPropertiesUnion.equals(other$searchEsRecallPropertiesUnion)) {
                return false;
            }
            String this$searchFilterProperties = this.getSearchFilterProperties();
            String other$searchFilterProperties = other.getSearchFilterProperties();
            if (this$searchFilterProperties == null ? other$searchFilterProperties != null : !this$searchFilterProperties.equals(other$searchFilterProperties)) {
                return false;
            }
            String this$searchFilterPropertiesCondition = this.getSearchFilterPropertiesCondition();
            String other$searchFilterPropertiesCondition = other.getSearchFilterPropertiesCondition();
            if (this$searchFilterPropertiesCondition == null ? other$searchFilterPropertiesCondition != null : !this$searchFilterPropertiesCondition.equals(other$searchFilterPropertiesCondition)) {
                return false;
            }
            String this$httpDomain = this.getHttpDomain();
            String other$httpDomain = other.getHttpDomain();
            if (this$httpDomain == null ? other$httpDomain != null : !this$httpDomain.equals(other$httpDomain)) {
                return false;
            }
            String this$elasticsearchBatchSize = this.getElasticsearchBatchSize();
            String other$elasticsearchBatchSize = other.getElasticsearchBatchSize();
            if (this$elasticsearchBatchSize == null ? other$elasticsearchBatchSize != null : !this$elasticsearchBatchSize.equals(other$elasticsearchBatchSize)) {
                return false;
            }
            String this$elasticsearchVectorSentencesMaxSize = this.getElasticsearchVectorSentencesMaxSize();
            String other$elasticsearchVectorSentencesMaxSize = other.getElasticsearchVectorSentencesMaxSize();
            if (this$elasticsearchVectorSentencesMaxSize == null ? other$elasticsearchVectorSentencesMaxSize != null : !this$elasticsearchVectorSentencesMaxSize.equals(other$elasticsearchVectorSentencesMaxSize)) {
                return false;
            }
            String this$tokenExpireTime = this.getTokenExpireTime();
            String other$tokenExpireTime = other.getTokenExpireTime();
            if (this$tokenExpireTime == null ? other$tokenExpireTime != null : !this$tokenExpireTime.equals(other$tokenExpireTime)) {
                return false;
            }
            String this$isOpenSync = this.getIsOpenSync();
            String other$isOpenSync = other.getIsOpenSync();
            if (this$isOpenSync == null ? other$isOpenSync != null : !this$isOpenSync.equals(other$isOpenSync)) {
                return false;
            }
            String this$isOpenHotSearch = this.getIsOpenHotSearch();
            String other$isOpenHotSearch = other.getIsOpenHotSearch();
            if (this$isOpenHotSearch == null ? other$isOpenHotSearch != null : !this$isOpenHotSearch.equals(other$isOpenHotSearch)) {
                return false;
            }
            String this$filterMostImpressions = this.getFilterMostImpressions();
            String other$filterMostImpressions = other.getFilterMostImpressions();
            if (this$filterMostImpressions == null ? other$filterMostImpressions != null : !this$filterMostImpressions.equals(other$filterMostImpressions)) {
                return false;
            }
            String this$isOpenBansRule = this.getIsOpenBansRule();
            String other$isOpenBansRule = other.getIsOpenBansRule();
            if (this$isOpenBansRule == null ? other$isOpenBansRule != null : !this$isOpenBansRule.equals(other$isOpenBansRule)) {
                return false;
            }
            String this$commodityStandardReplaceLogOpen = this.getCommodityStandardReplaceLogOpen();
            String other$commodityStandardReplaceLogOpen = other.getCommodityStandardReplaceLogOpen();
            if (this$commodityStandardReplaceLogOpen == null ? other$commodityStandardReplaceLogOpen != null : !this$commodityStandardReplaceLogOpen.equals(other$commodityStandardReplaceLogOpen)) {
                return false;
            }
            String this$commodityStandardAggField = this.getCommodityStandardAggField();
            String other$commodityStandardAggField = other.getCommodityStandardAggField();
            if (this$commodityStandardAggField == null ? other$commodityStandardAggField != null : !this$commodityStandardAggField.equals(other$commodityStandardAggField)) {
                return false;
            }
            String this$commodityStandardBanedField = this.getCommodityStandardBanedField();
            String other$commodityStandardBanedField = other.getCommodityStandardBanedField();
            if (this$commodityStandardBanedField == null ? other$commodityStandardBanedField != null : !this$commodityStandardBanedField.equals(other$commodityStandardBanedField)) {
                return false;
            }
            String this$commodityStandardBanedValues = this.getCommodityStandardBanedValues();
            String other$commodityStandardBanedValues = other.getCommodityStandardBanedValues();
            if (this$commodityStandardBanedValues == null ? other$commodityStandardBanedValues != null : !this$commodityStandardBanedValues.equals(other$commodityStandardBanedValues)) {
                return false;
            }
            String this$commodityStandardAggDsl = this.getCommodityStandardAggDsl();
            String other$commodityStandardAggDsl = other.getCommodityStandardAggDsl();
            return !(this$commodityStandardAggDsl == null ? other$commodityStandardAggDsl != null : !this$commodityStandardAggDsl.equals(other$commodityStandardAggDsl));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ReCallConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $esOpenClients = this.getEsOpenClients();
            result = result * 59 + ($esOpenClients == null ? 43 : $esOpenClients.hashCode());
            String $searchIsAccordingCommodity = this.getSearchIsAccordingCommodity();
            result = result * 59 + ($searchIsAccordingCommodity == null ? 43 : $searchIsAccordingCommodity.hashCode());
            String $esConfigSearchSize = this.getEsConfigSearchSize();
            result = result * 59 + ($esConfigSearchSize == null ? 43 : $esConfigSearchSize.hashCode());
            String $esFields = this.getEsFields();
            result = result * 59 + ($esFields == null ? 43 : $esFields.hashCode());
            String $isParticiple = this.getIsParticiple();
            result = result * 59 + ($isParticiple == null ? 43 : $isParticiple.hashCode());
            String $isSynonymRewrite = this.getIsSynonymRewrite();
            result = result * 59 + ($isSynonymRewrite == null ? 43 : $isSynonymRewrite.hashCode());
            String $esAccurateFields = this.getEsAccurateFields();
            result = result * 59 + ($esAccurateFields == null ? 43 : $esAccurateFields.hashCode());
            String $esAccurateTextFields = this.getEsAccurateTextFields();
            result = result * 59 + ($esAccurateTextFields == null ? 43 : $esAccurateTextFields.hashCode());
            String $esAccurateChineseFields = this.getEsAccurateChineseFields();
            result = result * 59 + ($esAccurateChineseFields == null ? 43 : $esAccurateChineseFields.hashCode());
            String $esConfigSearchExpire = this.getEsConfigSearchExpire();
            result = result * 59 + ($esConfigSearchExpire == null ? 43 : $esConfigSearchExpire.hashCode());
            String $esAccurateTextBlurry = this.getEsAccurateTextBlurry();
            result = result * 59 + ($esAccurateTextBlurry == null ? 43 : $esAccurateTextBlurry.hashCode());
            String $esMinMumShouldMatch = this.getEsMinMumShouldMatch();
            result = result * 59 + ($esMinMumShouldMatch == null ? 43 : $esMinMumShouldMatch.hashCode());
            String $esMinMustTermsListSize = this.getEsMinMustTermsListSize();
            result = result * 59 + ($esMinMustTermsListSize == null ? 43 : $esMinMustTermsListSize.hashCode());
            String $esConfigSearchOpenL3C = this.getEsConfigSearchOpenL3C();
            result = result * 59 + ($esConfigSearchOpenL3C == null ? 43 : $esConfigSearchOpenL3C.hashCode());
            String $esIndexPreference = this.getEsIndexPreference();
            result = result * 59 + ($esIndexPreference == null ? 43 : $esIndexPreference.hashCode());
            String $esAnalyzer = this.getEsAnalyzer();
            result = result * 59 + ($esAnalyzer == null ? 43 : $esAnalyzer.hashCode());
            String $esParticipleAnalyzer = this.getEsParticipleAnalyzer();
            result = result * 59 + ($esParticipleAnalyzer == null ? 43 : $esParticipleAnalyzer.hashCode());
            String $esMaxLong = this.getEsMaxLong();
            result = result * 59 + ($esMaxLong == null ? 43 : $esMaxLong.hashCode());
            String $esShelvesFilter = this.getEsShelvesFilter();
            result = result * 59 + ($esShelvesFilter == null ? 43 : $esShelvesFilter.hashCode());
            String $esAccurateCompleteParticipleFields = this.getEsAccurateCompleteParticipleFields();
            result = result * 59 + ($esAccurateCompleteParticipleFields == null ? 43 : $esAccurateCompleteParticipleFields.hashCode());
            String $esAccurateSize = this.getEsAccurateSize();
            result = result * 59 + ($esAccurateSize == null ? 43 : $esAccurateSize.hashCode());
            String $esMinScore = this.getEsMinScore();
            result = result * 59 + ($esMinScore == null ? 43 : $esMinScore.hashCode());
            String $esSeedField = this.getEsSeedField();
            result = result * 59 + ($esSeedField == null ? 43 : $esSeedField.hashCode());
            String $esSeedScore = this.getEsSeedScore();
            result = result * 59 + ($esSeedScore == null ? 43 : $esSeedScore.hashCode());
            String $esSeedQueryFilterListNeedEmpty = this.getEsSeedQueryFilterListNeedEmpty();
            result = result * 59 + ($esSeedQueryFilterListNeedEmpty == null ? 43 : $esSeedQueryFilterListNeedEmpty.hashCode());
            String $searchEsRecallPropertiesUnion = this.getSearchEsRecallPropertiesUnion();
            result = result * 59 + ($searchEsRecallPropertiesUnion == null ? 43 : $searchEsRecallPropertiesUnion.hashCode());
            String $searchFilterProperties = this.getSearchFilterProperties();
            result = result * 59 + ($searchFilterProperties == null ? 43 : $searchFilterProperties.hashCode());
            String $searchFilterPropertiesCondition = this.getSearchFilterPropertiesCondition();
            result = result * 59 + ($searchFilterPropertiesCondition == null ? 43 : $searchFilterPropertiesCondition.hashCode());
            String $httpDomain = this.getHttpDomain();
            result = result * 59 + ($httpDomain == null ? 43 : $httpDomain.hashCode());
            String $elasticsearchBatchSize = this.getElasticsearchBatchSize();
            result = result * 59 + ($elasticsearchBatchSize == null ? 43 : $elasticsearchBatchSize.hashCode());
            String $elasticsearchVectorSentencesMaxSize = this.getElasticsearchVectorSentencesMaxSize();
            result = result * 59 + ($elasticsearchVectorSentencesMaxSize == null ? 43 : $elasticsearchVectorSentencesMaxSize.hashCode());
            String $tokenExpireTime = this.getTokenExpireTime();
            result = result * 59 + ($tokenExpireTime == null ? 43 : $tokenExpireTime.hashCode());
            String $isOpenSync = this.getIsOpenSync();
            result = result * 59 + ($isOpenSync == null ? 43 : $isOpenSync.hashCode());
            String $isOpenHotSearch = this.getIsOpenHotSearch();
            result = result * 59 + ($isOpenHotSearch == null ? 43 : $isOpenHotSearch.hashCode());
            String $filterMostImpressions = this.getFilterMostImpressions();
            result = result * 59 + ($filterMostImpressions == null ? 43 : $filterMostImpressions.hashCode());
            String $isOpenBansRule = this.getIsOpenBansRule();
            result = result * 59 + ($isOpenBansRule == null ? 43 : $isOpenBansRule.hashCode());
            String $commodityStandardReplaceLogOpen = this.getCommodityStandardReplaceLogOpen();
            result = result * 59 + ($commodityStandardReplaceLogOpen == null ? 43 : $commodityStandardReplaceLogOpen.hashCode());
            String $commodityStandardAggField = this.getCommodityStandardAggField();
            result = result * 59 + ($commodityStandardAggField == null ? 43 : $commodityStandardAggField.hashCode());
            String $commodityStandardBanedField = this.getCommodityStandardBanedField();
            result = result * 59 + ($commodityStandardBanedField == null ? 43 : $commodityStandardBanedField.hashCode());
            String $commodityStandardBanedValues = this.getCommodityStandardBanedValues();
            result = result * 59 + ($commodityStandardBanedValues == null ? 43 : $commodityStandardBanedValues.hashCode());
            String $commodityStandardAggDsl = this.getCommodityStandardAggDsl();
            result = result * 59 + ($commodityStandardAggDsl == null ? 43 : $commodityStandardAggDsl.hashCode());
            return result;
        }

        public String toString() {
            return "SearchProcessConfig.ReCallConfig(esOpenClients=" + this.getEsOpenClients() + ", searchIsAccordingCommodity=" + this.getSearchIsAccordingCommodity() + ", esConfigSearchSize=" + this.getEsConfigSearchSize() + ", esFields=" + this.getEsFields() + ", isParticiple=" + this.getIsParticiple() + ", isSynonymRewrite=" + this.getIsSynonymRewrite() + ", esAccurateFields=" + this.getEsAccurateFields() + ", esAccurateTextFields=" + this.getEsAccurateTextFields() + ", esAccurateChineseFields=" + this.getEsAccurateChineseFields() + ", esConfigSearchExpire=" + this.getEsConfigSearchExpire() + ", esAccurateTextBlurry=" + this.getEsAccurateTextBlurry() + ", esMinMumShouldMatch=" + this.getEsMinMumShouldMatch() + ", esMinMustTermsListSize=" + this.getEsMinMustTermsListSize() + ", esConfigSearchOpenL3C=" + this.getEsConfigSearchOpenL3C() + ", esIndexPreference=" + this.getEsIndexPreference() + ", esAnalyzer=" + this.getEsAnalyzer() + ", esParticipleAnalyzer=" + this.getEsParticipleAnalyzer() + ", esMaxLong=" + this.getEsMaxLong() + ", esShelvesFilter=" + this.getEsShelvesFilter() + ", esAccurateCompleteParticipleFields=" + this.getEsAccurateCompleteParticipleFields() + ", esAccurateSize=" + this.getEsAccurateSize() + ", esMinScore=" + this.getEsMinScore() + ", esSeedField=" + this.getEsSeedField() + ", esSeedScore=" + this.getEsSeedScore() + ", esSeedQueryFilterListNeedEmpty=" + this.getEsSeedQueryFilterListNeedEmpty() + ", searchEsRecallPropertiesUnion=" + this.getSearchEsRecallPropertiesUnion() + ", searchFilterProperties=" + this.getSearchFilterProperties() + ", searchFilterPropertiesCondition=" + this.getSearchFilterPropertiesCondition() + ", httpDomain=" + this.getHttpDomain() + ", elasticsearchBatchSize=" + this.getElasticsearchBatchSize() + ", elasticsearchVectorSentencesMaxSize=" + this.getElasticsearchVectorSentencesMaxSize() + ", tokenExpireTime=" + this.getTokenExpireTime() + ", isOpenSync=" + this.getIsOpenSync() + ", isOpenHotSearch=" + this.getIsOpenHotSearch() + ", filterMostImpressions=" + this.getFilterMostImpressions() + ", isOpenBansRule=" + this.getIsOpenBansRule() + ", commodityStandardReplaceLogOpen=" + this.getCommodityStandardReplaceLogOpen() + ", commodityStandardAggField=" + this.getCommodityStandardAggField() + ", commodityStandardBanedField=" + this.getCommodityStandardBanedField() + ", commodityStandardBanedValues=" + this.getCommodityStandardBanedValues() + ", commodityStandardAggDsl=" + this.getCommodityStandardAggDsl() + ")";
        }
    }
}

