/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.nlp.alu.service.config;

import com.tydic.se.nlp.alu.service.config.VisibleThreadPoolTaskExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@EnableAsync
public class TaskPoolConfig {
    private static final Logger log = LoggerFactory.getLogger(TaskPoolConfig.class);

    @Bean
    @Primary
    public ThreadPoolTaskExecutor asyncServiceExecutor() {
        log.info("start asyncServiceExecutor");
        VisibleThreadPoolTaskExecutor executor = new VisibleThreadPoolTaskExecutor();
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        executor.setCorePoolSize(availableProcessors * 2);
        executor.setAllowCoreThreadTimeOut(true);
        executor.setMaxPoolSize(availableProcessors * 4);
        executor.setKeepAliveSeconds(60);
        executor.setAwaitTerminationSeconds(60);
        executor.setQueueCapacity(availableProcessors * 100);
        executor.setThreadNamePrefix("async-service-");
        executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        executor.initialize();
        return executor;
    }
}

