/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.nlp.alu.service.data;

import com.tydic.se.nlp.alu.corpus.tag.Nature;
import com.tydic.se.nlp.alu.intfs.QueryCorpusDataService;
import com.tydic.se.nlp.alu.req.QueryCorpusDataReqBo;
import com.tydic.se.nlp.alu.rsp.QueryCorpusDataRspBo;
import com.tydic.se.nlp.alu.service.constant.CountSqlEnum;
import com.tydic.se.nlp.alu.service.constant.InitialParticipleSqlEnum;
import com.tydic.se.nlp.alu.service.constant.QuerySqlEnum;
import com.tydic.se.nlp.alu.service.utils.TxtFileUtil;
import com.tydic.se.nlp.alu.util.SentencesUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="queryCatalogService")
public class QueryCatalogServiceImpl
implements QueryCorpusDataService {
    private static final Logger log = LoggerFactory.getLogger(QueryCatalogServiceImpl.class);
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private final String suffix_txt = ".txt";
    private final String suffix_dic = ".dic";
    private final String fileName = "catalog";
    private static final int PAGE_SIZE = 50000;
    private final String txtUrl = "/basic/exclusion-catalog.txt";
    private List<String> nameList = new ArrayList<String>();
    private List<String> dicList = new ArrayList<String>();
    private String catalogRegex = "[\\u4e00-\\u9fa5]{2,4}";

    public QueryCorpusDataRspBo saveDataToTxt(QueryCorpusDataReqBo reqBo) {
        String txtFile = reqBo.getOutPath() + "catalog" + ".txt";
        String dicFile = reqBo.getOutPath() + "catalog" + ".dic";
        QueryCorpusDataRspBo rspBo = new QueryCorpusDataRspBo();
        int counter = (Integer)this.jdbcTemplate.queryForObject(CountSqlEnum.CATALOG.getSql(), Integer.class);
        int totalPage = counter % 50000 == 0 ? counter / 50000 : counter / 50000 + 1;
        log.info("\u67e5\u8be2\u8fd4\u56de\u7684\u603b\u8bb0\u5f55\u6570\u91cf\uff1a" + counter + ",\u8fd4\u56de\u7684\u603b\u5206\u9875\uff1a" + totalPage);
        for (int i = 0; i < totalPage; ++i) {
            this.dealData(i);
        }
        TxtFileUtil.writeContent(this.nameList, txtFile, true);
        this.doInsertDic();
        TxtFileUtil.writeContent(this.dicList, dicFile, true);
        log.info("\u5904\u7406\u5b8c\u6210\uff01\uff01\uff01\uff01");
        rspBo.setFileName(dicFile);
        rspBo.setCode("0");
        rspBo.setMessage("\u6210\u529f");
        return rspBo;
    }

    private void doInsertDic() {
        ArrayList dicObjectList = new ArrayList();
        this.dicList.forEach(dic -> {
            Object[] seDicBo = new Object[]{dic, Nature.ncg.toString(), Nature.ncg.toString()};
            dicObjectList.add(seDicBo);
        });
        this.jdbcTemplate.batchUpdate(InitialParticipleSqlEnum.DIC_INSERT.getSql(), dicObjectList);
        log.info("\u63d2\u5165\u7c7b\u76ee\u6570\u636e\u7c7b\u578b{},\u6761\u6570{}", (Object)Nature.ncg.toString(), (Object)dicObjectList.size());
    }

    private void dealData(int startPage) {
        String querySql = QuerySqlEnum.CATALOG.getSql() + startPage * 50000 + "," + 50000;
        log.info("\u5f00\u59cb\u5904\u7406\u9875\u6570" + startPage + ",\u67e5\u8be2\u8bed\u53e5\uff1a" + querySql);
        try {
            SqlRowSet rs = this.jdbcTemplate.queryForRowSet(querySql);
            while (rs.next()) {
                String dealName;
                String name = rs.getString(1);
                if (StringUtils.isEmpty((Object)name) || StringUtils.isEmpty((Object)(dealName = this.dealCatalogMatches(name)))) continue;
                this.nameList.add(dealName);
                this.dicList.addAll(SentencesUtil.toSentenceList((String)dealName));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String dealCatalogMatches(String msg) throws IOException {
        List<String> list = TxtFileUtil.readLine(this.getClass().getResource("/basic/exclusion-catalog.txt").getPath());
        if (msg.matches(this.catalogRegex)) {
            for (String exclusionStr : list) {
                if (!msg.contains(exclusionStr)) continue;
                return null;
            }
            return msg;
        }
        return null;
    }
}

