/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.nlp.alu.service.data;

import com.tydic.se.nlp.alu.corpus.tag.Nature;
import com.tydic.se.nlp.alu.intfs.QueryCorpusDataService;
import com.tydic.se.nlp.alu.req.QueryCorpusDataReqBo;
import com.tydic.se.nlp.alu.rsp.QueryCorpusDataRspBo;
import com.tydic.se.nlp.alu.service.constant.CountSqlEnum;
import com.tydic.se.nlp.alu.service.constant.InitialParticipleSqlEnum;
import com.tydic.se.nlp.alu.service.constant.QuerySqlEnum;
import com.tydic.se.nlp.alu.service.utils.TxtFileUtil;
import com.tydic.se.nlp.alu.util.SentencesUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="queryColorService")
public class QueryColorServiceImpl
implements QueryCorpusDataService {
    private static final Logger log = LoggerFactory.getLogger(QueryColorServiceImpl.class);
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private final String oneWordColor = "\u9ec4\u6a59\u7eff\u767d\u9ed1\u84dd\u7070\u7ea2\u7d2b\u68d5\u7c89\u6854\u8910\u9752\u5170";
    private final String doubleWordColor = "\u5361\u5176\u5496\u5561";
    private final String suffix_txt = ".txt";
    private final String suffix_dic = ".dic";
    private final String fileName = "color";
    private static final int PAGE_SIZE = 50000;
    List<String> colorNameList = new ArrayList<String>();
    List<String> colorDicList = new ArrayList<String>();
    private String colorRegex = "[\\u4e00-\\u9fa5]{3}|[\\u4e00-\\u9fa5][\u8272]";

    public QueryCorpusDataRspBo saveDataToTxt(QueryCorpusDataReqBo reqBo) {
        String txtFile = reqBo.getOutPath() + "color" + ".txt";
        String dicFile = reqBo.getOutPath() + "color" + ".dic";
        QueryCorpusDataRspBo rspBo = new QueryCorpusDataRspBo();
        int counter = (Integer)this.jdbcTemplate.queryForObject(CountSqlEnum.COLOR.getSql(), Integer.class);
        int totalPage = counter % 50000 == 0 ? counter / 50000 : counter / 50000 + 1;
        log.info("\u67e5\u8be2\u8fd4\u56de\u7684\u603b\u8bb0\u5f55\u6570\u91cf\uff1a" + counter + ",\u8fd4\u56de\u7684\u603b\u5206\u9875\uff1a" + totalPage);
        for (int i = 0; i < totalPage; ++i) {
            this.dealData(i);
        }
        TxtFileUtil.writeContent(this.colorNameList, txtFile, true);
        this.doInsertDic();
        TxtFileUtil.writeContent(this.colorDicList, dicFile, true);
        log.info("\u5904\u7406\u5b8c\u6210\uff01\uff01\uff01\uff01");
        rspBo.setFileName(dicFile);
        rspBo.setCode("0");
        rspBo.setMessage("\u6210\u529f");
        return rspBo;
    }

    private void doInsertDic() {
        ArrayList dicObjectList = new ArrayList();
        this.colorDicList.forEach(dic -> {
            Object[] seDicBo = new Object[]{dic, Nature.ncor.toString(), Nature.ncor.toString()};
            dicObjectList.add(seDicBo);
        });
        this.jdbcTemplate.batchUpdate(InitialParticipleSqlEnum.DIC_INSERT.getSql(), dicObjectList);
        log.info("\u63d2\u5165\u989c\u8272\u6570\u636e\u7c7b\u578b{},\u6761\u6570{}", (Object)Nature.ncor.toString(), (Object)dicObjectList.size());
    }

    private void dealData(int startPage) {
        String querySql = QuerySqlEnum.COLOR.getSql() + startPage * 50000 + "," + 50000;
        log.info("\u5f00\u59cb\u5904\u7406\u9875\u6570" + startPage + ",\u67e5\u8be2\u8bed\u53e5\uff1a" + querySql);
        try {
            SqlRowSet rs = this.jdbcTemplate.queryForRowSet(querySql);
            while (rs.next()) {
                String dealName;
                String colorName = rs.getString(1);
                if (StringUtils.isEmpty((Object)colorName) || StringUtils.isEmpty((Object)(dealName = this.dealColorMatches(colorName)))) continue;
                this.colorNameList.add(dealName);
                this.colorDicList.addAll(SentencesUtil.toSentenceList((String)dealName));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String dealColorMatches(String msg) {
        if (msg.matches(this.colorRegex) && this.isContains(msg).booleanValue()) {
            return msg;
        }
        return null;
    }

    public Boolean isContains(String str) {
        int i;
        int length = 2;
        boolean flag = false;
        for (i = 0; i < "\u9ec4\u6a59\u7eff\u767d\u9ed1\u84dd\u7070\u7ea2\u7d2b\u68d5\u7c89\u6854\u8910\u9752\u5170".length(); ++i) {
            if (!str.contains("\u9ec4\u6a59\u7eff\u767d\u9ed1\u84dd\u7070\u7ea2\u7d2b\u68d5\u7c89\u6854\u8910\u9752\u5170".substring(i, i + 1))) continue;
            flag = true;
            break;
        }
        for (i = 0; i < "\u5361\u5176\u5496\u5561".length(); i += length) {
            if (!str.contains("\u5361\u5176\u5496\u5561".substring(i, i + 2))) continue;
            flag = true;
            break;
        }
        return flag;
    }
}

