/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.nlp.alu.service.data;

import com.tydic.se.nlp.alu.intfs.QueryCorpusDataService;
import com.tydic.se.nlp.alu.req.QueryCorpusDataReqBo;
import com.tydic.se.nlp.alu.rsp.QueryCorpusDataRspBo;
import com.tydic.se.nlp.alu.service.constant.CountSqlEnum;
import com.tydic.se.nlp.alu.service.constant.QuerySqlEnum;
import com.tydic.se.nlp.alu.service.utils.TxtFileUtil;
import com.tydic.se.nlp.alu.util.SentencesUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service(value="queryCommodityService")
public class QueryCommodityServiceImpl
implements QueryCorpusDataService {
    private static final Logger log = LoggerFactory.getLogger(QueryCommodityServiceImpl.class);
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private final String suffix_txt = ".txt";
    private final String suffix_dic = ".dic";
    private final String fileName = "commodity";
    private static final int PAGE_SIZE = 50000;
    private final String txtExclusionUrl = "/basic/last-exclusion-commodity.txt";
    private final String txtPartExclusionUrl = "/basic/part-exclusion-commodity.txt";
    private final String txtSplitModification = "/basic/modifier.txt";
    private final String txtBlackList = "/basic/commodity-black-list.txt";
    private final String txtWhiteList = "/basic/commodity-white-list.txt";
    List<String> dicList = new ArrayList<String>();
    List<String> modList = new ArrayList<String>();
    List<String> nameList = new ArrayList<String>();

    public QueryCorpusDataRspBo saveDataToTxt(QueryCorpusDataReqBo reqBo) {
        String dicFile = reqBo.getOutPath() + "commodity" + ".dic";
        String modFile = reqBo.getOutPath() + "commodity" + "Modification" + ".dic";
        String txtFile = reqBo.getOutPath() + "commodity" + ".txt";
        QueryCorpusDataRspBo rspBo = new QueryCorpusDataRspBo();
        int counter = (Integer)this.jdbcTemplate.queryForObject(CountSqlEnum.COMMODITY.getSql(), Integer.class);
        int totalPage = counter % 50000 == 0 ? counter / 50000 : counter / 50000 + 1;
        log.info("\u67e5\u8be2\u8fd4\u56de\u7684\u603b\u8bb0\u5f55\u6570\u91cf\uff1a" + counter + ",\u8fd4\u56de\u7684\u603b\u5206\u9875\uff1a" + totalPage);
        for (int i = 0; i < totalPage; ++i) {
            this.dealData(i);
        }
        TxtFileUtil.writeContent(this.dicList, dicFile, true);
        TxtFileUtil.writeContent(this.modList, modFile, true);
        TxtFileUtil.writeContent(this.nameList, txtFile, true);
        log.info("\u5904\u7406\u5b8c\u6210\uff01\uff01\uff01\uff01");
        rspBo.setCode("0");
        rspBo.setMessage("\u6210\u529f");
        return rspBo;
    }

    private void dealData(int startPage) {
        String querySql = QuerySqlEnum.COMMODITY.getSql() + startPage * 50000 + "," + 50000;
        log.info("\u5f00\u59cb\u5904\u7406\u9875\u6570" + startPage + ",,\u67e5\u8be2\u8bed\u53e5\uff1a" + querySql);
        try {
            SqlRowSet rs = this.jdbcTemplate.queryForRowSet(querySql);
            while (rs.next()) {
                String name = rs.getString(1);
                if (StringUtils.isEmpty((Object)name)) continue;
                this.addDic(name);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addDic(String word) throws IOException {
        String dealName = this.dealSpecialSymbols(word);
        this.nameList.add(dealName);
        List wordList = SentencesUtil.toSentenceList((String)dealName);
        String commodityName = this.dealScreen(wordList);
        if (!StringUtils.isEmpty((Object)commodityName)) {
            if (!this.isBlackList(commodityName)) {
                if (!this.isLastExclusion(commodityName) && !this.isPartExclusion(commodityName)) {
                    Object[] ar = this.spiltModification(commodityName);
                    if (ObjectUtils.isEmpty((Object[])ar)) {
                        if (!this.isRepeat(commodityName, this.dicList)) {
                            this.dicList.add(commodityName);
                        }
                    } else {
                        if (!this.isRepeat((String)ar[0], this.modList)) {
                            this.modList.add((String)ar[0]);
                        }
                        if (!this.isRepeat((String)ar[1], this.dicList) && !StringUtils.isEmpty((Object)ar[1])) {
                            this.dicList.add((String)ar[1]);
                        }
                    }
                }
            } else if (this.isWhiteList(commodityName) && !this.isRepeat(commodityName, this.dicList)) {
                this.dicList.add(commodityName);
            }
        }
    }

    private String dealSpecialSymbols(String msg) {
        String line = msg.replaceAll("\\{", "").replaceAll("}", "").replaceAll("\\[", "").replaceAll("]", "").replaceAll("\u3010", "").replaceAll("\u3011", "").replaceAll("\\(", "").replaceAll("\\)", "").replaceAll("\uff08", "").replaceAll("\uff09", "").replaceAll("[A-Za-z0-9]", "");
        return line;
    }

    private String dealScreen(List<String> wordList) {
        int length = 2;
        if (wordList.size() >= length) {
            for (int i = 1; i < wordList.size(); ++i) {
                if (!wordList.get(i).matches("[\\u4e00-\\u9fa5]{2,20}")) continue;
                return wordList.get(i);
            }
        }
        return null;
    }

    private boolean isRepeat(String name, List<String> dic) {
        for (String s : dic) {
            if (!s.equals(name)) continue;
            return true;
        }
        return false;
    }

    private boolean isLastExclusion(String commodityName) throws IOException {
        boolean flag = false;
        List<String> exclusions = TxtFileUtil.readLine(this.getClass().getResource("/basic/last-exclusion-commodity.txt").getPath());
        for (String s : exclusions) {
            if (StringUtils.isEmpty((Object)s)) continue;
            int length = s.trim().getBytes("UTF-8").length / 3;
            String substring = null;
            if (commodityName.getBytes("UTF-8").length >= length) {
                substring = commodityName.substring(commodityName.length() - length, commodityName.length());
            }
            if (!substring.equals(s)) continue;
            flag = true;
        }
        return flag;
    }

    private boolean isPartExclusion(String commodityName) throws IOException {
        boolean flag = false;
        int count = 0;
        List<String> exclusions = TxtFileUtil.readLine(this.getClass().getResource("/basic/part-exclusion-commodity.txt").getPath());
        for (String s : exclusions) {
            if (StringUtils.isEmpty((Object)s) || !commodityName.contains(s) || commodityName.getBytes("UTF-8").length >= (count += s.getBytes("UTF-8").length) + 6) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private String[] spiltModification(String commodityName) throws IOException {
        List<String> modifiers = TxtFileUtil.readLine(this.getClass().getResource("/basic/modifier.txt").getPath());
        String[] splitList = new String[2];
        int lastKeyWordIndex = -1;
        int lastKeyWordLength = 0;
        for (String s : modifiers) {
            if (StringUtils.isEmpty((Object)s) || !commodityName.contains(s)) continue;
            int length = s.getBytes("UTF-8").length / 3;
            int index = commodityName.lastIndexOf(s);
            if (index > lastKeyWordIndex) {
                lastKeyWordIndex = index;
                lastKeyWordLength = length;
            }
            if (index != lastKeyWordIndex || length <= lastKeyWordLength) continue;
            lastKeyWordLength = length;
        }
        if (lastKeyWordIndex >= 0) {
            splitList[0] = commodityName.substring(0, lastKeyWordIndex + lastKeyWordLength);
            splitList[1] = commodityName.substring(lastKeyWordIndex + lastKeyWordLength, commodityName.length());
            if (splitList[1].getBytes("UTF-8").length >= 6 && splitList[1].getBytes("UTF-8").length <= 21) {
                return splitList;
            }
            splitList[1] = null;
            return splitList;
        }
        return null;
    }

    private boolean isWhiteList(String commodityName) throws IOException {
        List<String> whiteList = TxtFileUtil.readLine(this.getClass().getResource("/basic/commodity-white-list.txt").getPath());
        for (String s : whiteList) {
            if (!commodityName.equals(s)) continue;
            return true;
        }
        return false;
    }

    private boolean isBlackList(String commodityName) throws IOException {
        List<String> blackList = TxtFileUtil.readLine(this.getClass().getResource("/basic/commodity-black-list.txt").getPath());
        for (String s : blackList) {
            if (StringUtils.isEmpty((Object)s) || !commodityName.contains(s)) continue;
            return true;
        }
        return false;
    }
}

