/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.nlp.alu.service.impl;

import com.tydic.se.nlp.alu.common.VendorEnum;
import com.tydic.se.nlp.alu.corpus.tag.Nature;
import com.tydic.se.nlp.alu.intfs.InitialParticipleService;
import com.tydic.se.nlp.alu.intfs.QueryCorpusDataService;
import com.tydic.se.nlp.alu.req.ParticipleReqBo;
import com.tydic.se.nlp.alu.req.QueryCorpusDataReqBo;
import com.tydic.se.nlp.alu.rsp.ParticipleRspBo;
import com.tydic.se.nlp.alu.rsp.QueryCorpusDataRspBo;
import com.tydic.se.nlp.alu.service.constant.InitialParticipleSqlEnum;
import com.tydic.se.nlp.alu.service.participle.IParticipleService;
import com.tydic.se.nlp.alu.service.utils.TxtFileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class InitialParticipleServiceImpl
implements InitialParticipleService {
    private static final Logger log = LoggerFactory.getLogger(InitialParticipleServiceImpl.class);
    protected final String suffix_txt = ".dic";
    static final int PAGE_SIZE = 50000;
    private List<String> typeList = new ArrayList<String>();
    @Autowired
    private IParticipleService participleService;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private Map<String, QueryCorpusDataService> corpusDataServiceMap;

    @PostConstruct
    public void initTypes() {
        this.typeList.add(Nature.ncl.toString());
        this.typeList.add(Nature.nmd.toString());
        this.typeList.add(Nature.nsz.toString());
    }

    String constructQueryCount(String type) {
        return InitialParticipleSqlEnum.DIC_COUNT.getSql() + type + "'";
    }

    String constructQuery(int startPage, String type) {
        return InitialParticipleSqlEnum.DIC_QUERY.getSql() + type + "' limit " + startPage * 50000 + "," + 50000;
    }

    Integer calcTotalPage(Integer count) {
        Integer totalPage = count % 50000 == 0 ? Integer.valueOf(count / 50000) : Integer.valueOf(count / 50000 + 1);
        log.info("\u67e5\u8be2\u8fd4\u56de\u7684\u603b\u8bb0\u5f55\u6570\u91cf\uff1a" + count + ",\u8fd4\u56de\u7684\u603b\u5206\u9875\uff1a" + totalPage);
        return totalPage;
    }

    public ParticipleRspBo participle(ParticipleReqBo reqBo) {
        ArrayList<String> fileList = new ArrayList<String>();
        ParticipleRspBo rspBo = new ParticipleRspBo();
        if (reqBo.getGenData().booleanValue()) {
            this.jdbcTemplate.update(InitialParticipleSqlEnum.DIC_DELETE.getSql());
            for (VendorEnum vendorEnum : VendorEnum.values()) {
                this.participleService.participle(vendorEnum.getCode());
            }
            fileList.addAll(this.otherType(reqBo));
        }
        fileList.addAll(this.writeFile(reqBo));
        rspBo.setFileNames(fileList);
        rspBo.setCode("0");
        rspBo.setMessage("\u6210\u529f");
        return rspBo;
    }

    private List<String> otherType(ParticipleReqBo reqBo) {
        ArrayList<String> fileNames = new ArrayList<String>();
        QueryCorpusDataReqBo corpusDataReqBo = new QueryCorpusDataReqBo();
        corpusDataReqBo.setOutPath(reqBo.getOutPath());
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.add("queryCommodityService");
        excludeList.add("queryModelService");
        excludeList.add("querySpecService");
        this.corpusDataServiceMap.forEach((key, service) -> {
            QueryCorpusDataRspBo rspBo;
            if (!excludeList.contains(key) && "0".equals((rspBo = service.saveDataToTxt(corpusDataReqBo)).getCode())) {
                fileNames.add(rspBo.getFileName());
            }
        });
        return fileNames;
    }

    private List<String> writeFile(ParticipleReqBo reqBo) {
        ArrayList<String> fileNameList = new ArrayList<String>();
        this.typeList.forEach(typeName -> {
            String fileName = reqBo.getOutPath() + typeName + ".dic";
            File file = new File(fileName);
            if (file.exists()) {
                file.delete();
            }
            Integer counter = (Integer)this.jdbcTemplate.queryForObject(this.constructQueryCount((String)typeName), Integer.class);
            Integer totalPage = this.calcTotalPage(counter);
            for (int i = 0; i < totalPage; ++i) {
                List<String> dicList = this.doQueryData(i, (String)typeName);
                TxtFileUtil.writeContent(dicList, fileName, true);
            }
            log.info("\u751f\u6210{}\u6587\u4ef6\u5b8c\u6210\uff01\uff01\uff01\uff01", (Object)fileName);
            fileNameList.add(fileName);
        });
        return fileNameList;
    }

    private List<String> doQueryData(int startPage, String type) {
        ArrayList<String> dicList = new ArrayList<String>();
        SqlRowSet rs = this.jdbcTemplate.queryForRowSet(this.constructQuery(startPage, type));
        while (rs.next()) {
            String word = rs.getString(1);
            if (StringUtils.isEmpty((Object)word)) continue;
            dicList.add(word);
        }
        return dicList;
    }
}

