/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.nlp.util;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.se.base.ability.bo.SeQuerySkuBO;
import com.tydic.se.base.exception.BusinessException;
import com.tydic.se.nlp.bo.AnalysisSkuBO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalysisCommTools {
    private static final Logger logger = LoggerFactory.getLogger(AnalysisCommTools.class);
    private static final String defaultFormat = "yyyyMMddHHmmssSSS";

    public static boolean strIsEmpty(String str) {
        if (str == null) {
            return true;
        }
        if ("".equals(str)) {
            return true;
        }
        if (str == "") {
            return true;
        }
        if (str.replaceAll(" ", "").length() < 1) {
            return true;
        }
        if ("null".equalsIgnoreCase(str)) {
            return true;
        }
        if (str.length() < 1) {
            return true;
        }
        return "undefined".equals(str);
    }

    public static boolean strIsEmpty(String ... value) {
        for (String str : value) {
            if (!AnalysisCommTools.strIsEmpty(str)) continue;
            return true;
        }
        return false;
    }

    public static long getPrimaryKey() {
        Sequence sequence = Sequence.getInstance();
        return sequence.nextId();
    }

    public static boolean isEffNumeric(String str) {
        if (AnalysisCommTools.strIsEmpty(str)) {
            return false;
        }
        int i = str.length();
        while (--i >= 0) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return !str.startsWith("0");
    }

    public static boolean isNumeric(String str) {
        if (AnalysisCommTools.strIsEmpty(str)) {
            return false;
        }
        String str1 = str.trim();
        int i = str1.length();
        while (--i >= 0) {
            if (Character.isDigit(str1.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean strIsChinese(String word) {
        int j;
        if (AnalysisCommTools.strIsEmpty(word)) {
            return false;
        }
        int i = word.getBytes().length;
        return i != (j = word.length());
    }

    public static boolean isEngilsh(String word) {
        if (AnalysisCommTools.strIsEmpty(word)) {
            return false;
        }
        String reg = "^[a-zA-Z0-9]+$";
        return word.matches(reg);
    }

    public static Boolean getIsOpen(CacheClient cacheClient, String key) {
        Boolean isOpen = false;
        try {
            String vaule = cacheClient.hget("{SEARCH}_CONFIG", key);
            if ("1".equals(vaule)) {
                isOpen = true;
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6392\u5e8f\u914d\u7f6e\u5f02\u5e38\uff0ckey:{}\uff0cerr:{}", (Object)key, (Object)e.getMessage());
            isOpen = false;
        }
        return isOpen;
    }

    public static Double getNum(CacheClient cacheClient, String key, Double defaultValue) {
        Double num;
        try {
            String str = cacheClient.hget("{SEARCH}_CONFIG", key);
            num = Double.parseDouble(str);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6392\u5e8f\u914d\u7f6e\u5f02\u5e38\uff0ckey:{}\uff0cerr:{}", (Object)key, (Object)e.getMessage());
            num = defaultValue;
        }
        return num;
    }

    public static List<Long> sort(Map<Long, Float> skuIdMap) {
        ArrayList<Map.Entry<Long, Float>> list = new ArrayList<Map.Entry<Long, Float>>(skuIdMap.entrySet());
        list.sort((o1, o2) -> {
            if (((Float)o2.getValue()).floatValue() > ((Float)o1.getValue()).floatValue()) {
                return 1;
            }
            if (((Float)o2.getValue()).equals(o1.getValue())) {
                return 0;
            }
            return -1;
        });
        ArrayList<Long> resList = new ArrayList<Long>();
        for (Map.Entry entry : list) {
            resList.add((Long)entry.getKey());
        }
        return resList;
    }

    public static List<Long> sort(Map<Long, JSONObject> skuIdMap, Boolean checkBlankCollapse) {
        ArrayList<Map.Entry<Long, JSONObject>> list = new ArrayList<Map.Entry<Long, JSONObject>>(skuIdMap.entrySet());
        list.sort((o1, o2) -> {
            if (((JSONObject)o2.getValue()).getFloat("score").floatValue() > ((JSONObject)o1.getValue()).getFloat("score").floatValue()) {
                return 1;
            }
            if (((JSONObject)o2.getValue()).getFloat("score").equals(((JSONObject)o1.getValue()).getFloat("score"))) {
                return 0;
            }
            return -1;
        });
        ArrayList commodiryIdList = new ArrayList();
        ArrayList<Long> resList = new ArrayList<Long>();
        for (Map.Entry entry : list) {
            if (checkBlankCollapse.booleanValue()) {
                if (commodiryIdList.contains(((JSONObject)entry.getValue()).getLong("commodity_id"))) continue;
                commodiryIdList.add(entry.getKey());
                resList.add((Long)entry.getKey());
                continue;
            }
            resList.add((Long)entry.getKey());
        }
        return resList;
    }

    public static SeQuerySkuBO jsonToSkuBO(JSONObject o) {
        o.remove((Object)"material_id");
        Long l4MgCategoryId = o.getLong("l4mg_category_id");
        o.remove((Object)"l4mg_category_id");
        Integer skuType = o.getInteger("sku_type");
        o.remove((Object)"sku_type");
        Integer bindStatus = o.getInteger("bind_status");
        o.remove((Object)"bind_status");
        if (!AnalysisCommTools.strIsEmpty(o.getString("on_shelve_time")) && !AnalysisCommTools.isEffNumeric(o.getString("on_shelve_time"))) {
            Date d = o.getDate("on_shelve_time");
            o.remove((Object)"on_shelve_time");
            try {
                o.put("on_shelve_time", (Object)d.getTime());
            }
            catch (Exception e) {
                logger.info("\u65f6\u95f4\u5b57\u7b26\u4e32\u8f6clong\u5f02\u5e38\uff0cerr:{}", (Object)e.getMessage());
            }
        }
        AnalysisCommTools.dealList(o, "l1_category_id");
        AnalysisCommTools.dealList(o, "l2_category_id");
        AnalysisCommTools.dealList(o, "l3_category_id");
        AnalysisCommTools.dealList(o, "channel_id");
        AnalysisCommTools.dealList(o, "skuPoolIds");
        AnalysisCommTools.dealList(o, "l1_category_name");
        AnalysisCommTools.dealList(o, "l2_category_name");
        AnalysisCommTools.dealList(o, "l3_category_name");
        AnalysisCommTools.dealList(o, "channel_Name");
        SeQuerySkuBO seQuerySkuBO = (SeQuerySkuBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)o), SeQuerySkuBO.class);
        return seQuerySkuBO;
    }

    public static AnalysisSkuBO jsonToAnalysisSkuBO(JSONObject jsonObject) {
        try {
            SeQuerySkuBO seQuerySkuBO = AnalysisCommTools.jsonToSkuBO(jsonObject);
            AnalysisSkuBO analysisSkuBO = new AnalysisSkuBO();
            PropertyUtils.copyProperties((Object)analysisSkuBO, (Object)seQuerySkuBO);
            analysisSkuBO.setTypeName(jsonObject.getString("type_name"));
            analysisSkuBO.setVectorScore(jsonObject.getDouble("vectorScore"));
            analysisSkuBO.setSimilarityScore(jsonObject.getDouble("similarityScore"));
            analysisSkuBO.setSimilaritySigmoidScore(jsonObject.getDouble("similaritySigmoidScore"));
            analysisSkuBO.setEsScore(jsonObject.getDouble("esScore"));
            analysisSkuBO.setSimilarityFieldScoreList((List)jsonObject.getObject("similarityFieldScoreList", ArrayList.class));
            analysisSkuBO.setCatelogScore(jsonObject.getDouble("catelogScore"));
            analysisSkuBO.setCatelogScoreMap((Map)jsonObject.getObject("catelogScoreMap", HashMap.class));
            analysisSkuBO.setDataCatelogScoreMap((Map)jsonObject.getObject("dataCatelogScoreMap", HashMap.class));
            analysisSkuBO.setWordWeightScore(jsonObject.getDouble("wordWeightScore"));
            analysisSkuBO.setWordScore(jsonObject.getDouble("wordScore"));
            analysisSkuBO.setDataCatelogScore(jsonObject.getDouble("dataCatelogScore"));
            analysisSkuBO.setWordWeightDataCatelogMap((Map)jsonObject.getObject("wordWeightDataCatelogMap", HashMap.class));
            analysisSkuBO.setWordList((List)jsonObject.getObject("wordList", ArrayList.class));
            analysisSkuBO.setSynonymList((List)jsonObject.getObject("synonymList", ArrayList.class));
            analysisSkuBO.setWordCharScore(jsonObject.getDouble("wordCharScore"));
            analysisSkuBO.setWordCharList((List)jsonObject.getObject("wordCharList", ArrayList.class));
            analysisSkuBO.setCharScore(jsonObject.getDouble("charScore"));
            analysisSkuBO.setCharList((List)jsonObject.getObject("charList", ArrayList.class));
            analysisSkuBO.setNerCategoryName(jsonObject.getString("ner_category_name"));
            analysisSkuBO.setEntityMatchScore(jsonObject.getDouble("entityMatchScore"));
            return analysisSkuBO;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public static void dealSeQuerySkuBO(SeQuerySkuBO seQuerySkuBO) {
    }

    public static List<String> getReplaceSubStr(String allStr, String subStr, List<String> analyerList) {
        HashSet<String> replaceSubStrSet = new HashSet<String>();
        ArrayList<String> al = new ArrayList<String>();
        if (!AnalysisCommTools.strIsEmpty(allStr, subStr)) {
            Matcher matcher = Pattern.compile("[a-zA-Z0-9\\p{Punct}]+").matcher(subStr);
            while (matcher.find()) {
                String a = "";
                char[] chars = matcher.group().toCharArray();
                for (int i = 0; i < chars.length; ++i) {
                    a = a + AnalysisCommTools.getReplaceStr(String.valueOf(chars[i]));
                }
                al.add(a);
            }
            Matcher matcher1 = Pattern.compile("[a-zA-Z]+").matcher(subStr);
            while (matcher1.find()) {
                al.add(matcher1.group());
            }
            Matcher matcher2 = Pattern.compile("[0-9]+").matcher(subStr);
            while (matcher2.find()) {
                al.add(matcher2.group());
            }
            if (analyerList != null && analyerList.size() > 0) {
                al.addAll(analyerList);
            }
            if (!subStr.equals("()")) {
                Pattern p = Pattern.compile("(?i)" + AnalysisCommTools.getReplaceStr(subStr));
                Matcher m = p.matcher(allStr);
                while (m.find()) {
                    replaceSubStrSet.add(m.group(0));
                }
            }
            for (String s : al) {
                if (subStr.equals("()")) continue;
                Pattern ap = Pattern.compile("(?i)" + AnalysisCommTools.getReplaceStr(s));
                Matcher am = ap.matcher(allStr);
                while (am.find()) {
                    replaceSubStrSet.add(am.group(0));
                }
            }
        }
        ArrayList<String> replaceSubStrList = new ArrayList<String>();
        if (replaceSubStrSet.size() > 0) {
            replaceSubStrList.addAll(replaceSubStrSet);
            replaceSubStrList.sort((o1, o2) -> {
                if (o1.length() > o2.length()) {
                    return -1;
                }
                if (o1.length() == o2.length()) {
                    return 0;
                }
                return 1;
            });
        }
        return replaceSubStrList;
    }

    private static String getReplaceStr(String oldStr) {
        if (!AnalysisCommTools.strIsEmpty(oldStr)) {
            String newStr = "";
            for (char c : oldStr.toCharArray()) {
                newStr = "$()*+.[]?^{}|".contains(String.valueOf(c)) || "\\".equals(String.valueOf(c)) ? newStr + "\\" + c : newStr + c;
            }
            return newStr;
        }
        return oldStr;
    }

    public static List<String> dealList(JSONObject o, String field) {
        List<String> list = new ArrayList<String>();
        String s = o.getString(field);
        if (!AnalysisCommTools.strIsEmpty(s)) {
            if (!s.startsWith("[") || !s.endsWith("]")) {
                list.add(s);
                o.put(field, list);
            } else {
                list = (List)JSONObject.parseObject((String)s, List.class);
            }
        }
        return list;
    }

    public static String formatDate(Date date, String ... patterns) {
        String pattern = patterns == null || patterns.length < 1 ? defaultFormat : patterns[0];
        SimpleDateFormat dft = new SimpleDateFormat(pattern, Locale.CHINA);
        return dft.format(date);
    }

    public static double sigmoid(double value, float maxValue, float minValue) {
        double k = 0.29000000000000004 / (double)(maxValue - minValue);
        return 0.7 + k * ((double)maxValue - value);
    }

    public static String getIndexName(CacheClient cacheClient, String key) {
        String index = cacheClient.hget("{SEARCH}_INDEX", key);
        if (AnalysisCommTools.strIsEmpty(index)) {
            throw new BusinessException("-9999", "\u4e0d\u5b58\u5728\u53ef\u7528\u7d22\u5f15\uff0c\u67e5\u8be2\u5931\u8d25\uff01");
        }
        return index;
    }

    public static String countOccurrences(String str, String subStr) {
        String s = "";
        int lastIndex = 0;
        while (lastIndex != -1) {
            if ((lastIndex = str.indexOf(subStr, lastIndex)) == -1) continue;
            s = s + subStr;
            lastIndex += subStr.length();
        }
        return s;
    }

    public static Boolean occurrences(Collection<String> collection, String str) {
        if (collection != null && !AnalysisCommTools.strIsEmpty(str)) {
            if (collection.stream().anyMatch(str::equalsIgnoreCase)) {
                return true;
            }
        }
        return false;
    }

    public static Boolean occurrences(Collection<String> collection, List<String> list) {
        if (collection != null && list != null && list.size() > 0) {
            for (String str : list) {
                Boolean flag = AnalysisCommTools.occurrences(collection, str);
                if (!flag.booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public static void main(String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("AbCd");
        list.add("aBcD");
        Stream<Object> stream = list.stream();
        for (int i = 1; i < list.size(); ++i) {
            stream = stream.flatMap(str -> list.stream().filter(temp -> !str.contains((CharSequence)temp)).map(str::concat));
        }
        System.out.println(stream.collect(Collectors.toList()));
    }
}

