/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.normalized.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.se.search.config.SearchProcessConfig;
import com.tydic.se.search.normalized.AnalyzerTokensService;
import com.tydic.se.search.normalized.TokensMatchIndexService;
import com.tydic.se.search.normalized.UccSearchTextNormalizationBusiService;
import com.tydic.se.search.normalized.bo.AnalyzerTokensBo;
import com.tydic.se.search.normalized.bo.AnalyzerTokensReqBO;
import com.tydic.se.search.normalized.bo.AnalyzerTokensRspBO;
import com.tydic.se.search.normalized.bo.TextNormalizationReqBo;
import com.tydic.se.search.normalized.bo.TextNormalizationRspBo;
import com.tydic.se.search.normalized.bo.TokensMatchIndexReqBO;
import com.tydic.se.search.normalized.bo.TokensMatchIndexRspBO;
import com.tydic.se.search.normalized.enumType.IntentRecognitionServiceEnum;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccSearchTextNormalizationBusiServiceImpl
implements UccSearchTextNormalizationBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccSearchTextNormalizationBusiServiceImpl.class);
    @Autowired
    private Map<String, TokensMatchIndexService> matchIndexServices;
    @Autowired
    private AnalyzerTokensService analyzerTokensService;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private SearchProcessConfig searchProcessConfig;

    public TextNormalizationRspBo normalization(TextNormalizationReqBo reqBo, Long seChannelType) {
        TextNormalizationRspBo rspBo = new TextNormalizationRspBo();
        String defaultQueryStr = reqBo.getQueryStr();
        String queryStr = reqBo.getQueryStr();
        AnalyzerTokensReqBO analyzerTokensReqBO = new AnalyzerTokensReqBO();
        analyzerTokensReqBO.setTokens(reqBo.getQueryStr());
        HashMap<String, AbstractList> matchResultMap = new HashMap<String, AbstractList>(16);
        AnalyzerTokensRspBO rspBO = this.analyzerTokensService.analyzer(analyzerTokensReqBO, seChannelType);
        log.error("es\u5e93\u6587\u672c\u9884\u6d4b\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)rspBO));
        TokensMatchIndexReqBO tokensMatchIndexReqBO = new TokensMatchIndexReqBO();
        String searchPredictiveRowSize = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)seChannelType)).searchPredictiveRowSize;
        if (rspBO.getRows() != null && rspBO.getRows().size() < Integer.parseInt(searchPredictiveRowSize)) {
            defaultQueryStr = ((AnalyzerTokensBo)rspBO.getRows().stream().reduce((first, second) -> second).get()).getToken();
            tokensMatchIndexReqBO.setRows(rspBO.getRows());
            for (Map.Entry<String, TokensMatchIndexService> entry : this.matchIndexServices.entrySet()) {
                List matchResultBos;
                Set<String> tagNames;
                IntentRecognitionServiceEnum serviceEnum = IntentRecognitionServiceEnum.getServiceEnum((String)entry.getKey());
                ArrayList matchNames = new ArrayList();
                TokensMatchIndexRspBO indexRspBO = entry.getValue().match(tokensMatchIndexReqBO, seChannelType);
                if (!"0000".equals(indexRspBO.getRespCode())) continue;
                if (!CollectionUtils.isEmpty((Collection)indexRspBO.getMatchBos()) && !CollectionUtils.isEmpty(tagNames = (matchResultBos = indexRspBO.getMatchBos()).stream().map(a -> a.getTagName()).collect(Collectors.toSet()))) {
                    if (serviceEnum != null && serviceEnum.equals((Object)IntentRecognitionServiceEnum.BRAND)) {
                        try {
                            HashSet mallBrandName = new HashSet();
                            HashSet brandName = new HashSet();
                            tagNames.forEach(each -> {
                                Object object = this.cacheClient.get("ucc_mall_brand_cache" + each);
                                if (object != null) {
                                    mallBrandName.add(JSON.toJSONString((Object)object));
                                } else {
                                    brandName.add(each);
                                }
                            });
                            if (!CollectionUtils.isEmpty(mallBrandName)) {
                                matchNames.addAll(mallBrandName);
                            }
                            if (!CollectionUtils.isEmpty(brandName)) {
                                matchNames.addAll(brandName);
                            }
                        }
                        catch (Exception e) {
                            matchNames.addAll(tagNames);
                            log.error(e.getMessage());
                        }
                    } else {
                        matchNames.addAll(tagNames);
                    }
                }
                matchResultMap.put(entry.getKey(), matchNames);
            }
        }
        if (StringUtils.isEmpty((Object)queryStr.trim())) {
            queryStr = defaultQueryStr;
            rspBo.setIsNull(Boolean.valueOf(true));
        }
        if (CollectionUtils.isEmpty(matchResultMap)) {
            matchResultMap.put("analyzerCatalogIndexService", new LinkedList());
            matchResultMap.put("analyzerBrandIndexService", new LinkedList());
            matchResultMap.put("analyzerVendorIndexService", new LinkedList());
        }
        rspBo.setMatchResultMap(matchResultMap);
        rspBo.setQueryStr(queryStr);
        return rspBo;
    }
}

