/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.sort.impl;

import com.tydic.se.base.SeBusinessException;
import com.tydic.se.base.ability.bo.qa.InsertFileDataBO;
import com.tydic.se.base.ability.bo.qa.req.QueryAnalysisFileUploadReqBO;
import com.tydic.se.base.ability.bo.qa.req.QueryAnalysisFilesListPO;
import com.tydic.se.base.dao.QueryAnalysisFilesListMapper;
import com.tydic.se.search.normalized.AnalyzerTokensService;
import com.tydic.se.search.normalized.bo.AnalyzerTokensBo;
import com.tydic.se.search.normalized.bo.AnalyzerTokensReqBO;
import com.tydic.se.search.normalized.bo.AnalyzerTokensRspBO;
import com.tydic.se.search.sort.QueryAnalysisSingleAtomService;
import com.tydic.se.search.sort.bo.QueryAnalysisReqBO;
import com.tydic.se.search.sort.exception.SearchSortException;
import com.tydic.se.search.util.FileUpLoad;
import com.tydic.se.search.util.SnowflakeIdWorker;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class QueryAnalysisSingleAtomServiceImpl
implements QueryAnalysisSingleAtomService {
    private static final Logger log = LoggerFactory.getLogger(QueryAnalysisSingleAtomServiceImpl.class);
    @Autowired
    private AnalyzerTokensService analyzerTokensService;
    @Autowired
    private FileUpLoad fileUpLoad;
    @Autowired
    private QueryAnalysisFilesListMapper queryAnalysisFilesListMapper;

    public List<String> getQueryAnalysisParticiple(QueryAnalysisReqBO queryAnalysisReqBO, Long seChannelType) {
        try {
            AnalyzerTokensReqBO reqBO = new AnalyzerTokensReqBO();
            reqBO.setTokens(queryAnalysisReqBO.getQueryConditions());
            AnalyzerTokensRspBO rspBO = this.analyzerTokensService.analyzer(reqBO, seChannelType);
            ArrayList analyzerTokensBos = new ArrayList(rspBO.getRows());
            LinkedList<String> stringList = new LinkedList<String>();
            if (!CollectionUtils.isEmpty(analyzerTokensBos)) {
                for (AnalyzerTokensBo analyzerTokensBo : analyzerTokensBos) {
                    stringList.add(analyzerTokensBo.getToken());
                }
            }
            return stringList;
        }
        catch (Exception e) {
            log.error("{}{}{}", new Object[]{"9999", "\u5206\u8bcd\u83b7\u53d6\u5931\u8d25\uff01", e});
            throw new SearchSortException("9999", "\u5206\u8bcd\u83b7\u53d6\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    public String fileUpload(QueryAnalysisFileUploadReqBO queryAnalysisFileUploadReqBO) throws Exception {
        try {
            String[] fileNameParts = queryAnalysisFileUploadReqBO.getFileName().split("\\.");
            String fileExtension = fileNameParts.length > 1 ? "." + fileNameParts[fileNameParts.length - 1] : "";
            String fileNameWithoutExt = queryAnalysisFileUploadReqBO.getFileName().replace(fileExtension, "");
            String fileUrl = this.fileUpLoad.upload(fileNameWithoutExt, queryAnalysisFileUploadReqBO.getFile(), fileExtension);
            log.info("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f: {}, URL: {}", (Object)queryAnalysisFileUploadReqBO.getFileName(), (Object)fileUrl);
            return fileUrl;
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25: {}", (Object)queryAnalysisFileUploadReqBO.getFileName(), (Object)e);
            throw new SearchSortException("9999", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25: " + e.getMessage(), (Throwable)e);
        }
    }

    public int insertFileData(InsertFileDataBO insertFileDataBO) throws Exception {
        try {
            QueryAnalysisFilesListPO queryAnalysisFilesListPO = new QueryAnalysisFilesListPO();
            if (insertFileDataBO == null) {
                throw new SeBusinessException("\u6587\u4ef6\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            }
            BeanUtils.copyProperties((Object)insertFileDataBO, (Object)queryAnalysisFilesListPO);
            queryAnalysisFilesListPO.setId(this.generateIntKey());
            int result = this.queryAnalysisFilesListMapper.insert(queryAnalysisFilesListPO);
            log.info("\u6587\u4ef6\u6570\u636e\u63d2\u5165\u6210\u529f: {}, \u5f71\u54cd\u884c\u6570: {}", (Object)insertFileDataBO.getFilename(), (Object)result);
            return result;
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u6570\u636e\u63d2\u5165\u5931\u8d25: {}", (Object)insertFileDataBO.getFilename(), (Object)e);
            throw new SearchSortException("9999", "\u6587\u4ef6\u6570\u636e\u63d2\u5165\u5931\u8d25: " + e.getMessage(), (Throwable)e);
        }
    }

    private Long generateIntKey() {
        SnowflakeIdWorker tableCodeSequence = new SnowflakeIdWorker(1L, 1L);
        Long tableCode = tableCodeSequence.nextId();
        return tableCode;
    }
}

