/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.sort.impl;

import com.tydic.se.base.ability.bo.SeComSortBO;
import com.tydic.se.base.ability.bo.SeQuerySkuBO;
import com.tydic.se.base.ability.bo.SeSearchReqBO;
import com.tydic.se.base.ability.bo.SeSearchRspBO;
import com.tydic.se.search.annotation.SearchLinkLog;
import com.tydic.se.search.config.SearchProcessConfig;
import com.tydic.se.search.sort.SearchCommoditySpecifySortService;
import com.tydic.se.search.sort.bo.SearchSortMsgBo;
import com.tydic.se.search.sort.exception.SearchSortException;
import com.tydic.se.search.sort.impl.steps.api.SearchStepEarmarkSortService;
import com.tydic.se.search.sort.impl.steps.api.SearchStepFusionAddService;
import com.tydic.se.search.sort.impl.steps.api.SearchStepSupplierDisruptService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SearchCommoditySpecifySortServiceImpl
implements SearchCommoditySpecifySortService {
    private static final Logger log = LoggerFactory.getLogger(SearchCommoditySpecifySortServiceImpl.class);
    @Autowired
    private SearchProcessConfig searchProcessConfig;
    @Autowired
    private SearchStepEarmarkSortService searchStepEarmarkSortService;
    @Autowired
    private SearchStepFusionAddService searchStepFusionAddService;
    @Autowired
    private SearchStepSupplierDisruptService searchStepSupplierDisruptService;

    @SearchLinkLog(desc="\u7279\u5f81\u6392\u5e8f")
    public SeSearchRspBO specifySort(SeSearchRspBO rspBo, SeSearchReqBO reqBo, SearchSortMsgBo searchSortMsgBo) throws SearchSortException {
        try {
            if (searchSortMsgBo.isSalesPriceJudge()) {
                this.sortPriceSort(rspBo, searchSortMsgBo);
            }
            Boolean seComSortExist = searchSortMsgBo.getComSortList().stream().anyMatch(seComSortBO -> "_score".equals(seComSortBO.getOrderByColumn()));
            Boolean seComSortPosition = !searchSortMsgBo.getComSortList().isEmpty() && "_score".equals(((SeComSortBO)searchSortMsgBo.getComSortList().get(0)).getOrderByColumn());
            String globalProductFiltering = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)searchSortMsgBo.getSeChannelType())).searchGlobalProductFiltering;
            Boolean seComSort = Objects.equals(globalProductFiltering, "1") ? Boolean.TRUE : Boolean.TRUE.equals(seComSortExist) && Boolean.TRUE.equals(seComSortPosition);
            log.info("{}{}\u542f\u52a8\u6743\u91cd\u503c\u76f8\u7b49\u65f6\u6392\u5e8f:{}", new Object[]{">>>\u7279\u5f81\u6392\u5e8f", ">>>TXT>>>", seComSort});
            int weightSort = 0;
            if (Boolean.TRUE.equals(seComSortExist) && Boolean.TRUE.equals(seComSortPosition) && !CollectionUtils.isEmpty((Collection)searchSortMsgBo.getComSortList()) && ((SeComSortBO)searchSortMsgBo.getComSortList().get(0)).getOrderType().equals(1)) {
                Collections.reverse(rspBo.getSkuList());
                weightSort = 1;
            }
            if (!CollectionUtils.isEmpty((Collection)searchSortMsgBo.getComSortList()) && searchSortMsgBo.getComSortList().size() == 1 && !"_score".equals(((SeComSortBO)searchSortMsgBo.getComSortList().get(0)).getOrderByColumn())) {
                seComSort = Boolean.FALSE;
                log.info("{}{}\u6307\u5b9a\u6392\u5e8f\u4e0d\u8fdb\u884c\u542f\u52a8\u6743\u91cd\u503c\u76f8\u7b49\u65f6\u6392\u5e8f\uff01", (Object)">>>\u7279\u5f81\u6392\u5e8f", (Object)">>>TXT>>>");
            }
            String earmarkEnable = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)searchSortMsgBo.getSeChannelType())).searchSortEarmarkEnable;
            if (!CollectionUtils.isEmpty((Collection)searchSortMsgBo.getComSortList()) && searchSortMsgBo.getComSortList().size() == 1 && Objects.equals(earmarkEnable, "1")) {
                this.searchStepEarmarkSortService.earmarkSort(rspBo, searchSortMsgBo, seComSort, weightSort);
            }
            if (Boolean.TRUE.equals(seComSortPosition)) {
                if (Boolean.TRUE.equals(searchSortMsgBo.getSortFusion())) {
                    rspBo = this.searchStepFusionAddService.fusionSorting(rspBo, searchSortMsgBo.getRecSkuList(), reqBo.getRecProductReqBO(), searchSortMsgBo);
                    return rspBo;
                }
                return rspBo;
            }
            log.info("{}{}\u6307\u5b9a\u6392\u5e8f\u540e\u5546\u54c1\u6570\u91cf{}{}", new Object[]{">>>\u7279\u5f81\u6392\u5e8f", ">>>TXT>>>", ">>>", rspBo.getSkuList().size()});
            return rspBo;
        }
        catch (SearchSortException e) {
            log.error("{}{}{}", new Object[]{"9999", "\u6307\u5b9a\u6392\u5e8f\uff01", e});
            throw new SearchSortException("9999", "\u6307\u5b9a\u6392\u5e8f\uff01", (Throwable)e);
        }
    }

    private void sortPriceSort(SeSearchRspBO rspBo, SearchSortMsgBo searchSortMsgBo) throws SearchSortException {
        LinkedList<SeQuerySkuBO> seQuerySkuBOList = new LinkedList<SeQuerySkuBO>();
        BigDecimal min = new BigDecimal(searchSortMsgBo.getMinSalesPrice().toString());
        BigDecimal max = new BigDecimal(searchSortMsgBo.getMaxSalesPrice().toString());
        for (SeQuerySkuBO seQuerySkuBO : rspBo.getSkuList()) {
            try {
                BigDecimal tmp = new BigDecimal(String.valueOf(seQuerySkuBO.getSalePrice()));
                if (max.equals(new BigDecimal(String.valueOf(0)))) {
                    if (tmp.compareTo(min) < 0) continue;
                    seQuerySkuBOList.add(seQuerySkuBO);
                    continue;
                }
                if (tmp.compareTo(min) < 0 || tmp.compareTo(max) >= 0) continue;
                seQuerySkuBOList.add(seQuerySkuBO);
            }
            catch (Exception exception) {}
        }
        log.info("\u539f\u6709\u6570\u636e{}\u6761\uff0c\u6307\u5b9a\u4ef7\u683c\u533a\u95f4\u6392\u5e8f\u540e\u6709{}\u6761\uff01", (Object)rspBo.getSkuList().size(), (Object)seQuerySkuBOList.size());
        rspBo.setSkuList(seQuerySkuBOList);
    }
}

