/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.sort.impl;

import cn.hutool.poi.excel.ExcelReader;
import cn.hutool.poi.excel.ExcelUtil;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.se.search.sort.QueryAnalysisSingleAtomService;
import com.tydic.se.search.sort.SearchSortWeightCalculation;
import com.tydic.se.search.sort.bo.QueryAnalysisExcelDataBO;
import com.tydic.se.search.sort.bo.QueryAnalysisReqBO;
import com.tydic.se.search.sort.exception.SearchSortException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SearchSortWeightCalculationImpl
implements SearchSortWeightCalculation {
    private static final Logger log = LoggerFactory.getLogger(SearchSortWeightCalculationImpl.class);
    @Autowired
    private QueryAnalysisSingleAtomService queryAnalysisSingleService;
    @Autowired
    private CacheClient cacheClient;
    private int wordTotal = 0;
    private int docTotal = 0;
    private Map<String, Double> tf = new HashMap<String, Double>();
    private Map<String, Double> idf = new HashMap<String, Double>();
    private Map<String, Double> iwf = new HashMap<String, Double>();
    private File file;

    public void TF_IDF(File file) {
        List<List<String>> query = this.readExcel(file);
        this.statistics(query);
    }

    private void statistics(List<List<String>> query) {
        this.docTotal = query.size();
        query.forEach(list -> {
            list.forEach(str -> {
                if (!this.iwf.containsKey(str)) {
                    this.iwf.put((String)str, 0.0);
                }
                this.iwf.put((String)str, this.iwf.get(str) + 1.0);
                ++this.wordTotal;
            });
            list = list.stream().distinct().collect(Collectors.toList());
            list.forEach(str -> {
                if (!this.idf.containsKey(str)) {
                    this.idf.put((String)str, 0.0);
                }
                this.idf.put((String)str, this.idf.get(str) + 1.0);
            });
        });
        this.iwf.replaceAll((k, v) -> Math.log((double)this.wordTotal / this.iwf.get(k)));
        this.idf.replaceAll((k, v) -> Math.log((double)this.docTotal / (this.idf.get(k) + 1.0)));
    }

    public List<List<String>> readExcel(File fileName) throws SearchSortException {
        try {
            ArrayList<List<String>> excelDataBOList = new ArrayList<List<String>>();
            ExcelReader reader = ExcelUtil.getReader((File)fileName);
            List readAll = reader.readAll();
            Long seChannelType = (Long)this.cacheClient.get("{SEARCH}_DEFAULT_CHANNEL_TYPE");
            for (int i = 0; i < readAll.size(); ++i) {
                reader = ExcelUtil.getReader((File)fileName, (int)i);
                reader.addHeaderAlias("\u7f16\u53f7", "num");
                reader.addHeaderAlias("\u641c\u7d22\u8bcd", "queryConditions");
                reader.addHeaderAlias("\u5206\u8bcd\u7ed3\u679c", "participle");
                reader.addHeaderAlias("\u5546\u54c1\u540d\u79f0", "commodityName");
                List excelDataBOS = reader.readAll(QueryAnalysisExcelDataBO.class);
                excelDataBOS.forEach(data -> {
                    String commodityName = data.getCommodityName();
                    QueryAnalysisReqBO queryAnalysisReqBO = new QueryAnalysisReqBO();
                    queryAnalysisReqBO.setQueryConditions(commodityName);
                    List participle = this.queryAnalysisSingleService.getQueryAnalysisParticiple(queryAnalysisReqBO, seChannelType);
                    excelDataBOList.add(participle);
                });
            }
            return excelDataBOList;
        }
        catch (SearchSortException e) {
            log.error("{}{}{}", new Object[]{"9999", "TF-IDF \u521d\u59cb\u5316xlsx\u89e3\u6790\u5931\u8d25\uff01", e});
            throw new SearchSortException("9999", "TF-IDF \u521d\u59cb\u5316xlsx\u89e3\u6790\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    public QueryAnalysisSingleAtomService getQueryAnalysisSingleService() {
        return this.queryAnalysisSingleService;
    }

    public CacheClient getCacheClient() {
        return this.cacheClient;
    }

    public int getWordTotal() {
        return this.wordTotal;
    }

    public int getDocTotal() {
        return this.docTotal;
    }

    public Map<String, Double> getTf() {
        return this.tf;
    }

    public Map<String, Double> getIdf() {
        return this.idf;
    }

    public Map<String, Double> getIwf() {
        return this.iwf;
    }

    public File getFile() {
        return this.file;
    }

    public void setQueryAnalysisSingleService(QueryAnalysisSingleAtomService queryAnalysisSingleService) {
        this.queryAnalysisSingleService = queryAnalysisSingleService;
    }

    public void setCacheClient(CacheClient cacheClient) {
        this.cacheClient = cacheClient;
    }

    public void setWordTotal(int wordTotal) {
        this.wordTotal = wordTotal;
    }

    public void setDocTotal(int docTotal) {
        this.docTotal = docTotal;
    }

    public void setTf(Map<String, Double> tf) {
        this.tf = tf;
    }

    public void setIdf(Map<String, Double> idf) {
        this.idf = idf;
    }

    public void setIwf(Map<String, Double> iwf) {
        this.iwf = iwf;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchSortWeightCalculationImpl)) {
            return false;
        }
        SearchSortWeightCalculationImpl other = (SearchSortWeightCalculationImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        QueryAnalysisSingleAtomService this$queryAnalysisSingleService = this.getQueryAnalysisSingleService();
        QueryAnalysisSingleAtomService other$queryAnalysisSingleService = other.getQueryAnalysisSingleService();
        if (this$queryAnalysisSingleService == null ? other$queryAnalysisSingleService != null : !this$queryAnalysisSingleService.equals(other$queryAnalysisSingleService)) {
            return false;
        }
        CacheClient this$cacheClient = this.getCacheClient();
        CacheClient other$cacheClient = other.getCacheClient();
        if (this$cacheClient == null ? other$cacheClient != null : !this$cacheClient.equals(other$cacheClient)) {
            return false;
        }
        if (this.getWordTotal() != other.getWordTotal()) {
            return false;
        }
        if (this.getDocTotal() != other.getDocTotal()) {
            return false;
        }
        Map<String, Double> this$tf = this.getTf();
        Map<String, Double> other$tf = other.getTf();
        if (this$tf == null ? other$tf != null : !((Object)this$tf).equals(other$tf)) {
            return false;
        }
        Map<String, Double> this$idf = this.getIdf();
        Map<String, Double> other$idf = other.getIdf();
        if (this$idf == null ? other$idf != null : !((Object)this$idf).equals(other$idf)) {
            return false;
        }
        Map<String, Double> this$iwf = this.getIwf();
        Map<String, Double> other$iwf = other.getIwf();
        if (this$iwf == null ? other$iwf != null : !((Object)this$iwf).equals(other$iwf)) {
            return false;
        }
        File this$file = this.getFile();
        File other$file = other.getFile();
        return !(this$file == null ? other$file != null : !((Object)this$file).equals(other$file));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SearchSortWeightCalculationImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        QueryAnalysisSingleAtomService $queryAnalysisSingleService = this.getQueryAnalysisSingleService();
        result = result * 59 + ($queryAnalysisSingleService == null ? 43 : $queryAnalysisSingleService.hashCode());
        CacheClient $cacheClient = this.getCacheClient();
        result = result * 59 + ($cacheClient == null ? 43 : $cacheClient.hashCode());
        result = result * 59 + this.getWordTotal();
        result = result * 59 + this.getDocTotal();
        Map<String, Double> $tf = this.getTf();
        result = result * 59 + ($tf == null ? 43 : ((Object)$tf).hashCode());
        Map<String, Double> $idf = this.getIdf();
        result = result * 59 + ($idf == null ? 43 : ((Object)$idf).hashCode());
        Map<String, Double> $iwf = this.getIwf();
        result = result * 59 + ($iwf == null ? 43 : ((Object)$iwf).hashCode());
        File $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
        return result;
    }

    public String toString() {
        return "SearchSortWeightCalculationImpl(queryAnalysisSingleService=" + this.getQueryAnalysisSingleService() + ", cacheClient=" + this.getCacheClient() + ", wordTotal=" + this.getWordTotal() + ", docTotal=" + this.getDocTotal() + ", tf=" + this.getTf() + ", idf=" + this.getIdf() + ", iwf=" + this.getIwf() + ", file=" + this.getFile() + ")";
    }
}

