/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.sort.impl.steps;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.se.base.SeBusinessException;
import com.tydic.se.base.ability.bo.SeEsbVendorBo;
import com.tydic.se.base.ability.bo.SeQuerySkuBO;
import com.tydic.se.base.ability.bo.SeSearchReqBO;
import com.tydic.se.base.ability.bo.SeSearchRspBO;
import com.tydic.se.search.annotation.SearchLinkLog;
import com.tydic.se.search.config.SearchProcessConfig;
import com.tydic.se.search.sort.impl.steps.api.SearchStepCheckAreaLimitRecallService;
import com.tydic.se.search.util.esb.ESBParamUtil;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class SearchStepCheckAreaLimitRecallServiceImpl
implements SearchStepCheckAreaLimitRecallService {
    private static final Logger log = LoggerFactory.getLogger(SearchStepCheckAreaLimitRecallServiceImpl.class);
    @Value(value="${search.recall.checkAreaLimit.url:${ESB_ACCESS_IP}/OSN/api/checkAreaLimit/v1}")
    private String checkAreaLimitUrl;
    @Autowired
    private SearchProcessConfig searchProcessConfig;

    @Override
    @SearchLinkLog(desc="\u533a\u57df\u9650\u5236\u8fc7\u6ee4")
    public void checkAreaLimitRecall(SeSearchReqBO reqBO, SeSearchRspBO rspBO, List<String> checkAreaLimitSkuIdList, List<SeEsbVendorBo> esbVendorBoList) {
        try {
            List skuList = rspBO.getSkuList();
            HashMap<String, List<JSONArray>> checkAreaLimitMap = new HashMap<String, List<JSONArray>>();
            for (SeQuerySkuBO sku : skuList) {
                if (sku.getSkuSource() == 2) {
                    List<JSONArray> list;
                    if (checkAreaLimitMap.containsKey(String.valueOf(sku.getSupplierId()))) {
                        list = (List)checkAreaLimitMap.get(String.valueOf(sku.getSupplierId()));
                        String checkAreaLimitSize = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)reqBO.getSeChannelType())).searchRecallCheckAreaLimitSize;
                        if (((JSONArray)list.get(list.size() - 1)).size() == Integer.parseInt(checkAreaLimitSize)) {
                            JSONArray array = new JSONArray();
                            array.add((Object)sku.getExtSkuId());
                            list.add(array);
                        } else {
                            ((JSONArray)list.get(list.size() - 1)).add((Object)sku.getExtSkuId());
                        }
                        checkAreaLimitMap.put(String.valueOf(sku.getSupplierId()), list);
                        continue;
                    }
                    list = new LinkedList();
                    JSONArray array = new JSONArray();
                    array.add((Object)sku.getExtSkuId());
                    list.add(array);
                    checkAreaLimitMap.put(String.valueOf(sku.getSupplierId()), list);
                    continue;
                }
                checkAreaLimitSkuIdList.add(sku.getExtSkuId());
            }
            String checkAreaLimitNumber = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)reqBO.getSeChannelType())).searchRecallCheckAreaLimitNumber;
            for (int i = 0; i < Math.min(Integer.parseInt(checkAreaLimitNumber), esbVendorBoList.size()); ++i) {
                SeEsbVendorBo esbVendorBo = esbVendorBoList.get(i);
                List checkAreaLimitList = (List)checkAreaLimitMap.get(String.valueOf(esbVendorBo.getVendorId()));
                if (ObjectUtils.isEmpty((Object)checkAreaLimitList)) continue;
                for (JSONArray reqArray : checkAreaLimitList) {
                    JSONObject req = new JSONObject();
                    req.put("skuIds", (Object)reqArray);
                    req.put("province", (Object)esbVendorBo.getProvince());
                    req.put("city", (Object)esbVendorBo.getCity());
                    req.put("county", (Object)(ObjectUtils.isEmpty((Object)esbVendorBo.getCounty()) ? 0L : esbVendorBo.getCounty()));
                    req.put("town", (Object)(ObjectUtils.isEmpty((Object)esbVendorBo.getTown()) ? 0L : esbVendorBo.getTown()));
                    JSONObject rsp = ESBParamUtil.callAbility((String)this.checkAreaLimitUrl, (String)esbVendorBo.getHsn(), (String)req.toJSONString());
                    if (rsp == null || ObjectUtils.isEmpty((Object)rsp.get((Object)"result"))) continue;
                    try {
                        JSONArray result = rsp.getJSONArray("result");
                        for (Object resultOne : result) {
                            JSONObject one = JSON.parseObject((String)JSON.toJSONString(resultOne));
                            if (!Objects.equals(one.get((Object)"isAreaRestrict"), Boolean.FALSE)) continue;
                            checkAreaLimitSkuIdList.add(one.getString("skuId"));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        log.warn("\u4f9b\u5e94\u5546\u8fd4\u56de\u6570\u636e\u5904\u7406\u5f02\u5e38 ex:{} rsp:{}", (Object)e.getMessage(), (Object)rsp);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u4f9b\u5e94\u5546\u533a\u57df\u9650\u5236\u67e5\u8be2\u5f02\u5e38\uff01ex:{}", (Object)e.getMessage());
            e.printStackTrace();
            throw new SeBusinessException("\u4f9b\u5e94\u5546\u533a\u57df\u9650\u5236\u67e5\u8be2\u5f02\u5e38\uff01");
        }
    }
}

