/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.sort.impl.steps;

import com.tydic.se.base.ability.bo.SeComSortBO;
import com.tydic.se.base.ability.bo.SeQuerySkuBO;
import com.tydic.se.base.ability.bo.SeSearchRspBO;
import com.tydic.se.search.annotation.SearchLinkLog;
import com.tydic.se.search.config.SearchProcessConfig;
import com.tydic.se.search.sort.bo.SearchSortMsgBo;
import com.tydic.se.search.sort.bo.SearchSortOrderColumnBo;
import com.tydic.se.search.sort.enumType.SpecifySortMethodEnum;
import com.tydic.se.search.sort.exception.SearchSortException;
import com.tydic.se.search.sort.impl.steps.api.SearchStepEarmarkSortService;
import com.tydic.se.search.sort.impl.steps.utils.SearchStepRelevanceUtil;
import com.tydic.se.search.util.SearchSortUtils;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SearchStepEarmarkSortServiceImpl
implements SearchStepEarmarkSortService {
    private static final Logger log = LoggerFactory.getLogger(SearchStepEarmarkSortServiceImpl.class);
    @Autowired
    private SearchProcessConfig searchProcessConfig;

    @Override
    @SearchLinkLog(desc="\u6307\u5b9a\u6392\u5e8f")
    public void earmarkSort(SeSearchRspBO rspBo, SearchSortMsgBo searchSortMsgBo, Boolean seComSort, int weightSort) throws SearchSortException {
        try {
            List seComSortBOList = searchSortMsgBo.getComSortList();
            Collections.reverse(seComSortBOList);
            for (SeComSortBO seComSortBO : seComSortBOList) {
                String fieldName;
                SearchSortOrderColumnBo searchSortOrderColumnBo = new SearchSortOrderColumnBo();
                searchSortOrderColumnBo.setField(Objects.equals(seComSortBO.getOrderByColumn(), "sale_price") ? "salePrice" : seComSortBO.getOrderByColumn());
                searchSortOrderColumnBo.setOrderType(seComSortBO.getOrderType());
                String string = fieldName = Objects.equals(((SeComSortBO)searchSortMsgBo.getComSortList().get(0)).getOrderByColumn(), "sale_price") ? "salePrice" : ((SeComSortBO)searchSortMsgBo.getComSortList().get(0)).getOrderByColumn();
                if (Boolean.TRUE.equals(SearchStepRelevanceUtil.doesFieldExist(SeQuerySkuBO.class, fieldName))) {
                    log.info("\u5bf9 {} \u5b57\u6bb5\u8fdb\u884c {} \u6392\u5217", (Object)seComSortBO.getOrderByColumn(), (Object)(searchSortOrderColumnBo.getOrderType() == 0 ? "\u964d\u5e8f" : "\u5347\u5e8f"));
                    rspBo.setSkuList(this.commoditySort(rspBo.getSkuList(), searchSortOrderColumnBo, seComSort, weightSort));
                }
                SearchSortUtils.printCustomize(Arrays.asList(rspBo.getSkuList().toArray()), (String)seComSortBO.getOrderByColumn(), (SearchSortMsgBo)searchSortMsgBo);
            }
        }
        catch (SearchSortException e) {
            log.error("{}{}{}", new Object[]{"9999", "\u6570\u636e\u6307\u5b9a\u6392\u5e8f\uff01", e});
            if (Boolean.TRUE.equals(seComSort)) {
                log.error("\u6307\u5b9a\u6392\u5e8f\u5f02\u5e38,\u5ffd\u7565!");
            }
            throw new SearchSortException("9999", "\u6570\u636e\u6307\u5b9a\u6392\u5e8f\uff01", (Throwable)e);
        }
    }

    private List<SeQuerySkuBO> commoditySort(List<SeQuerySkuBO> seQuerySkuBoBoList, final SearchSortOrderColumnBo orderColumn, final Boolean seComSort, final int weightSort) throws SearchSortException {
        try {
            Class<SeQuerySkuBO> clazz = SeQuerySkuBO.class;
            final Field field = this.getDeclaredFieldRecursively(SeQuerySkuBO.class, orderColumn.getField());
            if (orderColumn.getOrderType() == 1) {
                return seQuerySkuBoBoList.stream().sorted(new Comparator<SeQuerySkuBO>(){

                    @Override
                    public int compare(SeQuerySkuBO o1, SeQuerySkuBO o2) {
                        if (Boolean.TRUE.equals(seComSort)) {
                            BigDecimal bd2;
                            if (o1.getWeight().equals(o2.getWeight()) && o1.getSynonymWeight().equals(o2.getSynonymWeight())) {
                                String v1 = String.valueOf(field.get(o1));
                                String v2 = String.valueOf(field.get(o2));
                                v1 = SearchStepEarmarkSortServiceImpl.this.conversionField(v1, o1, orderColumn);
                                v2 = SearchStepEarmarkSortServiceImpl.this.conversionField(v2, o2, orderColumn);
                                BigDecimal bd1 = "null".equals(v1) ? new BigDecimal("0.0") : new BigDecimal(v1);
                                BigDecimal bd22 = "null".equals(v2) ? new BigDecimal("0.0") : new BigDecimal(v2);
                                return bd1.compareTo(bd22);
                            }
                            String v1 = String.valueOf(o1.getWeight());
                            String v2 = String.valueOf(o2.getWeight());
                            v1 = SearchStepEarmarkSortServiceImpl.this.conversionField(v1, o1, orderColumn);
                            v2 = SearchStepEarmarkSortServiceImpl.this.conversionField(v2, o2, orderColumn);
                            BigDecimal bd1 = "null".equals(v1) ? new BigDecimal("0.0") : new BigDecimal(v1);
                            BigDecimal bigDecimal = bd2 = "null".equals(v2) ? new BigDecimal("0.0") : new BigDecimal(v2);
                            if (weightSort == 0) {
                                return bd2.compareTo(bd1);
                            }
                            return bd1.compareTo(bd2);
                        }
                        String v1 = String.valueOf(field.get(o1));
                        String v2 = String.valueOf(field.get(o2));
                        v1 = SearchStepEarmarkSortServiceImpl.this.conversionField(v1, o1, orderColumn);
                        v2 = SearchStepEarmarkSortServiceImpl.this.conversionField(v2, o2, orderColumn);
                        BigDecimal bd1 = "null".equals(v1) ? new BigDecimal("0.0") : new BigDecimal(v1);
                        BigDecimal bd2 = "null".equals(v2) ? new BigDecimal("0.0") : new BigDecimal(v2);
                        return bd1.compareTo(bd2);
                    }
                }).collect(Collectors.toList());
            }
            return seQuerySkuBoBoList.stream().sorted(new Comparator<SeQuerySkuBO>(){

                @Override
                public int compare(SeQuerySkuBO o1, SeQuerySkuBO o2) {
                    if (Boolean.TRUE.equals(seComSort)) {
                        BigDecimal bd2;
                        if (o1.getWeight().equals(o2.getWeight()) && o1.getSynonymWeight().equals(o2.getSynonymWeight())) {
                            String v1 = String.valueOf(field.get(o1));
                            String v2 = String.valueOf(field.get(o2));
                            v1 = SearchStepEarmarkSortServiceImpl.this.conversionField(v1, o1, orderColumn);
                            v2 = SearchStepEarmarkSortServiceImpl.this.conversionField(v2, o2, orderColumn);
                            BigDecimal bd1 = "null".equals(v1) ? new BigDecimal("0.0") : new BigDecimal(v1);
                            BigDecimal bd22 = "null".equals(v2) ? new BigDecimal("0.0") : new BigDecimal(v2);
                            return bd22.compareTo(bd1);
                        }
                        String v1 = String.valueOf(o1.getWeight());
                        String v2 = String.valueOf(o2.getWeight());
                        v1 = SearchStepEarmarkSortServiceImpl.this.conversionField(v1, o1, orderColumn);
                        v2 = SearchStepEarmarkSortServiceImpl.this.conversionField(v2, o2, orderColumn);
                        BigDecimal bd1 = "null".equals(v1) ? new BigDecimal("0.0") : new BigDecimal(v1);
                        BigDecimal bigDecimal = bd2 = "null".equals(v2) ? new BigDecimal("0.0") : new BigDecimal(v2);
                        if (weightSort == 0) {
                            return bd2.compareTo(bd1);
                        }
                        return bd1.compareTo(bd2);
                    }
                    String v1 = String.valueOf(field.get(o1));
                    String v2 = String.valueOf(field.get(o2));
                    v1 = SearchStepEarmarkSortServiceImpl.this.conversionField(v1, o1, orderColumn);
                    v2 = SearchStepEarmarkSortServiceImpl.this.conversionField(v2, o2, orderColumn);
                    BigDecimal bd1 = "null".equals(v1) ? new BigDecimal("0.0") : new BigDecimal(v1);
                    BigDecimal bd2 = "null".equals(v2) ? new BigDecimal("0.0") : new BigDecimal(v2);
                    return bd2.compareTo(bd1);
                }
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new SearchSortException("9999", orderColumn.getField() + "\u5546\u54c1\u6307\u5b9a\u6838\u5fc3\u6392\u5e8f\uff01", (Throwable)e);
        }
    }

    private String conversionField(String value, SeQuerySkuBO skuBO, SearchSortOrderColumnBo orderColumn) {
        String newValue = "null";
        if (value == null || "null".equals(value)) {
            if (SpecifySortMethodEnum.PRICE_SORT.getField().equals(orderColumn.getField())) {
                newValue = String.valueOf(skuBO.getSalePrice());
            }
            return newValue;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss z yyyy", Locale.ENGLISH);
        try {
            ZonedDateTime zonedDateTime = ZonedDateTime.parse(value, formatter);
            long timestamp = zonedDateTime.toInstant().toEpochMilli();
            return String.valueOf(timestamp);
        }
        catch (DateTimeParseException e) {
            return value;
        }
    }

    private Field getDeclaredFieldRecursively(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        while (clazz != null && clazz != Object.class) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException e) {
                clazz = clazz.getSuperclass();
            }
        }
        throw new SearchSortException("9999", "field\u672a\u627e\u5230\uff01");
    }
}

