/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.sort.impl.steps;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.tydic.se.base.ability.bo.SeComSortBO;
import com.tydic.se.base.ability.bo.SeQuerySkuBO;
import com.tydic.se.base.ability.bo.SeSearchRspBO;
import com.tydic.se.base.ability.bo.recommend.RecProductReqBO;
import com.tydic.se.search.annotation.SearchLinkLog;
import com.tydic.se.search.config.SearchProcessConfig;
import com.tydic.se.search.sort.bo.SearchSortMsgBo;
import com.tydic.se.search.sort.impl.steps.api.SearchStepFusionAddService;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class SearchStepFusionAddServiceImpl
implements SearchStepFusionAddService {
    private static final Logger log = LoggerFactory.getLogger(SearchStepFusionAddServiceImpl.class);
    @Autowired
    private SearchProcessConfig searchProcessConfig;

    @Override
    @SearchLinkLog(desc="\u63a8\u8350\u5546\u54c1\u63d2\u5165")
    public SeSearchRspBO fusionSorting(SeSearchRspBO baseBo, List<SeQuerySkuBO> skuList, RecProductReqBO recProductReqBO, SearchSortMsgBo searchSortMsgBo) {
        if (ObjectUtils.isEmpty((Object)recProductReqBO)) {
            return baseBo;
        }
        String recommendationUrl = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)searchSortMsgBo.getSeChannelType())).searchSortRecommendUrl;
        if (StringUtils.isBlank((String)recommendationUrl)) {
            return baseBo;
        }
        if (!ObjectUtils.isEmpty((Object)searchSortMsgBo) && searchSortMsgBo.getComSortList().size() == 1 && !"_score".equals(((SeComSortBO)searchSortMsgBo.getComSortList().get(0)).getOrderByColumn())) {
            return baseBo;
        }
        SeSearchRspBO rspBo = (SeSearchRspBO)JSON.parseObject((String)JSON.toJSONString((Object)baseBo), SeSearchRspBO.class);
        try {
            String sortFusion = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)searchSortMsgBo.getSeChannelType())).searchSortRecommendSortFusion;
            String[] sortFusions = sortFusion.split(";");
            int pageSize = searchSortMsgBo.getPageSize();
            LinkedList<SeQuerySkuBO> baseSkuList = new LinkedList<SeQuerySkuBO>(baseBo.getSkuList());
            Iterator baseSkuIterator = baseSkuList.iterator();
            while (baseSkuIterator.hasNext()) {
                SeQuerySkuBO baseSkuBo = (SeQuerySkuBO)baseSkuIterator.next();
                for (SeQuerySkuBO addSkuBo : skuList) {
                    if (!Objects.equals(addSkuBo.getSkuId(), baseSkuBo.getSkuId())) continue;
                    baseSkuBo.setRecLabelName(addSkuBo.getRecLabelName());
                    baseSkuBo.setRecSceneName(addSkuBo.getRecSceneName());
                    baseSkuBo.setRecSceneId(addSkuBo.getRecSceneId());
                    baseSkuBo.setRecRoleId(addSkuBo.getRecRoleId());
                    BeanMapper.copy((Object)baseSkuBo, (Object)addSkuBo);
                    addSkuBo.setPriPicUrl(baseSkuBo.getPriPicUrl());
                    baseSkuIterator.remove();
                }
            }
            int addCount = 0;
            block4: for (String fusion : sortFusions) {
                String[] adds;
                if (skuList.size() <= 0) continue;
                String[] rule = fusion.split(":");
                int page = Integer.parseInt(rule[0]);
                for (String add : adds = rule[1].split(",")) {
                    if (skuList.size() <= 0) continue block4;
                    int index = (page - 1) * pageSize + (Integer.parseInt(add) - 1);
                    if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)skuList.get(0).getPriPicUrl())) {
                        skuList.get(0).setPriPicUrl(skuList.get(0).getPriPicUrl());
                    }
                    if (index >= baseBo.getSkuList().size()) {
                        baseSkuList.add(Math.max(baseBo.getSkuList().size() - 1, 0), skuList.get(0));
                    } else {
                        baseSkuList.add(index, skuList.get(0));
                    }
                    ++addCount;
                    skuList.remove(0);
                }
            }
            String ES_SEARCH_SIZE = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)searchSortMsgBo.getSeChannelType())).esConfigSearchSize;
            if (baseSkuList.size() > Integer.parseInt(ES_SEARCH_SIZE)) {
                log.warn("\u57fa\u7840\u6392\u5e8f\u4e0e\u667a\u80fd\u63a8\u8350\u878d\u5408\u79fb\u9664\u91cc\u672b\u5c3e{}\u4e2a\u5546\u54c1\uff01", (Object)(baseSkuList.size() - Integer.parseInt(ES_SEARCH_SIZE)));
                baseBo.setSkuList(baseSkuList.subList(0, Integer.parseInt(ES_SEARCH_SIZE)));
            } else {
                baseBo.setSkuList(baseSkuList);
            }
            log.error("\u57fa\u7840\u6392\u5e8f\u4e0e\u667a\u80fd\u63a8\u8350\u878d\u5408\u4e86{}\u4e2a\u5546\u54c1\uff01", (Object)addCount);
            return baseBo;
        }
        catch (Exception e) {
            log.error("\u57fa\u7840\u6392\u5e8f\u4e0e\u667a\u80fd\u63a8\u8350\u878d\u5408\u5931\u8d25\uff01 ex:{}", (Object)e.getMessage());
            e.printStackTrace();
            return rspBo;
        }
    }
}

