/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.sort.impl.steps;

import com.alibaba.fastjson.JSON;
import com.tydic.se.base.ability.bo.SeQuerySkuBO;
import com.tydic.se.base.ability.bo.SeSearchRspBO;
import com.tydic.se.search.annotation.SearchLinkLog;
import com.tydic.se.search.config.SearchProcessConfig;
import com.tydic.se.search.sort.impl.steps.api.SearchStepInternalRulesSortingService;
import com.tydic.se.search.sort.impl.steps.api.SearchStepInternalShardByChannelListService;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SearchStepInternalRulesSortingServiceImpl
implements SearchStepInternalRulesSortingService {
    private static final Logger log = LoggerFactory.getLogger(SearchStepInternalRulesSortingServiceImpl.class);
    @Autowired
    private SearchProcessConfig searchProcessConfig;
    @Autowired
    private SearchStepInternalShardByChannelListService searchStepInternalShardByChannelListService;

    @Override
    @SearchLinkLog(desc="\u5185\u90e8\u89c4\u5219\u8c03\u6574\u6392\u5e8f")
    public SeSearchRspBO internalRulesSorting(SeSearchRspBO rspBo, Long seChannelType) {
        SeSearchRspBO baseBo = (SeSearchRspBO)JSON.parseObject((String)JSON.toJSONString((Object)rspBo), SeSearchRspBO.class);
        try {
            List skuList = rspBo.getSkuList();
            LinkedHashMap<String, List<SeQuerySkuBO>> scopeSkuListMap = new LinkedHashMap<String, List<SeQuerySkuBO>>();
            int index = 0;
            while (index < skuList.size()) {
                String smoothingInternalScope;
                BigDecimal scope;
                BigDecimal difference;
                int add;
                LinkedList<String> smoothingWeightList = new LinkedList<String>();
                smoothingWeightList.add(String.valueOf(index));
                for (add = index; add < skuList.size() && (difference = BigDecimal.valueOf(((SeQuerySkuBO)skuList.get(index)).getSmoothingWeight() - ((SeQuerySkuBO)skuList.get(add)).getSmoothingWeight())).compareTo(scope = new BigDecimal(smoothingInternalScope = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)seChannelType)).searchSortSmoothingInternalScope)) <= 0; ++add) {
                    smoothingWeightList.add(String.valueOf(((SeQuerySkuBO)skuList.get(add)).getSmoothingWeight()));
                    String smoothingInternalStepLength = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)seChannelType)).searchSortSmoothingInternalStepLength;
                    if ((add + 1) % Integer.parseInt(smoothingInternalStepLength) != 0) continue;
                    ++add;
                    break;
                }
                List scopeList = skuList.subList(index, add);
                scopeSkuListMap.put(String.join((CharSequence)",", smoothingWeightList), scopeList);
                index = add;
            }
            List<SeQuerySkuBO> internal = this.searchStepInternalShardByChannelListService.internalShardByChannelList(scopeSkuListMap, seChannelType);
            rspBo.setSkuList(internal);
            return rspBo;
        }
        catch (Exception e) {
            log.error("\u76f8\u5173\u6027\u6392\u5e8f-\u6743\u91cd\u5e73\u6ed1\u5904\u7406 \u5185\u90e8\u8c03\u6574\u5f02\u5e38\uff01");
            e.printStackTrace();
            return baseBo;
        }
    }
}

