/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.sort.impl.steps;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.tydic.se.base.ability.bo.SeQuerySkuBO;
import com.tydic.se.base.ability.bo.SeSearchRspBO;
import com.tydic.se.search.annotation.SearchLinkLog;
import com.tydic.se.search.config.SearchProcessConfig;
import com.tydic.se.search.sort.bo.SearchSortMsgBo;
import com.tydic.se.search.sort.exception.SearchSortException;
import com.tydic.se.search.sort.impl.steps.api.SearchStepInternalRulesSortingService;
import com.tydic.se.search.sort.impl.steps.api.SearchStepSmoothParametersSortService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SearchStepSmoothParametersSortServiceImpl
implements SearchStepSmoothParametersSortService {
    private static final Logger log = LoggerFactory.getLogger(SearchStepSmoothParametersSortServiceImpl.class);
    @Autowired
    private SearchProcessConfig searchProcessConfig;
    @Autowired
    private SearchStepInternalRulesSortingService searchStepInternalRulesSortingService;

    @Override
    @SearchLinkLog(desc="\u5206\u8bcd\u6743\u91cd\u5e73\u6ed1\u5904\u7406")
    public SeSearchRspBO smoothParametersSort(SeSearchRspBO baseBo, SearchSortMsgBo searchSortMsgBo) throws SearchSortException {
        String smoothingSort = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)searchSortMsgBo.getSeChannelType())).searchSortSmoothing;
        if (Objects.equals(smoothingSort, "0")) {
            return baseBo;
        }
        String smoothingPredictiveSort = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)searchSortMsgBo.getSeChannelType())).searchSortSmoothingPredictiveSort;
        if (Objects.equals(smoothingPredictiveSort, "1")) {
            if (searchSortMsgBo == null) {
                log.warn("searchSortMsgBo\u53c2\u6570\u4e3anull\uff0c\u8df3\u8fc7\u5904\u7406");
                return baseBo;
            }
            if (searchSortMsgBo.getPredictiveRankingMap() == null || searchSortMsgBo.getPredictiveRankingMap().isEmpty()) {
                log.info("predictiveRankingMap\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u5904\u7406");
                return baseBo;
            }
            if (StringUtils.isEmpty((String)searchSortMsgBo.getQueryStr())) {
                log.info("queryStr\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u5904\u7406");
                return baseBo;
            }
            for (Map map : searchSortMsgBo.getPredictiveRankingMap()) {
                if (map == null) continue;
                for (Map.Entry entry : map.entrySet()) {
                    if (entry.getValue() == null || !((List)entry.getValue()).contains(searchSortMsgBo.getQueryStr())) continue;
                    log.info("{}{}\u9884\u6d4b\u6392\u5e8f\u4e2d{}-{},\u547d\u4e2d\u67e5\u8be2\u77ed\u8bed,{},\u8df3\u8fc7\u5e73\u6ed1\u5904\u7406\uff01", new Object[]{">>>\u76f8\u5173\u6027\u6392\u5e8f", ">>>TXT>>>", entry.getKey(), entry.getValue(), searchSortMsgBo.getQueryStr()});
                    return baseBo;
                }
            }
        }
        if (Boolean.TRUE.equals(searchSortMsgBo.getSpecifySort())) {
            return baseBo;
        }
        String smoothingStartNum = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)searchSortMsgBo.getSeChannelType())).searchSortSmoothingStartNum;
        if (searchSortMsgBo.getQueryStrParticiple().size() < Integer.parseInt(smoothingStartNum)) {
            return baseBo;
        }
        log.info("{}{}\u5e73\u6ed1\u5904\u7406{}{}", new Object[]{">>>\u76f8\u5173\u6027\u6392\u5e8f", ">>>LIST>>>", ">>>", JSONArray.toJSONString((Object)searchSortMsgBo.getQueryStrParticiple())});
        SeSearchRspBO rspBo = (SeSearchRspBO)JSON.parseObject((String)JSON.toJSONString((Object)baseBo), SeSearchRspBO.class);
        try {
            ArrayList<SeQuerySkuBO> seQuerySkuBOList = new ArrayList<SeQuerySkuBO>();
            for (SeQuerySkuBO seQuerySkuBo : rspBo.getSkuList()) {
                String skuName = seQuerySkuBo.getSkuName().toLowerCase(Locale.ROOT);
                int skuNameLen = skuName.length();
                BigDecimal weight = new BigDecimal("0.0");
                LinkedList<String> smoothingWeightDesc = new LinkedList<String>();
                String regex = "\\s+";
                if (skuName.contains(searchSortMsgBo.getQueryStr().toLowerCase(Locale.ROOT))) {
                    weight = weight.add(new BigDecimal("10"));
                    smoothingWeightDesc.add("\u5b8c\u6574\u5339\u914d:10");
                } else {
                    String delMoreNullQueryStr;
                    String delMoreNullTmpName = skuName.replaceAll(regex, " ");
                    if (delMoreNullTmpName.contains(delMoreNullQueryStr = searchSortMsgBo.getQueryStr().toLowerCase(Locale.ROOT).replaceAll(regex, " "))) {
                        weight = weight.add(new BigDecimal("8"));
                        smoothingWeightDesc.add("\u53bb\u591a\u7a7a\u683c\u5339\u914d:8");
                    } else {
                        String delNullQueryStr;
                        String delNullTmpName = delMoreNullTmpName.replaceAll(regex, "");
                        if (delNullTmpName.contains(delNullQueryStr = delMoreNullQueryStr.replaceAll(regex, ""))) {
                            weight = weight.add(new BigDecimal("6"));
                            smoothingWeightDesc.add("\u53bb\u7a7a\u683c\u5339\u914d:6");
                        } else {
                            String delNullQueryStrWords = String.join((CharSequence)"", searchSortMsgBo.getQueryStrParticiple()).toLowerCase(Locale.ROOT);
                            if (delNullTmpName.contains(delNullQueryStrWords)) {
                                weight = weight.add(new BigDecimal("4"));
                                smoothingWeightDesc.add("\u5206\u8bcd\u53bb\u7a7a\u683c\u5339\u914d:4");
                            }
                        }
                    }
                }
                int first = -1;
                for (int i = 0; i < searchSortMsgBo.getQueryStrParticiple().size(); ++i) {
                    String word = ((String)searchSortMsgBo.getQueryStrParticiple().get(i)).toLowerCase(Locale.ROOT);
                    int index = skuName.indexOf(word, first == -1 ? 0 : first);
                    if (index == -1) continue;
                    if (first == -1) {
                        first = index;
                        skuNameLen = skuName.substring(index).length();
                    }
                    BigDecimal wordWeight = new BigDecimal(String.valueOf(i > this.searchProcessConfig.getSmoothingParameters().size() - 1 ? Integer.valueOf(1) : this.searchProcessConfig.getSmoothingParameters().get(i)));
                    double smooth = ((double)skuNameLen - (double)index / 2.0) / (double)skuNameLen;
                    wordWeight = wordWeight.multiply(new BigDecimal(String.valueOf(smooth)));
                    smoothingWeightDesc.add(word + ":" + wordWeight.doubleValue());
                    weight = weight.add(wordWeight);
                }
                seQuerySkuBo.setSmoothingWeight(Double.valueOf(weight.doubleValue()));
                seQuerySkuBo.setSmoothingWeightDesc(String.join((CharSequence)",", smoothingWeightDesc));
                seQuerySkuBOList.add(seQuerySkuBo);
            }
            List smoothSeQuerySkuBOList = seQuerySkuBOList.stream().sorted(Comparator.comparing(SeQuerySkuBO::getSmoothingWeight).reversed()).collect(Collectors.toList());
            rspBo.setSkuList(smoothSeQuerySkuBOList);
            String smoothingInternal = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)searchSortMsgBo.getSeChannelType())).searchSortSmoothingInternal;
            if (Objects.equals(smoothingInternal, "1")) {
                rspBo = this.searchStepInternalRulesSortingService.internalRulesSorting(rspBo, searchSortMsgBo.getSeChannelType());
            }
            return rspBo;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u76f8\u5173\u6027\u6392\u5e8f-\u6743\u91cd\u5e73\u6ed1\u5904\u7406 \u5f02\u5e38\uff01");
            return baseBo;
        }
    }
}

