/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.sscext.external.impl.stockAdjust;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.sscext.external.bo.stockAdjust.SscExternalQryOrgMaterialStockInfoReqBO;
import com.tydic.sscext.external.bo.stockAdjust.SscExternalQryOrgMaterialStockInfoRspBO;
import com.tydic.sscext.external.stockAdjust.SscExternalQryOrgMaterialStockInfoService;
import com.tydic.sscext.utils.PropertiesUtil;
import com.tydic.sscext.utils.http.HSHttpHelper;
import com.tydic.sscext.utils.http.HSNHttpHeader;
import com.tydic.sscext.utils.http.HttpRetBean;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SscExternalQryOrgMaterialStockInfoServiceImpl
implements SscExternalQryOrgMaterialStockInfoService {
    private static final Logger log = LoggerFactory.getLogger(SscExternalQryOrgMaterialStockInfoServiceImpl.class);
    @Value(value="${esb.erp.mock.switch:false}")
    private Boolean esbErpMockSwitch;

    @Override
    public SscExternalQryOrgMaterialStockInfoRspBO qryOrgMaterialStockInfo(SscExternalQryOrgMaterialStockInfoReqBO reqBo) {
        SscExternalQryOrgMaterialStockInfoRspBO rspBo;
        if (this.esbErpMockSwitch.booleanValue()) {
            log.debug("\u67e5\u8be2erp\u7ec4\u7ec7\u4e0b\u7269\u6599\u5f53\u524d\u5e93\u5b58\u4fe1\u606fmock\u5206\u652f");
            return this.mockData();
        }
        try {
            String reqStr = JSON.toJSONString((Object)reqBo);
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(PropertiesUtil.getProperty("STOCK_ADJUST_QRY_CURRENT_MATERIAL_STOCK")), HSNHttpHeader.getRequestHeaders("json"), reqStr.getBytes(StandardCharsets.UTF_8), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                throw new BusinessException("1", "\u67e5\u8be2erp\u7ec4\u7ec7\u4e0b\u7269\u6599\u5f53\u524d\u5e93\u5b58\u4fe1\u606f[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty("STOCK_ADJUST_QRY_CURRENT_MATERIAL_STOCK") + "]");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new BusinessException("1", "\u8c03\u7528ESB-ERP\u67e5\u8be2erp\u7ec4\u7ec7\u4e0b\u7269\u6599\u5f53\u524d\u5e93\u5b58\u4fe1\u606f\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            rspBo = this.resolveRsp(returnString);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528ESB-ERP\u67e5\u8be2erp\u7ec4\u7ec7\u4e0b\u7269\u6599\u5f53\u524d\u5e93\u5b58\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("1", "\u8c03\u7528ESB-ERP\u67e5\u8be2erp\u7ec4\u7ec7\u4e0b\u7269\u6599\u5f53\u524d\u5e93\u5b58\u4fe1\u606f\u5f02\u5e38");
        }
        return rspBo;
    }

    private SscExternalQryOrgMaterialStockInfoRspBO mockData() {
        SscExternalQryOrgMaterialStockInfoRspBO rspBo = new SscExternalQryOrgMaterialStockInfoRspBO();
        List<String> stringList = Arrays.asList("\u6cb3\u5317\u65ed\u9633\u80fd\u6e90\u6709\u9650\u516c\u53f8-\u6cb3\u5317\u65ed\u9633_\u4e00\u7cfb\u7164\u573a-" + new Random().nextDouble(), "\u6cb3\u5317\u65ed\u9633\u80fd\u6e90\u6709\u9650\u516c\u53f8-\u6cb3\u5317\u65ed\u9633_\u4e8c\u7cfb\u7164\u573a-" + new Random().nextDouble() * 1000.0);
        rspBo.setCurrentStock(stringList);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private SscExternalQryOrgMaterialStockInfoRspBO resolveRsp(String returnString) {
        log.debug("\u8c03\u7528ESB-ERP\u67e5\u8be2erp\u7ec4\u7ec7\u4e0b\u7269\u6599\u5f53\u524d\u5e93\u5b58\u4fe1\u606f\u8fd4\u56de\u6570\u636e:{}", (Object)returnString);
        SscExternalQryOrgMaterialStockInfoRspBO rspBo = new SscExternalQryOrgMaterialStockInfoRspBO();
        JSONObject jsonObject = JSONObject.parseObject((String)returnString);
        if ("0".equals(jsonObject.get((Object)"code"))) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc(jsonObject.getString("msg"));
            List data = jsonObject.getJSONArray("data").toJavaList(String.class);
            rspBo.setCurrentStock(data);
        } else {
            rspBo.setRespCode("1");
            rspBo.setRespDesc(jsonObject.getString("msg"));
        }
        return rspBo;
    }
}

