/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.sscext.busi.impl.bidding;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.ssc.common.SscProjectDetailBO;
import com.tydic.ssc.service.busi.SscAddProjectDetailBusiService;
import com.tydic.ssc.service.busi.bo.SscAddProjectDetailBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscAddProjectDetailBusiRspBO;
import com.tydic.sscext.busi.bidding.SscBatchImportProjectDetailBusiService;
import com.tydic.sscext.busi.bo.bidding.SscBatchImportProjectDetailBusiServiceReqBO;
import com.tydic.sscext.busi.bo.bidding.SscBatchImportProjectDetailBusiServiceRspBO;
import com.tydic.sscext.utils.ExcelUtils;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class SscBatchImportProjectDetailBusiServiceImpl
implements SscBatchImportProjectDetailBusiService {
    @Value(value="${oss.accessUrl:}")
    private String ossAccessUrl;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Autowired
    private FileClient fileClient;
    @Autowired
    private SscAddProjectDetailBusiService sscAddProjectDetailBusiService;

    @Override
    public SscBatchImportProjectDetailBusiServiceRspBO batchImportProjectDetail(SscBatchImportProjectDetailBusiServiceReqBO reqBO) {
        SscBatchImportProjectDetailBusiServiceRspBO rspBO = new SscBatchImportProjectDetailBusiServiceRspBO();
        int maxSize = 500;
        ArrayList<SscProjectDetailBO> sscProjectDetailBOs = new ArrayList<SscProjectDetailBO>();
        InputStream inputStream = this.downloadFile(reqBO.getExcelFileUrl());
        List<Row> rows = this.getRowsFromFile(inputStream, reqBO.getExcelFileUrl());
        for (Row row : rows) {
            if (CollectionUtils.isEmpty(rows)) continue;
            SscProjectDetailBO sscProjectDetailBO = new SscProjectDetailBO();
            int colNum = 0;
            String materialCode = ExcelUtils.cellToString(row.getCell(colNum++), false);
            sscProjectDetailBO.setMaterailCode(materialCode);
            String materialName = ExcelUtils.cellToString(row.getCell(colNum++), false);
            sscProjectDetailBO.setMaterailName(materialName);
            String spec = ExcelUtils.cellToString(row.getCell(colNum++), false);
            sscProjectDetailBO.setSpec(spec);
            String model = ExcelUtils.cellToString(row.getCell(colNum++), false);
            sscProjectDetailBO.setModel(model);
            String measureName = ExcelUtils.cellToString(row.getCell(colNum++), false);
            sscProjectDetailBO.setMeasureName(measureName);
            String purchaseNumber = ExcelUtils.cellToString(row.getCell(colNum++), false);
            sscProjectDetailBO.setPurchaseNumber(StringUtils.hasText((String)purchaseNumber) ? new BigDecimal(purchaseNumber).setScale(6, 4) : null);
            String bugetUnitPrice = ExcelUtils.cellToString(row.getCell(colNum++), false);
            try {
                sscProjectDetailBO.setBugetUnitPrice(StringUtils.hasText((String)bugetUnitPrice) ? MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(bugetUnitPrice).setScale(2, 4)) : null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String bugetTotalPrice = ExcelUtils.cellToString(row.getCell(colNum++), false);
            try {
                sscProjectDetailBO.setBugetTotalPrice(StringUtils.hasText((String)bugetTotalPrice) ? MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(bugetTotalPrice).setScale(2, 4)) : null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String linkMan = ExcelUtils.cellToString(row.getCell(colNum++), false);
            sscProjectDetailBO.setLinkMan(linkMan);
            String linkTel = ExcelUtils.cellToString(row.getCell(colNum++), false);
            sscProjectDetailBO.setLinkTel(linkTel);
            String linkPhone = ExcelUtils.cellToString(row.getCell(colNum++), false);
            sscProjectDetailBO.setLinkPhone(linkPhone);
            String deliveryAdderss = ExcelUtils.cellToString(row.getCell(colNum++), false);
            sscProjectDetailBO.setDeliveryAdderss(deliveryAdderss);
            String deliveryEndTime = ExcelUtils.cellToString(row.getCell(colNum++), false);
            sscProjectDetailBO.setDeliveryEndTime(DateUtils.strToDate((String)deliveryEndTime));
            String materialLinkPhone = ExcelUtils.cellToString(row.getCell(colNum++), false);
            sscProjectDetailBO.setMaterialLinkPhone(materialLinkPhone);
            sscProjectDetailBO.setStageId(reqBO.getStageId());
            sscProjectDetailBOs.add(sscProjectDetailBO);
            if (sscProjectDetailBOs.size() < 500) continue;
            break;
        }
        reqBO.setSscProjectDetailBOs(sscProjectDetailBOs);
        SscAddProjectDetailBusiReqBO sscAddProjectDetailBusiReqBO = new SscAddProjectDetailBusiReqBO();
        sscAddProjectDetailBusiReqBO.setProjectId(reqBO.getProjectId());
        sscAddProjectDetailBusiReqBO.setSscProjectDetailBOs(reqBO.getSscProjectDetailBOs());
        SscAddProjectDetailBusiRspBO sscAddProjectDetailBusiRspBO = this.sscAddProjectDetailBusiService.addProjectDetail(sscAddProjectDetailBusiReqBO);
        BeanUtils.copyProperties((Object)sscAddProjectDetailBusiRspBO, (Object)((Object)rspBO));
        return rspBO;
    }

    private InputStream downloadFile(String filePath) {
        InputStream inputStream;
        filePath = filePath.replace(this.ossAccessUrl, "").replace(this.ossFileUrl, "").replace("https://", "").replace("http://", "");
        try {
            inputStream = this.fileClient.downLoadToInputStream(filePath);
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u8bfb\u53d6\u4e0d\u5230\u6587\u4ef6\u3010" + filePath + "\u3011\uff01");
        }
        if (inputStream == null) {
            throw new ZTBusinessException("\u8bfb\u53d6\u4e0d\u5230\u6587\u4ef6\u3010" + filePath + "\u3011\uff01");
        }
        return inputStream;
    }

    private List<Row> getRowsFromFile(InputStream inputStream, String fileUrl) {
        ArrayList<HSSFRow> rows;
        String suffix = ExcelUtils.getSuffix(fileUrl);
        if (!StringUtils.isEmpty((Object)suffix)) {
            suffix = suffix.toLowerCase();
        }
        if ("xls".equals(suffix)) {
            List<HSSFRow> hssfRows = ExcelUtils.readXls(inputStream, 0, 1, 7);
            rows = new ArrayList<HSSFRow>(hssfRows);
        } else if ("xlsx".equals(suffix)) {
            List<XSSFRow> xssfRows = ExcelUtils.readXlsx(inputStream, 0, 1, 7);
            rows = new ArrayList<XSSFRow>(xssfRows);
        } else {
            throw new BusinessException("8888", "\u6587\u4ef6\u683c\u5f0f\u4e0d\u5bf9,\u4ec5\u652f\u6301xls\u53caxlsx\u683c\u5f0f\uff01");
        }
        if (CollectionUtils.isEmpty(rows)) {
            throw new BusinessException("8888", "\u83b7\u53d6\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\uff01");
        }
        return rows;
    }
}

