/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.sscext.busi.impl.bidding;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.ssc.dao.SscProjectDAO;
import com.tydic.ssc.dao.SscProjectDetailDAO;
import com.tydic.ssc.dao.SscProjectOperateRecordDAO;
import com.tydic.ssc.dao.po.SscProjectDetailPO;
import com.tydic.ssc.dao.po.SscProjectOperateRecordPO;
import com.tydic.ssc.dao.po.SscProjectPO;
import com.tydic.sscext.bo.common.SscExtSyncPrayBillListPurchasedNumBO;
import com.tydic.sscext.bo.prayBill.SscExtSyncPrayBillListPurchasedNumAbilityReqBO;
import com.tydic.sscext.bo.prayBill.SscExtSyncPrayBillListPurchasedNumAbilityRspBO;
import com.tydic.sscext.busi.bidding.SscExtErpCancelProjectBusiService;
import com.tydic.sscext.constant.SscExtConstant;
import com.tydic.sscext.serivce.bidding.bo.SscExtErpCancelProjectAbilityReqBO;
import com.tydic.sscext.serivce.bidding.bo.SscExtErpCancelProjectAbilityRspBO;
import com.tydic.sscext.serivce.praybill.SscExtSyncPrayBillListPurchasedNumAbilityService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class SscExtErpCancelProjectBusiServiceImpl
implements SscExtErpCancelProjectBusiService {
    private static final Logger log = LoggerFactory.getLogger(SscExtErpCancelProjectBusiServiceImpl.class);
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="SSC_GROUP_TEST")
    private SscExtSyncPrayBillListPurchasedNumAbilityService sscExtSyncPrayBillListPurchasedNumAbilityService;
    @Autowired
    private SscProjectDAO sscProjectDAO;
    @Autowired
    private SscProjectDetailDAO sscProjectDetailDAO;
    @Autowired
    private SscProjectOperateRecordDAO sscProjectOperateRecordDAO;

    @Override
    public SscExtErpCancelProjectAbilityRspBO cancelProject(SscExtErpCancelProjectAbilityReqBO reqBO) {
        if (reqBO.getProjectId() == null) {
            throw new BusinessException("8888", "\u53c2\u6570\u9519\u8bef\uff0c\u9879\u76eeID\u4e3a\u7a7a");
        }
        SscProjectPO sscProjectPO = this.sscProjectDAO.selectByPrimaryKey(reqBO.getProjectId());
        if (sscProjectPO == null) {
            throw new BusinessException("8888", "\u9879\u76ee\u4e0d\u5b58\u5728");
        }
        if ("-1".equals(sscProjectPO.getProjectStatus())) {
            throw new BusinessException("8888", "\u9879\u76ee\u4e0d\u80fd\u64a4\u9500");
        }
        if ("1".equals(sscProjectPO.getProjectStatus())) {
            throw new BusinessException("8888", "\u9879\u76ee\u8349\u7a3f\u72b6\u6001\u4e0d\u80fd\u64a4\u9500");
        }
        if ("13".equals(sscProjectPO.getProjectStatus())) {
            throw new BusinessException("8888", "\u9879\u76ee\u5df2\u7ecf\u64a4\u9500");
        }
        if ("7".equals(sscProjectPO.getProjectStatus())) {
            throw new BusinessException("8888", "\u9879\u76ee\u5ba1\u6279\u4e2d\uff0c\u4e0d\u80fd\u64a4\u9500");
        }
        SscProjectDetailPO sscProjectDetailPo = new SscProjectDetailPO();
        sscProjectDetailPo.setProjectId(reqBO.getProjectId());
        List<SscProjectDetailPO> projectDetailDAOList = this.sscProjectDetailDAO.getList(sscProjectDetailPo);
        if (!CollectionUtils.isEmpty((Collection)projectDetailDAOList) && !CollectionUtils.isEmpty(projectDetailDAOList = projectDetailDAOList.stream().filter(po -> StringUtils.hasText((String)po.getProjectDetailExtField3())).collect(Collectors.toList()))) {
            Map<String, List<SscProjectDetailPO>> collect = projectDetailDAOList.stream().collect(Collectors.groupingBy(SscProjectDetailPO::getProjectDetailExtField1));
            collect.forEach((prayBillId, poList) -> {
                SscExtSyncPrayBillListPurchasedNumAbilityReqBO syncPrayBillListPurchasedNumReqBO = new SscExtSyncPrayBillListPurchasedNumAbilityReqBO();
                syncPrayBillListPurchasedNumReqBO.setOperType(SscExtConstant.SyncPrayBillListPurchaesNumOperType.AFTER_SALE);
                syncPrayBillListPurchasedNumReqBO.setChangeType(SscExtConstant.SscExtChangeType.SSC);
                syncPrayBillListPurchasedNumReqBO.setSourceId(reqBO.getProjectId());
                ArrayList purchasedNumCheckList = new ArrayList();
                poList.forEach(po -> {
                    SscExtSyncPrayBillListPurchasedNumBO syncPrayBillListPurchasedNumBo = new SscExtSyncPrayBillListPurchasedNumBO();
                    syncPrayBillListPurchasedNumBo.setMaterialCode(po.getMaterailCode());
                    syncPrayBillListPurchasedNumBo.setPrayBillCode(po.getProjectDetailExtField3());
                    BigDecimal purchasedNum = po.getPurchaseNumber();
                    if (po.getNotPurchaseNumber() != null) {
                        purchasedNum = po.getPurchaseNumber().subtract(po.getNotPurchaseNumber());
                    }
                    log.info("\u64a4\u9500\u8be2\u6bd4\u4ef7\u9879\u76ee\u8be6\u60c5ID{},\u8bf7\u8d2d\u5355ID{},\u7269\u6599\u7f16\u7801{}\uff0c\u91c7\u8d2d\u6570\u91cf{},\u6d41\u6807\u6570\u91cf\uff0c\u8ba1\u7b97\u7ed3\u679c{}", new Object[]{po.getProjectDetailId(), prayBillId, po.getMaterailCode(), po.getPurchaseNumber(), po.getNotPurchaseNumber(), purchasedNum});
                    syncPrayBillListPurchasedNumBo.setPurchasedNum(purchasedNum);
                    syncPrayBillListPurchasedNumBo.setPrayBillId(prayBillId);
                    purchasedNumCheckList.add(syncPrayBillListPurchasedNumBo);
                });
                syncPrayBillListPurchasedNumReqBO.setPraylist(purchasedNumCheckList);
                SscExtSyncPrayBillListPurchasedNumAbilityRspBO syncPrayBillListPurchasedNumRspBo = this.sscExtSyncPrayBillListPurchasedNumAbilityService.syncPrayBillListPurchasedNum(syncPrayBillListPurchasedNumReqBO);
                if (!"0000".equals(syncPrayBillListPurchasedNumRspBo.getRespCode())) {
                    throw new ZTBusinessException("\u56de\u9000\u8bf7\u8d2d\u5355\u91c7\u8d2d\u6570\u91cf\u5931\u8d25\uff01" + syncPrayBillListPurchasedNumRspBo.getRespDesc());
                }
            });
            projectDetailDAOList.forEach(detail -> {
                SscProjectDetailPO po = new SscProjectDetailPO();
                po.setProjectDetailId(detail.getProjectDetailId());
                po.setNotPurchaseNumber(detail.getPurchaseNumber());
                this.sscProjectDetailDAO.updateProjectDetail(po);
            });
        }
        Date now = new Date();
        SscProjectPO po2 = new SscProjectPO();
        po2.setProjectId(reqBO.getProjectId());
        po2.setProjectStatus("13");
        po2.setProjectUpdateId(reqBO.getUserId());
        po2.setProjectUpdateName(reqBO.getUsername());
        po2.setProjectUpdateTime(now);
        this.sscProjectDAO.updateByPrimaryKeySelective(po2);
        SscProjectOperateRecordPO recordPO = new SscProjectOperateRecordPO();
        recordPO.setOperateContent("\u64a4\u9500\u9879\u76ee[" + reqBO.getProjectId() + "]");
        recordPO.setOperTime(now);
        recordPO.setOperNo(reqBO.getUserId());
        recordPO.setOperType("CX");
        recordPO.setOperName(reqBO.getName());
        recordPO.setProjectId(reqBO.getProjectId());
        recordPO.setOperateReason(reqBO.getReason());
        this.sscProjectOperateRecordDAO.insertSscProjectOperateRecord(recordPO);
        SscExtErpCancelProjectAbilityRspBO rspBO = new SscExtErpCancelProjectAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u9879\u76ee\u64a4\u9500\u6210\u529f");
        return rspBO;
    }
}

