/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.sscext.busi.impl.bidding;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.sscext.busi.bidding.SscProSubmitQuotationBusiService;
import com.tydic.sscext.busi.bo.bidding.SscProSubmitQuotationBusiServiceReqBO;
import com.tydic.sscext.busi.bo.bidding.SscProSubmitQuotationBusiServiceRspBO;
import com.tydic.sscext.dao.SscProjectSupplierProMapper;
import com.tydic.sscext.dao.SscSupplierQuotationDetailProMapper;
import com.tydic.sscext.dao.SscSupplierQuotationProMapper;
import com.tydic.sscext.dao.po.SscProjectSupplierProPO;
import com.tydic.sscext.dao.po.SscSupplierQuotationDetailProPO;
import com.tydic.sscext.dao.po.SscSupplierQuotationProPO;
import com.tydic.sscext.serivce.bidding.bo.SscProQuotationDetailInfo;
import com.tydic.sscext.serivce.bidding.bo.SscProQuotationInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SscProSubmitQuotationBusiServiceImpl
implements SscProSubmitQuotationBusiService {
    private static final Logger log = LoggerFactory.getLogger(SscProSubmitQuotationBusiServiceImpl.class);
    @Autowired
    private SscProjectSupplierProMapper sscProjectSupplierProMapper;
    @Autowired
    private SscSupplierQuotationProMapper sscSupplierQuotationProMapper;
    @Autowired
    private SscSupplierQuotationDetailProMapper sscSupplierQuotationDetailProMapper;

    @Override
    public SscProSubmitQuotationBusiServiceRspBO submitQuotation(SscProSubmitQuotationBusiServiceReqBO reqBO) {
        SscProSubmitQuotationBusiServiceRspBO rspBO = new SscProSubmitQuotationBusiServiceRspBO();
        BigDecimal supplierTaxTotalPrice = BigDecimal.ZERO;
        BigDecimal supplierTotalQuotationPrice = BigDecimal.ZERO;
        for (SscProQuotationInfo quotationInfo : reqBO.getQuotationInfoList()) {
            Long quotataionId = null == quotationInfo.getQuotationId() ? Sequence.getInstance().nextId() : quotationInfo.getQuotationId().longValue();
            ArrayList<SscSupplierQuotationDetailProPO> quotationDetailProPOList = new ArrayList<SscSupplierQuotationDetailProPO>();
            SscSupplierQuotationProPO quotationProPO = new SscSupplierQuotationProPO();
            BeanUtils.copyProperties((Object)quotationInfo, (Object)quotationProPO);
            quotationProPO.setQuotationOperateNo(reqBO.getMemIdIn());
            quotationProPO.setQuotationOperateName(reqBO.getName());
            quotationProPO.setQuotationTime(new Date());
            BigDecimal quotationTaxTotalPrice = BigDecimal.ZERO;
            BigDecimal quotationTotalQuotationPrice = BigDecimal.ZERO;
            for (SscProQuotationDetailInfo quotationDetailInfo : quotationInfo.getQuotationDetailInfoList()) {
                SscSupplierQuotationDetailProPO quotationDetailProPO = new SscSupplierQuotationDetailProPO();
                BeanUtils.copyProperties((Object)quotationDetailInfo, (Object)quotationDetailProPO);
                quotationDetailProPO.setProjectId(quotationInfo.getProjectId());
                quotationDetailProPO.setStageId(quotationInfo.getStageId());
                quotationDetailProPO.setSupplierId(quotationInfo.getSupplierId());
                quotationDetailProPO.setSupplierName(quotationInfo.getSupplierName());
                BigDecimal quotationUnitPrice = quotationDetailInfo.getQuotationUnitPrice().multiply(new BigDecimal("10000"));
                quotationDetailProPO.setQuotationUnitPrice(quotationUnitPrice.longValue());
                BigDecimal noTaxUnitPrice = quotationUnitPrice.subtract(quotationUnitPrice.multiply(quotationDetailInfo.getTaxRate()));
                quotationDetailProPO.setNoTaxUnitPrice(noTaxUnitPrice.longValue());
                BigDecimal totalQuotationPrice = quotationDetailInfo.getQuotationNum().multiply(noTaxUnitPrice);
                quotationDetailProPO.setTotalQuotationPrice(totalQuotationPrice.longValue());
                BigDecimal taxTotalPrice = quotationDetailInfo.getQuotationNum().multiply(quotationUnitPrice);
                quotationDetailProPO.setTaxTotalPrice(taxTotalPrice.longValue());
                quotationDetailProPO.setQuotationRound(1);
                quotationDetailProPO.setOperId(reqBO.getMemIdIn());
                quotationDetailProPO.setOperName(reqBO.getName());
                quotationDetailProPO.setOperTime(new Date());
                quotationDetailProPO.setQuotationDetailStatus("1");
                quotationDetailProPO.setDelStatus("0");
                if (null == quotationDetailInfo.getQuotationDetailId()) {
                    quotationDetailProPO.setQuotationDetailId(Sequence.getInstance().nextId());
                }
                quotationDetailProPO.setQuotationId(quotataionId);
                quotationDetailProPOList.add(quotationDetailProPO);
                quotationTaxTotalPrice = quotationTaxTotalPrice.add(totalQuotationPrice);
                quotationTotalQuotationPrice = quotationTotalQuotationPrice.add(taxTotalPrice);
            }
            quotationProPO.setTaxTotalPrice(quotationTaxTotalPrice.longValue());
            quotationProPO.setTotalQuotationPrice(quotationTotalQuotationPrice.longValue());
            quotationProPO.setInitialTotalPrice(quotationProPO.getTotalQuotationPrice());
            quotationProPO.setEndTotalPrice(quotationProPO.getTotalQuotationPrice());
            supplierTaxTotalPrice = supplierTaxTotalPrice.add(quotationTaxTotalPrice);
            supplierTotalQuotationPrice = supplierTotalQuotationPrice.add(quotationTotalQuotationPrice);
            quotationProPO.setWinBidStatus("1");
            quotationProPO.setQuotationStatus("1");
            quotationProPO.setDelStatus("0");
            if (null == quotationInfo.getQuotationId()) {
                quotationProPO.setQuotationId(quotataionId);
                int var1 = this.sscSupplierQuotationProMapper.insert(quotationProPO);
                if (var1 < 1) {
                    throw new BusinessException("8888", "\u65b0\u589e\u62a5\u4ef7\u4fe1\u606f\u5f02\u5e38\uff01");
                }
                try {
                    this.sscSupplierQuotationDetailProMapper.insertBatch(quotationDetailProPOList);
                    continue;
                }
                catch (Exception e) {
                    log.debug("\u65b0\u589e\u62a5\u4ef7\u660e\u7ec6\u4fe1\u606f\u5f02\u5e38\uff1a[{}]", (Object)e.getMessage());
                    throw new BusinessException("8888", "\u65b0\u589e\u62a5\u4ef7\u660e\u7ec6\u4fe1\u606f\u5f02\u5e38\uff01");
                }
            }
            int var2 = this.sscSupplierQuotationProMapper.updateById(quotationProPO);
            if (var2 < 1) {
                throw new BusinessException("8888", "\u66f4\u65b0\u62a5\u4ef7\u4fe1\u606f\u5f02\u5e38\uff01");
            }
            if (CollectionUtils.isEmpty(quotationDetailProPOList)) continue;
            for (SscSupplierQuotationDetailProPO quotationDetailProPO : quotationDetailProPOList) {
                int var3 = this.sscSupplierQuotationDetailProMapper.updateById(quotationDetailProPO);
                if (var3 >= 1) continue;
                throw new BusinessException("8888", "\u66f4\u65b0\u62a5\u4ef7\u660e\u7ec6\u4fe1\u606f\u5f02\u5e38\uff01");
            }
        }
        SscProjectSupplierProPO projectSupplierProPO = new SscProjectSupplierProPO();
        projectSupplierProPO.setProjectSupplierId(reqBO.getProjectSupplierId());
        projectSupplierProPO.setDeliveryDate(reqBO.getDeliveryDate());
        projectSupplierProPO.setTaxTotalPrice(supplierTaxTotalPrice.longValue());
        projectSupplierProPO.setTotalQuotationPrice(supplierTotalQuotationPrice.longValue());
        projectSupplierProPO.setTenderFile(reqBO.getTenderFile());
        projectSupplierProPO.setProjectSupplierStatus("7");
        int var4 = this.sscProjectSupplierProMapper.updateById(projectSupplierProPO);
        if (var4 < 1) {
            throw new BusinessException("8888", "\u66f4\u65b0\u9879\u76ee\u4f9b\u5e94\u5546\u4fe1\u606f\u5f02\u5e38\uff01");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6295\u6807\u63d0\u4ea4\u6210\u529f");
        return rspBO;
    }
}

